<?php

namespace PHPMaker2023\Jack_Jill_school;

// Page object
$StudentAdd = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { student: currentTable } });
var currentPageID = ew.PAGE_ID = "add";
var currentForm;
var fstudentadd;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fstudentadd")
        .setPageId("add")

        // Add fields
        .setFields([
            ["studentID", [fields.studentID.visible && fields.studentID.required ? ew.Validators.required(fields.studentID.caption) : null, ew.Validators.integer], fields.studentID.isInvalid],
            ["PIN", [fields.PIN.visible && fields.PIN.required ? ew.Validators.required(fields.PIN.caption) : null], fields.PIN.isInvalid],
            ["Last_Name", [fields.Last_Name.visible && fields.Last_Name.required ? ew.Validators.required(fields.Last_Name.caption) : null], fields.Last_Name.isInvalid],
            ["First_Name", [fields.First_Name.visible && fields.First_Name.required ? ew.Validators.required(fields.First_Name.caption) : null], fields.First_Name.isInvalid],
            ["Gender", [fields.Gender.visible && fields.Gender.required ? ew.Validators.required(fields.Gender.caption) : null], fields.Gender.isInvalid],
            ["Date_Of_Birth", [fields.Date_Of_Birth.visible && fields.Date_Of_Birth.required ? ew.Validators.required(fields.Date_Of_Birth.caption) : null, ew.Validators.datetime(fields.Date_Of_Birth.clientFormatPattern)], fields.Date_Of_Birth.isInvalid],
            ["Place_Of_Birth", [fields.Place_Of_Birth.visible && fields.Place_Of_Birth.required ? ew.Validators.required(fields.Place_Of_Birth.caption) : null], fields.Place_Of_Birth.isInvalid],
            ["Card_No", [fields.Card_No.visible && fields.Card_No.required ? ew.Validators.required(fields.Card_No.caption) : null], fields.Card_No.isInvalid],
            ["Unique_QR", [fields.Unique_QR.visible && fields.Unique_QR.required ? ew.Validators.required(fields.Unique_QR.caption) : null], fields.Unique_QR.isInvalid],
            ["Photo", [fields.Photo.visible && fields.Photo.required ? ew.Validators.fileRequired(fields.Photo.caption) : null], fields.Photo.isInvalid],
            ["Address", [fields.Address.visible && fields.Address.required ? ew.Validators.required(fields.Address.caption) : null], fields.Address.isInvalid],
            ["Start_Date", [fields.Start_Date.visible && fields.Start_Date.required ? ew.Validators.required(fields.Start_Date.caption) : null, ew.Validators.datetime(fields.Start_Date.clientFormatPattern)], fields.Start_Date.isInvalid],
            ["Expiry_Date", [fields.Expiry_Date.visible && fields.Expiry_Date.required ? ew.Validators.required(fields.Expiry_Date.caption) : null, ew.Validators.datetime(fields.Expiry_Date.clientFormatPattern)], fields.Expiry_Date.isInvalid],
            ["SClass", [fields.SClass.visible && fields.SClass.required ? ew.Validators.required(fields.SClass.caption) : null], fields.SClass.isInvalid],
            ["Contact_Incase", [fields.Contact_Incase.visible && fields.Contact_Incase.required ? ew.Validators.required(fields.Contact_Incase.caption) : null], fields.Contact_Incase.isInvalid],
            ["Contact_Tel", [fields.Contact_Tel.visible && fields.Contact_Tel.required ? ew.Validators.required(fields.Contact_Tel.caption) : null], fields.Contact_Tel.isInvalid],
            ["Reference", [fields.Reference.visible && fields.Reference.required ? ew.Validators.required(fields.Reference.caption) : null], fields.Reference.isInvalid],
            ["EmployeeID", [fields.EmployeeID.visible && fields.EmployeeID.required ? ew.Validators.required(fields.EmployeeID.caption) : null, ew.Validators.integer], fields.EmployeeID.isInvalid],
            ["Status", [fields.Status.visible && fields.Status.required ? ew.Validators.required(fields.Status.caption) : null], fields.Status.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Multi-Page
        .setMultiPage(true)

        // Dynamic selection lists
        .setLists({
            "PIN": <?= $Page->PIN->toClientList($Page) ?>,
            "Last_Name": <?= $Page->Last_Name->toClientList($Page) ?>,
            "Gender": <?= $Page->Gender->toClientList($Page) ?>,
            "Card_No": <?= $Page->Card_No->toClientList($Page) ?>,
            "Status": <?= $Page->Status->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<?php if (!$Page->IsModal) { ?>
<div class="col-md-12">
  <div class="card shadow-sm">
    <div class="card-header">
	  <h4 class="card-title"><?php echo Language()->phrase("AddCaption"); ?></h4>
	  <div class="card-tools">
	  <button type="button" class="btn btn-tool" data-card-widget="maximize"><i class="fas fa-expand"></i>
	  </button>
	  </div>
	  <!-- /.card-tools -->
    </div>
    <!-- /.card-header -->
    <div class="card-body">
<?php } ?>
<form name="fstudentadd" id="fstudentadd" class="<?= $Page->FormClassName ?> form-wizard" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="on" style="width:100% !important;">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="student">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<?php if (IsJsonResponse()) { ?>
<input type="hidden" name="json" value="1">
<?php } ?>
<input type="hidden" name="<?= $Page->OldKeyName ?>" value="<?= $Page->OldKey ?>">
<div class="ew-multi-page"><!-- multi-page -->
<div id="pages_StudentAdd" class="sw sw-theme-arrows sw-justified"><!-- multi-page tabs -->
    <ul class="nav nav-progress">
        <li class="nav-item"><a class="nav-link" href="#tab_student1"><span class="num">1</span><?= $Page->pageCaption(1) ?></a></li>
        <li class="nav-item"><a class="nav-link" href="#tab_student2"><span class="num">2</span><?= $Page->pageCaption(2) ?></a></li>
        <li class="nav-item"><a class="nav-link" href="#tab_student3"><span class="num">3</span><?= $Page->pageCaption(3) ?></a></li>
        <li class="nav-item"><a class="nav-link" href="#tab_student4"><span class="num">4</span><?= $Page->pageCaption(4) ?></a></li>
        <li class="nav-item"><a class="nav-link" href="#tab_student5"><span class="num">5</span><?= $Page->pageCaption(5) ?></a></li>
    </ul>
    <div class="<?= $Page->MultiPages->tabContentClasses() ?>"><!-- multi-page tabs .tab-content -->
        <div class="tab-pane" id="tab_student1" role="tabpanel"><!-- multi-page .tab-pane -->
<div class="ew-add-div"><!-- page* -->
<?php if ($Page->studentID->Visible) { // studentID ?>
    <div id="r_studentID"<?= $Page->studentID->rowAttributes() ?>>
        <label id="elh_student_studentID" for="x_studentID" class="<?= $Page->LeftColumnClass ?>"><?= $Page->studentID->caption() ?><?= $Page->studentID->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->studentID->cellAttributes() ?>>
<span id="el_student_studentID">
<input type="<?= $Page->studentID->getInputTextType() ?>" name="x_studentID" id="x_studentID" data-table="student" data-field="x_studentID" value="<?= $Page->studentID->EditValue ?>" data-page="1" size="30" placeholder="<?= HtmlEncode($Page->studentID->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->studentID->formatPattern()) ?>"<?= $Page->studentID->editAttributes() ?> aria-describedby="x_studentID_help">
<?= $Page->studentID->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->studentID->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->PIN->Visible) { // PIN ?>
    <div id="r_PIN"<?= $Page->PIN->rowAttributes() ?>>
        <label id="elh_student_PIN" class="<?= $Page->LeftColumnClass ?>"><?= $Page->PIN->caption() ?><?= $Page->PIN->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->PIN->cellAttributes() ?>>
<span id="el_student_PIN">
<?php
if (IsRTL()) {
    $Page->PIN->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_PIN" class="ew-auto-suggest">
    <input type="<?= $Page->PIN->getInputTextType() ?>" class="form-control" name="sv_x_PIN" id="sv_x_PIN" value="<?= RemoveHtml($Page->PIN->EditValue) ?>" autocomplete="off" size="30" maxlength="57" placeholder="<?= HtmlEncode($Page->PIN->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->PIN->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->PIN->formatPattern()) ?>"<?= $Page->PIN->editAttributes() ?> aria-describedby="x_PIN_help">
</span>
<selection-list hidden class="form-control" data-table="student" data-field="x_PIN" data-input="sv_x_PIN" data-page="1" data-value-separator="<?= $Page->PIN->displayValueSeparatorAttribute() ?>" name="x_PIN" id="x_PIN" value="<?= HtmlEncode($Page->PIN->CurrentValue) ?>"></selection-list>
<?= $Page->PIN->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->PIN->getErrorMessage() ?></div>
<script>
loadjs.ready("fstudentadd", function() {
    fstudentadd.createAutoSuggest(Object.assign({"id":"x_PIN","forceSelect":false}, { lookupAllDisplayFields: <?= $Page->PIN->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.student.fields.PIN.autoSuggestOptions));
});
</script>
<?= $Page->PIN->Lookup->getParamTag($Page, "p_x_PIN") ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->Last_Name->Visible) { // Last_Name ?>
    <div id="r_Last_Name"<?= $Page->Last_Name->rowAttributes() ?>>
        <label id="elh_student_Last_Name" class="<?= $Page->LeftColumnClass ?>"><?= $Page->Last_Name->caption() ?><?= $Page->Last_Name->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->Last_Name->cellAttributes() ?>>
<span id="el_student_Last_Name">
<?php
if (IsRTL()) {
    $Page->Last_Name->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_Last_Name" class="ew-auto-suggest">
    <input type="<?= $Page->Last_Name->getInputTextType() ?>" class="form-control" name="sv_x_Last_Name" id="sv_x_Last_Name" value="<?= RemoveHtml($Page->Last_Name->EditValue) ?>" autocomplete="off" placeholder="<?= HtmlEncode($Page->Last_Name->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->Last_Name->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Last_Name->formatPattern()) ?>"<?= $Page->Last_Name->editAttributes() ?> aria-describedby="x_Last_Name_help">
</span>
<selection-list hidden class="form-control" data-table="student" data-field="x_Last_Name" data-input="sv_x_Last_Name" data-page="1" data-value-separator="<?= $Page->Last_Name->displayValueSeparatorAttribute() ?>" name="x_Last_Name" id="x_Last_Name" value="<?= HtmlEncode($Page->Last_Name->CurrentValue) ?>"></selection-list>
<?= $Page->Last_Name->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->Last_Name->getErrorMessage() ?></div>
<script>
loadjs.ready("fstudentadd", function() {
    fstudentadd.createAutoSuggest(Object.assign({"id":"x_Last_Name","forceSelect":false}, { lookupAllDisplayFields: <?= $Page->Last_Name->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.student.fields.Last_Name.autoSuggestOptions));
});
</script>
<?= $Page->Last_Name->Lookup->getParamTag($Page, "p_x_Last_Name") ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->First_Name->Visible) { // First_Name ?>
    <div id="r_First_Name"<?= $Page->First_Name->rowAttributes() ?>>
        <label id="elh_student_First_Name" for="x_First_Name" class="<?= $Page->LeftColumnClass ?>"><?= $Page->First_Name->caption() ?><?= $Page->First_Name->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->First_Name->cellAttributes() ?>>
<span id="el_student_First_Name">
<input type="<?= $Page->First_Name->getInputTextType() ?>" name="x_First_Name" id="x_First_Name" data-table="student" data-field="x_First_Name" value="<?= $Page->First_Name->EditValue ?>" data-page="1" size="30" maxlength="60" placeholder="<?= HtmlEncode($Page->First_Name->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->First_Name->formatPattern()) ?>"<?= $Page->First_Name->editAttributes() ?> aria-describedby="x_First_Name_help">
<?= $Page->First_Name->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->First_Name->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->Card_No->Visible) { // Card_No ?>
    <div id="r_Card_No"<?= $Page->Card_No->rowAttributes() ?>>
        <label id="elh_student_Card_No" class="<?= $Page->LeftColumnClass ?>"><?= $Page->Card_No->caption() ?><?= $Page->Card_No->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->Card_No->cellAttributes() ?>>
<span id="el_student_Card_No">
<?php
if (IsRTL()) {
    $Page->Card_No->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_Card_No" class="ew-auto-suggest">
    <input type="<?= $Page->Card_No->getInputTextType() ?>" class="form-control" name="sv_x_Card_No" id="sv_x_Card_No" value="<?= RemoveHtml($Page->Card_No->EditValue) ?>" autocomplete="off" size="30" maxlength="20" placeholder="<?= HtmlEncode($Page->Card_No->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->Card_No->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Card_No->formatPattern()) ?>"<?= $Page->Card_No->editAttributes() ?> aria-describedby="x_Card_No_help">
</span>
<selection-list hidden class="form-control" data-table="student" data-field="x_Card_No" data-input="sv_x_Card_No" data-page="1" data-value-separator="<?= $Page->Card_No->displayValueSeparatorAttribute() ?>" name="x_Card_No" id="x_Card_No" value="<?= HtmlEncode($Page->Card_No->CurrentValue) ?>"></selection-list>
<?= $Page->Card_No->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->Card_No->getErrorMessage() ?></div>
<script>
loadjs.ready("fstudentadd", function() {
    fstudentadd.createAutoSuggest(Object.assign({"id":"x_Card_No","forceSelect":false}, { lookupAllDisplayFields: <?= $Page->Card_No->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.student.fields.Card_No.autoSuggestOptions));
});
</script>
<?= $Page->Card_No->Lookup->getParamTag($Page, "p_x_Card_No") ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->Unique_QR->Visible) { // Unique_QR ?>
    <div id="r_Unique_QR"<?= $Page->Unique_QR->rowAttributes() ?>>
        <label id="elh_student_Unique_QR" for="x_Unique_QR" class="<?= $Page->LeftColumnClass ?>"><?= $Page->Unique_QR->caption() ?><?= $Page->Unique_QR->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->Unique_QR->cellAttributes() ?>>
<span id="el_student_Unique_QR">
<input type="<?= $Page->Unique_QR->getInputTextType() ?>" name="x_Unique_QR" id="x_Unique_QR" data-table="student" data-field="x_Unique_QR" value="<?= $Page->Unique_QR->EditValue ?>" data-page="1" size="30" maxlength="12" placeholder="<?= HtmlEncode($Page->Unique_QR->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Unique_QR->formatPattern()) ?>"<?= $Page->Unique_QR->editAttributes() ?> aria-describedby="x_Unique_QR_help">
<?= $Page->Unique_QR->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->Unique_QR->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->Photo->Visible) { // Photo ?>
    <div id="r_Photo"<?= $Page->Photo->rowAttributes() ?>>
        <label id="elh_student_Photo" class="<?= $Page->LeftColumnClass ?>"><?= $Page->Photo->caption() ?><?= $Page->Photo->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->Photo->cellAttributes() ?>>
<span id="el_student_Photo">
<div id="fd_x_Photo" class="fileinput-button ew-file-drop-zone">
    <input
        type="file"
        id="x_Photo"
        name="x_Photo"
        class="form-control ew-file-input"
        title="<?= $Page->Photo->title() ?>"
        lang="<?= CurrentLanguageID() ?>"
        data-table="student"
        data-field="x_Photo"
        data-size="60"
        data-accept-file-types="<?= $Page->Photo->acceptFileTypes() ?>"
        data-max-file-size="<?= $Page->Photo->UploadMaxFileSize ?>"
        data-max-number-of-files="null"
        data-disable-image-crop="<?= $Page->Photo->ImageCropper ? 0 : 1 ?>"
        data-page="1"
        aria-describedby="x_Photo_help"
        <?= ($Page->Photo->ReadOnly || $Page->Photo->Disabled) ? " disabled" : "" ?>
        <?= $Page->Photo->editAttributes() ?>
    >
    <div class="text-muted ew-file-text"><?= $Language->phrase("ChooseFile") ?></div>
</div>
<?= $Page->Photo->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->Photo->getErrorMessage() ?></div>
<input type="hidden" name="fn_x_Photo" id= "fn_x_Photo" value="<?= $Page->Photo->Upload->FileName ?>">
<input type="hidden" name="fa_x_Photo" id= "fa_x_Photo" value="0">
<table id="ft_x_Photo" class="table table-sm float-start ew-upload-table"><tbody class="files"></tbody></table>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->Status->Visible) { // Status ?>
    <div id="r_Status"<?= $Page->Status->rowAttributes() ?>>
        <label id="elh_student_Status" for="x_Status" class="<?= $Page->LeftColumnClass ?>"><?= $Page->Status->caption() ?><?= $Page->Status->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->Status->cellAttributes() ?>>
<span id="el_student_Status">
    <select
        id="x_Status"
        name="x_Status"
        class="form-select ew-select<?= $Page->Status->isInvalidClass() ?>"
        <?php if (!$Page->Status->IsNativeSelect) { ?>
        data-select2-id="fstudentadd_x_Status"
        <?php } ?>
        data-table="student"
        data-field="x_Status"
        data-page="1"
        data-value-separator="<?= $Page->Status->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->Status->getPlaceHolder()) ?>"
        <?= $Page->Status->editAttributes() ?>>
        <?= $Page->Status->selectOptionListHtml("x_Status") ?>
    </select>
    <?= $Page->Status->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->Status->getErrorMessage() ?></div>
<?php if (!$Page->Status->IsNativeSelect) { ?>
<script>
loadjs.ready("fstudentadd", function() {
    var options = { name: "x_Status", selectId: "fstudentadd_x_Status" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fstudentadd.lists.Status?.lookupOptions.length) {
        options.data = { id: "x_Status", form: "fstudentadd" };
    } else {
        options.ajax = { id: "x_Status", form: "fstudentadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.student.fields.Status.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
</div><!-- /page* -->
        </div><!-- /multi-page .tab-pane -->
        <div class="tab-pane" id="tab_student2" role="tabpanel"><!-- multi-page .tab-pane -->
<div class="ew-add-div"><!-- page* -->
<?php if ($Page->Gender->Visible) { // Gender ?>
    <div id="r_Gender"<?= $Page->Gender->rowAttributes() ?>>
        <label id="elh_student_Gender" for="x_Gender" class="<?= $Page->LeftColumnClass ?>"><?= $Page->Gender->caption() ?><?= $Page->Gender->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->Gender->cellAttributes() ?>>
<span id="el_student_Gender">
    <select
        id="x_Gender"
        name="x_Gender"
        class="form-select ew-select<?= $Page->Gender->isInvalidClass() ?>"
        <?php if (!$Page->Gender->IsNativeSelect) { ?>
        data-select2-id="fstudentadd_x_Gender"
        <?php } ?>
        data-table="student"
        data-field="x_Gender"
        data-page="2"
        data-value-separator="<?= $Page->Gender->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->Gender->getPlaceHolder()) ?>"
        <?= $Page->Gender->editAttributes() ?>>
        <?= $Page->Gender->selectOptionListHtml("x_Gender") ?>
    </select>
    <?= $Page->Gender->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->Gender->getErrorMessage() ?></div>
<?php if (!$Page->Gender->IsNativeSelect) { ?>
<script>
loadjs.ready("fstudentadd", function() {
    var options = { name: "x_Gender", selectId: "fstudentadd_x_Gender" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fstudentadd.lists.Gender?.lookupOptions.length) {
        options.data = { id: "x_Gender", form: "fstudentadd" };
    } else {
        options.ajax = { id: "x_Gender", form: "fstudentadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.student.fields.Gender.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->Date_Of_Birth->Visible) { // Date_Of_Birth ?>
    <div id="r_Date_Of_Birth"<?= $Page->Date_Of_Birth->rowAttributes() ?>>
        <label id="elh_student_Date_Of_Birth" for="x_Date_Of_Birth" class="<?= $Page->LeftColumnClass ?>"><?= $Page->Date_Of_Birth->caption() ?><?= $Page->Date_Of_Birth->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->Date_Of_Birth->cellAttributes() ?>>
<span id="el_student_Date_Of_Birth">
<input type="<?= $Page->Date_Of_Birth->getInputTextType() ?>" name="x_Date_Of_Birth" id="x_Date_Of_Birth" data-table="student" data-field="x_Date_Of_Birth" value="<?= $Page->Date_Of_Birth->EditValue ?>" data-page="2" placeholder="<?= HtmlEncode($Page->Date_Of_Birth->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Date_Of_Birth->formatPattern()) ?>"<?= $Page->Date_Of_Birth->editAttributes() ?> aria-describedby="x_Date_Of_Birth_help">
<?= $Page->Date_Of_Birth->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->Date_Of_Birth->getErrorMessage() ?></div>
<?php if (!$Page->Date_Of_Birth->ReadOnly && !$Page->Date_Of_Birth->Disabled && !isset($Page->Date_Of_Birth->EditAttrs["readonly"]) && !isset($Page->Date_Of_Birth->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fstudentadd", "datetimepicker"], function () {
    let format = "<?= DateFormat(7) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.isDark() ? "dark" : "auto"
            }
        };
    ew.createDateTimePicker("fstudentadd", "x_Date_Of_Birth", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->Place_Of_Birth->Visible) { // Place_Of_Birth ?>
    <div id="r_Place_Of_Birth"<?= $Page->Place_Of_Birth->rowAttributes() ?>>
        <label id="elh_student_Place_Of_Birth" for="x_Place_Of_Birth" class="<?= $Page->LeftColumnClass ?>"><?= $Page->Place_Of_Birth->caption() ?><?= $Page->Place_Of_Birth->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->Place_Of_Birth->cellAttributes() ?>>
<span id="el_student_Place_Of_Birth">
<input type="<?= $Page->Place_Of_Birth->getInputTextType() ?>" name="x_Place_Of_Birth" id="x_Place_Of_Birth" data-table="student" data-field="x_Place_Of_Birth" value="<?= $Page->Place_Of_Birth->EditValue ?>" data-page="2" size="30" maxlength="50" placeholder="<?= HtmlEncode($Page->Place_Of_Birth->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Place_Of_Birth->formatPattern()) ?>"<?= $Page->Place_Of_Birth->editAttributes() ?> aria-describedby="x_Place_Of_Birth_help">
<?= $Page->Place_Of_Birth->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->Place_Of_Birth->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->Address->Visible) { // Address ?>
    <div id="r_Address"<?= $Page->Address->rowAttributes() ?>>
        <label id="elh_student_Address" for="x_Address" class="<?= $Page->LeftColumnClass ?>"><?= $Page->Address->caption() ?><?= $Page->Address->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->Address->cellAttributes() ?>>
<span id="el_student_Address">
<input type="<?= $Page->Address->getInputTextType() ?>" name="x_Address" id="x_Address" data-table="student" data-field="x_Address" value="<?= $Page->Address->EditValue ?>" data-page="2" size="30" maxlength="100" placeholder="<?= HtmlEncode($Page->Address->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Address->formatPattern()) ?>"<?= $Page->Address->editAttributes() ?> aria-describedby="x_Address_help">
<?= $Page->Address->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->Address->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
</div><!-- /page* -->
        </div><!-- /multi-page .tab-pane -->
        <div class="tab-pane" id="tab_student3" role="tabpanel"><!-- multi-page .tab-pane -->
<div class="ew-add-div"><!-- page* -->
<?php if ($Page->Start_Date->Visible) { // Start_Date ?>
    <div id="r_Start_Date"<?= $Page->Start_Date->rowAttributes() ?>>
        <label id="elh_student_Start_Date" for="x_Start_Date" class="<?= $Page->LeftColumnClass ?>"><?= $Page->Start_Date->caption() ?><?= $Page->Start_Date->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->Start_Date->cellAttributes() ?>>
<span id="el_student_Start_Date">
<input type="<?= $Page->Start_Date->getInputTextType() ?>" name="x_Start_Date" id="x_Start_Date" data-table="student" data-field="x_Start_Date" value="<?= $Page->Start_Date->EditValue ?>" data-page="3" placeholder="<?= HtmlEncode($Page->Start_Date->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Start_Date->formatPattern()) ?>"<?= $Page->Start_Date->editAttributes() ?> aria-describedby="x_Start_Date_help">
<?= $Page->Start_Date->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->Start_Date->getErrorMessage() ?></div>
<?php if (!$Page->Start_Date->ReadOnly && !$Page->Start_Date->Disabled && !isset($Page->Start_Date->EditAttrs["readonly"]) && !isset($Page->Start_Date->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fstudentadd", "datetimepicker"], function () {
    let format = "<?= DateFormat(7) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.isDark() ? "dark" : "auto"
            }
        };
    ew.createDateTimePicker("fstudentadd", "x_Start_Date", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->Expiry_Date->Visible) { // Expiry_Date ?>
    <div id="r_Expiry_Date"<?= $Page->Expiry_Date->rowAttributes() ?>>
        <label id="elh_student_Expiry_Date" for="x_Expiry_Date" class="<?= $Page->LeftColumnClass ?>"><?= $Page->Expiry_Date->caption() ?><?= $Page->Expiry_Date->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->Expiry_Date->cellAttributes() ?>>
<span id="el_student_Expiry_Date">
<input type="<?= $Page->Expiry_Date->getInputTextType() ?>" name="x_Expiry_Date" id="x_Expiry_Date" data-table="student" data-field="x_Expiry_Date" value="<?= $Page->Expiry_Date->EditValue ?>" data-page="3" placeholder="<?= HtmlEncode($Page->Expiry_Date->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Expiry_Date->formatPattern()) ?>"<?= $Page->Expiry_Date->editAttributes() ?> aria-describedby="x_Expiry_Date_help">
<?= $Page->Expiry_Date->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->Expiry_Date->getErrorMessage() ?></div>
<?php if (!$Page->Expiry_Date->ReadOnly && !$Page->Expiry_Date->Disabled && !isset($Page->Expiry_Date->EditAttrs["readonly"]) && !isset($Page->Expiry_Date->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fstudentadd", "datetimepicker"], function () {
    let format = "<?= DateFormat(7) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.isDark() ? "dark" : "auto"
            }
        };
    ew.createDateTimePicker("fstudentadd", "x_Expiry_Date", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->SClass->Visible) { // SClass ?>
    <div id="r_SClass"<?= $Page->SClass->rowAttributes() ?>>
        <label id="elh_student_SClass" for="x_SClass" class="<?= $Page->LeftColumnClass ?>"><?= $Page->SClass->caption() ?><?= $Page->SClass->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->SClass->cellAttributes() ?>>
<span id="el_student_SClass">
<input type="<?= $Page->SClass->getInputTextType() ?>" name="x_SClass" id="x_SClass" data-table="student" data-field="x_SClass" value="<?= $Page->SClass->EditValue ?>" data-page="3" size="30" maxlength="60" placeholder="<?= HtmlEncode($Page->SClass->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->SClass->formatPattern()) ?>"<?= $Page->SClass->editAttributes() ?> aria-describedby="x_SClass_help">
<?= $Page->SClass->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->SClass->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
</div><!-- /page* -->
        </div><!-- /multi-page .tab-pane -->
        <div class="tab-pane" id="tab_student4" role="tabpanel"><!-- multi-page .tab-pane -->
<div class="ew-add-div"><!-- page* -->
<?php if ($Page->Contact_Incase->Visible) { // Contact_Incase ?>
    <div id="r_Contact_Incase"<?= $Page->Contact_Incase->rowAttributes() ?>>
        <label id="elh_student_Contact_Incase" for="x_Contact_Incase" class="<?= $Page->LeftColumnClass ?>"><?= $Page->Contact_Incase->caption() ?><?= $Page->Contact_Incase->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->Contact_Incase->cellAttributes() ?>>
<span id="el_student_Contact_Incase">
<input type="<?= $Page->Contact_Incase->getInputTextType() ?>" name="x_Contact_Incase" id="x_Contact_Incase" data-table="student" data-field="x_Contact_Incase" value="<?= $Page->Contact_Incase->EditValue ?>" data-page="4" size="30" maxlength="70" placeholder="<?= HtmlEncode($Page->Contact_Incase->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Contact_Incase->formatPattern()) ?>"<?= $Page->Contact_Incase->editAttributes() ?> aria-describedby="x_Contact_Incase_help">
<?= $Page->Contact_Incase->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->Contact_Incase->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->Contact_Tel->Visible) { // Contact_Tel ?>
    <div id="r_Contact_Tel"<?= $Page->Contact_Tel->rowAttributes() ?>>
        <label id="elh_student_Contact_Tel" for="x_Contact_Tel" class="<?= $Page->LeftColumnClass ?>"><?= $Page->Contact_Tel->caption() ?><?= $Page->Contact_Tel->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->Contact_Tel->cellAttributes() ?>>
<span id="el_student_Contact_Tel">
<input type="<?= $Page->Contact_Tel->getInputTextType() ?>" name="x_Contact_Tel" id="x_Contact_Tel" data-table="student" data-field="x_Contact_Tel" value="<?= $Page->Contact_Tel->EditValue ?>" data-page="4" size="30" maxlength="25" placeholder="<?= HtmlEncode($Page->Contact_Tel->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Contact_Tel->formatPattern()) ?>"<?= $Page->Contact_Tel->editAttributes() ?> aria-describedby="x_Contact_Tel_help">
<?= $Page->Contact_Tel->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->Contact_Tel->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->Reference->Visible) { // Reference ?>
    <div id="r_Reference"<?= $Page->Reference->rowAttributes() ?>>
        <label id="elh_student_Reference" for="x_Reference" class="<?= $Page->LeftColumnClass ?>"><?= $Page->Reference->caption() ?><?= $Page->Reference->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->Reference->cellAttributes() ?>>
<span id="el_student_Reference">
<input type="<?= $Page->Reference->getInputTextType() ?>" name="x_Reference" id="x_Reference" data-table="student" data-field="x_Reference" value="<?= $Page->Reference->EditValue ?>" data-page="4" size="30" maxlength="100" placeholder="<?= HtmlEncode($Page->Reference->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Reference->formatPattern()) ?>"<?= $Page->Reference->editAttributes() ?> aria-describedby="x_Reference_help">
<?= $Page->Reference->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->Reference->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
</div><!-- /page* -->
        </div><!-- /multi-page .tab-pane -->
        <div class="tab-pane" id="tab_student5" role="tabpanel"><!-- multi-page .tab-pane -->
<div class="ew-add-div"><!-- page* -->
<?php if ($Page->EmployeeID->Visible) { // EmployeeID ?>
    <div id="r_EmployeeID"<?= $Page->EmployeeID->rowAttributes() ?>>
        <label id="elh_student_EmployeeID" for="x_EmployeeID" class="<?= $Page->LeftColumnClass ?>"><?= $Page->EmployeeID->caption() ?><?= $Page->EmployeeID->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->EmployeeID->cellAttributes() ?>>
<span id="el_student_EmployeeID">
<input type="<?= $Page->EmployeeID->getInputTextType() ?>" name="x_EmployeeID" id="x_EmployeeID" data-table="student" data-field="x_EmployeeID" value="<?= $Page->EmployeeID->EditValue ?>" data-page="5" size="30" placeholder="<?= HtmlEncode($Page->EmployeeID->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->EmployeeID->formatPattern()) ?>"<?= $Page->EmployeeID->editAttributes() ?> aria-describedby="x_EmployeeID_help">
<?= $Page->EmployeeID->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->EmployeeID->getErrorMessage() ?></div>
<script type="text/javascript">
loadjs.ready(["fstudentadd", "jquerynumber"], function() {
	ew.createjQueryNumber("fstudentadd", "x_EmployeeID", {"number": true, "decimals": 0, "dec_point": "<?php echo $DECIMAL_SEPARATOR ?>", "thousands_sep" : "<?php echo $GROUPING_SEPARATOR ?>"});
});
</script>
</span>
</div></div>
    </div>
<?php } ?>
</div><!-- /page* -->
        </div><!-- /multi-page .tab-pane -->
    </div><!-- /multi-page tabs .tab-content -->
</div><!-- /multi-page tabs -->
</div><!-- /multi-page -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fstudentadd"><?= $Language->phrase("AddBtn") ?></button>
<?php if (IsJsonResponse()) { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-bs-dismiss="modal"><?= $Language->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fstudentadd" data-href="<?= HtmlEncode(GetUrl($Page->getReturnUrl())) ?>"><?= $Language->phrase("CancelBtn") ?></button>
<?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php if (!$Page->IsModal) { ?>
		</div>
     <!-- /.card-body -->
     </div>
  <!-- /.card -->
</div>
<?php } ?>
<div class="clearfix">&nbsp;</div>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("student");
});
</script>
<?php if (Config("MS_ENTER_MOVING_CURSOR_TO_NEXT_FIELD")) { ?>
<script>
loadjs.ready("head", function() { $("#fstudentadd:first *:input[type!=hidden]:first").focus(),$("input").keydown(function(i){if(13==i.which){var e=$(this).closest("form").find(":input:visible:enabled"),n=e.index(this);n==e.length-1||(e.eq(e.index(this)+1).focus(),i.preventDefault())}else 113==i.which&&$("#btn-action").click()}),$("select").keydown(function(i){if(13==i.which){var e=$(this).closest("form").find(":input:visible:enabled"),n=e.index(this);n==e.length-1||(e.eq(e.index(this)+1).focus(),i.preventDefault())}else 113==i.which&&$("#btn-action").click()}),$("radio").keydown(function(i){if(13==i.which){var e=$(this).closest("form").find(":input:visible:enabled"),n=e.index(this);n==e.length-1||(e.eq(e.index(this)+1).focus(),i.preventDefault())}else 113==i.which&&$("#btn-action").click()})});
</script>
<?php } ?>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php if (!$Page->IsModal && !$Page->isExport()) { ?>
<script>
loadjs.ready(["wrapper", "head", "swal"],function(){$('#btn-action').on('click',function(){if(fstudentadd.validateFields()){ew.prompt({title: ew.language.phrase("MessageAddConfirm"),icon:'question',showCancelButton:true},result=>{if(result)$("#fstudentadd").submit();});return false;} else { ew.prompt({title: ew.language.phrase("MessageInvalidForm"), icon: 'warning', showCancelButton:false}); }});});
</script>
<?php } ?>
<?php if (@$_COOKIE['theme'] == 'dark') { ?>
<style>
:root { 
  --sw-border-color: #eeeeee;
  --sw-toolbar-btn-color: #ffffff;
  --sw-toolbar-btn-background-color: #0a2730;
  --sw-anchor-default-primary-color: #757575;
  --sw-anchor-default-secondary-color: #b0b0b1;
  --sw-anchor-active-primary-color: #000000;
  --sw-anchor-active-secondary-color: #ffffff;
  --sw-anchor-done-primary-color: #333333;
  --sw-anchor-done-secondary-color: #aaaaaa;
  --sw-anchor-disabled-primary-color: #f8f9fa;
  --sw-anchor-disabled-secondary-color: #dbe0e5;
  --sw-anchor-error-primary-color: #dc3545;
  --sw-anchor-error-secondary-color: #ffffff;
  --sw-anchor-warning-primary-color: #ffc107;
  --sw-anchor-warning-secondary-color: #ffffff;
  --sw-progress-color: #0a2730;
  --sw-progress-background-color: #f8f9fa;
  --sw-loader-color: #0a2730;
  --sw-loader-background-color: #f8f9fa;
  --sw-loader-background-wrapper-color: rgba(255, 255, 255, 0.7);
}
</style>
<?php } else { ?>
<?php // Begin of BLUE COLOR THEME // ?>
<style>
:root {
  --sw-border-color: #eeeeee;
  --sw-toolbar-btn-color: #ffffff;
  --sw-toolbar-btn-background-color: #009EF7;
  --sw-anchor-default-primary-color: #f8f9fa;
  --sw-anchor-default-secondary-color: #b0b0b1;
  --sw-anchor-active-primary-color: #009EF7;
  --sw-anchor-active-secondary-color: #ffffff;
  --sw-anchor-done-primary-color: #90d4fa;
  --sw-anchor-done-secondary-color: #fefefe;
  --sw-anchor-disabled-primary-color: #f8f9fa;
  --sw-anchor-disabled-secondary-color: #dbe0e5;
  --sw-anchor-error-primary-color: #dc3545;
  --sw-anchor-error-secondary-color: #ffffff;
  --sw-anchor-warning-primary-color: #ffc107;
  --sw-anchor-warning-secondary-color: #ffffff;
  --sw-progress-color: #009EF7;
  --sw-progress-background-color: #f8f9fa;
  --sw-loader-color: #009EF7;
  --sw-loader-background-color: #f8f9fa;
  --sw-loader-background-wrapper-color: rgba(255, 255, 255, 0.7);
}
</style>
<?php // End of BLUE COLOR THEME // ?>
<?php } ?>
<script type="text/javascript">
loadjs.ready(["wrapper", "head", "formwizard"], function() {
  $('#pages_StudentAdd').smartWizard({
	  selected: 0,
	  theme: 'arrows', // basic, arrows, square, round, dots
	  enableURLhash: false, // Enable selection of the step based on url hash
	  justified: true, // Nav menu justification. true/false
	  autoAdjustHeight: false, // Automatically adjust content height
	  keyboardSettings: {
		  keyNavigation: false, // Enable/Disable keyboard navigation(left and right keys are used if enabled)
		  keyLeft: [37], // Left key code
		  keyRight: [39] // Right key code
	  },
	  transition: {
		  animation: 'slide-horizontal', // Effect on navigation, none/fade/slide-horizontal/slide-vertical/slide-swing
	  },
	  toolbar: {
		  showNextButton: true, // show/hide a Next button
		  showPreviousButton: true, // show/hide a Previous button
		  position: 'top' // none/top/both/bottom
	  },
	  anchorSettings: {
		  anchorClickable: true, // Enable/Disable anchor navigation
		  enableAllAnchors: true, // Activates all anchors clickable all times
		  markDoneStep: true, // Add done state on navigation
		  markAllPreviousStepsAsDone: true, // When a step selected by url hash, all previous steps are marked done
		  removeDoneStepOnNavigateBack: false, // While navigate back done step after active step will be cleared
		  enableAnchorOnDoneStep: true // Enable/Disable the done steps navigation
	  },
	  lang: { // Language variables for button
		  next: ew.language.phrase('Next'),
		  previous: ew.language.phrase('Prev')
	  }
  });
  $('#pages_StudentAdd').on('showStep', function(e, anchorObject, stepIndex, stepDirection, stepPosition) {
	  if (stepPosition == 'last') {
		$('#btn-action').prop('disabled', false);
		$('#btn-cancel').prop('disabled', false);
	  } else {
	    $('#btn-action').prop('disabled', true);
		$('#btn-cancel').prop('disabled', false);
	  }
  });
  <?php if (!$Page->isConfirm()) { // if not Confirm page ?>
  $('#pages_StudentAdd').on('leaveStep', function(e, anchorObject, currentStepIndex, nextStepIndex, stepDirection) {
    var isRequired = ew.hasValue;
    currentTab = currentStepIndex;
	ew.hasValue = function(el) {
      var $elTab = $(el).closest('.tab-pane'),
      elTabNum = $elTab.attr("id");
      if ($elTab.length && $elTab.closest(".ew-form.ew-add-form.form-wizard")) {
        elTabNum = elTabNum.substr(elTabNum.length - 2).replace(/\D/g, '');
        return parseInt(elTabNum) <= (parseInt(currentTab) + 1) ? isRequired(el) : true;
      } else {
        return isRequired(el);
      }
    }
    var oldTab = currentTab;
    currentTab = currentStepIndex;
    if (!fstudentadd.validateFields()) {
      currentTab = oldTab;
      return false;
    } else {
      currentTab = nextStepIndex;
    }
  });
  <?php } ?>
});
</script>
