<?php

namespace PHPMaker2023\Jack_Jill_school;

// Page object
$AnnouncementSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { announcement: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fannouncementsearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fannouncementsearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["Announcement_ID", [ew.Validators.integer], fields.Announcement_ID.isInvalid],
            ["Is_Active", [], fields.Is_Active.isInvalid],
            ["Topic", [], fields.Topic.isInvalid],
            ["_Message", [], fields._Message.isInvalid],
            ["Date_LastUpdate", [ew.Validators.datetime(fields.Date_LastUpdate.clientFormatPattern)], fields.Date_LastUpdate.isInvalid],
            ["_Language", [], fields._Language.isInvalid],
            ["Auto_Publish", [], fields.Auto_Publish.isInvalid],
            ["Date_Start", [ew.Validators.datetime(fields.Date_Start.clientFormatPattern)], fields.Date_Start.isInvalid],
            ["Date_End", [ew.Validators.datetime(fields.Date_End.clientFormatPattern)], fields.Date_End.isInvalid],
            ["Date_Created", [ew.Validators.datetime(fields.Date_Created.clientFormatPattern)], fields.Date_Created.isInvalid],
            ["Created_By", [], fields.Created_By.isInvalid],
            ["Translated_ID", [ew.Validators.integer], fields.Translated_ID.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "Is_Active": <?= $Page->Is_Active->toClientList($Page) ?>,
            "Auto_Publish": <?= $Page->Auto_Publish->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<?php if (!$Page->IsModal) { ?>
<div class="col-md-12">
  <div class="card shadow-sm">
    <div class="card-header">
	  <h4 class="card-title"><?php echo Language()->phrase("SearchCaption"); ?></h4>
	  <div class="card-tools">
	  <button type="button" class="btn btn-tool" data-card-widget="maximize"><i class="fas fa-expand"></i>
	  </button>
	  </div>
	  <!-- /.card-tools -->
    </div>
    <!-- /.card-header -->
    <div class="card-body">
<?php } ?>
<form name="fannouncementsearch" id="fannouncementsearch" class="<?= $Page->FormClassName ?> form-wizard" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="on" style="width:100% !important;">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="announcement">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->Announcement_ID->Visible) { // Announcement_ID ?>
    <div id="r_Announcement_ID" class="row"<?= $Page->Announcement_ID->rowAttributes() ?>>
        <label for="x_Announcement_ID" class="<?= $Page->LeftColumnClass ?>"><span id="elh_announcement_Announcement_ID"><?= $Page->Announcement_ID->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_Announcement_ID" id="z_Announcement_ID" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->Announcement_ID->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_announcement_Announcement_ID" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->Announcement_ID->getInputTextType() ?>" name="x_Announcement_ID" id="x_Announcement_ID" data-table="announcement" data-field="x_Announcement_ID" value="<?= $Page->Announcement_ID->EditValue ?>" placeholder="<?= HtmlEncode($Page->Announcement_ID->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Announcement_ID->formatPattern()) ?>"<?= $Page->Announcement_ID->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Announcement_ID->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->Is_Active->Visible) { // Is_Active ?>
    <div id="r_Is_Active" class="row"<?= $Page->Is_Active->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_announcement_Is_Active"><?= $Page->Is_Active->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_Is_Active" id="z_Is_Active" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->Is_Active->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_announcement_Is_Active" class="ew-search-field ew-search-field-single">
<div class="form-check form-switch d-inline-block">
    <input type="checkbox" class="form-check-input<?= $Page->Is_Active->isInvalidClass() ?>" data-table="announcement" data-field="x_Is_Active" data-boolean name="x_Is_Active" id="x_Is_Active" value="1"<?= ConvertToBool($Page->Is_Active->AdvancedSearch->SearchValue) ? " checked" : "" ?><?= $Page->Is_Active->editAttributes() ?>>
    <div class="invalid-feedback"><?= $Page->Is_Active->getErrorMessage(false) ?></div>
</div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->Topic->Visible) { // Topic ?>
    <div id="r_Topic" class="row"<?= $Page->Topic->rowAttributes() ?>>
        <label for="x_Topic" class="<?= $Page->LeftColumnClass ?>"><span id="elh_announcement_Topic"><?= $Page->Topic->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_Topic" id="z_Topic" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->Topic->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_announcement_Topic" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->Topic->getInputTextType() ?>" name="x_Topic" id="x_Topic" data-table="announcement" data-field="x_Topic" value="<?= $Page->Topic->EditValue ?>" size="30" maxlength="50" placeholder="<?= HtmlEncode($Page->Topic->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Topic->formatPattern()) ?>"<?= $Page->Topic->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Topic->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->_Message->Visible) { // Message ?>
    <div id="r__Message" class="row"<?= $Page->_Message->rowAttributes() ?>>
        <label for="x__Message" class="<?= $Page->LeftColumnClass ?>"><span id="elh_announcement__Message"><?= $Page->_Message->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z__Message" id="z__Message" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->_Message->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_announcement__Message" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->_Message->getInputTextType() ?>" name="x__Message" id="x__Message" data-table="announcement" data-field="x__Message" value="<?= $Page->_Message->EditValue ?>" size="35" placeholder="<?= HtmlEncode($Page->_Message->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_Message->formatPattern()) ?>"<?= $Page->_Message->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_Message->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->Date_LastUpdate->Visible) { // Date_LastUpdate ?>
    <div id="r_Date_LastUpdate" class="row"<?= $Page->Date_LastUpdate->rowAttributes() ?>>
        <label for="x_Date_LastUpdate" class="<?= $Page->LeftColumnClass ?>"><span id="elh_announcement_Date_LastUpdate"><?= $Page->Date_LastUpdate->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_Date_LastUpdate" id="z_Date_LastUpdate" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->Date_LastUpdate->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_announcement_Date_LastUpdate" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->Date_LastUpdate->getInputTextType() ?>" name="x_Date_LastUpdate" id="x_Date_LastUpdate" data-table="announcement" data-field="x_Date_LastUpdate" value="<?= $Page->Date_LastUpdate->EditValue ?>" placeholder="<?= HtmlEncode($Page->Date_LastUpdate->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Date_LastUpdate->formatPattern()) ?>"<?= $Page->Date_LastUpdate->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Date_LastUpdate->getErrorMessage(false) ?></div>
<?php if (!$Page->Date_LastUpdate->ReadOnly && !$Page->Date_LastUpdate->Disabled && !isset($Page->Date_LastUpdate->EditAttrs["readonly"]) && !isset($Page->Date_LastUpdate->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fannouncementsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(0) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.isDark() ? "dark" : "auto"
            }
        };
    ew.createDateTimePicker("fannouncementsearch", "x_Date_LastUpdate", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->_Language->Visible) { // Language ?>
    <div id="r__Language" class="row"<?= $Page->_Language->rowAttributes() ?>>
        <label for="x__Language" class="<?= $Page->LeftColumnClass ?>"><span id="elh_announcement__Language"><?= $Page->_Language->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z__Language" id="z__Language" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->_Language->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_announcement__Language" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->_Language->getInputTextType() ?>" name="x__Language" id="x__Language" data-table="announcement" data-field="x__Language" value="<?= $Page->_Language->EditValue ?>" size="30" maxlength="5" placeholder="<?= HtmlEncode($Page->_Language->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_Language->formatPattern()) ?>"<?= $Page->_Language->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_Language->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->Auto_Publish->Visible) { // Auto_Publish ?>
    <div id="r_Auto_Publish" class="row"<?= $Page->Auto_Publish->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_announcement_Auto_Publish"><?= $Page->Auto_Publish->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_Auto_Publish" id="z_Auto_Publish" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->Auto_Publish->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_announcement_Auto_Publish" class="ew-search-field ew-search-field-single">
<div class="form-check form-switch d-inline-block">
    <input type="checkbox" class="form-check-input<?= $Page->Auto_Publish->isInvalidClass() ?>" data-table="announcement" data-field="x_Auto_Publish" data-boolean name="x_Auto_Publish" id="x_Auto_Publish" value="1"<?= ConvertToBool($Page->Auto_Publish->AdvancedSearch->SearchValue) ? " checked" : "" ?><?= $Page->Auto_Publish->editAttributes() ?>>
    <div class="invalid-feedback"><?= $Page->Auto_Publish->getErrorMessage(false) ?></div>
</div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->Date_Start->Visible) { // Date_Start ?>
    <div id="r_Date_Start" class="row"<?= $Page->Date_Start->rowAttributes() ?>>
        <label for="x_Date_Start" class="<?= $Page->LeftColumnClass ?>"><span id="elh_announcement_Date_Start"><?= $Page->Date_Start->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_Date_Start" id="z_Date_Start" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->Date_Start->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_announcement_Date_Start" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->Date_Start->getInputTextType() ?>" name="x_Date_Start" id="x_Date_Start" data-table="announcement" data-field="x_Date_Start" value="<?= $Page->Date_Start->EditValue ?>" placeholder="<?= HtmlEncode($Page->Date_Start->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Date_Start->formatPattern()) ?>"<?= $Page->Date_Start->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Date_Start->getErrorMessage(false) ?></div>
<?php if (!$Page->Date_Start->ReadOnly && !$Page->Date_Start->Disabled && !isset($Page->Date_Start->EditAttrs["readonly"]) && !isset($Page->Date_Start->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fannouncementsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(0) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.isDark() ? "dark" : "auto"
            }
        };
    ew.createDateTimePicker("fannouncementsearch", "x_Date_Start", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->Date_End->Visible) { // Date_End ?>
    <div id="r_Date_End" class="row"<?= $Page->Date_End->rowAttributes() ?>>
        <label for="x_Date_End" class="<?= $Page->LeftColumnClass ?>"><span id="elh_announcement_Date_End"><?= $Page->Date_End->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_Date_End" id="z_Date_End" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->Date_End->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_announcement_Date_End" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->Date_End->getInputTextType() ?>" name="x_Date_End" id="x_Date_End" data-table="announcement" data-field="x_Date_End" value="<?= $Page->Date_End->EditValue ?>" placeholder="<?= HtmlEncode($Page->Date_End->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Date_End->formatPattern()) ?>"<?= $Page->Date_End->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Date_End->getErrorMessage(false) ?></div>
<?php if (!$Page->Date_End->ReadOnly && !$Page->Date_End->Disabled && !isset($Page->Date_End->EditAttrs["readonly"]) && !isset($Page->Date_End->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fannouncementsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(0) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.isDark() ? "dark" : "auto"
            }
        };
    ew.createDateTimePicker("fannouncementsearch", "x_Date_End", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->Date_Created->Visible) { // Date_Created ?>
    <div id="r_Date_Created" class="row"<?= $Page->Date_Created->rowAttributes() ?>>
        <label for="x_Date_Created" class="<?= $Page->LeftColumnClass ?>"><span id="elh_announcement_Date_Created"><?= $Page->Date_Created->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_Date_Created" id="z_Date_Created" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->Date_Created->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_announcement_Date_Created" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->Date_Created->getInputTextType() ?>" name="x_Date_Created" id="x_Date_Created" data-table="announcement" data-field="x_Date_Created" value="<?= $Page->Date_Created->EditValue ?>" placeholder="<?= HtmlEncode($Page->Date_Created->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Date_Created->formatPattern()) ?>"<?= $Page->Date_Created->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Date_Created->getErrorMessage(false) ?></div>
<?php if (!$Page->Date_Created->ReadOnly && !$Page->Date_Created->Disabled && !isset($Page->Date_Created->EditAttrs["readonly"]) && !isset($Page->Date_Created->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fannouncementsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(0) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.isDark() ? "dark" : "auto"
            }
        };
    ew.createDateTimePicker("fannouncementsearch", "x_Date_Created", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->Created_By->Visible) { // Created_By ?>
    <div id="r_Created_By" class="row"<?= $Page->Created_By->rowAttributes() ?>>
        <label for="x_Created_By" class="<?= $Page->LeftColumnClass ?>"><span id="elh_announcement_Created_By"><?= $Page->Created_By->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_Created_By" id="z_Created_By" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->Created_By->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_announcement_Created_By" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->Created_By->getInputTextType() ?>" name="x_Created_By" id="x_Created_By" data-table="announcement" data-field="x_Created_By" value="<?= $Page->Created_By->EditValue ?>" size="30" maxlength="200" placeholder="<?= HtmlEncode($Page->Created_By->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Created_By->formatPattern()) ?>"<?= $Page->Created_By->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Created_By->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->Translated_ID->Visible) { // Translated_ID ?>
    <div id="r_Translated_ID" class="row"<?= $Page->Translated_ID->rowAttributes() ?>>
        <label for="x_Translated_ID" class="<?= $Page->LeftColumnClass ?>"><span id="elh_announcement_Translated_ID"><?= $Page->Translated_ID->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_Translated_ID" id="z_Translated_ID" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->Translated_ID->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_announcement_Translated_ID" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->Translated_ID->getInputTextType() ?>" name="x_Translated_ID" id="x_Translated_ID" data-table="announcement" data-field="x_Translated_ID" value="<?= $Page->Translated_ID->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->Translated_ID->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Translated_ID->formatPattern()) ?>"<?= $Page->Translated_ID->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Translated_ID->getErrorMessage(false) ?></div>
<script type="text/javascript">
loadjs.ready(["fannouncementsearch", "jquerynumber"], function() {
	ew.createjQueryNumber("fannouncementsearch", "x_Translated_ID", {"number": true, "decimals": 0, "dec_point": "<?php echo $DECIMAL_SEPARATOR ?>", "thousands_sep" : "<?php echo $GROUPING_SEPARATOR ?>"});
});
</script>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fannouncementsearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fannouncementsearch"><?= $Language->phrase("Cancel") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="fannouncementsearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php if (!$Page->IsModal) { ?>
		</div>
     <!-- /.card-body -->
     </div>
  <!-- /.card -->
</div>
<?php } ?>
<div class="clearfix">&nbsp;</div>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("announcement");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
