<?php

namespace PHPMaker2023\Jack_Jill_school;

use Slim\App;
use Slim\Routing\RouteCollectorProxy;
use Slim\Exception\HttpNotFoundException;

// Handle Routes
return function (App $app) {
	// breadcrumblinksaddsp
    $app->any('/breadcrumblinksaddsp', BreadcrumblinksaddspController::class)->add(PermissionMiddleware::class)->setName('breadcrumblinksaddsp-breadcrumblinksaddsp-custom'); // custom

	// breadcrumblinkschecksp
    $app->any('/breadcrumblinkschecksp', BreadcrumblinkscheckspController::class)->add(PermissionMiddleware::class)->setName('breadcrumblinkschecksp-breadcrumblinkschecksp-custom'); // custom

	// breadcrumblinksdeletesp
    $app->any('/breadcrumblinksdeletesp', BreadcrumblinksdeletespController::class)->add(PermissionMiddleware::class)->setName('breadcrumblinksdeletesp-breadcrumblinksdeletesp-custom'); // custom

	// breadcrumblinksmovesp
    $app->any('/breadcrumblinksmovesp', BreadcrumblinksmovespController::class)->add(PermissionMiddleware::class)->setName('breadcrumblinksmovesp-breadcrumblinksmovesp-custom'); // custom

	// loadhelponline
    $app->any('/loadhelponline', LoadhelponlineController::class)->add(PermissionMiddleware::class)->setName('loadhelponline-loadhelponline-custom'); // custom

	// loadaboutus
    $app->any('/loadaboutus', LoadaboutusController::class)->add(PermissionMiddleware::class)->setName('loadaboutus-loadaboutus-custom'); // custom

	// loadtermsconditions
    $app->any('/loadtermsconditions', LoadtermsconditionsController::class)->add(PermissionMiddleware::class)->setName('loadtermsconditions-loadtermsconditions-custom'); // custom

	// printtermsconditions
    $app->any('/printtermsconditions', PrinttermsconditionsController::class)->add(PermissionMiddleware::class)->setName('printtermsconditions-printtermsconditions-custom'); // custom

    // employees
    $app->map(["GET","POST","OPTIONS"], '/employeeslist[/{EmployeeID}]', EmployeesController::class . ':list')->add(PermissionMiddleware::class)->setName('employeeslist-employees-list'); // list
    $app->map(["GET","POST","OPTIONS"], '/employeesadd[/{EmployeeID}]', EmployeesController::class . ':add')->add(PermissionMiddleware::class)->setName('employeesadd-employees-add'); // add
    $app->map(["GET","POST","OPTIONS"], '/employeesview[/{EmployeeID}]', EmployeesController::class . ':view')->add(PermissionMiddleware::class)->setName('employeesview-employees-view'); // view
    $app->map(["GET","POST","OPTIONS"], '/employeesedit[/{EmployeeID}]', EmployeesController::class . ':edit')->add(PermissionMiddleware::class)->setName('employeesedit-employees-edit'); // edit
    $app->map(["GET","POST","OPTIONS"], '/employeesdelete[/{EmployeeID}]', EmployeesController::class . ':delete')->add(PermissionMiddleware::class)->setName('employeesdelete-employees-delete'); // delete
    $app->map(["GET","POST","OPTIONS"], '/employeessearch', EmployeesController::class . ':search')->add(PermissionMiddleware::class)->setName('employeessearch-employees-search'); // search

    // userlevelpermissions
    $app->map(["GET","POST","OPTIONS"], '/userlevelpermissionslist[/{keys:.*}]', UserlevelpermissionsController::class . ':list')->add(PermissionMiddleware::class)->setName('userlevelpermissionslist-userlevelpermissions-list'); // list
    $app->map(["GET","POST","OPTIONS"], '/userlevelpermissionsadd[/{keys:.*}]', UserlevelpermissionsController::class . ':add')->add(PermissionMiddleware::class)->setName('userlevelpermissionsadd-userlevelpermissions-add'); // add
    $app->map(["GET","POST","OPTIONS"], '/userlevelpermissionsview[/{keys:.*}]', UserlevelpermissionsController::class . ':view')->add(PermissionMiddleware::class)->setName('userlevelpermissionsview-userlevelpermissions-view'); // view
    $app->map(["GET","POST","OPTIONS"], '/userlevelpermissionsedit[/{keys:.*}]', UserlevelpermissionsController::class . ':edit')->add(PermissionMiddleware::class)->setName('userlevelpermissionsedit-userlevelpermissions-edit'); // edit
    $app->map(["GET","POST","OPTIONS"], '/userlevelpermissionsdelete[/{keys:.*}]', UserlevelpermissionsController::class . ':delete')->add(PermissionMiddleware::class)->setName('userlevelpermissionsdelete-userlevelpermissions-delete'); // delete

    // userlevels
    $app->map(["GET","POST","OPTIONS"], '/userlevelslist[/{userlevelid}]', UserlevelsController::class . ':list')->add(PermissionMiddleware::class)->setName('userlevelslist-userlevels-list'); // list
    $app->map(["GET","POST","OPTIONS"], '/userlevelsadd[/{userlevelid}]', UserlevelsController::class . ':add')->add(PermissionMiddleware::class)->setName('userlevelsadd-userlevels-add'); // add
    $app->map(["GET","POST","OPTIONS"], '/userlevelsview[/{userlevelid}]', UserlevelsController::class . ':view')->add(PermissionMiddleware::class)->setName('userlevelsview-userlevels-view'); // view
    $app->map(["GET","POST","OPTIONS"], '/userlevelsedit[/{userlevelid}]', UserlevelsController::class . ':edit')->add(PermissionMiddleware::class)->setName('userlevelsedit-userlevels-edit'); // edit
    $app->map(["GET","POST","OPTIONS"], '/userlevelsdelete[/{userlevelid}]', UserlevelsController::class . ':delete')->add(PermissionMiddleware::class)->setName('userlevelsdelete-userlevels-delete'); // delete

    // news
    $app->map(["GET", "POST", "OPTIONS"], '/news[/{params:.*}]', NewsController::class . ':custom')->add(PermissionMiddleware::class)->setName('news-news-custom'); // custom

    // usersprofile
    $app->map(["GET","POST","OPTIONS"], '/usersprofilelist[/{EmployeeID}]', UsersprofileController::class . ':list')->add(PermissionMiddleware::class)->setName('usersprofilelist-usersprofile-list'); // list

    // tasks
    $app->map(["GET","POST","OPTIONS"], '/taskslist[/{TaskID:.*}]', TasksController::class . ':list')->add(PermissionMiddleware::class)->setName('taskslist-tasks-list'); // list
    $app->map(["GET","POST","OPTIONS"], '/tasksadd[/{TaskID:.*}]', TasksController::class . ':add')->add(PermissionMiddleware::class)->setName('tasksadd-tasks-add'); // add
    $app->map(["GET","POST","OPTIONS"], '/tasksview[/{TaskID:.*}]', TasksController::class . ':view')->add(PermissionMiddleware::class)->setName('tasksview-tasks-view'); // view
    $app->map(["GET","POST","OPTIONS"], '/tasksedit[/{TaskID:.*}]', TasksController::class . ':edit')->add(PermissionMiddleware::class)->setName('tasksedit-tasks-edit'); // edit
    $app->map(["GET","POST","OPTIONS"], '/tasksdelete[/{TaskID:.*}]', TasksController::class . ':delete')->add(PermissionMiddleware::class)->setName('tasksdelete-tasks-delete'); // delete

    // calendar
    $app->map(["GET","POST","OPTIONS"], '/calendarlist[/{Id}]', CalendarController::class . ':list')->add(PermissionMiddleware::class)->setName('calendarlist-calendar-list'); // list
    $app->map(["GET","POST","OPTIONS"], '/calendaradd[/{Id}]', CalendarController::class . ':add')->add(PermissionMiddleware::class)->setName('calendaradd-calendar-add'); // add
    $app->map(["GET","POST","OPTIONS"], '/calendarview[/{Id}]', CalendarController::class . ':view')->add(PermissionMiddleware::class)->setName('calendarview-calendar-view'); // view
    $app->map(["GET","POST","OPTIONS"], '/calendaredit[/{Id}]', CalendarController::class . ':edit')->add(PermissionMiddleware::class)->setName('calendaredit-calendar-edit'); // edit
    $app->map(["GET","POST","OPTIONS"], '/calendardelete[/{Id}]', CalendarController::class . ':delete')->add(PermissionMiddleware::class)->setName('calendardelete-calendar-delete'); // delete

    // Calendar1
    $app->map(["GET", "POST", "OPTIONS"], '/calendar1', Calendar1Controller::class . ':calendar')->add(PermissionMiddleware::class)->setName('calendar1-Calendar1-calendar'); // calendar
    $app->map(["GET","POST","OPTIONS"], '/calendar1add[/{Id}]', Calendar1Controller::class . ':add')->add(PermissionMiddleware::class)->setName('calendar1add-Calendar1-add'); // add
    $app->map(["GET","OPTIONS"], '/calendar1view[/{Id}]', Calendar1Controller::class . ':view')->add(PermissionMiddleware::class)->setName('calendar1view-Calendar1-view'); // view
    $app->map(["GET","POST","OPTIONS"], '/calendar1edit[/{Id}]', Calendar1Controller::class . ':edit')->add(PermissionMiddleware::class)->setName('calendar1edit-Calendar1-edit'); // edit
    $app->map(["GET","POST","OPTIONS"], '/calendar1delete[/{Id}]', Calendar1Controller::class . ':delete')->add(PermissionMiddleware::class)->setName('calendar1delete-Calendar1-delete'); // delete

    // announcement
    $app->map(["GET","POST","OPTIONS"], '/announcementlist[/{Announcement_ID}]', AnnouncementController::class . ':list')->add(PermissionMiddleware::class)->setName('announcementlist-announcement-list'); // list
    $app->map(["GET","POST","OPTIONS"], '/announcementadd[/{Announcement_ID}]', AnnouncementController::class . ':add')->add(PermissionMiddleware::class)->setName('announcementadd-announcement-add'); // add
    $app->map(["GET","POST","OPTIONS"], '/announcementview[/{Announcement_ID}]', AnnouncementController::class . ':view')->add(PermissionMiddleware::class)->setName('announcementview-announcement-view'); // view
    $app->map(["GET","POST","OPTIONS"], '/announcementedit[/{Announcement_ID}]', AnnouncementController::class . ':edit')->add(PermissionMiddleware::class)->setName('announcementedit-announcement-edit'); // edit
    $app->map(["GET","POST","OPTIONS"], '/announcementdelete[/{Announcement_ID}]', AnnouncementController::class . ':delete')->add(PermissionMiddleware::class)->setName('announcementdelete-announcement-delete'); // delete
    $app->map(["GET","POST","OPTIONS"], '/announcementsearch', AnnouncementController::class . ':search')->add(PermissionMiddleware::class)->setName('announcementsearch-announcement-search'); // search

    // breadcrumblinks
    $app->map(["GET","POST","OPTIONS"], '/breadcrumblinkslist[/{Page_Title:.*}]', BreadcrumblinksController::class . ':list')->add(PermissionMiddleware::class)->setName('breadcrumblinkslist-breadcrumblinks-list'); // list
    $app->map(["GET","POST","OPTIONS"], '/breadcrumblinksadd[/{Page_Title:.*}]', BreadcrumblinksController::class . ':add')->add(PermissionMiddleware::class)->setName('breadcrumblinksadd-breadcrumblinks-add'); // add
    $app->map(["GET","POST","OPTIONS"], '/breadcrumblinksview[/{Page_Title:.*}]', BreadcrumblinksController::class . ':view')->add(PermissionMiddleware::class)->setName('breadcrumblinksview-breadcrumblinks-view'); // view
    $app->map(["GET","POST","OPTIONS"], '/breadcrumblinksedit[/{Page_Title:.*}]', BreadcrumblinksController::class . ':edit')->add(PermissionMiddleware::class)->setName('breadcrumblinksedit-breadcrumblinks-edit'); // edit
    $app->map(["GET","POST","OPTIONS"], '/breadcrumblinksdelete[/{Page_Title:.*}]', BreadcrumblinksController::class . ':delete')->add(PermissionMiddleware::class)->setName('breadcrumblinksdelete-breadcrumblinks-delete'); // delete

    // events
    $app->map(["GET","POST","OPTIONS"], '/eventslist[/{Event_ID}]', EventsController::class . ':list')->add(PermissionMiddleware::class)->setName('eventslist-events-list'); // list
    $app->map(["GET","POST","OPTIONS"], '/eventsadd[/{Event_ID}]', EventsController::class . ':add')->add(PermissionMiddleware::class)->setName('eventsadd-events-add'); // add
    $app->map(["GET","POST","OPTIONS"], '/eventsview[/{Event_ID}]', EventsController::class . ':view')->add(PermissionMiddleware::class)->setName('eventsview-events-view'); // view
    $app->map(["GET","POST","OPTIONS"], '/eventsedit[/{Event_ID}]', EventsController::class . ':edit')->add(PermissionMiddleware::class)->setName('eventsedit-events-edit'); // edit
    $app->map(["GET","POST","OPTIONS"], '/eventsdelete[/{Event_ID}]', EventsController::class . ':delete')->add(PermissionMiddleware::class)->setName('eventsdelete-events-delete'); // delete

    // help
    $app->map(["GET","POST","OPTIONS"], '/helplist[/{Help_ID}]', HelpController::class . ':list')->add(PermissionMiddleware::class)->setName('helplist-help-list'); // list
    $app->map(["GET","POST","OPTIONS"], '/helpadd[/{Help_ID}]', HelpController::class . ':add')->add(PermissionMiddleware::class)->setName('helpadd-help-add'); // add
    $app->map(["GET","POST","OPTIONS"], '/helpview[/{Help_ID}]', HelpController::class . ':view')->add(PermissionMiddleware::class)->setName('helpview-help-view'); // view
    $app->map(["GET","POST","OPTIONS"], '/helpedit[/{Help_ID}]', HelpController::class . ':edit')->add(PermissionMiddleware::class)->setName('helpedit-help-edit'); // edit
    $app->map(["GET","POST","OPTIONS"], '/helpdelete[/{Help_ID}]', HelpController::class . ':delete')->add(PermissionMiddleware::class)->setName('helpdelete-help-delete'); // delete
    $app->map(["GET","OPTIONS"], '/helppreview', HelpController::class . ':preview')->add(PermissionMiddleware::class)->setName('helppreview-help-preview'); // preview

    // help_categories
    $app->map(["GET","POST","OPTIONS"], '/helpcategorieslist[/{Category_ID}]', HelpCategoriesController::class . ':list')->add(PermissionMiddleware::class)->setName('helpcategorieslist-help_categories-list'); // list
    $app->map(["GET","POST","OPTIONS"], '/helpcategoriesadd[/{Category_ID}]', HelpCategoriesController::class . ':add')->add(PermissionMiddleware::class)->setName('helpcategoriesadd-help_categories-add'); // add
    $app->map(["GET","POST","OPTIONS"], '/helpcategoriesview[/{Category_ID}]', HelpCategoriesController::class . ':view')->add(PermissionMiddleware::class)->setName('helpcategoriesview-help_categories-view'); // view
    $app->map(["GET","POST","OPTIONS"], '/helpcategoriesedit[/{Category_ID}]', HelpCategoriesController::class . ':edit')->add(PermissionMiddleware::class)->setName('helpcategoriesedit-help_categories-edit'); // edit
    $app->map(["GET","POST","OPTIONS"], '/helpcategoriesdelete[/{Category_ID}]', HelpCategoriesController::class . ':delete')->add(PermissionMiddleware::class)->setName('helpcategoriesdelete-help_categories-delete'); // delete

    // languages
    $app->map(["GET","POST","OPTIONS"], '/languageslist[/{Language_Code:.*}]', LanguagesController::class . ':list')->add(PermissionMiddleware::class)->setName('languageslist-languages-list'); // list
    $app->map(["GET","POST","OPTIONS"], '/languagesadd[/{Language_Code:.*}]', LanguagesController::class . ':add')->add(PermissionMiddleware::class)->setName('languagesadd-languages-add'); // add
    $app->map(["GET","POST","OPTIONS"], '/languagesview[/{Language_Code:.*}]', LanguagesController::class . ':view')->add(PermissionMiddleware::class)->setName('languagesview-languages-view'); // view
    $app->map(["GET","POST","OPTIONS"], '/languagesedit[/{Language_Code:.*}]', LanguagesController::class . ':edit')->add(PermissionMiddleware::class)->setName('languagesedit-languages-edit'); // edit
    $app->map(["GET","POST","OPTIONS"], '/languagesdelete[/{Language_Code:.*}]', LanguagesController::class . ':delete')->add(PermissionMiddleware::class)->setName('languagesdelete-languages-delete'); // delete

    // settings
    $app->map(["GET","POST","OPTIONS"], '/settingslist[/{Option_ID}]', SettingsController::class . ':list')->add(PermissionMiddleware::class)->setName('settingslist-settings-list'); // list
    $app->map(["GET","POST","OPTIONS"], '/settingsadd[/{Option_ID}]', SettingsController::class . ':add')->add(PermissionMiddleware::class)->setName('settingsadd-settings-add'); // add
    $app->map(["GET","POST","OPTIONS"], '/settingsview[/{Option_ID}]', SettingsController::class . ':view')->add(PermissionMiddleware::class)->setName('settingsview-settings-view'); // view
    $app->map(["GET","POST","OPTIONS"], '/settingsedit[/{Option_ID}]', SettingsController::class . ':edit')->add(PermissionMiddleware::class)->setName('settingsedit-settings-edit'); // edit
    $app->map(["GET","POST","OPTIONS"], '/settingsdelete[/{Option_ID}]', SettingsController::class . ':delete')->add(PermissionMiddleware::class)->setName('settingsdelete-settings-delete'); // delete

    // stats_counter
    $app->map(["GET","POST","OPTIONS"], '/statscounterlist[/{keys:.*}]', StatsCounterController::class . ':list')->add(PermissionMiddleware::class)->setName('statscounterlist-stats_counter-list'); // list
    $app->map(["GET","POST","OPTIONS"], '/statscounteradd[/{keys:.*}]', StatsCounterController::class . ':add')->add(PermissionMiddleware::class)->setName('statscounteradd-stats_counter-add'); // add
    $app->map(["GET","POST","OPTIONS"], '/statscounterview[/{keys:.*}]', StatsCounterController::class . ':view')->add(PermissionMiddleware::class)->setName('statscounterview-stats_counter-view'); // view

    // stats_counterlog
    $app->map(["GET","POST","OPTIONS"], '/statscounterloglist[/{IP_Address:.*}]', StatsCounterlogController::class . ':list')->add(PermissionMiddleware::class)->setName('statscounterloglist-stats_counterlog-list'); // list
    $app->map(["GET","POST","OPTIONS"], '/statscounterlogadd[/{IP_Address:.*}]', StatsCounterlogController::class . ':add')->add(PermissionMiddleware::class)->setName('statscounterlogadd-stats_counterlog-add'); // add

    // stats_date
    $app->map(["GET","POST","OPTIONS"], '/statsdatelist[/{keys:.*}]', StatsDateController::class . ':list')->add(PermissionMiddleware::class)->setName('statsdatelist-stats_date-list'); // list
    $app->map(["GET","POST","OPTIONS"], '/statsdateadd[/{keys:.*}]', StatsDateController::class . ':add')->add(PermissionMiddleware::class)->setName('statsdateadd-stats_date-add'); // add
    $app->map(["GET","POST","OPTIONS"], '/statsdateview[/{keys:.*}]', StatsDateController::class . ':view')->add(PermissionMiddleware::class)->setName('statsdateview-stats_date-view'); // view

    // stats_hour
    $app->map(["GET","POST","OPTIONS"], '/statshourlist[/{keys:.*}]', StatsHourController::class . ':list')->add(PermissionMiddleware::class)->setName('statshourlist-stats_hour-list'); // list
    $app->map(["GET","POST","OPTIONS"], '/statshouradd[/{keys:.*}]', StatsHourController::class . ':add')->add(PermissionMiddleware::class)->setName('statshouradd-stats_hour-add'); // add
    $app->map(["GET","POST","OPTIONS"], '/statshourview[/{keys:.*}]', StatsHourController::class . ':view')->add(PermissionMiddleware::class)->setName('statshourview-stats_hour-view'); // view

    // stats_month
    $app->map(["GET","POST","OPTIONS"], '/statsmonthlist[/{keys:.*}]', StatsMonthController::class . ':list')->add(PermissionMiddleware::class)->setName('statsmonthlist-stats_month-list'); // list
    $app->map(["GET","POST","OPTIONS"], '/statsmonthadd[/{keys:.*}]', StatsMonthController::class . ':add')->add(PermissionMiddleware::class)->setName('statsmonthadd-stats_month-add'); // add
    $app->map(["GET","POST","OPTIONS"], '/statsmonthview[/{keys:.*}]', StatsMonthController::class . ':view')->add(PermissionMiddleware::class)->setName('statsmonthview-stats_month-view'); // view

    // stats_year
    $app->map(["GET","POST","OPTIONS"], '/statsyearlist[/{Year}]', StatsYearController::class . ':list')->add(PermissionMiddleware::class)->setName('statsyearlist-stats_year-list'); // list
    $app->map(["GET","POST","OPTIONS"], '/statsyearadd[/{Year}]', StatsYearController::class . ':add')->add(PermissionMiddleware::class)->setName('statsyearadd-stats_year-add'); // add
    $app->map(["GET","POST","OPTIONS"], '/statsyearview[/{Year}]', StatsYearController::class . ':view')->add(PermissionMiddleware::class)->setName('statsyearview-stats_year-view'); // view

    // subscriptions
    $app->map(["GET","POST","OPTIONS"], '/subscriptionslist[/{Id}]', SubscriptionsController::class . ':list')->add(PermissionMiddleware::class)->setName('subscriptionslist-subscriptions-list'); // list
    $app->map(["GET","POST","OPTIONS"], '/subscriptionsadd[/{Id}]', SubscriptionsController::class . ':add')->add(PermissionMiddleware::class)->setName('subscriptionsadd-subscriptions-add'); // add
    $app->map(["GET","POST","OPTIONS"], '/subscriptionsview[/{Id}]', SubscriptionsController::class . ':view')->add(PermissionMiddleware::class)->setName('subscriptionsview-subscriptions-view'); // view
    $app->map(["GET","POST","OPTIONS"], '/subscriptionsedit[/{Id}]', SubscriptionsController::class . ':edit')->add(PermissionMiddleware::class)->setName('subscriptionsedit-subscriptions-edit'); // edit
    $app->map(["GET","POST","OPTIONS"], '/subscriptionsdelete[/{Id}]', SubscriptionsController::class . ':delete')->add(PermissionMiddleware::class)->setName('subscriptionsdelete-subscriptions-delete'); // delete

    // audittrail
    $app->map(["GET","POST","OPTIONS"], '/audittraillist[/{Id}]', AudittrailController::class . ':list')->add(PermissionMiddleware::class)->setName('audittraillist-audittrail-list'); // list
    $app->map(["GET","POST","OPTIONS"], '/audittrailadd[/{Id}]', AudittrailController::class . ':add')->add(PermissionMiddleware::class)->setName('audittrailadd-audittrail-add'); // add
    $app->map(["GET","POST","OPTIONS"], '/audittrailview[/{Id}]', AudittrailController::class . ':view')->add(PermissionMiddleware::class)->setName('audittrailview-audittrail-view'); // view
    $app->map(["GET","POST","OPTIONS"], '/audittrailedit[/{Id}]', AudittrailController::class . ':edit')->add(PermissionMiddleware::class)->setName('audittrailedit-audittrail-edit'); // edit
    $app->map(["GET","POST","OPTIONS"], '/audittraildelete[/{Id}]', AudittrailController::class . ':delete')->add(PermissionMiddleware::class)->setName('audittraildelete-audittrail-delete'); // delete

    // student
    $app->map(["GET","POST","OPTIONS"], '/studentlist[/{studentID}]', StudentController::class . ':list')->add(PermissionMiddleware::class)->setName('studentlist-student-list'); // list
    $app->map(["GET","POST","OPTIONS"], '/studentadd[/{studentID}]', StudentController::class . ':add')->add(PermissionMiddleware::class)->setName('studentadd-student-add'); // add
    $app->map(["GET","POST","OPTIONS"], '/studentview[/{studentID}]', StudentController::class . ':view')->add(PermissionMiddleware::class)->setName('studentview-student-view'); // view
    $app->map(["GET","POST","OPTIONS"], '/studentedit[/{studentID}]', StudentController::class . ':edit')->add(PermissionMiddleware::class)->setName('studentedit-student-edit'); // edit
    $app->map(["GET","POST","OPTIONS"], '/studentdelete[/{studentID}]', StudentController::class . ':delete')->add(PermissionMiddleware::class)->setName('studentdelete-student-delete'); // delete

    // Students_Reports
    $app->map(["GET", "POST", "OPTIONS"], '/studentsreports/StudentsChart', StudentsReportsController::class . ':StudentsChart')->add(PermissionMiddleware::class)->setName('studentsreports-Students_Reports-summary-StudentsChart'); // StudentsChart
    $app->map(["GET", "POST", "OPTIONS"], '/studentsreports', StudentsReportsController::class . ':summary')->add(PermissionMiddleware::class)->setName('studentsreports-Students_Reports-summary'); // summary

    // password_reset_logs
    $app->map(["GET","POST","OPTIONS"], '/passwordresetlogslist[/{id}]', PasswordResetLogsController::class . ':list')->add(PermissionMiddleware::class)->setName('passwordresetlogslist-password_reset_logs-list'); // list
    $app->map(["GET","POST","OPTIONS"], '/passwordresetlogsadd[/{id}]', PasswordResetLogsController::class . ':add')->add(PermissionMiddleware::class)->setName('passwordresetlogsadd-password_reset_logs-add'); // add
    $app->map(["GET","POST","OPTIONS"], '/passwordresetlogsview[/{id}]', PasswordResetLogsController::class . ':view')->add(PermissionMiddleware::class)->setName('passwordresetlogsview-password_reset_logs-view'); // view
    $app->map(["GET","POST","OPTIONS"], '/passwordresetlogsedit[/{id}]', PasswordResetLogsController::class . ':edit')->add(PermissionMiddleware::class)->setName('passwordresetlogsedit-password_reset_logs-edit'); // edit
    $app->map(["GET","POST","OPTIONS"], '/passwordresetlogsdelete[/{id}]', PasswordResetLogsController::class . ':delete')->add(PermissionMiddleware::class)->setName('passwordresetlogsdelete-password_reset_logs-delete'); // delete

    // password_reset_otps
    $app->map(["GET","POST","OPTIONS"], '/passwordresetotpslist[/{id}]', PasswordResetOtpsController::class . ':list')->add(PermissionMiddleware::class)->setName('passwordresetotpslist-password_reset_otps-list'); // list
    $app->map(["GET","POST","OPTIONS"], '/passwordresetotpsadd[/{id}]', PasswordResetOtpsController::class . ':add')->add(PermissionMiddleware::class)->setName('passwordresetotpsadd-password_reset_otps-add'); // add
    $app->map(["GET","POST","OPTIONS"], '/passwordresetotpsview[/{id}]', PasswordResetOtpsController::class . ':view')->add(PermissionMiddleware::class)->setName('passwordresetotpsview-password_reset_otps-view'); // view
    $app->map(["GET","POST","OPTIONS"], '/passwordresetotpsedit[/{id}]', PasswordResetOtpsController::class . ':edit')->add(PermissionMiddleware::class)->setName('passwordresetotpsedit-password_reset_otps-edit'); // edit
    $app->map(["GET","POST","OPTIONS"], '/passwordresetotpsdelete[/{id}]', PasswordResetOtpsController::class . ':delete')->add(PermissionMiddleware::class)->setName('passwordresetotpsdelete-password_reset_otps-delete'); // delete

    // employee_sessions
    $app->map(["GET","POST","OPTIONS"], '/employeesessionslist[/{employee_id}]', EmployeeSessionsController::class . ':list')->add(PermissionMiddleware::class)->setName('employeesessionslist-employee_sessions-list'); // list
    $app->map(["GET","POST","OPTIONS"], '/employeesessionsview[/{employee_id}]', EmployeeSessionsController::class . ':view')->add(PermissionMiddleware::class)->setName('employeesessionsview-employee_sessions-view'); // view
    $app->map(["GET","POST","OPTIONS"], '/employeesessionsdelete[/{employee_id}]', EmployeeSessionsController::class . ':delete')->add(PermissionMiddleware::class)->setName('employeesessionsdelete-employee_sessions-delete'); // delete

    // privacy
    $app->map(["GET","POST","OPTIONS"], '/privacy', OthersController::class . ':privacy')->add(PermissionMiddleware::class)->setName('privacy');

    // personal_data
    $app->map(["GET","POST","OPTIONS"], '/personaldata', OthersController::class . ':personaldata')->add(PermissionMiddleware::class)->setName('personaldata');

    // login
    $app->map(["GET","POST","OPTIONS"], '/login[/{provider}]', OthersController::class . ':login')->add(PermissionMiddleware::class)->setName('login');

    // login2fa
    $app->map(["GET","POST","OPTIONS"], '/login2fa', OthersController::class . ':login2fa')->add(PermissionMiddleware::class)->setName('login2fa');

    // reset_password
    $app->map(["GET","POST","OPTIONS"], '/resetpassword', OthersController::class . ':resetpassword')->add(PermissionMiddleware::class)->setName('resetpassword');

    // change_password
    $app->map(["GET","POST","OPTIONS"], '/changepassword', OthersController::class . ':changepassword')->add(PermissionMiddleware::class)->setName('changepassword');

    // userpriv
    $app->map(["GET","POST","OPTIONS"], '/userpriv', OthersController::class . ':userpriv')->add(PermissionMiddleware::class)->setName('userpriv');

    // logout
    $app->map(["GET","POST","OPTIONS"], '/logout', OthersController::class . ':logout')->add(PermissionMiddleware::class)->setName('logout');

    // captcha
    $app->map(["GET","OPTIONS"], '/captcha[/{page}]', OthersController::class . ':captcha')->add(PermissionMiddleware::class)->setName('captcha');

    // barcode
    $app->map(["GET","OPTIONS"], '/barcode', OthersController::class . ':barcode')->add(PermissionMiddleware::class)->setName('barcode');

    // Swagger
    $app->get('/' . Config("SWAGGER_ACTION"), OthersController::class . ':swagger')->setName(Config("SWAGGER_ACTION")); // Swagger

    // Index
    $app->get('/[index]', OthersController::class . ':index')->add(PermissionMiddleware::class)->setName('index');

    // Route Action event
    if (function_exists(PROJECT_NAMESPACE . "Route_Action")) {
        if (Route_Action($app) === false) {
            return;
        }
    }

    /**
     * Catch-all route to serve a 404 Not Found page if none of the routes match
     * NOTE: Make sure this route is defined last.
     */
    $app->map(
        ['GET', 'POST', 'PUT', 'DELETE', 'PATCH'],
        '/{routes:.+}',
        function ($request, $response, $params) {
            throw new HttpNotFoundException($request, str_replace("%p", $params["routes"], Container("language")->phrase("PageNotFound")));
        }
    );
};
