<?php

namespace PHPMaker2023\Jack_Jill_school;

use Slim\Views\PhpRenderer;
use Slim\Csrf\Guard;
use Slim\HttpCache\CacheProvider;
use Slim\Flash\Messages;
use Psr\Container\ContainerInterface;
use Monolog\Logger;
use Monolog\Handler\RotatingFileHandler;
use Doctrine\DBAL\Logging\LoggerChain;
use Doctrine\DBAL\Logging\DebugStack;

return [
    "cache" => \DI\create(CacheProvider::class),
    "flash" => fn(ContainerInterface $c) => new Messages(),
    "view" => fn(ContainerInterface $c) => new PhpRenderer($GLOBALS["RELATIVE_PATH"] . "views/"),
    "audit" => fn(ContainerInterface $c) => (new Logger("audit"))->pushHandler(new AuditTrailHandler("log/audit.log")), // For audit trail
    "log" => fn(ContainerInterface $c) => (new Logger("log"))->pushHandler(new RotatingFileHandler($GLOBALS["RELATIVE_PATH"] . "log/log.log")),
    "sqllogger" => function (ContainerInterface $c) {
        $loggers = [];
        if (Config("DEBUG")) {
            $loggers[] = $c->get("debugstack");
        }
        $loggers[] = $c->get("debugsqllogger");
        return (count($loggers) > 0) ? new LoggerChain($loggers) : null;
    },
    "csrf" => fn(ContainerInterface $c) => new Guard($GLOBALS["ResponseFactory"], Config("CSRF_PREFIX")),
    "debugstack" => \DI\create(DebugStack::class),
    "debugsqllogger" => \DI\create(DebugSqlLogger::class),
    "security" => \DI\create(AdvancedSecurity::class),
    "profile" => \DI\create(UserProfile::class),
    "language" => \DI\create(Language::class),
    "timer" => \DI\create(Timer::class),
    "session" => \DI\create(HttpSession::class),

    // Tables
    "employees" => \DI\create(Employees::class),
    "userlevelpermissions" => \DI\create(Userlevelpermissions::class),
    "userlevels" => \DI\create(Userlevels::class),
    "news" => \DI\create(News::class),
    "usersprofile" => \DI\create(Usersprofile::class),
    "tasks" => \DI\create(Tasks::class),
    "calendar" => \DI\create(Calendar::class),
    "Calendar1" => \DI\create(Calendar1::class),
    "announcement" => \DI\create(Announcement::class),
    "breadcrumblinks" => \DI\create(Breadcrumblinks::class),
    "events" => \DI\create(Events::class),
    "help" => \DI\create(Help::class),
    "help_categories" => \DI\create(HelpCategories::class),
    "languages" => \DI\create(Languages::class),
    "settings" => \DI\create(Settings::class),
    "stats_counter" => \DI\create(StatsCounter::class),
    "stats_counterlog" => \DI\create(StatsCounterlog::class),
    "stats_date" => \DI\create(StatsDate::class),
    "stats_hour" => \DI\create(StatsHour::class),
    "stats_month" => \DI\create(StatsMonth::class),
    "stats_year" => \DI\create(StatsYear::class),
    "subscriptions" => \DI\create(Subscriptions::class),
    "audittrail" => \DI\create(Audittrail::class),
    "student" => \DI\create(Student::class),
    "Students_Reports" => \DI\create(StudentsReports::class),
    "password_reset_logs" => \DI\create(PasswordResetLogs::class),
    "password_reset_otps" => \DI\create(PasswordResetOtps::class),
    "employee_sessions" => \DI\create(EmployeeSessions::class),

    // User table
    "usertable" => \DI\get("employees"),
];
