<?php

namespace PHPMaker2023\Jack_Jill_school;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\FetchMode;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;

/**
 * Page class
 */
class VolontaireList extends Volontaire
{
    use MessagesTrait;

    // Page ID
    public $PageID = "list";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "VolontaireList";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // Grid form hidden field names
    public $FormName = "fvolontairelist";
    public $FormActionName = "";
    public $FormBlankRowName = "";
    public $FormKeyCountName = "";

    // CSS class/style
    public $CurrentPageName = "volontairelist";

    // Page URLs
    public $AddUrl;
    public $EditUrl;
    public $DeleteUrl;
    public $ViewUrl;
    public $CopyUrl;
    public $ListUrl;

    // Update URLs
    public $InlineAddUrl;
    public $InlineCopyUrl;
    public $InlineEditUrl;
    public $GridAddUrl;
    public $GridEditUrl;
    public $MultiEditUrl;
    public $MultiDeleteUrl;
    public $MultiUpdateUrl;

    // Audit Trail
    public $AuditTrailOnAdd = true;
    public $AuditTrailOnEdit = true;
    public $AuditTrailOnDelete = true;
    public $AuditTrailOnView = false;
    public $AuditTrailOnViewData = false;
    public $AuditTrailOnSearch = false;

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<p id="ew-page-header">' . $header . '</p>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<p id="ew-page-footer">' . $footer . '</p>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->volontaireID->Visible = false;
        $this->Carte_No->setVisibility();
        $this->NIP->setVisibility();
        $this->Nom->setVisibility();
        $this->Prenom->setVisibility();
        $this->Sexe->Visible = false;
        $this->DateNaissance->setVisibility();
        $this->Lieu->setVisibility();
        $this->Photo->setVisibility();
        $this->Unique_QR->setVisibility();
        $this->Groupe_Sanguin->Visible = false;
        $this->Delivree->setVisibility();
        $this->Expire->setVisibility();
        $this->Localite->setVisibility();
        $this->Prevenir->Visible = false;
        $this->Prevenir_Tel->Visible = false;
        $this->Reference->Visible = false;
        $this->EmployeeID->Visible = false;
        $this->Statut->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->FormActionName = Config("FORM_ROW_ACTION_NAME");
        $this->FormBlankRowName = Config("FORM_BLANK_ROW_NAME");
        $this->FormKeyCountName = Config("FORM_KEY_COUNT_NAME");
        $this->TableVar = 'volontaire';
        $this->TableName = 'volontaire';

        // Table CSS class
        $this->TableClass = "table table-bordered table-hover table-sm ew-table";

        // CSS class name as context
        $this->ContextClass = CheckClassName($this->TableVar);
        AppendClass($this->TableGridClass, $this->ContextClass);

        // Fixed header table
        if (!$this->UseCustomTemplate) {
            $this->setFixedHeaderTable(Config("USE_FIXED_HEADER_TABLE"), Config("FIXED_HEADER_TABLE_HEIGHT"));
        }

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("language");

        // Table object (volontaire)
        if (!isset($GLOBALS["volontaire"]) || get_class($GLOBALS["volontaire"]) == PROJECT_NAMESPACE . "volontaire") {
            $GLOBALS["volontaire"] = &$this;
        }

        // Page URL
        $pageUrl = $this->pageUrl(false);

        // Initialize URLs
        $this->AddUrl = "volontaireadd";
        $this->InlineAddUrl = $pageUrl . "action=add";
        $this->GridAddUrl = $pageUrl . "action=gridadd";
        $this->GridEditUrl = $pageUrl . "action=gridedit";
        $this->MultiEditUrl = $pageUrl . "action=multiedit";
        $this->MultiDeleteUrl = "volontairedelete";
        $this->MultiUpdateUrl = "volontaireupdate";

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'volontaire');
        }

        // Start timer
        $DebugTimer = Container("timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");

        // List options
        $this->ListOptions = new ListOptions(["Tag" => "td", "TableVar" => $this->TableVar]);

        // Export options
        $this->ExportOptions = new ListOptions(["TagClassName" => "ew-export-option"]);

        // Import options
        $this->ImportOptions = new ListOptions(["TagClassName" => "ew-import-option"]);

        // Other options
        if (!$this->OtherOptions) {
            $this->OtherOptions = new ListOptionsArray();
        }

        // Grid-Add/Edit
        $this->OtherOptions["addedit"] = new ListOptions([
            "TagClassName" => "ew-add-edit-option",
            "UseDropDownButton" => false,
            "DropDownButtonPhrase" => $Language->phrase("ButtonAddEdit"),
            "UseButtonGroup" => true
        ]);

        // Detail tables
        $this->OtherOptions["detail"] = new ListOptions(["TagClassName" => "ew-detail-option"]);
        // Actions
        $this->OtherOptions["action"] = new ListOptions(["TagClassName" => "ew-action-option"]);

        // Filter options
        $this->FilterOptions = new ListOptions(["TagClassName" => "ew-filter-option"]);

        // List actions
        $this->ListActions = new ListActions();
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return is_object($Response) ? $Response->getBody() : ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }

        // Global Page Unloaded event (in userfn*.php)
        Page_Unloaded();
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (StartsString("application/json", $Response->getHeaderLine("Content-type")) && $Response->getBody()->getSize()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response (Assume return to modal for simplicity)
            if ($this->IsModal) { // Show as modal
                $result = ["url" => GetUrl($url), "modal" => "1"];
                $pageName = GetPageName($url);
                if ($pageName != $this->getListUrl()) { // Not List page => View page
                    $result["caption"] = $this->getModalCaption($pageName);
                    $result["view"] = $pageName == "volontaireview"; // If View page, no primary button
                } else { // List page
                    // $result["list"] = $this->PageID == "search"; // Refresh List page if current page is Search page
                    $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                    $this->clearFailureMessage();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from recordset
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Recordset
            while ($rs && !$rs->EOF) {
                $this->loadRowValues($rs); // Set up DbValue/CurrentValue
                $this->Photo->OldUploadPath = $this->Photo->getUploadPath(); // PHP
                $this->Photo->UploadPath = $this->Photo->OldUploadPath;
                $row = $this->getRecordFromArray($rs->fields);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
                $rs->moveNext();
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DATATYPE_BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        if ($fld->DataType == DATATYPE_MEMO && $fld->MemoMaxLength > 0) {
                            $val = TruncateMemo($val, $fld->MemoMaxLength, $fld->TruncateMemoRemoveHtml);
                        }
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['volontaireID'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
    }

    // Lookup data
    public function lookup($ar = null)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $ar["field"] ?? Post("field");
        $lookup = $this->Fields[$fieldName]->Lookup;
        $name = $ar["name"] ?? Post("name");
        $isQuery = ContainsString($name, "query_builder_rule");
        if ($isQuery) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $ar["ajax"] ?? Post("ajax", "unknown");
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $ar["q"] ?? Param("q") ?? $ar["sv"] ?? Post("sv", "");
            $pageSize = $ar["n"] ?? Param("n") ?? $ar["recperpage"] ?? Post("recperpage", 10);
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $ar["q"] ?? Param("q", "");
            $pageSize = $ar["n"] ?? Param("n", -1);
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $ar["start"] ?? Param("start", -1);
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $ar["page"] ?? Param("page", -1);
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($ar["s"] ?? Post("s", ""));
        $userFilter = Decrypt($ar["f"] ?? Post("f", ""));
        $userOrderBy = Decrypt($ar["o"] ?? Post("o", ""));
        $keys = $ar["keys"] ?? Post("keys");
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $ar["v0"] ?? $ar["lookupValue"] ?? Post("v0", Post("lookupValue", ""));
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $ar["v" . $i] ?? Post("v" . $i, "");
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, !is_array($ar)); // Use settings from current page
    }

    // Class variables
    public $ListOptions; // List options
    public $ExportOptions; // Export options
    public $SearchOptions; // Search options
    public $OtherOptions; // Other options
    public $FilterOptions; // Filter options
    public $ImportOptions; // Import options
    public $ListActions; // List actions
    public $SelectedCount = 0;
    public $SelectedIndex = 0;
    public $DisplayRecords = 20;
    public $StartRecord;
    public $StopRecord;
    public $TotalRecords = 0;
    // Begin modification by UDS Hub, September 18, 2020
    // public $RecordRange = 10;
	public $RecordRange = 5; // old/original setting: 10

	// End modification by UDS Hub, September 18, 2020
    public $PageSizes = "20,30,40,50,100,500,-1"; // Page sizes (comma separated)
    public $DefaultSearchWhere = ""; // Default search WHERE clause
    public $SearchWhere = ""; // Search WHERE clause
    public $SearchPanelClass = "ew-search-panel collapse"; // Search Panel class
    public $SearchColumnCount = 0; // For extended search
    public $SearchFieldsPerRow = 1; // For extended search
    public $RecordCount = 0; // Record count
    public $InlineRowCount = 0;
    public $StartRowCount = 1;
    public $RowCount = 0;
    public $Attrs = []; // Row attributes and cell attributes
    public $RowIndex = 0; // Row index
    public $KeyCount = 0; // Key count
    public $MultiColumnGridClass = "row-cols-md-4";
    public $MultiColumnEditClass = "col-12 w-100";
    public $MultiColumnCardClass = "card h-100 ew-card";
    public $MultiColumnListOptionsPosition = "bottom-start";
    public $LayoutOptions;
    public $MultiColumnLayout = "cards";
    public $DbMasterFilter = ""; // Master filter
    public $DbDetailFilter = ""; // Detail filter
    public $MasterRecordExists;
    public $MultiSelectKey;
    public $Command;
    public $UserAction; // User action
    public $RestoreSearch = false;
    public $HashValue; // Hash value
    public $DetailPages;
    public $TopContentClass = "ew-top";
    public $MiddleContentClass = "ew-middle";
    public $BottomContentClass = "ew-bottom";
    public $PageAction;
    public $RecKeys = [];
    public $IsModal = false;
    protected $FilterForModalActions = "";
    private $UseInfiniteScroll = false;

    /**
     * Load recordset from filter
     *
     * @return void
     */
    public function loadRecordsetFromFilter($filter)
    {
        // Set up list options
        $this->setupListOptions();

        // Search options
        $this->setupSearchOptions();

		// Other options
        $this->setupOtherOptions();

        // Set visibility
        $this->setVisibility();

        // Load recordset
        $this->TotalRecords = $this->loadRecordCount($filter);
        $this->StartRecord = 1;
        $this->StopRecord = $this->DisplayRecords;
        $this->CurrentFilter = $filter;
        $this->Recordset = $this->loadRecordset();

        // Set up pager
        $this->Pager = new PrevNextPager($this, $this->StartRecord, $this->DisplayRecords, $this->TotalRecords, $this->PageSizes, $this->RecordRange, $this->AutoHidePager, $this->AutoHidePageSizeSelector);
    }

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $UserProfile, $Language, $Security, $CurrentForm, $DashboardReport;

        // Multi column button position
        $this->MultiColumnListOptionsPosition = Config("MULTI_COLUMN_LIST_OPTIONS_POSITION");
		$DashboardReport = $DashboardReport || ConvertToBool(Param(Config("PAGE_DASHBOARD"), false));

// Is modal
        $this->IsModal = ConvertToBool(Param("modal"));

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Update last accessed time
        if (!IsSysAdmin() && !$UserProfile->isValidUser(CurrentUserName(), session_id())) {
            $this->setFailureMessage($Language->phrase("UserProfileCorrupted"));
            $this->terminate('logout');
            // return;
        }

        // Get export parameters
        $custom = "";
        if (Param("export") !== null) {
            $this->Export = Param("export");
            $custom = Param("custom", "");
        } else {
            $this->setExportReturnUrl(CurrentUrl());
        }
        $ExportType = $this->Export; // Get export parameter, used in header
        if ($ExportType != "") {
            global $SkipHeaderFooter;
            $SkipHeaderFooter = true;
        }
        $this->CurrentAction = Param("action"); // Set up current action

        // Get grid add count
        $gridaddcnt = Get(Config("TABLE_GRID_ADD_ROW_COUNT"), "");
        if (is_numeric($gridaddcnt) && $gridaddcnt > 0) {
            $this->GridAddRowCount = $gridaddcnt;
        }

        // Set up list options
        $this->setupListOptions();

        // Setup export options
        $this->setupExportOptions();
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        Page_Loading();

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Setup other options
        $this->setupOtherOptions();

        // Set up custom action (compatible with old version)
        foreach ($this->CustomActions as $name => $action) {
            $this->ListActions->add($name, $action);
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->Sexe);
        $this->setupLookupOptions($this->EmployeeID);
        $this->setupLookupOptions($this->Statut);

        // Enabled fixed header table and infinite scroll
        if (!IsExport() && !$DashboardReport) {
            $this->setFixedHeaderTable(true);
            AppendClass($this->TableClass, "ew-infinite-scroll-table");
            AppendClass($this->TableGridClass, "ew-infinite-scroll-grid");
            $this->TableContainerStyle = "max-height: 100%";
        }
		My_Global_Check(); // Modified by UDS Hub, October 6, 2021

        // Set Infinite-Scroll in header
        AddHeader("Infinite-Scroll", "true");

        // Update form name to avoid conflict
        if ($this->IsModal) {
            $this->FormName = "fvolontairegrid";
        }

        // Set up page action
        $this->PageAction = CurrentPageUrl(false);

        // Set up infinite scroll
        $this->UseInfiniteScroll = ConvertToBool(Param("infinitescroll"));

        // Search filters
        $srchAdvanced = ""; // Advanced search filter
        $srchBasic = ""; // Basic search filter
        $filter = ""; // Filter
        $query = ""; // Query builder

        // Get command
        $this->Command = strtolower(Get("cmd", ""));

        // Process list action first
        if ($this->processListAction()) { // Ajax request
            $this->terminate();
            return;
        }

        // Set up records per page
        $this->setupDisplayRecords();

        // Handle reset command
        $this->resetCmd();

        // Set up Breadcrumb
        if (!$this->isExport()) {
            $this->setupBreadcrumb();
        }

        // Hide list options
        if ($this->isExport()) {
            $this->ListOptions->hideAllOptions(["sequence"]);
            $this->ListOptions->UseDropDownButton = false; // Disable drop down button
            $this->ListOptions->UseButtonGroup = false; // Disable button group
        } elseif ($this->isGridAdd() || $this->isGridEdit() || $this->isMultiEdit() || $this->isConfirm()) {
            $this->ListOptions->hideAllOptions();
            $this->ListOptions->UseDropDownButton = false; // Disable drop down button
            $this->ListOptions->UseButtonGroup = false; // Disable button group
        }

        // Hide options
        if ($this->isExport() || !(EmptyValue($this->CurrentAction) || $this->isSearch())) {
            $this->ExportOptions->hideAllOptions();
            $this->FilterOptions->hideAllOptions();
            $this->ImportOptions->hideAllOptions();
        }

        // Hide other options
        if ($this->isExport()) {
            $this->OtherOptions->hideAllOptions();
        }

        // Get default search criteria
        AddFilter($this->DefaultSearchWhere, $this->basicSearchWhere(true));
        AddFilter($this->DefaultSearchWhere, $this->advancedSearchWhere(true));

        // Get basic search values
        $this->loadBasicSearchValues();

        // Get and validate search values for advanced search
        if (EmptyValue($this->UserAction)) { // Skip if user action
            $this->loadSearchValues();
        }

        // Process filter list
        if ($this->processFilterList()) {
            $this->terminate();
            return;
        }
        if (!$this->validateSearch()) {
            // Nothing to do
        }

        // Restore search parms from Session if not searching / reset / export
        if (($this->isExport() || $this->Command != "search" && $this->Command != "reset" && $this->Command != "resetall") && $this->Command != "json" && $this->checkSearchParms()) {
            $this->restoreSearchParms();
        }

        // Call Recordset SearchValidated event
        $this->recordsetSearchValidated();

        // Set up sorting order
        $this->setupSortOrder();

        // Get basic search criteria
        if (!$this->hasInvalidFields()) {
            $srchBasic = $this->basicSearchWhere();
        }

        // Get advanced search criteria
        if (!$this->hasInvalidFields()) {
            $srchAdvanced = $this->advancedSearchWhere();
        }

        // Get query builder criteria
        $query = $this->queryBuilderWhere();

        // Restore display records
        if ($this->Command != "json" && $this->getRecordsPerPage() != "") {
            $this->DisplayRecords = $this->getRecordsPerPage(); // Restore from Session
        } else {
            $this->DisplayRecords = 20; // Load default
            $this->setRecordsPerPage($this->DisplayRecords); // Save default to Session
        }

        // Load search default if no existing search criteria
        if (!$this->checkSearchParms() && !$query) {
            // Load basic search from default
            $this->BasicSearch->loadDefault();
            if ($this->BasicSearch->Keyword != "") {
                $srchBasic = $this->basicSearchWhere(); // Save to session
            }

            // Load advanced search from default
            if ($this->loadAdvancedSearchDefault()) {
                $srchAdvanced = $this->advancedSearchWhere(); // Save to session
            }
        }

        // Restore search settings from Session
        if (!$this->hasInvalidFields()) {
            $this->loadAdvancedSearch();
        }

        // Build search criteria
        if ($query) {
            AddFilter($this->SearchWhere, $query);
        } else {
            AddFilter($this->SearchWhere, $srchAdvanced);
            AddFilter($this->SearchWhere, $srchBasic);
        }

        // Call Recordset_Searching event
        $this->recordsetSearching($this->SearchWhere);

        // Save search criteria
        if ($this->Command == "search" && !$this->RestoreSearch) {
            $this->setSearchWhere($this->SearchWhere); // Save to Session
            $this->StartRecord = 1; // Reset start record counter
            $this->setStartRecordNumber($this->StartRecord);
        } elseif ($this->Command != "json" && !$query) {
            $this->SearchWhere = $this->getSearchWhere();
        }

        // Build filter
        $filter = "";
        if (!$Security->canList()) {
            $filter = "(0=1)"; // Filter all records
        }
        AddFilter($filter, $this->DbDetailFilter);
        AddFilter($filter, $this->SearchWhere);

        // Set up filter
        if ($this->Command == "json") {
            $this->UseSessionForListSql = false; // Do not use session for ListSQL
            $this->CurrentFilter = $filter;
        } else {
            $this->setSessionWhere($filter);
            $this->CurrentFilter = "";
        }
        $this->Filter = $this->applyUserIDFilters($filter);

        // Export selected records
        if ($this->isExport()) {
            $this->CurrentFilter = $this->buildExportSelectedFilter();
        }
        if ($this->isGridAdd()) {
            $this->CurrentFilter = "0=1";
            $this->StartRecord = 1;
            $this->DisplayRecords = $this->GridAddRowCount;
            $this->TotalRecords = $this->DisplayRecords;
            $this->StopRecord = $this->DisplayRecords;
        } elseif (($this->isEdit() || $this->isCopy() || $this->isInlineInserted() || $this->isInlineUpdated()) && $this->UseInfiniteScroll) { // Get current record only
            $this->CurrentFilter = $this->isInlineUpdated() ? $this->getRecordFilter() : $this->getFilterFromRecordKeys();
            $this->TotalRecords = $this->listRecordCount();
            $this->StartRecord = 1;
            $this->StopRecord = $this->DisplayRecords;
            $this->Recordset = $this->loadRecordset();
        } elseif (
            $this->UseInfiniteScroll && $this->isGridInserted() ||
            $this->UseInfiniteScroll && ($this->isGridEdit() || $this->isGridUpdated()) ||
            $this->isMultiEdit() ||
            $this->UseInfiniteScroll && $this->isMultiUpdated()
        ) { // Get current records only
            $this->CurrentFilter = $this->FilterForModalActions; // Restore filter
            $this->TotalRecords = $this->listRecordCount();
            $this->StartRecord = 1;
            $this->StopRecord = $this->DisplayRecords;
            $this->Recordset = $this->loadRecordset();
        } else {
            $this->TotalRecords = $this->listRecordCount();
            $this->StartRecord = 1;
            if ($this->DisplayRecords <= 0 || ($this->isExport() && $this->ExportAll)) { // Display all records
                $this->DisplayRecords = $this->TotalRecords;
            }
            if (!($this->isExport() && $this->ExportAll)) { // Set up start record position
                $this->setupStartRecord();
            }
            $this->Recordset = $this->loadRecordset($this->StartRecord - 1, $this->DisplayRecords);

            // Set no record found message
            if ((EmptyValue($this->CurrentAction) || $this->isSearch()) && $this->TotalRecords == 0) {
                if (!$Security->canList()) {
                    $this->setWarningMessage(DeniedMessage());
                }
                if ($this->SearchWhere == "0=101") {
                    $this->setWarningMessage($Language->phrase("EnterSearchCriteria"));
                } else {
                    $this->setWarningMessage($Language->phrase("NoRecord"));
                }
            }

            // Audit trail on search
            if ($this->AuditTrailOnSearch && $this->Command == "search" && !$this->RestoreSearch) {
                $searchParm = ServerVar("QUERY_STRING");
                $searchSql = $this->getSessionWhere();
                $this->writeAuditTrailOnSearch($searchParm, $searchSql);
            }
        }

        // Set up list action columns
        foreach ($this->ListActions->Items as $listaction) {
            if ($listaction->Allow) {
                if ($listaction->Select == ACTION_MULTIPLE) { // Show checkbox column if multiple action
                    $this->ListOptions["checkbox"]->Visible = true;
                } elseif ($listaction->Select == ACTION_SINGLE) { // Show list action column
                        $this->ListOptions["listactions"]->Visible = true; // Set visible if any list action is allowed
                }
            }
        }

        // Search options
        $this->setupSearchOptions();

        // Set up search panel class
        if ($this->SearchWhere != "") {
            if ($query) { // Hide search panel if using QueryBuilder
                RemoveClass($this->SearchPanelClass, "show");
            } else {
                AppendClass($this->SearchPanelClass, "show");
            }
        }
		if (@$_COOKIE['volontaire_searchpanel'] == 'notactive') {
			RemoveClass($this->SearchPanelClass, "show");
			AppendClass($this->SearchPanelClass, "collapse");
		} elseif (@$_COOKIE['volontaire_searchpanel'] == 'active') {
			RemoveClass($this->SearchPanelClass, "collapse");
			AppendClass($this->SearchPanelClass, "show");
		}

        // Handle inline add for custom template in table layout with no records
        if ($this->UseCustomTemplate && $this->MultiColumnLayout == "table" && $this->isAdd() && $this->TotalRecords == 0) {
            $this->MultiColumnLayout = "cards";
        }

        // No custom template for cards layout
        if ($this->MultiColumnLayout == "cards") {
            $this->UseCustomTemplate = false;
        }

        // API list action
        if (IsApi()) {
            if (Route(0) == Config("API_LIST_ACTION")) {
                if (!$this->isExport()) {
                    $rows = $this->getRecordsFromRecordset($this->Recordset);
                    $this->Recordset->close();
                    WriteJson([
                        "success" => true,
                        "action" => Config("API_LIST_ACTION"),
                        $this->TableVar => $rows,
                        "totalRecordCount" => $this->TotalRecords
                    ]);
                    $this->terminate(true);
                }
                return;
            } elseif ($this->getFailureMessage() != "") {
                WriteJson(["error" => $this->getFailureMessage()]);
                $this->clearFailureMessage();
                $this->terminate(true);
                return;
            }
        }

        // Render other options
        $this->renderOtherOptions();

        // Set up pager
        $this->Pager = new PrevNextPager($this, $this->StartRecord, $this->DisplayRecords, $this->TotalRecords, $this->PageSizes, $this->RecordRange, $this->AutoHidePager, $this->AutoHidePageSizeSelector);

		// Set up first record for Export Data purpose, by UDS Hub, February 20, 2021
		$first_rec = $_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_START_REC")]; //  Get(Config("TABLE_START_REC")) > 0 ? Get(Config("TABLE_START_REC")) : 1;
		$_SESSION["First_Record"] = $first_rec;

        // Set ReturnUrl in header if necessary
        if ($returnUrl = Container("flash")->getFirstMessage("Return-Url")) {
            AddHeader("Return-Url", GetUrl($returnUrl));
        }

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            Page_Rendering();

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get page number
    public function getPageNumber()
    {
        return ($this->DisplayRecords > 0 && $this->StartRecord > 0) ? ceil($this->StartRecord / $this->DisplayRecords) : 1;
    }

    // Set up number of records displayed per page
    protected function setupDisplayRecords()
    {
        // Begin of modification Customize Navigation/Pager Panel, by UDS Hub, May 2, 2012
		global $Language;
        $wrk = Get(Config("TABLE_REC_PER_PAGE"), "");
		if ($wrk > 500 || strtolower($wrk) == "all") {
            $wrk = 500;
            $this->setFailureMessage(str_replace("%t", 500, $Language->Phrase("MaximumRecordsPerPage")));
        }

		// End of modification Customize Navigation/Pager Panel, by UDS Hub, May 2, 2012
        if ($wrk != "") {
            if (is_numeric($wrk)) {
                $this->DisplayRecords = (int)$wrk;
            } else {
                if (SameText($wrk, "all")) { // Display all records
                    $this->DisplayRecords = -1;
                } else {
                    $this->DisplayRecords = 20; // Non-numeric, load default
                }
            }
            $this->setRecordsPerPage($this->DisplayRecords); // Save to Session
            // Reset start position
            $this->StartRecord = 1;
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Build filter for all keys
    protected function buildKeyFilter()
    {
        global $CurrentForm;
        $wrkFilter = "";

        // Update row index and get row key
        $rowindex = 1;
        $CurrentForm->Index = $rowindex;
        $thisKey = strval($CurrentForm->getValue($this->OldKeyName));
        while ($thisKey != "") {
            $this->setKey($thisKey);
            if ($this->OldKey != "") {
                $filter = $this->getRecordFilter();
                if ($wrkFilter != "") {
                    $wrkFilter .= " OR ";
                }
                $wrkFilter .= $filter;
            } else {
                $wrkFilter = "0=1";
                break;
            }

            // Update row index and get row key
            $rowindex++; // Next row
            $CurrentForm->Index = $rowindex;
            $thisKey = strval($CurrentForm->getValue($this->OldKeyName));
        }
        return $wrkFilter;
    }

    // Get list of filters
    public function getFilterList()
    {
        global $UserProfile;

        // Initialize
        $filterList = "";
        $savedFilterList = "";

        // Load server side filters
        if (Config("SEARCH_FILTER_OPTION") == "Server" && isset($UserProfile)) {
            $savedFilterList = $UserProfile->getSearchFilters(CurrentUserName(), "fvolontairesrch");
        }
        $filterList = Concat($filterList, $this->Carte_No->AdvancedSearch->toJson(), ","); // Field Carte_No
        $filterList = Concat($filterList, $this->NIP->AdvancedSearch->toJson(), ","); // Field NIP
        $filterList = Concat($filterList, $this->Nom->AdvancedSearch->toJson(), ","); // Field Nom
        $filterList = Concat($filterList, $this->Prenom->AdvancedSearch->toJson(), ","); // Field Prenom
        $filterList = Concat($filterList, $this->Sexe->AdvancedSearch->toJson(), ","); // Field Sexe
        $filterList = Concat($filterList, $this->DateNaissance->AdvancedSearch->toJson(), ","); // Field DateNaissance
        $filterList = Concat($filterList, $this->Lieu->AdvancedSearch->toJson(), ","); // Field Lieu
        $filterList = Concat($filterList, $this->Photo->AdvancedSearch->toJson(), ","); // Field Photo
        $filterList = Concat($filterList, $this->Unique_QR->AdvancedSearch->toJson(), ","); // Field Unique_QR
        $filterList = Concat($filterList, $this->Groupe_Sanguin->AdvancedSearch->toJson(), ","); // Field Groupe_Sanguin
        $filterList = Concat($filterList, $this->Delivree->AdvancedSearch->toJson(), ","); // Field Delivree
        $filterList = Concat($filterList, $this->Expire->AdvancedSearch->toJson(), ","); // Field Expire
        $filterList = Concat($filterList, $this->Localite->AdvancedSearch->toJson(), ","); // Field Localite
        $filterList = Concat($filterList, $this->Prevenir->AdvancedSearch->toJson(), ","); // Field Prevenir
        $filterList = Concat($filterList, $this->Prevenir_Tel->AdvancedSearch->toJson(), ","); // Field Prevenir_Tel
        $filterList = Concat($filterList, $this->Reference->AdvancedSearch->toJson(), ","); // Field Reference
        $filterList = Concat($filterList, $this->Statut->AdvancedSearch->toJson(), ","); // Field Statut
        if ($this->BasicSearch->Keyword != "") {
            $wrk = "\"" . Config("TABLE_BASIC_SEARCH") . "\":\"" . JsEncode($this->BasicSearch->Keyword) . "\",\"" . Config("TABLE_BASIC_SEARCH_TYPE") . "\":\"" . JsEncode($this->BasicSearch->Type) . "\"";
            $filterList = Concat($filterList, $wrk, ",");
        }

        // Return filter list in JSON
        if ($filterList != "") {
            $filterList = "\"data\":{" . $filterList . "}";
        }
        if ($savedFilterList != "") {
            $filterList = Concat($filterList, "\"filters\":" . $savedFilterList, ",");
        }
        return ($filterList != "") ? "{" . $filterList . "}" : "null";
    }

    // Process filter list
    protected function processFilterList()
    {
        global $UserProfile;
        if (Post("ajax") == "savefilters") { // Save filter request (Ajax)
            $filters = Post("filters");
            $UserProfile->setSearchFilters(CurrentUserName(), "fvolontairesrch", $filters);
            WriteJson([["success" => true]]); // Success
            return true;
        } elseif (Post("cmd") == "resetfilter") {
            $this->restoreFilterList();
        }
        return false;
    }

    // Restore list of filters
    protected function restoreFilterList()
    {
        // Return if not reset filter
        if (Post("cmd") !== "resetfilter") {
            return false;
        }
        $filter = json_decode(Post("filter"), true);
        $this->Command = "search";

        // Field Carte_No
        $this->Carte_No->AdvancedSearch->SearchValue = @$filter["x_Carte_No"];
        $this->Carte_No->AdvancedSearch->SearchOperator = @$filter["z_Carte_No"];
        $this->Carte_No->AdvancedSearch->SearchCondition = @$filter["v_Carte_No"];
        $this->Carte_No->AdvancedSearch->SearchValue2 = @$filter["y_Carte_No"];
        $this->Carte_No->AdvancedSearch->SearchOperator2 = @$filter["w_Carte_No"];
        $this->Carte_No->AdvancedSearch->save();

        // Field NIP
        $this->NIP->AdvancedSearch->SearchValue = @$filter["x_NIP"];
        $this->NIP->AdvancedSearch->SearchOperator = @$filter["z_NIP"];
        $this->NIP->AdvancedSearch->SearchCondition = @$filter["v_NIP"];
        $this->NIP->AdvancedSearch->SearchValue2 = @$filter["y_NIP"];
        $this->NIP->AdvancedSearch->SearchOperator2 = @$filter["w_NIP"];
        $this->NIP->AdvancedSearch->save();

        // Field Nom
        $this->Nom->AdvancedSearch->SearchValue = @$filter["x_Nom"];
        $this->Nom->AdvancedSearch->SearchOperator = @$filter["z_Nom"];
        $this->Nom->AdvancedSearch->SearchCondition = @$filter["v_Nom"];
        $this->Nom->AdvancedSearch->SearchValue2 = @$filter["y_Nom"];
        $this->Nom->AdvancedSearch->SearchOperator2 = @$filter["w_Nom"];
        $this->Nom->AdvancedSearch->save();

        // Field Prenom
        $this->Prenom->AdvancedSearch->SearchValue = @$filter["x_Prenom"];
        $this->Prenom->AdvancedSearch->SearchOperator = @$filter["z_Prenom"];
        $this->Prenom->AdvancedSearch->SearchCondition = @$filter["v_Prenom"];
        $this->Prenom->AdvancedSearch->SearchValue2 = @$filter["y_Prenom"];
        $this->Prenom->AdvancedSearch->SearchOperator2 = @$filter["w_Prenom"];
        $this->Prenom->AdvancedSearch->save();

        // Field Sexe
        $this->Sexe->AdvancedSearch->SearchValue = @$filter["x_Sexe"];
        $this->Sexe->AdvancedSearch->SearchOperator = @$filter["z_Sexe"];
        $this->Sexe->AdvancedSearch->SearchCondition = @$filter["v_Sexe"];
        $this->Sexe->AdvancedSearch->SearchValue2 = @$filter["y_Sexe"];
        $this->Sexe->AdvancedSearch->SearchOperator2 = @$filter["w_Sexe"];
        $this->Sexe->AdvancedSearch->save();

        // Field DateNaissance
        $this->DateNaissance->AdvancedSearch->SearchValue = @$filter["x_DateNaissance"];
        $this->DateNaissance->AdvancedSearch->SearchOperator = @$filter["z_DateNaissance"];
        $this->DateNaissance->AdvancedSearch->SearchCondition = @$filter["v_DateNaissance"];
        $this->DateNaissance->AdvancedSearch->SearchValue2 = @$filter["y_DateNaissance"];
        $this->DateNaissance->AdvancedSearch->SearchOperator2 = @$filter["w_DateNaissance"];
        $this->DateNaissance->AdvancedSearch->save();

        // Field Lieu
        $this->Lieu->AdvancedSearch->SearchValue = @$filter["x_Lieu"];
        $this->Lieu->AdvancedSearch->SearchOperator = @$filter["z_Lieu"];
        $this->Lieu->AdvancedSearch->SearchCondition = @$filter["v_Lieu"];
        $this->Lieu->AdvancedSearch->SearchValue2 = @$filter["y_Lieu"];
        $this->Lieu->AdvancedSearch->SearchOperator2 = @$filter["w_Lieu"];
        $this->Lieu->AdvancedSearch->save();

        // Field Photo
        $this->Photo->AdvancedSearch->SearchValue = @$filter["x_Photo"];
        $this->Photo->AdvancedSearch->SearchOperator = @$filter["z_Photo"];
        $this->Photo->AdvancedSearch->SearchCondition = @$filter["v_Photo"];
        $this->Photo->AdvancedSearch->SearchValue2 = @$filter["y_Photo"];
        $this->Photo->AdvancedSearch->SearchOperator2 = @$filter["w_Photo"];
        $this->Photo->AdvancedSearch->save();

        // Field Unique_QR
        $this->Unique_QR->AdvancedSearch->SearchValue = @$filter["x_Unique_QR"];
        $this->Unique_QR->AdvancedSearch->SearchOperator = @$filter["z_Unique_QR"];
        $this->Unique_QR->AdvancedSearch->SearchCondition = @$filter["v_Unique_QR"];
        $this->Unique_QR->AdvancedSearch->SearchValue2 = @$filter["y_Unique_QR"];
        $this->Unique_QR->AdvancedSearch->SearchOperator2 = @$filter["w_Unique_QR"];
        $this->Unique_QR->AdvancedSearch->save();

        // Field Groupe_Sanguin
        $this->Groupe_Sanguin->AdvancedSearch->SearchValue = @$filter["x_Groupe_Sanguin"];
        $this->Groupe_Sanguin->AdvancedSearch->SearchOperator = @$filter["z_Groupe_Sanguin"];
        $this->Groupe_Sanguin->AdvancedSearch->SearchCondition = @$filter["v_Groupe_Sanguin"];
        $this->Groupe_Sanguin->AdvancedSearch->SearchValue2 = @$filter["y_Groupe_Sanguin"];
        $this->Groupe_Sanguin->AdvancedSearch->SearchOperator2 = @$filter["w_Groupe_Sanguin"];
        $this->Groupe_Sanguin->AdvancedSearch->save();

        // Field Delivree
        $this->Delivree->AdvancedSearch->SearchValue = @$filter["x_Delivree"];
        $this->Delivree->AdvancedSearch->SearchOperator = @$filter["z_Delivree"];
        $this->Delivree->AdvancedSearch->SearchCondition = @$filter["v_Delivree"];
        $this->Delivree->AdvancedSearch->SearchValue2 = @$filter["y_Delivree"];
        $this->Delivree->AdvancedSearch->SearchOperator2 = @$filter["w_Delivree"];
        $this->Delivree->AdvancedSearch->save();

        // Field Expire
        $this->Expire->AdvancedSearch->SearchValue = @$filter["x_Expire"];
        $this->Expire->AdvancedSearch->SearchOperator = @$filter["z_Expire"];
        $this->Expire->AdvancedSearch->SearchCondition = @$filter["v_Expire"];
        $this->Expire->AdvancedSearch->SearchValue2 = @$filter["y_Expire"];
        $this->Expire->AdvancedSearch->SearchOperator2 = @$filter["w_Expire"];
        $this->Expire->AdvancedSearch->save();

        // Field Localite
        $this->Localite->AdvancedSearch->SearchValue = @$filter["x_Localite"];
        $this->Localite->AdvancedSearch->SearchOperator = @$filter["z_Localite"];
        $this->Localite->AdvancedSearch->SearchCondition = @$filter["v_Localite"];
        $this->Localite->AdvancedSearch->SearchValue2 = @$filter["y_Localite"];
        $this->Localite->AdvancedSearch->SearchOperator2 = @$filter["w_Localite"];
        $this->Localite->AdvancedSearch->save();

        // Field Prevenir
        $this->Prevenir->AdvancedSearch->SearchValue = @$filter["x_Prevenir"];
        $this->Prevenir->AdvancedSearch->SearchOperator = @$filter["z_Prevenir"];
        $this->Prevenir->AdvancedSearch->SearchCondition = @$filter["v_Prevenir"];
        $this->Prevenir->AdvancedSearch->SearchValue2 = @$filter["y_Prevenir"];
        $this->Prevenir->AdvancedSearch->SearchOperator2 = @$filter["w_Prevenir"];
        $this->Prevenir->AdvancedSearch->save();

        // Field Prevenir_Tel
        $this->Prevenir_Tel->AdvancedSearch->SearchValue = @$filter["x_Prevenir_Tel"];
        $this->Prevenir_Tel->AdvancedSearch->SearchOperator = @$filter["z_Prevenir_Tel"];
        $this->Prevenir_Tel->AdvancedSearch->SearchCondition = @$filter["v_Prevenir_Tel"];
        $this->Prevenir_Tel->AdvancedSearch->SearchValue2 = @$filter["y_Prevenir_Tel"];
        $this->Prevenir_Tel->AdvancedSearch->SearchOperator2 = @$filter["w_Prevenir_Tel"];
        $this->Prevenir_Tel->AdvancedSearch->save();

        // Field Reference
        $this->Reference->AdvancedSearch->SearchValue = @$filter["x_Reference"];
        $this->Reference->AdvancedSearch->SearchOperator = @$filter["z_Reference"];
        $this->Reference->AdvancedSearch->SearchCondition = @$filter["v_Reference"];
        $this->Reference->AdvancedSearch->SearchValue2 = @$filter["y_Reference"];
        $this->Reference->AdvancedSearch->SearchOperator2 = @$filter["w_Reference"];
        $this->Reference->AdvancedSearch->save();

        // Field Statut
        $this->Statut->AdvancedSearch->SearchValue = @$filter["x_Statut"];
        $this->Statut->AdvancedSearch->SearchOperator = @$filter["z_Statut"];
        $this->Statut->AdvancedSearch->SearchCondition = @$filter["v_Statut"];
        $this->Statut->AdvancedSearch->SearchValue2 = @$filter["y_Statut"];
        $this->Statut->AdvancedSearch->SearchOperator2 = @$filter["w_Statut"];
        $this->Statut->AdvancedSearch->save();
        $this->BasicSearch->setKeyword(@$filter[Config("TABLE_BASIC_SEARCH")]);
        $this->BasicSearch->setType(@$filter[Config("TABLE_BASIC_SEARCH_TYPE")]);
    }

    // Advanced search WHERE clause based on QueryString
    public function advancedSearchWhere($default = false)
    {
        global $Security;
        $where = "";
        if (!$Security->canSearch()) {
            return "";
        }
        $this->buildSearchSql($where, $this->Carte_No, $default, false); // Carte_No
        $this->buildSearchSql($where, $this->NIP, $default, false); // NIP
        $this->buildSearchSql($where, $this->Nom, $default, false); // Nom
        $this->buildSearchSql($where, $this->Prenom, $default, false); // Prenom
        $this->buildSearchSql($where, $this->Sexe, $default, false); // Sexe
        $this->buildSearchSql($where, $this->DateNaissance, $default, false); // DateNaissance
        $this->buildSearchSql($where, $this->Lieu, $default, false); // Lieu
        $this->buildSearchSql($where, $this->Photo, $default, false); // Photo
        $this->buildSearchSql($where, $this->Unique_QR, $default, false); // Unique_QR
        $this->buildSearchSql($where, $this->Groupe_Sanguin, $default, false); // Groupe_Sanguin
        $this->buildSearchSql($where, $this->Delivree, $default, false); // Delivree
        $this->buildSearchSql($where, $this->Expire, $default, false); // Expire
        $this->buildSearchSql($where, $this->Localite, $default, false); // Localite
        $this->buildSearchSql($where, $this->Prevenir, $default, false); // Prevenir
        $this->buildSearchSql($where, $this->Prevenir_Tel, $default, false); // Prevenir_Tel
        $this->buildSearchSql($where, $this->Reference, $default, false); // Reference
        $this->buildSearchSql($where, $this->Statut, $default, false); // Statut

        // Set up search command
        if (!$default && $where != "" && in_array($this->Command, ["", "reset", "resetall"])) {
            $this->Command = "search";
        }
        if (!$default && $this->Command == "search") {
            $this->Carte_No->AdvancedSearch->save(); // Carte_No
            $this->NIP->AdvancedSearch->save(); // NIP
            $this->Nom->AdvancedSearch->save(); // Nom
            $this->Prenom->AdvancedSearch->save(); // Prenom
            $this->Sexe->AdvancedSearch->save(); // Sexe
            $this->DateNaissance->AdvancedSearch->save(); // DateNaissance
            $this->Lieu->AdvancedSearch->save(); // Lieu
            $this->Photo->AdvancedSearch->save(); // Photo
            $this->Unique_QR->AdvancedSearch->save(); // Unique_QR
            $this->Groupe_Sanguin->AdvancedSearch->save(); // Groupe_Sanguin
            $this->Delivree->AdvancedSearch->save(); // Delivree
            $this->Expire->AdvancedSearch->save(); // Expire
            $this->Localite->AdvancedSearch->save(); // Localite
            $this->Prevenir->AdvancedSearch->save(); // Prevenir
            $this->Prevenir_Tel->AdvancedSearch->save(); // Prevenir_Tel
            $this->Reference->AdvancedSearch->save(); // Reference
            $this->Statut->AdvancedSearch->save(); // Statut

            // Clear rules for QueryBuilder
            $this->setSessionRules("");
        }
        return $where;
    }

    // Parse query builder rule function
    protected function parseRules($group, $fieldName = "") {
        $group["condition"] ??= "AND";
        if (!in_array($group["condition"], ["AND", "OR"])) {
            throw new \Exception("Unable to build SQL query with condition '" . $group["condition"] . "'");
        }
        if (!is_array($group["rules"] ?? null)) {
            return "";
        }
        $parts = [];
        foreach ($group["rules"] as $rule) {
            if (is_array($rule["rules"] ?? null) && count($rule["rules"]) > 0) {
                $parts[] = "(" . " " . $this->parseRules($rule, $fieldName) . " " . ")" . " ";
            } else {
                $field = $rule["field"];
                $fld = $this->fieldByParam($field);
                if (!$fld) {
                    throw new \Exception("Failed to find field '" . $field . "'");
                }
                if ($fieldName == "" || $fld->Name == $fieldName) { // Field name not specified or matched field name
                    $fldOpr = array_search($rule["operator"], Config("CLIENT_SEARCH_OPERATORS"));
                    $ope = Config("QUERY_BUILDER_OPERATORS")[$rule["operator"]] ?? null;
                    if (!$ope || !$fldOpr) {
                        throw new \Exception("Unknown SQL operation for operator '" . $rule["operator"] . "'");
                    }
                    if ($ope["nb_inputs"] > 0 && ($rule["value"] ?? false) || IsNullOrEmptyOperator($fldOpr)) {
                        $rule["value"] = !is_array($rule["value"]) ? [$rule["value"]] : $rule["value"];
                        $fldVal = $rule["value"][0];
                        if (is_array($fldVal)) {
                            $fldVal = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal);
                        }
                        $useFilter = $fld->UseFilter; // Query builder does not use filter
                        try {
                            if ($fld->isMultiSelect()) {
                                $parts[] = $fldVal != "" ? GetMultiSearchSql($fld, $fldOpr, ConvertSearchValue($fldVal, $fldOpr, $fld), $this->Dbid) : "";
                            } else {
                                $fldVal2 = ContainsString($fldOpr, "BETWEEN") ? $rule["value"][1] : ""; // BETWEEN
                                if (is_array($fldVal2)) {
                                    $fldVal2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal2);
                                }
                                $parts[] = GetSearchSql(
                                    $fld,
                                    ConvertSearchValue($fldVal, $fldOpr, $fld), // $fldVal
                                    $fldOpr,
                                    "", // $fldCond not used
                                    ConvertSearchValue($fldVal2, $fldOpr, $fld), // $fldVal2
                                    "", // $fldOpr2 not used
                                    $this->Dbid
                                );
                            }
                        } finally {
                            $fld->UseFilter = $useFilter;
                        }
                    }
                }
            }
        }
        $where = implode(" " . $group["condition"] . " ", array_filter($parts));
        if ($group["not"] ?? false) {
            $where = "NOT (" . $where . ")";
        }
        return $where;
    }

    // Quey builder WHERE clause
    public function queryBuilderWhere($fieldName = "")
    {
        global $Security;
        if (!$Security->canSearch()) {
            return "";
        }

        // Get rules by query builder
        $rules = Post("rules") ?? $this->getSessionRules();

        // Decode and parse rules
        $where = $rules ? $this->parseRules(json_decode($rules, true), $fieldName) : "";

        // Clear other search and save rules to session
        if ($where && $fieldName == "") { // Skip if get query for specific field
            $this->resetSearchParms();
            $this->setSessionRules($rules);
        }

        // Return query
        return $where;
    }

    // Build search SQL
    protected function buildSearchSql(&$where, $fld, $default, $multiValue)
    {
        $fldParm = $fld->Param;
        $fldVal = $default ? $fld->AdvancedSearch->SearchValueDefault : $fld->AdvancedSearch->SearchValue;
        $fldOpr = $default ? $fld->AdvancedSearch->SearchOperatorDefault : $fld->AdvancedSearch->SearchOperator;
        $fldCond = $default ? $fld->AdvancedSearch->SearchConditionDefault : $fld->AdvancedSearch->SearchCondition;
        $fldVal2 = $default ? $fld->AdvancedSearch->SearchValue2Default : $fld->AdvancedSearch->SearchValue2;
        $fldOpr2 = $default ? $fld->AdvancedSearch->SearchOperator2Default : $fld->AdvancedSearch->SearchOperator2;
        $fldVal = ConvertSearchValue($fldVal, $fldOpr, $fld);
        $fldVal2 = ConvertSearchValue($fldVal2, $fldOpr2, $fld);
        $fldOpr = ConvertSearchOperator($fldOpr, $fld, $fldVal);
        $fldOpr2 = ConvertSearchOperator($fldOpr2, $fld, $fldVal2);
        $wrk = "";
        if (is_array($fldVal)) {
            $fldVal = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal);
        }
        if (is_array($fldVal2)) {
            $fldVal2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal2);
        }
        if (Config("SEARCH_MULTI_VALUE_OPTION") == 1 && !$fld->UseFilter || !IsMultiSearchOperator($fldOpr)) {
            $multiValue = false;
        }
        if ($multiValue) {
            $wrk = $fldVal != "" ? GetMultiSearchSql($fld, $fldOpr, $fldVal, $this->Dbid) : ""; // Field value 1
            $wrk2 = $fldVal2 != "" ? GetMultiSearchSql($fld, $fldOpr2, $fldVal2, $this->Dbid) : ""; // Field value 2
            AddFilter($wrk, $wrk2, $fldCond);
        } else {
            $wrk = GetSearchSql($fld, $fldVal, $fldOpr, $fldCond, $fldVal2, $fldOpr2, $this->Dbid);
        }
        if ($this->SearchOption == "AUTO" && in_array($this->BasicSearch->getType(), ["AND", "OR"])) {
            $cond = $this->BasicSearch->getType();
        } else {
            $cond = SameText($this->SearchOption, "OR") ? "OR" : "AND";
        }
        AddFilter($where, $wrk, $cond);
    }

    // Show list of filters
    public function showFilterList()
    {
        global $Language;

        // Initialize
        $filterList = "";
        $captionClass = $this->isExport("email") ? "ew-filter-caption-email" : "ew-filter-caption";
        $captionSuffix = $this->isExport("email") ? ": " : "";

        // Field Carte_No
        $filter = $this->queryBuilderWhere("Carte_No");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->Carte_No, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->Carte_No->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field NIP
        $filter = $this->queryBuilderWhere("NIP");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->NIP, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->NIP->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field Nom
        $filter = $this->queryBuilderWhere("Nom");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->Nom, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->Nom->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field Prenom
        $filter = $this->queryBuilderWhere("Prenom");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->Prenom, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->Prenom->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field DateNaissance
        $filter = $this->queryBuilderWhere("DateNaissance");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->DateNaissance, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->DateNaissance->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field Lieu
        $filter = $this->queryBuilderWhere("Lieu");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->Lieu, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->Lieu->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field Photo
        $filter = $this->queryBuilderWhere("Photo");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->Photo, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->Photo->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field Unique_QR
        $filter = $this->queryBuilderWhere("Unique_QR");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->Unique_QR, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->Unique_QR->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field Delivree
        $filter = $this->queryBuilderWhere("Delivree");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->Delivree, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->Delivree->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field Expire
        $filter = $this->queryBuilderWhere("Expire");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->Expire, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->Expire->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field Localite
        $filter = $this->queryBuilderWhere("Localite");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->Localite, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->Localite->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field Statut
        $filter = $this->queryBuilderWhere("Statut");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->Statut, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->Statut->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }
        if ($this->BasicSearch->Keyword != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $Language->phrase("BasicSearchKeyword") . "</span>" . $captionSuffix . $this->BasicSearch->Keyword . "</div>";
        }

        // Show Filters
        if ($filterList != "") {
            $message = "<div id=\"ew-filter-list\" class=\"callout callout-info d-table\"><div id=\"ew-current-filters\">" .
                $Language->phrase("CurrentFilters") . "</div>" . $filterList . "</div>";
            $this->messageShowing($message, "");
            Write($message);
        } else { // Output empty tag
            Write("<div id=\"ew-filter-list\"></div>");
        }
    }

    // Return basic search WHERE clause based on search keyword and type
    public function basicSearchWhere($default = false)
    {
        global $Security;
        $searchStr = "";
        if (!$Security->canSearch()) {
            return "";
        }

        // Fields to search
        $searchFlds = [];
        $searchFlds[] = &$this->Carte_No;
        $searchFlds[] = &$this->NIP;
        $searchFlds[] = &$this->Nom;
        $searchFlds[] = &$this->Prenom;
        $searchFlds[] = &$this->Sexe;
        $searchFlds[] = &$this->Lieu;
        $searchFlds[] = &$this->Photo;
        $searchFlds[] = &$this->Unique_QR;
        $searchFlds[] = &$this->Groupe_Sanguin;
        $searchFlds[] = &$this->Localite;
        $searchFlds[] = &$this->Prevenir;
        $searchFlds[] = &$this->Prevenir_Tel;
        $searchFlds[] = &$this->Reference;
        $searchFlds[] = &$this->Statut;
        $searchKeyword = $default ? $this->BasicSearch->KeywordDefault : $this->BasicSearch->Keyword;
        $searchType = $default ? $this->BasicSearch->TypeDefault : $this->BasicSearch->Type;

        // Get search SQL
        if ($searchKeyword != "") {
            $ar = $this->BasicSearch->keywordList($default);
            $searchStr = GetQuickSearchFilter($searchFlds, $ar, $searchType, Config("BASIC_SEARCH_ANY_FIELDS"), $this->Dbid);
            if (!$default && in_array($this->Command, ["", "reset", "resetall"])) {
                $this->Command = "search";
            }
        }
        if (!$default && $this->Command == "search") {
            $this->BasicSearch->setKeyword($searchKeyword);
            $this->BasicSearch->setType($searchType);

            // Clear rules for QueryBuilder
            $this->setSessionRules("");
        }
        return $searchStr;
    }

    // Check if search parm exists
    protected function checkSearchParms()
    {
        // Check basic search
        if ($this->BasicSearch->issetSession()) {
            return true;
        }
        if ($this->Carte_No->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->NIP->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->Nom->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->Prenom->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->Sexe->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->DateNaissance->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->Lieu->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->Photo->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->Unique_QR->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->Groupe_Sanguin->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->Delivree->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->Expire->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->Localite->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->Prevenir->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->Prevenir_Tel->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->Reference->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->Statut->AdvancedSearch->issetSession()) {
            return true;
        }
        return false;
    }

    // Clear all search parameters
    protected function resetSearchParms()
    {
        // Clear search WHERE clause
        $this->SearchWhere = "";
        $this->setSearchWhere($this->SearchWhere);

        // Clear basic search parameters
        $this->resetBasicSearchParms();

        // Clear advanced search parameters
        $this->resetAdvancedSearchParms();

        // Clear queryBuilder
        $this->setSessionRules("");
    }

    // Load advanced search default values
    protected function loadAdvancedSearchDefault()
    {
        return false;
    }

    // Clear all basic search parameters
    protected function resetBasicSearchParms()
    {
        $this->BasicSearch->unsetSession();
    }

    // Clear all advanced search parameters
    protected function resetAdvancedSearchParms()
    {
        $this->Carte_No->AdvancedSearch->unsetSession();
        $this->NIP->AdvancedSearch->unsetSession();
        $this->Nom->AdvancedSearch->unsetSession();
        $this->Prenom->AdvancedSearch->unsetSession();
        $this->Sexe->AdvancedSearch->unsetSession();
        $this->DateNaissance->AdvancedSearch->unsetSession();
        $this->Lieu->AdvancedSearch->unsetSession();
        $this->Photo->AdvancedSearch->unsetSession();
        $this->Unique_QR->AdvancedSearch->unsetSession();
        $this->Groupe_Sanguin->AdvancedSearch->unsetSession();
        $this->Delivree->AdvancedSearch->unsetSession();
        $this->Expire->AdvancedSearch->unsetSession();
        $this->Localite->AdvancedSearch->unsetSession();
        $this->Prevenir->AdvancedSearch->unsetSession();
        $this->Prevenir_Tel->AdvancedSearch->unsetSession();
        $this->Reference->AdvancedSearch->unsetSession();
        $this->Statut->AdvancedSearch->unsetSession();
    }

    // Restore all search parameters
    protected function restoreSearchParms()
    {
        $this->RestoreSearch = true;

        // Restore basic search values
        $this->BasicSearch->load();

        // Restore advanced search values
        $this->Carte_No->AdvancedSearch->load();
        $this->NIP->AdvancedSearch->load();
        $this->Nom->AdvancedSearch->load();
        $this->Prenom->AdvancedSearch->load();
        $this->Sexe->AdvancedSearch->load();
        $this->DateNaissance->AdvancedSearch->load();
        $this->Lieu->AdvancedSearch->load();
        $this->Photo->AdvancedSearch->load();
        $this->Unique_QR->AdvancedSearch->load();
        $this->Groupe_Sanguin->AdvancedSearch->load();
        $this->Delivree->AdvancedSearch->load();
        $this->Expire->AdvancedSearch->load();
        $this->Localite->AdvancedSearch->load();
        $this->Prevenir->AdvancedSearch->load();
        $this->Prevenir_Tel->AdvancedSearch->load();
        $this->Reference->AdvancedSearch->load();
        $this->Statut->AdvancedSearch->load();
    }

    // Set up sort parameters
    protected function setupSortOrder()
    {
        // Load default Sorting Order
        if ($this->Command != "json") {
            $defaultSort = ""; // Set up default sort
            if ($this->getSessionOrderBy() == "" && $defaultSort != "") {
                $this->setSessionOrderBy($defaultSort);
            }
        }

        // Check for "order" parameter
        if (Get("order") !== null) {
            $this->CurrentOrder = Get("order");
            $this->CurrentOrderType = Get("ordertype", "");
            $this->updateSort($this->Carte_No); // Carte_No
            $this->updateSort($this->NIP); // NIP
            $this->updateSort($this->Nom); // Nom
            $this->updateSort($this->Prenom); // Prenom
            $this->updateSort($this->DateNaissance); // DateNaissance
            $this->updateSort($this->Lieu); // Lieu
            $this->updateSort($this->Photo); // Photo
            $this->updateSort($this->Unique_QR); // Unique_QR
            $this->updateSort($this->Delivree); // Delivree
            $this->updateSort($this->Expire); // Expire
            $this->updateSort($this->Localite); // Localite
            $this->updateSort($this->Statut); // Statut
            $this->setStartRecordNumber(1); // Reset start position
        }

        // Update field sort
        $this->updateFieldSort();
    }

    // Reset command
    // - cmd=reset (Reset search parameters)
    // - cmd=resetall (Reset search and master/detail parameters)
    // - cmd=resetsort (Reset sort parameters)
    protected function resetCmd()
    {
        // Check if reset command
        if (StartsString("reset", $this->Command)) {
            // Reset search criteria
            if ($this->Command == "reset" || $this->Command == "resetall") {
                $this->resetSearchParms();
            }

            // Reset (clear) sorting order
            if ($this->Command == "resetsort") {
                $orderBy = "";
                $this->setSessionOrderBy($orderBy);
                $this->volontaireID->setSort("");
                $this->Carte_No->setSort("");
                $this->NIP->setSort("");
                $this->Nom->setSort("");
                $this->Prenom->setSort("");
                $this->Sexe->setSort("");
                $this->DateNaissance->setSort("");
                $this->Lieu->setSort("");
                $this->Photo->setSort("");
                $this->Unique_QR->setSort("");
                $this->Groupe_Sanguin->setSort("");
                $this->Delivree->setSort("");
                $this->Expire->setSort("");
                $this->Localite->setSort("");
                $this->Prevenir->setSort("");
                $this->Prevenir_Tel->setSort("");
                $this->Reference->setSort("");
                $this->EmployeeID->setSort("");
                $this->Statut->setSort("");
            }

            // Reset start position
            $this->StartRecord = 1;
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Set up list options
    protected function setupListOptions()
    {
        global $Security, $Language;
        $this->MultiColumnLayout = Param(Config("PAGE_LAYOUT"));
        if (in_array($this->MultiColumnLayout, Config("PAGE_LAYOUTS"))) {
            $this->setSessionLayout($this->MultiColumnLayout);
        } else {
            $this->MultiColumnLayout = $this->getSessionLayout() ?? "cards";
        }

        // Add group option item ("button")
        $item = &$this->ListOptions->addGroupOption();
        $item->Body = "";
        $item->OnLeft = $this->MultiColumnLayout == "cards" ? false : true;
        $item->Visible = false;

        // "view"
        $item = &$this->ListOptions->add("view");
        $item->CssClass = "text-nowrap";
        $item->Visible = $Security->canView();
        $item->OnLeft = $this->MultiColumnLayout == "cards" ? false : true;

        // "edit"
        $item = &$this->ListOptions->add("edit");
        $item->CssClass = "text-nowrap";
        $item->Visible = $Security->canEdit();
        $item->OnLeft = $this->MultiColumnLayout == "cards" ? false : true;

        // List actions
        $item = &$this->ListOptions->add("listactions");
        $item->CssClass = "text-nowrap";
        $item->OnLeft = $this->MultiColumnLayout == "cards" ? false : true;
        $item->Visible = false;
        $item->ShowInButtonGroup = false;
        $item->ShowInDropDown = false;

        // "checkbox"
        $item = &$this->ListOptions->add("checkbox");
        $item->Visible = true;
        $item->OnLeft = $this->MultiColumnLayout == "cards" ? false : true;
        $item->Header = "<div class=\"form-check\"><input type=\"checkbox\" name=\"key\" id=\"key\" class=\"form-check-input\" data-ew-action=\"select-all-keys\"></div>";
        if ($item->OnLeft) {
            $item->moveTo(0);
        }
        $item->ShowInDropDown = false;
        $item->ShowInButtonGroup = false;

        // Drop down button for ListOptions
        $this->ListOptions->UseDropDownButton = true;
        if ($this->MultiColumnLayout == "cards") { // Multi column layout
            $this->ListOptions->DropDownButtonPhrase = $Language->phrase("ButtonListOptionsCard");
            $this->ListOptions->TagClassName = "ew-multi-column-list-option-card m-1";
        } else {
            $this->ListOptions->DropDownButtonPhrase = $Language->phrase("ButtonListOptions");
            $this->ListOptions->TagClassName = "ew-multi-column-list-option-table";
        }
        $this->ListOptions->UseButtonGroup = true;
        if ($this->ListOptions->UseButtonGroup && IsMobile()) {
            $this->ListOptions->UseDropDownButton = true;
        }

        //$this->ListOptions->ButtonClass = ""; // Class for button group

        // Call ListOptions_Load event
        $this->listOptionsLoad();
        $this->setupListOptionsExt();
        $item = $this->ListOptions[$this->ListOptions->GroupOptionName];
        $item->Visible = $this->ListOptions->groupOptionVisible();
    }

    // Set up list options (extensions)
    protected function setupListOptionsExt()
    {
        // Preview extension
        $this->ListOptions->hideDetailItemsForDropDown(); // Hide detail items for dropdown if necessary
    }

    // Add "hash" parameter to URL
    public function urlAddHash($url, $hash)
    {
        return $this->UseAjaxActions ? $url : UrlAddQuery($url, "hash=" . $hash);
    }

    // Render list options
    public function renderListOptions()
    {
        global $Security, $Language, $CurrentForm, $UserProfile;
        $this->ListOptions->loadDefault();

        // Call ListOptions_Rendering event
        $this->listOptionsRendering();
        $pageUrl = $this->pageUrl(false);
        if ($this->CurrentMode == "view") {
            // "view"
            $opt = $this->ListOptions["view"];
            $viewcaption = HtmlTitle($Language->phrase("ViewLink"));
            if ($Security->canView()) {
                if ($this->ModalView && !IsMobile()) {
                    $opt->Body = "<a class=\"ew-row-link ew-view\" title=\"" . $viewcaption . "\" data-table=\"volontaire\" data-caption=\"" . $viewcaption . "\" data-ew-action=\"modal\" data-action=\"view\" data-ajax=\"" . ($this->UseAjaxActions ? "true" : "false") . "\" data-url=\"" . HtmlEncode(GetUrl($this->ViewUrl)) . "\" data-btn=\"null\">" . $Language->phrase("ViewLink") . "</a>";
                } else {
                    $opt->Body = "<a class=\"ew-row-link ew-view\" title=\"" . $viewcaption . "\" data-caption=\"" . $viewcaption . "\" href=\"" . HtmlEncode(GetUrl($this->ViewUrl)) . "\">" . $Language->phrase("ViewLink") . "</a>";
                }
            } else {
                $opt->Body = "";
            }

            // "edit"
            $opt = $this->ListOptions["edit"];
            $editcaption = HtmlTitle($Language->phrase("EditLink"));
            if ($Security->canEdit()) {
                if ($this->ModalEdit && !IsMobile()) {
					$opt->Body = "<a class=\"ew-row-link ew-edit\" title=\"" . $editcaption . "\" data-table=\"volontaire\" data-caption=\"" . $editcaption . "\" data-ew-action=\"modal\" data-action=\"edit\" data-ajax=\"" . ($this->UseAjaxActions ? "true" : "false") . "\" data-url=\"" . HtmlEncode(GetUrl($this->EditUrl)) . "\" data-ask=\"1\" data-btn=\"SaveBtn\">" . $Language->phrase("EditLink") . "</a>";
                } else {
                    $opt->Body = "<a class=\"ew-row-link ew-edit\" title=\"" . $editcaption . "\" data-caption=\"" . $editcaption . "\" href=\"" . HtmlEncode(GetUrl($this->EditUrl)) . "\">" . $Language->phrase("EditLink") . "</a>";
                }
            } else {
                $opt->Body = "";
            }
        } // End View mode

        // Set up list action buttons
        $opt = $this->ListOptions["listactions"];
        if ($opt && !$this->isExport() && !$this->CurrentAction) {
            $body = "";
            $links = [];
            foreach ($this->ListActions->Items as $listaction) {
                $action = $listaction->Action;
                $allowed = $listaction->Allow;
                if ($listaction->Select == ACTION_SINGLE && $allowed) {
                    $caption = $listaction->Caption;
                    $icon = ($listaction->Icon != "") ? "<i class=\"" . HtmlEncode(str_replace(" ew-icon", "", $listaction->Icon)) . "\" data-caption=\"" . HtmlTitle($caption) . "\"></i> " : "";
                    $link = "<li><button type=\"button\" class=\"dropdown-item ew-action ew-list-action\" data-caption=\"" . HtmlTitle($caption) . "\" data-ew-action=\"submit\" form=\"fvolontairelist\" data-key=\"" . $this->keyToJson(true) . "\"" . $listaction->toDataAttrs() . ">" . $icon . " " . $listaction->Caption . "</button></li>";
                    if ($action == "resetusersecret" && !$UserProfile->hasUserSecret($this->_Username->CurrentValue)) {
                        $link = ""; // Clear link
                    }
                    if ($link != "") {
                        $links[] = $link;
                        if ($body == "") { // Setup first button
                            $body = "<button type=\"button\" class=\"btn btn-default ew-action ew-list-action\" title=\"" . HtmlTitle($caption) . "\" data-caption=\"" . HtmlTitle($caption) . "\" data-ew-action=\"submit\" form=\"fvolontairelist\" data-key=\"" . $this->keyToJson(true) . "\"" . $listaction->toDataAttrs() . ">" . $icon . " " . $listaction->Caption . "</button>";
                        }
                    }
                }
            }
            if (count($links) > 1) { // More than one buttons, use dropdown
                $body = "<button type=\"button\" class=\"dropdown-toggle btn btn-default ew-actions\" title=\"" . HtmlTitle($Language->phrase("ListActionButton")) . "\" data-bs-toggle=\"dropdown\">" . $Language->phrase("ListActionButton") . "</button>";
                $content = "";
                foreach ($links as $link) {
                    $content .= "<li>" . $link . "</li>";
                }
                $body .= "<ul class=\"dropdown-menu" . ($opt->OnLeft ? "" : " dropdown-menu-right") . "\">" . $content . "</ul>";
                $body = "<div class=\"btn-group btn-group-sm\">" . $body . "</div>";
            }
            if (count($links) > 0) {
                $opt->Body = $body;
            }
        }

        // "checkbox"
        $opt = $this->ListOptions["checkbox"];
        $opt->Body = "<div class=\"form-check\"><input type=\"checkbox\" id=\"key_m_" . $this->RowCount . "\" name=\"key_m[]\" class=\"form-check-input ew-multi-select\" value=\"" . HtmlEncode($this->volontaireID->CurrentValue) . "\"></div>";
        $this->renderListOptionsExt();

        // Call ListOptions_Rendered event
        $this->listOptionsRendered();
    }

    // Render list options (extensions)
    protected function renderListOptionsExt()
    {
        // Render list options (to be implemented by extensions)
        global $Security, $Language;
    }

    // Set up other options
    protected function setupOtherOptions()
    {
        global $Language, $Security;
        $options = &$this->OtherOptions;
        $option = $options["addedit"];

        // Add
        $item = &$option->add("add");
        $addcaption = HtmlTitle($Language->phrase("AddLink"));
        if ($this->ModalAdd && !IsMobile()) {
			$item->Body = "<a class=\"ew-add-edit ew-add\" title=\"" . $addcaption . "\" data-table=\"volontaire\" data-caption=\"" . $addcaption . "\" data-ew-action=\"modal\" data-action=\"add\" data-ajax=\"" . ($this->UseAjaxActions ? "true" : "false") . "\" data-url=\"" . HtmlEncode(GetUrl($this->AddUrl)) . "\" data-ask=\"1\" data-btn=\"AddBtn\">" . $Language->phrase("AddLink") . "</a>";
        } else {
            $item->Body = "<a class=\"ew-add-edit ew-add\" title=\"" . $addcaption . "\" data-caption=\"" . $addcaption . "\" href=\"" . HtmlEncode(GetUrl($this->AddUrl)) . "\">" . $Language->phrase("AddLink") . "</a>";
        }
        $item->Visible = $this->AddUrl != "" && $Security->canAdd();
        $option = $options["action"];

        // Add multi delete
        $item = &$option->add("multidelete");
        $item->Body = "<button type=\"button\" class=\"ew-action ew-multi-delete\" title=\"" .
            HtmlTitle($Language->phrase("DeleteSelectedLink")) . "\" data-caption=\"" .
            HtmlTitle($Language->phrase("DeleteSelectedLink")) . "\" form=\"fvolontairelist\"" .
            " data-ew-action=\"" . ($this->UseAjaxActions ? "inline" : "submit") . "\"" .
            ($this->UseAjaxActions ? " data-action=\"delete\"" : "") .
            " data-url=\"" . GetUrl($this->MultiDeleteUrl) . "\"" .
            ($this->InlineDelete ? " data-msg=\"" . HtmlEncode($Language->phrase("DeleteConfirm")) . "\" data-data='{\"action\":\"delete\"}'" : " data-data='{\"action\":\"show\"}'") .
            ">" . $Language->phrase("DeleteSelectedLink") . "</button>";
        $item->Visible = $Security->canDelete();

        // Set up layout buttons/select all checkbox for multi column list page
        $this->LayoutOptions = new ListOptions(["TagClassName" => "ew-layout-option mb-3"]);
        $item = &$this->LayoutOptions->add("cards");
        $classname = $this->MultiColumnLayout == "cards" ? " disabled" : "";
        $item->Body = "<button type=\"button\" class=\"btn btn-default " . $classname . "\" title=\"" . $Language->phrase("MultiColumnCards", true) . "\" data-ew-action=\"layout\" data-layout=\"cards\" data-url=\"" . $this->pageUrl(false) . "\">" . $Language->phrase("MultiColumnCards") . "</button>";
        $item->Visible = true;
        $item = &$this->LayoutOptions->add("table");
        $classname = $this->MultiColumnLayout == "table" ? " disabled" : "";
        $item->Body = "<button type=\"button\" class=\"btn btn-default " . $classname . "\" title=\"" . $Language->phrase("MultiColumnTable", true) . "\" data-ew-action=\"layout\" data-layout=\"table\" data-url=\"" . $this->pageUrl(false) . "\">" . $Language->phrase("MultiColumnTable") . "</button>";
        $item->Visible = true;
        $item = &$this->LayoutOptions->add("checkbox");
        $item->Body = "<div class=\"btn-group\"><div class=\"form-check\"><input type=\"checkbox\" name=\"key\" id=\"key\" class=\"form-check-input\" data-ew-action=\"select-all-keys\" form=\"fvolontairelist\"><label class=\"form-check-label\" for=\"key\">" . $Language->phrase("SelectAll") . "</label></div></div>";
        $item->ShowInButtonGroup = true;
        $item->Visible = true && $this->MultiColumnLayout == "cards";
        $this->LayoutOptions->addGroupOption();
        $this->LayoutOptions->UseDropDownButton = false;
        $this->LayoutOptions->UseButtonGroup = true;
        if (IsExport("print") || $this->IsModal) {
            $this->LayoutOptions->hideAllOptions();
        }

        // Set up options default
        foreach ($options as $name => $option) {
            if ($name != "column") { // Always use dropdown for column
                $option->UseDropDownButton = true;
                $option->UseButtonGroup = true;
            }
            //$option->ButtonClass = ""; // Class for button group
            $item = &$option->addGroupOption();
            $item->Body = "";
            $item->Visible = false;
        }
        $options["addedit"]->DropDownButtonPhrase = $Language->phrase("ButtonAddEdit");
        $options["detail"]->DropDownButtonPhrase = $Language->phrase("ButtonDetails");
        $options["action"]->DropDownButtonPhrase = $Language->phrase("ButtonActions");

        // Filter button
        $item = &$this->FilterOptions->add("savecurrentfilter");
        $item->Body = "<a class=\"ew-save-filter\" data-form=\"fvolontairesrch\" data-ew-action=\"none\">" . $Language->phrase("SaveCurrentFilter") . "</a>";
        $item->Visible = true;
        $item = &$this->FilterOptions->add("deletefilter");
        $item->Body = "<a class=\"ew-delete-filter\" data-form=\"fvolontairesrch\" data-ew-action=\"none\">" . $Language->phrase("DeleteFilter") . "</a>";
        $item->Visible = true;
        $this->FilterOptions->UseDropDownButton = true;
        $this->FilterOptions->UseButtonGroup = !$this->FilterOptions->UseDropDownButton;
        $this->FilterOptions->DropDownButtonPhrase = $Language->phrase("Filters");

        // Add group option item
        $item = &$this->FilterOptions->addGroupOption();
        $item->Body = "";
        $item->Visible = false;
    }

    // Create new column option
    public function createColumnOption($name)
    {
        $field = $this->Fields[$name] ?? false;
        if ($field && $field->Visible) {
            $item = new ListOption($field->Name);
            $item->Body = '<button class="dropdown-item">' .
                '<div class="form-check ew-dropdown-checkbox">' .
                '<div class="form-check-input ew-dropdown-check-input" data-field="' . $field->Param . '"></div>' .
                '<label class="form-check-label ew-dropdown-check-label">' . $field->caption() . '</label></div></button>';
            return $item;
        }
        return null;
    }

    // Render other options
    public function renderOtherOptions()
    {
        global $Language, $Security;
        $options = &$this->OtherOptions;
        $option = $options["action"];
        // Set up list action buttons
        foreach ($this->ListActions->Items as $listaction) {
            if ($listaction->Select == ACTION_MULTIPLE) {
                $item = &$option->add("custom_" . $listaction->Action);
                $caption = $listaction->Caption;
                $icon = ($listaction->Icon != "") ? '<i class="' . HtmlEncode($listaction->Icon) . '" data-caption="' . HtmlEncode($caption) . '"></i>' . $caption : $caption;
                $item->Body = '<button type="button" class="btn btn-default ew-action ew-list-action" title="' . HtmlEncode($caption) . '" data-caption="' . HtmlEncode($caption) . '" data-ew-action="submit" form="fvolontairelist"' . $listaction->toDataAttrs() . '>' . $icon . '</button>';
                $item->Visible = $listaction->Allow;
            }
        }

        // Hide multi edit, grid edit and other options
        if ($this->TotalRecords <= 0) {
            $option = $options["addedit"];
            $item = $option["gridedit"];
            if ($item) {
                $item->Visible = false;
            }
            $option = $options["action"];
            $option->hideAllOptions();
        }
    }

    // Process list action
    protected function processListAction()
    {
        global $Language, $Security, $Response;
        $userlist = "";
        $user = "";
        $filter = $this->getFilterFromRecordKeys();
        $userAction = Post("action", "");
        if ($filter != "" && $userAction != "") {
            // Check permission first
            $actionCaption = $userAction;
            if (array_key_exists($userAction, $this->ListActions->Items)) {
                if (array_key_exists($userAction, $this->CustomActions)) {
                    $this->UserAction = $userAction;
					$this->CurrentAction = ""; // Clear current action
                }
                $actionCaption = $this->ListActions[$userAction]->Caption;
                if (!$this->ListActions[$userAction]->Allow) {
                    $errmsg = str_replace('%s', $actionCaption, $Language->phrase("CustomActionNotAllowed"));
                    if (Post("ajax") == $userAction) { // Ajax
                        echo "<p class=\"text-danger\" style=\"padding: 20px;\">" . $errmsg . "</p>";
                        return true;
                    } else {
                        $this->setFailureMessage($errmsg);
                        return false;
                    }
                }
            }
            $this->CurrentFilter = $filter;
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $rows = ExecuteRows($sql, $conn);
            $count = count($rows);
            $this->ActionValue = Post("actionvalue");

            // Call row action event
            if ($count > 0) {
                if ($this->UseTransaction) {
                    $conn->beginTransaction();
                }
                $this->SelectedCount = $count;
                $this->SelectedIndex = 0;
                foreach ($rows as $row) {
                    $this->SelectedIndex++;
                    $processed = $this->rowCustomAction($userAction, $row);
                    if (!$processed) {
                        break;
                    }
                }
                if ($processed) {
                    if ($this->UseTransaction) { // Commit transaction
                        $conn->commit();
                    }
                    if ($this->getSuccessMessage() == "" && !ob_get_length() && !$Response->getBody()->getSize()) { // No output
                        $this->setSuccessMessage(str_replace('%s', $actionCaption, $Language->phrase("CustomActionCompleted"))); // Set up success message
                    }
                } else {
                    if ($this->UseTransaction) { // Rollback transaction
                        $conn->rollback();
                    }

                    // Set up error message
                    if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                        // Use the message, do nothing
                    } elseif ($this->CancelMessage != "") {
                        $this->setFailureMessage($this->CancelMessage);
                        $this->CancelMessage = "";
                    } else {
                        $this->setFailureMessage(str_replace('%s', $actionCaption, $Language->phrase("CustomActionFailed")));
                    }
                }
            }
            if (Post("ajax") == $userAction) { // Ajax
                if ($this->getSuccessMessage() != "") {
                    echo "<p class=\"text-success\" style=\"padding: 20px;\">" . $this->getSuccessMessage() . "</p>";
                    $this->clearSuccessMessage(); // Clear message
                }
                if ($this->getFailureMessage() != "") {
                    echo "<p class=\"text-danger\" style=\"padding: 20px;\">" . $this->getFailureMessage() . "</p>";
                    $this->clearFailureMessage(); // Clear message
                }
                return true;
            }
        }
        return false; // Not ajax request
    }

    // Get multi-column row CSS class
    public function getMultiColumnRowClass()
    {
        if ($this->isAddOrEdit() && ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT)) {
            return "row"; // Full row
        }
        return "row row-cols-1 " . $this->MultiColumnGridClass . " g-4 ew-multi-column-row";
    }

    // Get multi-column col-* CSS class
    public function getMultiColumnColClass()
    {
        if ($this->isAddOrEdit() && ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT)) {
            return $this->MultiColumnEditClass; // Full row
        }
        return "col";
    }

    // Set up Grid
    public function setupGrid()
    {
        global $CurrentForm;
        if ($this->ExportAll && $this->isExport()) {
            $this->StopRecord = $this->TotalRecords;
        } else {
            // Set the last record to display
            if ($this->TotalRecords > $this->StartRecord + $this->DisplayRecords - 1) {
                $this->StopRecord = $this->StartRecord + $this->DisplayRecords - 1;
            } else {
                $this->StopRecord = $this->TotalRecords;
            }
        }
        $this->RecordCount = $this->StartRecord - 1;
        if ($this->Recordset && !$this->Recordset->EOF) {
            // Nothing to do
        } elseif ($this->isGridAdd() && !$this->AllowAddDeleteRow && $this->StopRecord == 0) { // Grid-Add with no records
            $this->StopRecord = $this->GridAddRowCount;
        } elseif ($this->isAdd() && $this->TotalRecords == 0) { // Inline-Add with no records
            $this->StopRecord = 1;
        }

        // Initialize aggregate
        $this->RowType = ROWTYPE_AGGREGATEINIT;
        $this->resetAttributes();
        $this->renderRow();
        if (($this->isGridAdd() || $this->isGridEdit()) && $this->MultiColumnLayout == "table") { // Render template row first
            $this->RowIndex = '$rowindex$';
        }
    }

    // Set up Row
    public function setupRow()
    {
        global $CurrentForm;
        if ($this->isGridAdd() || $this->isGridEdit()) {
            if ($this->RowIndex === '$rowindex$') { // Render template row first
                $this->loadRowValues();

                // Set row properties
                $this->resetAttributes();
                $this->RowAttrs->merge(["data-rowindex" => $this->RowIndex, "id" => "r0_volontaire", "data-rowtype" => ROWTYPE_ADD]);
                $this->RowAttrs->appendClass("ew-template");
                // Render row
                $this->RowType = ROWTYPE_ADD;
                $this->renderRow();

                // Render list options
                $this->renderListOptions();

                // Reset record count for template row
                $this->RecordCount--;
                return;
            }
        }

        // Set up key count
        $this->KeyCount = $this->RowIndex;

        // Init row class and style
        $this->resetAttributes();
        $this->CssClass = "";
        if ($this->isCopy() && $this->InlineRowCount == 0 && !$this->loadRow()) { // Inline copy
            $this->CurrentAction = "add";
        }
        if ($this->isAdd() && $this->InlineRowCount == 0 || $this->isGridAdd()) {
            $this->loadRowValues(); // Load default values
            $this->OldKey = "";
            $this->setKey($this->OldKey);
        } elseif ($this->isInlineInserted() && $this->UseInfiniteScroll) {
            // Nothing to do, just use current values
        } elseif (!($this->isCopy() && $this->InlineRowCount == 0)) {
            $this->loadRowValues($this->Recordset); // Load row values
            if ($this->isGridEdit() || $this->isMultiEdit()) {
                $this->OldKey = $this->getKey(true); // Get from CurrentValue
                $this->setKey($this->OldKey);
            }
        }
        $this->RowType = ROWTYPE_VIEW; // Render view
        if (($this->isAdd() || $this->isCopy()) && $this->InlineRowCount == 0 || $this->isGridAdd()) { // Add
            $this->RowType = ROWTYPE_ADD; // Render add
        }

        // Inline Add/Copy row (row 0)
        if ($this->RowType == ROWTYPE_ADD && ($this->isAdd() || $this->isCopy())) {
            $this->InlineRowCount++;
            $this->RecordCount--; // Reset record count for inline add/copy row
            if ($this->TotalRecords == 0) { // Reset stop record if no records
                $this->StopRecord = 0;
            }
        } else {
            // Inline Edit row
            if ($this->RowType == ROWTYPE_EDIT && $this->isEdit()) {
                $this->InlineRowCount++;
            }
            $this->RowCount++; // Increment row count
        }

        // Set up row attributes
        $this->RowAttrs->merge([
            "data-rowindex" => $this->RowCount,
            "data-key" => $this->getKey(true),
            "id" => "r" . $this->RowCount . "_volontaire",
            "data-rowtype" => $this->RowType,
            "class" => ($this->RowCount % 2 != 1) ? "ew-table-alt-row" : "",
        ]);
        if ($this->isAdd() && $this->RowType == ROWTYPE_ADD || $this->isEdit() && $this->RowType == ROWTYPE_EDIT) { // Inline-Add/Edit row
            $this->RowAttrs->appendClass("table-active");
        }

        // Render row
        $this->renderRow();

        // Render list options
        $this->renderListOptions();
    }

// Load basic search values
    protected function loadBasicSearchValues()
    {
        $this->BasicSearch->setKeyword(Get(Config("TABLE_BASIC_SEARCH"), ""), false);
        if ($this->BasicSearch->Keyword != "" && $this->Command == "") {
            $this->Command = "search";
        }
        $this->BasicSearch->setType(Get(Config("TABLE_BASIC_SEARCH_TYPE"), ""), false);
    }

    // Load search values for validation
    protected function loadSearchValues()
    {
        // Load search values
        $hasValue = false;

        // Load query builder rules
        $rules = Post("rules");
        if ($rules && $this->Command == "") {
            $this->QueryRules = $rules;
            $this->Command = "search";
        }

        // Carte_No
        if ($this->Carte_No->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->Carte_No->AdvancedSearch->SearchValue != "" || $this->Carte_No->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // NIP
        if ($this->NIP->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->NIP->AdvancedSearch->SearchValue != "" || $this->NIP->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // Nom
        if ($this->Nom->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->Nom->AdvancedSearch->SearchValue != "" || $this->Nom->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // Prenom
        if ($this->Prenom->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->Prenom->AdvancedSearch->SearchValue != "" || $this->Prenom->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // Sexe
        if ($this->Sexe->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->Sexe->AdvancedSearch->SearchValue != "" || $this->Sexe->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // DateNaissance
        if ($this->DateNaissance->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->DateNaissance->AdvancedSearch->SearchValue != "" || $this->DateNaissance->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // Lieu
        if ($this->Lieu->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->Lieu->AdvancedSearch->SearchValue != "" || $this->Lieu->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // Photo
        if ($this->Photo->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->Photo->AdvancedSearch->SearchValue != "" || $this->Photo->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // Unique_QR
        if ($this->Unique_QR->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->Unique_QR->AdvancedSearch->SearchValue != "" || $this->Unique_QR->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // Groupe_Sanguin
        if ($this->Groupe_Sanguin->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->Groupe_Sanguin->AdvancedSearch->SearchValue != "" || $this->Groupe_Sanguin->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // Delivree
        if ($this->Delivree->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->Delivree->AdvancedSearch->SearchValue != "" || $this->Delivree->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // Expire
        if ($this->Expire->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->Expire->AdvancedSearch->SearchValue != "" || $this->Expire->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // Localite
        if ($this->Localite->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->Localite->AdvancedSearch->SearchValue != "" || $this->Localite->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // Prevenir
        if ($this->Prevenir->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->Prevenir->AdvancedSearch->SearchValue != "" || $this->Prevenir->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // Prevenir_Tel
        if ($this->Prevenir_Tel->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->Prevenir_Tel->AdvancedSearch->SearchValue != "" || $this->Prevenir_Tel->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // Reference
        if ($this->Reference->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->Reference->AdvancedSearch->SearchValue != "" || $this->Reference->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // Statut
        if ($this->Statut->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->Statut->AdvancedSearch->SearchValue != "" || $this->Statut->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }
        return $hasValue;
    }

    // Load recordset
    public function loadRecordset($offset = -1, $rowcnt = -1)
    {
        // Load List page SQL (QueryBuilder)
        $sql = $this->getListSql();

        // Load recordset
        if ($offset > -1) {
            $sql->setFirstResult($offset);
        }
        if ($rowcnt > 0) {
            $sql->setMaxResults($rowcnt);
        }
        $result = $sql->execute();
        $rs = new Recordset($result, $sql);

        // Call Recordset Selected event
        $this->recordsetSelected($rs);
        return $rs;
    }

    // Load records as associative array
    public function loadRows($offset = -1, $rowcnt = -1)
    {
        // Load List page SQL (QueryBuilder)
        $sql = $this->getListSql();

        // Load recordset
        if ($offset > -1) {
            $sql->setFirstResult($offset);
        }
        if ($rowcnt > 0) {
            $sql->setMaxResults($rowcnt);
        }
        $result = $sql->execute();
        return $result->fetchAllAssociative();
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from recordset or record
     *
     * @param Recordset|array $rs Record
     * @return void
     */
    public function loadRowValues($rs = null)
    {
        if (is_array($rs)) {
            $row = $rs;
        } elseif ($rs && property_exists($rs, "fields")) { // Recordset
            $row = $rs->fields;
        } else {
            $row = $this->newRow();
        }
        if (!$row) {
            return;
        }

        // Call Row Selected event
        $this->rowSelected($row);
        $this->volontaireID->setDbValue($row['volontaireID']);
        $this->Carte_No->setDbValue($row['Carte_No']);
        $this->NIP->setDbValue($row['NIP']);
        $this->Nom->setDbValue($row['Nom']);
        $this->Prenom->setDbValue($row['Prenom']);
        $this->Sexe->setDbValue($row['Sexe']);
        $this->DateNaissance->setDbValue($row['DateNaissance']);
        $this->Lieu->setDbValue($row['Lieu']);
        $this->Photo->Upload->DbValue = $row['Photo'];
        $this->Photo->setDbValue($this->Photo->Upload->DbValue);
        $this->Unique_QR->setDbValue($row['Unique_QR']);
        $this->Groupe_Sanguin->setDbValue($row['Groupe_Sanguin']);
        $this->Delivree->setDbValue($row['Delivree']);
        $this->Expire->setDbValue($row['Expire']);
        $this->Localite->setDbValue($row['Localite']);
        $this->Prevenir->setDbValue($row['Prevenir']);
        $this->Prevenir_Tel->setDbValue($row['Prevenir_Tel']);
        $this->Reference->setDbValue($row['Reference']);
        $this->EmployeeID->setDbValue($row['EmployeeID']);
        $this->Statut->setDbValue($row['Statut']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['volontaireID'] = $this->volontaireID->DefaultValue;
        $row['Carte_No'] = $this->Carte_No->DefaultValue;
        $row['NIP'] = $this->NIP->DefaultValue;
        $row['Nom'] = $this->Nom->DefaultValue;
        $row['Prenom'] = $this->Prenom->DefaultValue;
        $row['Sexe'] = $this->Sexe->DefaultValue;
        $row['DateNaissance'] = $this->DateNaissance->DefaultValue;
        $row['Lieu'] = $this->Lieu->DefaultValue;
        $row['Photo'] = $this->Photo->DefaultValue;
        $row['Unique_QR'] = $this->Unique_QR->DefaultValue;
        $row['Groupe_Sanguin'] = $this->Groupe_Sanguin->DefaultValue;
        $row['Delivree'] = $this->Delivree->DefaultValue;
        $row['Expire'] = $this->Expire->DefaultValue;
        $row['Localite'] = $this->Localite->DefaultValue;
        $row['Prevenir'] = $this->Prevenir->DefaultValue;
        $row['Prevenir_Tel'] = $this->Prevenir_Tel->DefaultValue;
        $row['Reference'] = $this->Reference->DefaultValue;
        $row['EmployeeID'] = $this->EmployeeID->DefaultValue;
        $row['Statut'] = $this->Statut->DefaultValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load old record
        if ($this->OldKey != "") {
            $this->setKey($this->OldKey);
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $rs = LoadRecordset($sql, $conn);
            if ($rs && ($row = $rs->fields)) {
                $this->loadRowValues($row); // Load row values
                return $row;
            }
        }
        $this->loadRowValues(); // Load default row values
        return null;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs
        $this->ViewUrl = $this->getViewUrl();
        $this->EditUrl = $this->getEditUrl();
        $this->InlineEditUrl = $this->getInlineEditUrl();
        $this->CopyUrl = $this->getCopyUrl();
        $this->InlineCopyUrl = $this->getInlineCopyUrl();
        $this->DeleteUrl = $this->getDeleteUrl();

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // volontaireID
        $this->volontaireID->CellCssStyle = "white-space: nowrap;";

        // Carte_No

        // NIP

        // Nom

        // Prenom

        // Sexe

        // DateNaissance

        // Lieu

        // Photo

        // Unique_QR

        // Groupe_Sanguin

        // Delivree
        $this->Delivree->CellCssStyle = "white-space: nowrap;";

        // Expire
        $this->Expire->CellCssStyle = "white-space: nowrap;";

        // Localite

        // Prevenir

        // Prevenir_Tel

        // Reference

        // EmployeeID
        $this->EmployeeID->CellCssStyle = "white-space: nowrap;";

        // Statut

        // View row
        if ($this->RowType == ROWTYPE_VIEW) {
            // Carte_No
            $this->Carte_No->ViewValue = $this->Carte_No->CurrentValue;

            // NIP
            $this->NIP->ViewValue = $this->NIP->CurrentValue;

            // Nom
            $this->Nom->ViewValue = $this->Nom->CurrentValue;

            // Prenom
            $this->Prenom->ViewValue = $this->Prenom->CurrentValue;

            // Sexe
            if (strval($this->Sexe->CurrentValue) != "") {
                $this->Sexe->ViewValue = $this->Sexe->optionCaption($this->Sexe->CurrentValue);
            } else {
                $this->Sexe->ViewValue = null;
            }

            // DateNaissance
            $this->DateNaissance->ViewValue = $this->DateNaissance->CurrentValue;
            $this->DateNaissance->ViewValue = FormatDateTime($this->DateNaissance->ViewValue, $this->DateNaissance->formatPattern());

            // Lieu
            $this->Lieu->ViewValue = $this->Lieu->CurrentValue;

            // Photo
            $this->Photo->UploadPath = $this->Photo->getUploadPath(); // PHP
            if (!EmptyValue($this->Photo->Upload->DbValue)) {
                $this->Photo->ImageWidth = 100;
                $this->Photo->ImageHeight = 100;
                $this->Photo->ImageAlt = $this->Photo->alt();
                $this->Photo->ImageCssClass = "ew-image";
                $this->Photo->ViewValue = $this->Photo->Upload->DbValue;
            } else {
                $this->Photo->ViewValue = "";
            }

            // Unique_QR
            $this->Unique_QR->ViewValue = $this->Unique_QR->CurrentValue;
            $this->Unique_QR->ImageAlt = $this->Unique_QR->alt();
                $this->Unique_QR->ImageCssClass = "ew-image";

            // Groupe_Sanguin
            $this->Groupe_Sanguin->ViewValue = $this->Groupe_Sanguin->CurrentValue;

            // Delivree
            $this->Delivree->ViewValue = $this->Delivree->CurrentValue;
            $this->Delivree->ViewValue = FormatDateTime($this->Delivree->ViewValue, $this->Delivree->formatPattern());

            // Expire
            $this->Expire->ViewValue = $this->Expire->CurrentValue;
            $this->Expire->ViewValue = FormatDateTime($this->Expire->ViewValue, $this->Expire->formatPattern());

            // Localite
            $this->Localite->ViewValue = $this->Localite->CurrentValue;

            // Prevenir
            $this->Prevenir->ViewValue = $this->Prevenir->CurrentValue;

            // Prevenir_Tel
            $this->Prevenir_Tel->ViewValue = $this->Prevenir_Tel->CurrentValue;

            // Reference
            $this->Reference->ViewValue = $this->Reference->CurrentValue;

            // Statut
            if (strval($this->Statut->CurrentValue) != "") {
                $this->Statut->ViewValue = $this->Statut->optionCaption($this->Statut->CurrentValue);
            } else {
                $this->Statut->ViewValue = null;
            }
            $this->Statut->CssClass = "fw-bold";

            // Carte_No
            $this->Carte_No->HrefValue = "";
            $this->Carte_No->TooltipValue = "";

            // NIP
            $this->NIP->HrefValue = "";
            $this->NIP->TooltipValue = "";

            // Nom
            $this->Nom->HrefValue = "";
            $this->Nom->TooltipValue = "";

            // Prenom
            $this->Prenom->HrefValue = "";
            $this->Prenom->TooltipValue = "";

            // DateNaissance
            $this->DateNaissance->HrefValue = "";
            $this->DateNaissance->TooltipValue = "";

            // Lieu
            $this->Lieu->HrefValue = "";
            $this->Lieu->TooltipValue = "";

            // Photo
            $this->Photo->UploadPath = $this->Photo->getUploadPath(); // PHP
            if (!EmptyValue($this->Photo->Upload->DbValue)) {
                $this->Photo->HrefValue = GetFileUploadUrl($this->Photo, $this->Photo->htmlDecode($this->Photo->Upload->DbValue)); // Add prefix/suffix
                $this->Photo->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->Photo->HrefValue = FullUrl($this->Photo->HrefValue, "href");
                }
            } else {
                $this->Photo->HrefValue = "";
            }
            $this->Photo->ExportHrefValue = $this->Photo->UploadPath . $this->Photo->Upload->DbValue;
            $this->Photo->TooltipValue = "";
            if ($this->Photo->UseColorbox) {
                if (EmptyValue($this->Photo->TooltipValue)) {
                    $this->Photo->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
                }
                $this->Photo->LinkAttrs["data-rel"] = "volontaire_x" . $this->RowCount . "_Photo";
                $this->Photo->LinkAttrs->appendClass("ew-lightbox");
            }

            // Unique_QR
            $this->Unique_QR->HrefValue = "";
            $this->Unique_QR->ExportHrefValue = PhpBarcode::barcode(true)->getHrefValue($this->Unique_QR->CurrentValue, 'QRCODE', 60);
            $this->Unique_QR->TooltipValue = "";

            // Delivree
            $this->Delivree->HrefValue = "";
            $this->Delivree->TooltipValue = "";

            // Expire
            $this->Expire->HrefValue = "";
            $this->Expire->TooltipValue = "";

            // Localite
            $this->Localite->HrefValue = "";
            $this->Localite->TooltipValue = "";

            // Statut
            $this->Statut->HrefValue = "";
            $this->Statut->TooltipValue = "";
        } elseif ($this->RowType == ROWTYPE_SEARCH) {
            // Carte_No
            $this->Carte_No->setupEditAttributes();
            if (!$this->Carte_No->Raw) {
                $this->Carte_No->AdvancedSearch->SearchValue = HtmlDecode($this->Carte_No->AdvancedSearch->SearchValue);
            }
            $this->Carte_No->EditValue = HtmlEncode($this->Carte_No->AdvancedSearch->SearchValue);
            $arwrk = [];
            $arwrk["lf"] = $this->Carte_No->CurrentValue;
            $arwrk["df"] = $this->Carte_No->CurrentValue;
            $arwrk = $this->Carte_No->Lookup->renderViewRow($arwrk, $this);
            $dispVal = $this->Carte_No->displayValue($arwrk);
            if ($dispVal != "") {
                $this->Carte_No->EditValue = $dispVal;
            }
            $this->Carte_No->PlaceHolder = RemoveHtml($this->Carte_No->caption());

            // NIP
            $this->NIP->setupEditAttributes();
            if (!$this->NIP->Raw) {
                $this->NIP->AdvancedSearch->SearchValue = HtmlDecode($this->NIP->AdvancedSearch->SearchValue);
            }
            $this->NIP->EditValue = HtmlEncode($this->NIP->AdvancedSearch->SearchValue);
            $arwrk = [];
            $arwrk["lf"] = $this->NIP->CurrentValue;
            $arwrk["df"] = $this->NIP->CurrentValue;
            $arwrk = $this->NIP->Lookup->renderViewRow($arwrk, $this);
            $dispVal = $this->NIP->displayValue($arwrk);
            if ($dispVal != "") {
                $this->NIP->EditValue = $dispVal;
            }
            $this->NIP->PlaceHolder = RemoveHtml($this->NIP->caption());

            // Nom
            $this->Nom->setupEditAttributes();
            if (!$this->Nom->Raw) {
                $this->Nom->AdvancedSearch->SearchValue = HtmlDecode($this->Nom->AdvancedSearch->SearchValue);
            }
            $this->Nom->EditValue = HtmlEncode($this->Nom->AdvancedSearch->SearchValue);
            $arwrk = [];
            $arwrk["lf"] = $this->Nom->CurrentValue;
            $arwrk["df"] = $this->Nom->CurrentValue;
            $arwrk = $this->Nom->Lookup->renderViewRow($arwrk, $this);
            $dispVal = $this->Nom->displayValue($arwrk);
            if ($dispVal != "") {
                $this->Nom->EditValue = $dispVal;
            }
            $this->Nom->PlaceHolder = RemoveHtml($this->Nom->caption());

            // Prenom
            $this->Prenom->setupEditAttributes();
            if (!$this->Prenom->Raw) {
                $this->Prenom->AdvancedSearch->SearchValue = HtmlDecode($this->Prenom->AdvancedSearch->SearchValue);
            }
            $this->Prenom->EditValue = HtmlEncode($this->Prenom->AdvancedSearch->SearchValue);
            $this->Prenom->PlaceHolder = RemoveHtml($this->Prenom->caption());

            // DateNaissance
            $this->DateNaissance->setupEditAttributes();
            $this->DateNaissance->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->DateNaissance->AdvancedSearch->SearchValue, $this->DateNaissance->formatPattern()), $this->DateNaissance->formatPattern()));
            $this->DateNaissance->PlaceHolder = RemoveHtml($this->DateNaissance->caption());

            // Lieu
            $this->Lieu->setupEditAttributes();
            if (!$this->Lieu->Raw) {
                $this->Lieu->AdvancedSearch->SearchValue = HtmlDecode($this->Lieu->AdvancedSearch->SearchValue);
            }
            $this->Lieu->EditValue = HtmlEncode($this->Lieu->AdvancedSearch->SearchValue);
            $this->Lieu->PlaceHolder = RemoveHtml($this->Lieu->caption());

            // Photo
            $this->Photo->setupEditAttributes();
            if (!$this->Photo->Raw) {
                $this->Photo->AdvancedSearch->SearchValue = HtmlDecode($this->Photo->AdvancedSearch->SearchValue);
            }
            $this->Photo->EditValue = HtmlEncode($this->Photo->AdvancedSearch->SearchValue);
            $this->Photo->PlaceHolder = RemoveHtml($this->Photo->caption());

            // Unique_QR
            $this->Unique_QR->setupEditAttributes();
            if (!$this->Unique_QR->Raw) {
                $this->Unique_QR->AdvancedSearch->SearchValue = HtmlDecode($this->Unique_QR->AdvancedSearch->SearchValue);
            }
            $this->Unique_QR->EditValue = HtmlEncode($this->Unique_QR->AdvancedSearch->SearchValue);
            $arwrk = [];
            $arwrk["lf"] = $this->Unique_QR->CurrentValue;
            $arwrk["df"] = $this->Unique_QR->CurrentValue;
            $arwrk = $this->Unique_QR->Lookup->renderViewRow($arwrk, $this);
            $dispVal = $this->Unique_QR->displayValue($arwrk);
            if ($dispVal != "") {
                $this->Unique_QR->EditValue = $dispVal;
            }
            $this->Unique_QR->PlaceHolder = RemoveHtml($this->Unique_QR->caption());

            // Delivree
            $this->Delivree->setupEditAttributes();
            $this->Delivree->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->Delivree->AdvancedSearch->SearchValue, $this->Delivree->formatPattern()), $this->Delivree->formatPattern()));
            $this->Delivree->PlaceHolder = RemoveHtml($this->Delivree->caption());

            // Expire
            $this->Expire->setupEditAttributes();
            $this->Expire->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->Expire->AdvancedSearch->SearchValue, $this->Expire->formatPattern()), $this->Expire->formatPattern()));
            $this->Expire->PlaceHolder = RemoveHtml($this->Expire->caption());

            // Localite
            $this->Localite->setupEditAttributes();
            if (!$this->Localite->Raw) {
                $this->Localite->AdvancedSearch->SearchValue = HtmlDecode($this->Localite->AdvancedSearch->SearchValue);
            }
            $this->Localite->EditValue = HtmlEncode($this->Localite->AdvancedSearch->SearchValue);
            $arwrk = [];
            $arwrk["lf"] = $this->Localite->CurrentValue;
            $arwrk["df"] = $this->Localite->CurrentValue;
            $arwrk = $this->Localite->Lookup->renderViewRow($arwrk, $this);
            $dispVal = $this->Localite->displayValue($arwrk);
            if ($dispVal != "") {
                $this->Localite->EditValue = $dispVal;
            }
            $this->Localite->PlaceHolder = RemoveHtml($this->Localite->caption());

            // Statut
            $this->Statut->setupEditAttributes();
            $this->Statut->EditValue = $this->Statut->options(true);
            $this->Statut->PlaceHolder = RemoveHtml($this->Statut->caption());
        }
        if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != ROWTYPE_AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate search
    protected function validateSearch()
    {
        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }

        // Return validate result
        $validateSearch = !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateSearch = $validateSearch && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateSearch;
    }

    // Load advanced search
    public function loadAdvancedSearch()
    {
        $this->Carte_No->AdvancedSearch->load();
        $this->NIP->AdvancedSearch->load();
        $this->Nom->AdvancedSearch->load();
        $this->Prenom->AdvancedSearch->load();
        $this->Sexe->AdvancedSearch->load();
        $this->DateNaissance->AdvancedSearch->load();
        $this->Lieu->AdvancedSearch->load();
        $this->Photo->AdvancedSearch->load();
        $this->Unique_QR->AdvancedSearch->load();
        $this->Groupe_Sanguin->AdvancedSearch->load();
        $this->Delivree->AdvancedSearch->load();
        $this->Expire->AdvancedSearch->load();
        $this->Localite->AdvancedSearch->load();
        $this->Prevenir->AdvancedSearch->load();
        $this->Prevenir_Tel->AdvancedSearch->load();
        $this->Reference->AdvancedSearch->load();
        $this->Statut->AdvancedSearch->load();
    }

    // Build export filter for selected records
    protected function buildExportSelectedFilter()
    {
        global $Language;
        $wrkFilter = "";
        if ($this->isExport()) {
            $wrkFilter = $this->getFilterFromRecordKeys();
        }
        return $wrkFilter;
    }

    // Get export HTML tag
    protected function getExportTag($type, $custom = false)
    {
        global $Language;

        // if ($type == "print" || $custom) {
        //    $pageUrl = $this->pageUrl(false); // removed by UDS Hub, Sept 27, 2022 ... Printer Friendly (print) using API EXPORT ACTION, too!

        //    $exportUrl = GetUrl($pageUrl . "export=" . $type . ($custom ? "&amp;custom=1" : "")); // removed by UDS Hub, Sept 27, 2022 ... Printer Friendly (print) using API EXPORT ACTION, too!
        // } else {
            //$query = GetCsrfAsQuery();

            //$exportUrl = GetApiUrl(Config("API_EXPORT_ACTION") . "/" . $type . "/" . $this->TableVar, $query);
        // } // removed by UDS Hub, Sept 27, 2022 ... Printer Friendly (print) using API EXPORT ACTION, too!

		// Begin of modification, moved to Client-Side into masinoew.js file, by UDS Hub, September 27, 2022
		if ($type == "print" || $custom) { // Begin of added Printer Friendly, by UDS Hub, September 27, 2022
			$query = GetCsrfAsQuery(); // it is a global function in phpfn.php 
			$exportUrl = GetApiUrl(Config("API_EXPORT_ACTION") . "/" . $type . "/" . $this->TableVar, $query);
		} else { // else for Export other than Printer Friendly
			$exportUrl = GetApiUrl(Config("API_EXPORT_ACTION") . "/" . $type . "/" . $this->TableVar);
		}
		// End of modification, moved to Client-Side into masinoew.js file, by UDS Hub, September 27, 2022
        if (SameText($type, "excel")) {
            if ($custom) {
                return "<button type=\"button\" class=\"btn btn-default ew-export-link ew-excel\" title=\"" . HtmlEncode($Language->phrase("ExportToExcel", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToExcel", true)) . "\" form=\"fvolontairelist\" data-url=\"" . $exportUrl . "\" data-ew-action=\"export\" data-export=\"excel\" data-custom=\"true\" data-export-selected=\"true\">" . $Language->phrase("ExportToExcel") . "</button>";
            } else {
                return "<button type=\"button\" class=\"btn btn-default ew-export-link ew-excel\" title=\"" . HtmlEncode($Language->phrase("ExportToExcel", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToExcel", true)) . "\" form=\"fvolontairelist\" data-url=\"" . $exportUrl . "\" data-ew-action=\"export\" data-export=\"excel\" data-custom=\"false\" data-export-selected=\"true\">" . $Language->phrase("ExportToExcel") . "</button>";
            }
        } elseif (SameText($type, "word")) {
            if ($custom) {
                return "<button type=\"button\" class=\"btn btn-default ew-export-link ew-word\" title=\"" . HtmlEncode($Language->phrase("ExportToWord", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToWord", true)) . "\" form=\"fvolontairelist\" data-url=\"" . $exportUrl . "\" data-ew-action=\"export\" data-export=\"word\" data-custom=\"true\" data-export-selected=\"true\">" . $Language->phrase("ExportToWord") . "</button>";
            } else {
                return "<button type=\"button\" class=\"btn btn-default ew-export-link ew-word\" title=\"" . HtmlEncode($Language->phrase("ExportToWord", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToWord", true)) . "\" form=\"fvolontairelist\" data-url=\"" . $exportUrl . "\" data-ew-action=\"export\" data-export=\"word\" data-custom=\"false\" data-export-selected=\"true\">" . $Language->phrase("ExportToWord") . "</button>";
            }
        } elseif (SameText($type, "pdf")) {
            if ($custom) {
                return "<button type=\"button\" class=\"btn btn-default ew-export-link ew-pdf\" title=\"" . HtmlEncode($Language->phrase("ExportToPdf", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToPdf", true)) . "\" form=\"fvolontairelist\" data-url=\"" . $exportUrl . "\" data-ew-action=\"export\" data-export=\"pdf\" data-custom=\"true\" data-export-selected=\"true\">" . $Language->phrase("ExportToPdf") . "</button>";
            } else {
                return "<button type=\"button\" class=\"btn btn-default ew-export-link ew-pdf\" title=\"" . HtmlEncode($Language->phrase("ExportToPdf", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToPdf", true)) . "\" form=\"fvolontairelist\" data-url=\"" . $exportUrl . "\" data-ew-action=\"export\" data-export=\"pdf\" data-custom=\"false\" data-export-selected=\"true\">" . $Language->phrase("ExportToPdf") . "</button>";
            }
        } elseif (SameText($type, "html")) {
            return "<button type=\"button\" class=\"btn btn-default ew-export-link ew-html\" title=\"" . HtmlEncode($Language->phrase("ExportToHtml", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToHtml", true)) . "\" form=\"fvolontairelist\" data-url=\"" . $exportUrl . "\" data-ew-action=\"export\" data-export=\"html\" data-custom=\"false\" data-export-selected=\"true\">" . $Language->phrase("ExportToHtml") . "</button>";
        } elseif (SameText($type, "xml")) {
            return "<button type=\"button\" class=\"btn btn-default ew-export-link ew-xml\" title=\"" . HtmlEncode($Language->phrase("ExportToXml", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToXml", true)) . "\" form=\"fvolontairelist\" data-url=\"" . $exportUrl . "\" data-ew-action=\"export\" data-export=\"xml\" data-custom=\"false\" data-export-selected=\"true\">" . $Language->phrase("ExportToXml") . "</button>";
        } elseif (SameText($type, "csv")) {
            return "<button type=\"button\" class=\"btn btn-default ew-export-link ew-csv\" title=\"" . HtmlEncode($Language->phrase("ExportToCsv", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToCsv", true)) . "\" form=\"fvolontairelist\" data-url=\"" . $exportUrl . "\" data-ew-action=\"export\" data-export=\"csv\" data-custom=\"false\" data-export-selected=\"true\">" . $Language->phrase("ExportToCsv") . "</button>";
        } elseif (SameText($type, "email")) {
            $url = $custom ? ' data-url="' . $exportUrl . '"' : '';
            return '<button type="button" class="btn btn-default ew-export-link ew-email" title="' . $Language->phrase("ExportToEmail", true) . '" data-caption="' . $Language->phrase("ExportToEmail", true) . '" form="fvolontairelist" data-ew-action="email" data-custom="false" data-hdr="' . $Language->phrase("ExportToEmail", true) . '" data-exported-selected="true"' . $url . '>' . $Language->phrase("ExportToEmail") . '</button>';
        } elseif (SameText($type, "print")) {
            return "<button type=\"button\" class=\"btn btn-default ew-export-link ew-print\" title=\"" . HtmlEncode($Language->phrase("PrinterFriendly", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("PrinterFriendly", true)) . "\" form=\"fvolontairelist\" data-url=\"" . $exportUrl . "\" data-ew-action=\"export\" data-export=\"print\" data-custom=\"false\" data-export-selected=\"true\">" . $Language->phrase("PrinterFriendly") . "</button>";
        }
    }

    // Set up export options
    protected function setupExportOptions()
    {
        global $Language, $Security;

        // Printer friendly
        $item = &$this->ExportOptions->add("print");
        $item->Body = $this->getExportTag("print");
        if (MS_ENABLE_PERMISSION_FOR_EXPORT_DATA == TRUE) { // customized by UDS Hub, September 25, 2020
			$item->Visible = $Security->canExportToPrint();
		} else {
			$item->Visible = true;
		}

        // Export to Excel
        $item = &$this->ExportOptions->add("excel");
        $item->Body = $this->getExportTag("excel");
        if (MS_ENABLE_PERMISSION_FOR_EXPORT_DATA == TRUE) { // customized by UDS Hub, September 25, 2020
			$item->Visible = $Security->canExportToExcel();
		} else {
			$item->Visible = true;
		}

        // Export to Word
        $item = &$this->ExportOptions->add("word");
        $item->Body = $this->getExportTag("word");
        if (MS_ENABLE_PERMISSION_FOR_EXPORT_DATA == TRUE) { // customized by UDS Hub, September 25, 2020
			$item->Visible = $Security->canExportToWord();
		} else {
			$item->Visible = true;
		}

        // Export to HTML
        $item = &$this->ExportOptions->add("html");
        $item->Body = $this->getExportTag("html");
        if (MS_ENABLE_PERMISSION_FOR_EXPORT_DATA == TRUE) { // customized by UDS Hub, September 25, 2020
			$item->Visible = $Security->canExportToHTML();
		} else {
			$item->Visible = true;
		}

        // Export to XML
        $item = &$this->ExportOptions->add("xml");
        $item->Body = $this->getExportTag("xml");
        if (MS_ENABLE_PERMISSION_FOR_EXPORT_DATA == TRUE) { // customized by UDS Hub, September 25, 2020
			$item->Visible = $Security->canExportToXML();
		} else {
			$item->Visible = true;
		}

        // Export to CSV
        $item = &$this->ExportOptions->add("csv");
        $item->Body = $this->getExportTag("csv");
        if (MS_ENABLE_PERMISSION_FOR_EXPORT_DATA == TRUE) { // customized by UDS Hub, September 25, 2020
			$item->Visible = $Security->canExportToCSV();
		} else {
			$item->Visible = true;
		}

        // Export to PDF
        $item = &$this->ExportOptions->add("pdf");
        $item->Body = $this->getExportTag("pdf");
        if (MS_ENABLE_PERMISSION_FOR_EXPORT_DATA == TRUE) { // customized by UDS Hub, September 25, 2020
			$item->Visible = $Security->canExportToPDF();
		} else {
			$item->Visible = true;
		}

        // Export to Email
        $item = &$this->ExportOptions->add("email");
        $item->Body = $this->getExportTag("email");
        if (MS_ENABLE_PERMISSION_FOR_EXPORT_DATA == TRUE) { // customized by UDS Hub, September 25, 2020
			$item->Visible = $Security->canExportToEmail();
		} else {
			$item->Visible = true;
		}

        // Drop down button for export
        $this->ExportOptions->UseButtonGroup = true;
        $this->ExportOptions->UseDropDownButton = false;
        if ($this->ExportOptions->UseButtonGroup && IsMobile()) {
            $this->ExportOptions->UseDropDownButton = true;
        }
        $this->ExportOptions->DropDownButtonPhrase = $Language->phrase("ButtonExport");

        // Add group option item
        $item = &$this->ExportOptions->addGroupOption();
        $item->Body = "";
        $item->Visible = false;
        if (!$Security->canExport()) { // Export not allowed
            $this->ExportOptions->hideAllOptions();
        }
    }

    // Set up search options
    protected function setupSearchOptions()
    {
        global $Language, $Security;
        $pageUrl = $this->pageUrl(false);
        $this->SearchOptions = new ListOptions(["TagClassName" => "ew-search-option"]);

	    // Search button
        $item = &$this->SearchOptions->add("searchtoggle");
		if (@$_COOKIE['volontaire_searchpanel'] == 'notactive') {
			$item->Body = "<a class=\"btn btn-default ew-search-toggle\" role=\"button\" title=\"" . $Language->phrase("SearchPanel") . "\" data-caption=\"" . $Language->phrase("SearchPanel") . "\" data-ew-action=\"search-toggle\" data-form=\"fvolontairesrch\" aria-pressed=\"false\">" . $Language->phrase("SearchLink") . "</a>";
		} else {
			// $item->Body = "<a class=\"btn btn-default ew-search-toggle\" role=\"button\" title=\"" . $Language->phrase("SearchPanel") . "\" data-caption=\"" . $Language->phrase("SearchPanel") . "\" data-ew-action=\"search-toggle\" data-form=\"fvolontairesrch\" aria-pressed=\"false\">" . $Language->phrase("SearchLink") . "</a>";
			$item->Body = "<a class=\"btn btn-default ew-search-toggle active\" role=\"button\" title=\"" . $Language->phrase("SearchPanel") . "\" data-caption=\"" . $Language->phrase("SearchPanel") . "\" data-ew-action=\"search-toggle\" data-form=\"fvolontairesrch\" aria-pressed=\"true\">" . $Language->phrase("SearchLink") . "</a>";
		}
        $item->Visible = true;

        // Show all button
        $item = &$this->SearchOptions->add("showall");
        if ($this->UseCustomTemplate || !$this->UseAjaxActions) {
            $item->Body = "<a class=\"btn btn-default ew-show-all\" role=\"button\" title=\"" . $Language->phrase("ShowAll") . "\" data-caption=\"" . $Language->phrase("ShowAll") . "\" href=\"" . $pageUrl . "cmd=reset\">" . $Language->phrase("ShowAllBtn") . "</a>";
        } else {
            $item->Body = "<a class=\"btn btn-default ew-show-all\" role=\"button\" title=\"" . $Language->phrase("ShowAll") . "\" data-caption=\"" . $Language->phrase("ShowAll") . "\" data-ew-action=\"refresh\" data-url=\"" . $pageUrl . "cmd=reset\">" . $Language->phrase("ShowAllBtn") . "</a>";
        }
        $item->Visible = ($this->SearchWhere != $this->DefaultSearchWhere && $this->SearchWhere != "0=101");

        // Button group for search
        $this->SearchOptions->UseDropDownButton = false;
        $this->SearchOptions->UseButtonGroup = true;
        $this->SearchOptions->DropDownButtonPhrase = $Language->phrase("ButtonSearch");

        // Add group option item
        $item = &$this->SearchOptions->addGroupOption();
        $item->Body = "";
        $item->Visible = false;

        // Hide search options
        if ($this->isExport() || $this->CurrentAction && $this->CurrentAction != "search") {
            $this->SearchOptions->hideAllOptions();
        }
        if (!$Security->canSearch()) {
            $this->SearchOptions->hideAllOptions();
            $this->FilterOptions->hideAllOptions();
        }
    }

    // Check if any search fields
    public function hasSearchFields()
    {
        return true;
    }

    // Render search options
    protected function renderSearchOptions()
    {
        if (!$this->hasSearchFields() && $this->SearchOptions["searchtoggle"]) {
            $this->SearchOptions["searchtoggle"]->Visible = false;
        }
    }

    /**
    * Export data in HTML/CSV/Word/Excel/XML/Email/PDF format
    *
    * @param bool $return Return the data rather than output it
    * @return mixed
    */
    public function exportData($doc)
    {
        global $Language;
        $utf8 = SameText(Config("PROJECT_CHARSET"), "utf-8");

        // Load recordset
        $rs = null;
        $this->TotalRecords = $this->listRecordCount();

        // Export all
        if ($this->ExportAll) {
            if (Config("EXPORT_ALL_TIME_LIMIT") >= 0) {
                @set_time_limit(Config("EXPORT_ALL_TIME_LIMIT"));
            }
            $this->DisplayRecords = $this->TotalRecords;
            $this->StopRecord = $this->TotalRecords;
        } else { // Export one page only
            $this->setupStartRecord(); // Set up start record position
            // Set the last record to display
            if ($this->DisplayRecords <= 0) {
                $this->StopRecord = $this->TotalRecords;
            } else {
                $this->StopRecord = $this->StartRecord + $this->DisplayRecords - 1;
            }
        }
        $rs = $this->loadRecordset($this->StartRecord - 1, $this->DisplayRecords <= 0 ? $this->TotalRecords : $this->DisplayRecords);
        if (!$rs || !$doc) {
            RemoveHeader("Content-Type"); // Remove header
            RemoveHeader("Content-Disposition");
            $this->showMessage();
            return;
        }
        $this->StartRecord = 1;
        $this->StopRecord = $this->DisplayRecords <= 0 ? $this->TotalRecords : $this->DisplayRecords;

        // Call Page Exporting server event
        $doc->ExportCustom = !$this->pageExporting($doc);

        // Page header
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        $doc->Text .= $header;
        $this->exportDocument($doc, $rs, $this->StartRecord, $this->StopRecord, "");

        // Close recordset
        $rs->close();

        // Page footer
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        $doc->Text .= $footer;

        // Export header and footer
        $doc->exportHeaderAndFooter();

        // Call Page Exported server event
        $this->pageExported($doc);
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("index");
        $url = CurrentUrl();
        $url = preg_replace('/\?cmd=reset(all){0,1}$/i', '', $url); // Remove cmd=reset(all)
        $Breadcrumb->add("list", $this->TableVar, $url, "", $this->TableVar, true);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup !== null && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_Carte_No":
                    break;
                case "x_NIP":
                    break;
                case "x_Nom":
                    break;
                case "x_Sexe":
                    break;
                case "x_Lieu":
                    break;
                case "x_Unique_QR":
                    break;
                case "x_Localite":
                    break;
                case "x_EmployeeID":
                    break;
                case "x_Statut":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Set up starting record parameters
    public function setupStartRecord()
    {
        if ($this->DisplayRecords == 0) {
            return;
        }
        $pageNo = Get(Config("TABLE_PAGE_NUMBER"));
        $startRec = Get(Config("TABLE_START_REC"));
        $infiniteScroll = ConvertToBool(Param("infinitescroll"));
        if ($pageNo !== null) { // Check for "pageno" parameter first
            $pageNo = ParseInteger($pageNo);
            if (is_numeric($pageNo)) {
                $this->StartRecord = ($pageNo - 1) * $this->DisplayRecords + 1;
                if ($this->StartRecord <= 0) {
                    $this->StartRecord = 1;
                } elseif ($this->StartRecord >= (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1) {
                    $this->StartRecord = (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1;
                }
            }
        } elseif ($startRec !== null && is_numeric($startRec)) { // Check for "start" parameter
            $this->StartRecord = $startRec;
        } elseif (!$infiniteScroll) {
            $this->StartRecord = $this->getStartRecordNumber();
        }

        // Check if correct start record counter
        if (!is_numeric($this->StartRecord) || intval($this->StartRecord) <= 0) { // Avoid invalid start record counter
            $this->StartRecord = 1; // Reset start record counter
        } elseif ($this->StartRecord > $this->TotalRecords) { // Avoid starting record > total records
            $this->StartRecord = (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to last page first record
        } elseif (($this->StartRecord - 1) % $this->DisplayRecords != 0) {
            $this->StartRecord = (int)(($this->StartRecord - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to page boundary
        }
        if (!$infiniteScroll) {
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Get page count
    public function pageCount() {
        return ceil($this->TotalRecords / $this->DisplayRecords);
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == 'success') {
            //$msg = "your success message";
        } elseif ($type == 'failure') {
            //$msg = "your failure message";
        } elseif ($type == 'warning') {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }

    // ListOptions Load event
    public function listOptionsLoad()
    {
        // Example:
        //$opt = &$this->ListOptions->Add("new");
        //$opt->Header = "xxx";
        //$opt->OnLeft = true; // Link on left
        //$opt->MoveTo(0); // Move to first column
    }

    // ListOptions Rendering event
    public function listOptionsRendering()
    {
        //Container("DetailTableGrid")->DetailAdd = (...condition...); // Set to true or false conditionally
        //Container("DetailTableGrid")->DetailEdit = (...condition...); // Set to true or false conditionally
        //Container("DetailTableGrid")->DetailView = (...condition...); // Set to true or false conditionally
    }

    // ListOptions Rendered event
    public function listOptionsRendered()
    {
        // Example:
        //$this->ListOptions["new"]->Body = "xxx";
    }

    // Row Custom Action event
    public function rowCustomAction($action, $row)
    {
        // Return false to abort
        return true;
    }

    // Page Exporting event
    // $doc = export object
    public function pageExporting(&$doc)
    {
        //$doc->Text = "my header"; // Export header
        //return false; // Return false to skip default export and use Row_Export event
        return true; // Return true to use default export and skip Row_Export event
    }

    // Row Export event
    // $doc = export document object
    public function rowExport($doc, $rs)
    {
        //$doc->Text .= "my content"; // Build HTML with field value: $rs["MyField"] or $this->MyField->ViewValue
    }

    // Page Exported event
    // $doc = export document object
    public function pageExported($doc)
    {
        //$doc->Text .= "my footer"; // Export footer
        //Log($doc->Text);
    }

    // Page Importing event
    public function pageImporting(&$builder, &$options)
    {
        //var_dump($options); // Show all options for importing
        //$builder = fn($workflow) => $workflow->addStep($myStep);
        //return false; // Return false to skip import
        return true;
    }

    // Row Import event
    public function rowImport(&$row, $cnt)
    {
        //Log($cnt); // Import record count
        //var_dump($row); // Import row
        //return false; // Return false to skip import
        return true;
    }

    // Page Imported event
    public function pageImported($obj, $results)
    {
        //var_dump($obj); // Workflow result object
        //var_dump($results); // Import results
    }
}
