<?php

namespace PHPMaker2023\Jack_Jill_school;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\FetchMode;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;

/**
 * Table class for volontaire
 */
class Volontaire extends DbTable
{
    protected $SqlFrom = "";
    protected $SqlSelect = null;
    protected $SqlSelectList = null;
    protected $SqlWhere = "";
    protected $SqlGroupBy = "";
    protected $SqlHaving = "";
    protected $SqlOrderBy = "";
    public $DbErrorMessage = "";
    public $UseSessionForListSql = true;

    // Column CSS classes
    public $LeftColumnClass = "col-sm-4 col-form-label ew-label";
    public $RightColumnClass = "col-sm-8";
    public $OffsetColumnClass = "col-sm-8 offset-sm-4";
    public $TableLeftColumnClass = "w-col-4";

    // Audit trail
    public $AuditTrailOnAdd = true;
    public $AuditTrailOnEdit = true;
    public $AuditTrailOnDelete = true;
    public $AuditTrailOnView = false;
    public $AuditTrailOnViewData = false;
    public $AuditTrailOnSearch = false;

    // Ajax / Modal
    public $UseAjaxActions = true;
    public $ModalSearch = false;
    public $ModalView = true;
    public $ModalAdd = true;
    public $ModalEdit = true;
    public $ModalUpdate = true;
    public $InlineDelete = true;
    public $ModalGridAdd = false;
    public $ModalGridEdit = false;
    public $ModalMultiEdit = false;

    // Fields
    public $volontaireID;
    public $Carte_No;
    public $NIP;
    public $Nom;
    public $Prenom;
    public $Sexe;
    public $DateNaissance;
    public $Lieu;
    public $Photo;
    public $Unique_QR;
    public $Groupe_Sanguin;
    public $Delivree;
    public $Expire;
    public $Localite;
    public $Prevenir;
    public $Prevenir_Tel;
    public $Reference;
    public $EmployeeID;
    public $Statut;

    // Page ID
    public $PageID = ""; // To be overridden by subclass

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $CurrentLanguage, $CurrentLocale;

        // Language object
        $Language = Container("language");
        $this->TableVar = "volontaire";
        $this->TableName = 'volontaire';
        $this->TableType = "TABLE";
        $this->ImportUseTransaction = $this->supportsTransaction() && Config("IMPORT_USE_TRANSACTION");
        $this->UseTransaction = $this->supportsTransaction() && Config("USE_TRANSACTION");

        // Update Table
        $this->UpdateTable = "volontaire";
        $this->Dbid = 'DB';
        $this->ExportAll = false;
        $this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)

        // PDF
        $this->ExportPageOrientation = "landscape"; // Page orientation (PDF only)
        $this->ExportPageSize = "a4"; // Page size (PDF only)

        // PhpSpreadsheet
        $this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_LANDSCAPE; // Page orientation (PhpSpreadsheet only)
        $this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)

        // PHPWord
        $this->ExportWordPageOrientation = "landscape"; // Page orientation (PHPWord only)
        $this->ExportWordPageSize = "A4"; // Page orientation (PHPWord only)
        $this->ExportWordColumnWidth = null; // Cell width (PHPWord only)
        $this->DetailAdd = false; // Allow detail add
        $this->DetailEdit = false; // Allow detail edit
        $this->DetailView = false; // Allow detail view
        $this->ShowMultipleDetails = false; // Show multiple details
        $this->GridAddRowCount = 5;
        $this->AllowAddDeleteRow = true; // Allow add/delete row
        $this->UseAjaxActions = $this->UseAjaxActions || Config("USE_AJAX_ACTIONS");
        $this->UseColumnVisibility = true;
        $this->UserIDAllowSecurity = Config("DEFAULT_USER_ID_ALLOW_SECURITY"); // Default User ID allowed permissions
        $this->BasicSearch = new BasicSearch($this);

        // volontaireID
        $this->volontaireID = new DbField(
            $this, // Table
            'x_volontaireID', // Variable name
            'volontaireID', // Name
            '`volontaireID`', // Expression
            '`volontaireID`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`volontaireID`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->volontaireID->InputTextType = "text";
        $this->volontaireID->IsPrimaryKey = true; // Primary key field
        $this->volontaireID->Nullable = false; // NOT NULL field
        $this->volontaireID->Required = true; // Required field
        $this->volontaireID->Sortable = false; // Allow sort
        $this->volontaireID->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->volontaireID->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['volontaireID'] = &$this->volontaireID;

        // Carte_No
        $this->Carte_No = new DbField(
            $this, // Table
            'x_Carte_No', // Variable name
            'Carte_No', // Name
            '`Carte_No`', // Expression
            '`Carte_No`', // Basic search expression
            200, // Type
            20, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Carte_No`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->Carte_No->addMethod("getDefault", fn() => 2023-00);
        $this->Carte_No->InputTextType = "text";
        $this->Carte_No->Nullable = false; // NOT NULL field
        $this->Carte_No->Required = true; // Required field
        switch ($CurrentLanguage) {
            case "en-US":
                $this->Carte_No->Lookup = new Lookup('Carte_No', 'volontaire', true, 'Carte_No', ["Carte_No","","",""], '', '', [], [], [], [], [], [], '', '', "`Carte_No`");
                break;
            case "fr":
                $this->Carte_No->Lookup = new Lookup('Carte_No', 'volontaire', true, 'Carte_No', ["Carte_No","","",""], '', '', [], [], [], [], [], [], '', '', "`Carte_No`");
                break;
            default:
                $this->Carte_No->Lookup = new Lookup('Carte_No', 'volontaire', true, 'Carte_No', ["Carte_No","","",""], '', '', [], [], [], [], [], [], '', '', "`Carte_No`");
                break;
        }
        $this->Carte_No->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['Carte_No'] = &$this->Carte_No;

        // NIP
        $this->NIP = new DbField(
            $this, // Table
            'x_NIP', // Variable name
            'NIP', // Name
            '`NIP`', // Expression
            '`NIP`', // Basic search expression
            200, // Type
            57, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`NIP`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->NIP->InputTextType = "text";
        switch ($CurrentLanguage) {
            case "en-US":
                $this->NIP->Lookup = new Lookup('NIP', 'volontaire', true, 'NIP', ["NIP","","",""], '', '', [], [], [], [], [], [], '', '', "`NIP`");
                break;
            case "fr":
                $this->NIP->Lookup = new Lookup('NIP', 'volontaire', true, 'NIP', ["NIP","","",""], '', '', [], [], [], [], [], [], '', '', "`NIP`");
                break;
            default:
                $this->NIP->Lookup = new Lookup('NIP', 'volontaire', true, 'NIP', ["NIP","","",""], '', '', [], [], [], [], [], [], '', '', "`NIP`");
                break;
        }
        $this->NIP->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['NIP'] = &$this->NIP;

        // Nom
        $this->Nom = new DbField(
            $this, // Table
            'x_Nom', // Variable name
            'Nom', // Name
            '`Nom`', // Expression
            '`Nom`', // Basic search expression
            201, // Type
            260, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Nom`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->Nom->InputTextType = "text";
        $this->Nom->Nullable = false; // NOT NULL field
        $this->Nom->Required = true; // Required field
        switch ($CurrentLanguage) {
            case "en-US":
                $this->Nom->Lookup = new Lookup('Nom', 'volontaire', true, 'Nom', ["Nom","","",""], '', '', [], [], [], [], [], [], '', '', "`Nom`");
                break;
            case "fr":
                $this->Nom->Lookup = new Lookup('Nom', 'volontaire', true, 'Nom', ["Nom","","",""], '', '', [], [], [], [], [], [], '', '', "`Nom`");
                break;
            default:
                $this->Nom->Lookup = new Lookup('Nom', 'volontaire', true, 'Nom', ["Nom","","",""], '', '', [], [], [], [], [], [], '', '', "`Nom`");
                break;
        }
        $this->Nom->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['Nom'] = &$this->Nom;

        // Prenom
        $this->Prenom = new DbField(
            $this, // Table
            'x_Prenom', // Variable name
            'Prenom', // Name
            '`Prenom`', // Expression
            '`Prenom`', // Basic search expression
            200, // Type
            60, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Prenom`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->Prenom->InputTextType = "text";
        $this->Prenom->Nullable = false; // NOT NULL field
        $this->Prenom->Required = true; // Required field
        $this->Prenom->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['Prenom'] = &$this->Prenom;

        // Sexe
        $this->Sexe = new DbField(
            $this, // Table
            'x_Sexe', // Variable name
            'Sexe', // Name
            '`Sexe`', // Expression
            '`Sexe`', // Basic search expression
            200, // Type
            12, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Sexe`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'RADIO' // Edit Tag
        );
        $this->Sexe->InputTextType = "text";
        switch ($CurrentLanguage) {
            case "en-US":
                $this->Sexe->Lookup = new Lookup('Sexe', 'volontaire', false, '', ["","","",""], '', '', [], [], [], [], [], [], '', '', "");
                break;
            case "fr":
                $this->Sexe->Lookup = new Lookup('Sexe', 'volontaire', false, '', ["","","",""], '', '', [], [], [], [], [], [], '', '', "");
                break;
            default:
                $this->Sexe->Lookup = new Lookup('Sexe', 'volontaire', false, '', ["","","",""], '', '', [], [], [], [], [], [], '', '', "");
                break;
        }
        $this->Sexe->OptionCount = 2;
        $this->Sexe->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['Sexe'] = &$this->Sexe;

        // DateNaissance
        $this->DateNaissance = new DbField(
            $this, // Table
            'x_DateNaissance', // Variable name
            'DateNaissance', // Name
            '`DateNaissance`', // Expression
            CastDateFieldForLike("`DateNaissance`", 7, "DB"), // Basic search expression
            133, // Type
            10, // Size
            7, // Date/Time format
            false, // Is upload field
            '`DateNaissance`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->DateNaissance->InputTextType = "text";
        $this->DateNaissance->DefaultErrorMessage = str_replace("%s", DateFormat(7), $Language->phrase("IncorrectDate"));
        $this->DateNaissance->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['DateNaissance'] = &$this->DateNaissance;

        // Lieu
        $this->Lieu = new DbField(
            $this, // Table
            'x_Lieu', // Variable name
            'Lieu', // Name
            '`Lieu`', // Expression
            '`Lieu`', // Basic search expression
            200, // Type
            50, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Lieu`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->Lieu->InputTextType = "text";
        $this->Lieu->Nullable = false; // NOT NULL field
        $this->Lieu->Required = true; // Required field
        switch ($CurrentLanguage) {
            case "en-US":
                $this->Lieu->Lookup = new Lookup('Lieu', 'volontaire', true, 'Lieu', ["Lieu","","",""], '', '', [], [], [], [], [], [], '', '', "`Lieu`");
                break;
            case "fr":
                $this->Lieu->Lookup = new Lookup('Lieu', 'volontaire', true, 'Lieu', ["Lieu","","",""], '', '', [], [], [], [], [], [], '', '', "`Lieu`");
                break;
            default:
                $this->Lieu->Lookup = new Lookup('Lieu', 'volontaire', true, 'Lieu', ["Lieu","","",""], '', '', [], [], [], [], [], [], '', '', "`Lieu`");
                break;
        }
        $this->Lieu->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['Lieu'] = &$this->Lieu;

        // Photo
        $this->Photo = new DbField(
            $this, // Table
            'x_Photo', // Variable name
            'Photo', // Name
            '`Photo`', // Expression
            '`Photo`', // Basic search expression
            200, // Type
            60, // Size
            -1, // Date/Time format
            true, // Is upload field
            '`Photo`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'IMAGE', // View Tag
            'FILE' // Edit Tag
        );
        $this->Photo->addMethod("getUploadPath", fn() => "upload/volontaire/");
        $this->Photo->InputTextType = "text";
        $this->Photo->Required = true; // Required field
        $this->Photo->ImageResize = true;
        $this->Photo->SearchOperators = ["=", "<>", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['Photo'] = &$this->Photo;

        // Unique_QR
        $this->Unique_QR = new DbField(
            $this, // Table
            'x_Unique_QR', // Variable name
            'Unique_QR', // Name
            '`Unique_QR`', // Expression
            '`Unique_QR`', // Basic search expression
            200, // Type
            12, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Unique_QR`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'IMAGE', // View Tag
            'TEXT' // Edit Tag
        );
        $this->Unique_QR->InputTextType = "text";
        $this->Unique_QR->Required = true; // Required field
        switch ($CurrentLanguage) {
            case "en-US":
                $this->Unique_QR->Lookup = new Lookup('Unique_QR', 'volontaire', true, 'Unique_QR', ["Unique_QR","","",""], '', '', [], [], [], [], [], [], '', '', "`Unique_QR`");
                break;
            case "fr":
                $this->Unique_QR->Lookup = new Lookup('Unique_QR', 'volontaire', true, 'Unique_QR', ["Unique_QR","","",""], '', '', [], [], [], [], [], [], '', '', "`Unique_QR`");
                break;
            default:
                $this->Unique_QR->Lookup = new Lookup('Unique_QR', 'volontaire', true, 'Unique_QR', ["Unique_QR","","",""], '', '', [], [], [], [], [], [], '', '', "`Unique_QR`");
                break;
        }
        $this->Unique_QR->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['Unique_QR'] = &$this->Unique_QR;

        // Groupe_Sanguin
        $this->Groupe_Sanguin = new DbField(
            $this, // Table
            'x_Groupe_Sanguin', // Variable name
            'Groupe_Sanguin', // Name
            '`Groupe_Sanguin`', // Expression
            '`Groupe_Sanguin`', // Basic search expression
            200, // Type
            23, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Groupe_Sanguin`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->Groupe_Sanguin->InputTextType = "text";
        $this->Groupe_Sanguin->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['Groupe_Sanguin'] = &$this->Groupe_Sanguin;

        // Delivree
        $this->Delivree = new DbField(
            $this, // Table
            'x_Delivree', // Variable name
            'Delivree', // Name
            '`Delivree`', // Expression
            CastDateFieldForLike("`Delivree`", 7, "DB"), // Basic search expression
            133, // Type
            10, // Size
            7, // Date/Time format
            false, // Is upload field
            '`Delivree`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->Delivree->InputTextType = "text";
        $this->Delivree->DefaultErrorMessage = str_replace("%s", DateFormat(7), $Language->phrase("IncorrectDate"));
        $this->Delivree->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['Delivree'] = &$this->Delivree;

        // Expire
        $this->Expire = new DbField(
            $this, // Table
            'x_Expire', // Variable name
            'Expire', // Name
            '`Expire`', // Expression
            CastDateFieldForLike("`Expire`", 7, "DB"), // Basic search expression
            133, // Type
            10, // Size
            7, // Date/Time format
            false, // Is upload field
            '`Expire`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->Expire->InputTextType = "text";
        $this->Expire->DefaultErrorMessage = str_replace("%s", DateFormat(7), $Language->phrase("IncorrectDate"));
        $this->Expire->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['Expire'] = &$this->Expire;

        // Localite
        $this->Localite = new DbField(
            $this, // Table
            'x_Localite', // Variable name
            'Localite', // Name
            '`Localite`', // Expression
            '`Localite`', // Basic search expression
            200, // Type
            60, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Localite`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->Localite->InputTextType = "text";
        $this->Localite->Nullable = false; // NOT NULL field
        $this->Localite->Required = true; // Required field
        switch ($CurrentLanguage) {
            case "en-US":
                $this->Localite->Lookup = new Lookup('Localite', 'volontaire', true, 'Localite', ["Localite","","",""], '', '', [], [], [], [], [], [], '', '', "`Localite`");
                break;
            case "fr":
                $this->Localite->Lookup = new Lookup('Localite', 'volontaire', true, 'Localite', ["Localite","","",""], '', '', [], [], [], [], [], [], '', '', "`Localite`");
                break;
            default:
                $this->Localite->Lookup = new Lookup('Localite', 'volontaire', true, 'Localite', ["Localite","","",""], '', '', [], [], [], [], [], [], '', '', "`Localite`");
                break;
        }
        $this->Localite->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['Localite'] = &$this->Localite;

        // Prevenir
        $this->Prevenir = new DbField(
            $this, // Table
            'x_Prevenir', // Variable name
            'Prevenir', // Name
            '`Prevenir`', // Expression
            '`Prevenir`', // Basic search expression
            200, // Type
            70, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Prevenir`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->Prevenir->InputTextType = "text";
        $this->Prevenir->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['Prevenir'] = &$this->Prevenir;

        // Prevenir_Tel
        $this->Prevenir_Tel = new DbField(
            $this, // Table
            'x_Prevenir_Tel', // Variable name
            'Prevenir_Tel', // Name
            '`Prevenir_Tel`', // Expression
            '`Prevenir_Tel`', // Basic search expression
            200, // Type
            25, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Prevenir_Tel`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->Prevenir_Tel->InputTextType = "text";
        $this->Prevenir_Tel->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['Prevenir_Tel'] = &$this->Prevenir_Tel;

        // Reference
        $this->Reference = new DbField(
            $this, // Table
            'x_Reference', // Variable name
            'Reference', // Name
            '`Reference`', // Expression
            '`Reference`', // Basic search expression
            200, // Type
            100, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Reference`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->Reference->InputTextType = "text";
        $this->Reference->Nullable = false; // NOT NULL field
        $this->Reference->Required = true; // Required field
        $this->Reference->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['Reference'] = &$this->Reference;

        // EmployeeID
        $this->EmployeeID = new DbField(
            $this, // Table
            'x_EmployeeID', // Variable name
            'EmployeeID', // Name
            '`EmployeeID`', // Expression
            '`EmployeeID`', // Basic search expression
            16, // Type
            4, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`EmployeeID`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->EmployeeID->InputTextType = "text";
        $this->EmployeeID->Sortable = false; // Allow sort
        $this->EmployeeID->setSelectMultiple(false); // Select one
        $this->EmployeeID->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->EmployeeID->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        switch ($CurrentLanguage) {
            case "en-US":
                $this->EmployeeID->Lookup = new Lookup('EmployeeID', 'employees', false, 'EmployeeID', ["LastName","FirstName","",""], '', '', [], [], [], [], [], [], '', '', "CONCAT(COALESCE(`LastName`, ''),'" . ValueSeparator(1, $this->EmployeeID) . "',COALESCE(`FirstName`,''))");
                break;
            case "fr":
                $this->EmployeeID->Lookup = new Lookup('EmployeeID', 'employees', false, 'EmployeeID', ["LastName","FirstName","",""], '', '', [], [], [], [], [], [], '', '', "CONCAT(COALESCE(`LastName`, ''),'" . ValueSeparator(1, $this->EmployeeID) . "',COALESCE(`FirstName`,''))");
                break;
            default:
                $this->EmployeeID->Lookup = new Lookup('EmployeeID', 'employees', false, 'EmployeeID', ["LastName","FirstName","",""], '', '', [], [], [], [], [], [], '', '', "CONCAT(COALESCE(`LastName`, ''),'" . ValueSeparator(1, $this->EmployeeID) . "',COALESCE(`FirstName`,''))");
                break;
        }
        $this->EmployeeID->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->EmployeeID->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['EmployeeID'] = &$this->EmployeeID;

        // Statut
        $this->Statut = new DbField(
            $this, // Table
            'x_Statut', // Variable name
            'Statut', // Name
            '`Statut`', // Expression
            '`Statut`', // Basic search expression
            200, // Type
            50, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Statut`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->Statut->InputTextType = "text";
        $this->Statut->setSelectMultiple(false); // Select one
        $this->Statut->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->Statut->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        switch ($CurrentLanguage) {
            case "en-US":
                $this->Statut->Lookup = new Lookup('Statut', 'volontaire', false, '', ["","","",""], '', '', [], [], [], [], [], [], '', '', "");
                break;
            case "fr":
                $this->Statut->Lookup = new Lookup('Statut', 'volontaire', false, '', ["","","",""], '', '', [], [], [], [], [], [], '', '', "");
                break;
            default:
                $this->Statut->Lookup = new Lookup('Statut', 'volontaire', false, '', ["","","",""], '', '', [], [], [], [], [], [], '', '', "");
                break;
        }
        $this->Statut->OptionCount = 5;
        $this->Statut->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['Statut'] = &$this->Statut;

        // Add Doctrine Cache
        $this->Cache = new ArrayCache();
        $this->CacheProfile = new \Doctrine\DBAL\Cache\QueryCacheProfile(0, $this->TableVar);

        // Call Table Load event
        $this->tableLoad();
    }

    // Field Visibility
    public function getFieldVisibility($fldParm)
    {
        global $Security;
        return $this->$fldParm->Visible; // Returns original value
    }

    // Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
    public function setLeftColumnClass($class)
    {
        if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
            $this->LeftColumnClass = $class . " col-form-label ew-label";
            $this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
            $this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
            $this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
        }
    }

    // Single column sort
    public function updateSort(&$fld)
    {
        if ($this->CurrentOrder == $fld->Name) {
            $sortField = $fld->Expression;
            $lastSort = $fld->getSort();
            if (in_array($this->CurrentOrderType, ["ASC", "DESC", "NO"])) {
                $curSort = $this->CurrentOrderType;
            } else {
                $curSort = $lastSort;
            }
            $orderBy = in_array($curSort, ["ASC", "DESC"]) ? $sortField . " " . $curSort : "";
            $this->setSessionOrderBy($orderBy); // Save to Session
        }
    }

    // Update field sort
    public function updateFieldSort()
    {
        $orderBy = $this->getSessionOrderBy(); // Get ORDER BY from Session
        $flds = GetSortFields($orderBy);
        foreach ($this->Fields as $field) {
            $fldSort = "";
            foreach ($flds as $fld) {
                if ($fld[0] == $field->Expression || $fld[0] == $field->VirtualExpression) {
                    $fldSort = $fld[1];
                }
            }
            $field->setSort($fldSort);
        }
    }

    // Render X Axis for chart
    public function renderChartXAxis($chartVar, $chartRow)
    {
        return $chartRow;
    }

    // Table level SQL
    public function getSqlFrom() // From
    {
        return ($this->SqlFrom != "") ? $this->SqlFrom : "volontaire";
    }

    public function sqlFrom() // For backward compatibility
    {
        return $this->getSqlFrom();
    }

    public function setSqlFrom($v)
    {
        $this->SqlFrom = $v;
    }

    public function getSqlSelect() // Select
    {
        return $this->SqlSelect ?? $this->getQueryBuilder()->select("*");
    }

    public function sqlSelect() // For backward compatibility
    {
        return $this->getSqlSelect();
    }

    public function setSqlSelect($v)
    {
        $this->SqlSelect = $v;
    }

    public function getSqlWhere() // Where
    {
        $where = ($this->SqlWhere != "") ? $this->SqlWhere : "";
        $this->DefaultFilter = "";
        AddFilter($where, $this->DefaultFilter);
        return $where;
    }

    public function sqlWhere() // For backward compatibility
    {
        return $this->getSqlWhere();
    }

    public function setSqlWhere($v)
    {
        $this->SqlWhere = $v;
    }

    public function getSqlGroupBy() // Group By
    {
        return ($this->SqlGroupBy != "") ? $this->SqlGroupBy : "";
    }

    public function sqlGroupBy() // For backward compatibility
    {
        return $this->getSqlGroupBy();
    }

    public function setSqlGroupBy($v)
    {
        $this->SqlGroupBy = $v;
    }

    public function getSqlHaving() // Having
    {
        return ($this->SqlHaving != "") ? $this->SqlHaving : "";
    }

    public function sqlHaving() // For backward compatibility
    {
        return $this->getSqlHaving();
    }

    public function setSqlHaving($v)
    {
        $this->SqlHaving = $v;
    }

    public function getSqlOrderBy() // Order By
    {
        return ($this->SqlOrderBy != "") ? $this->SqlOrderBy : "";
    }

    public function sqlOrderBy() // For backward compatibility
    {
        return $this->getSqlOrderBy();
    }

    public function setSqlOrderBy($v)
    {
        $this->SqlOrderBy = $v;
    }

    // Apply User ID filters
    public function applyUserIDFilters($filter, $id = "")
    {
        return $filter;
    }

    // Check if User ID security allows view all
    public function userIDAllow($id = "")
    {
        $allow = $this->UserIDAllowSecurity;
        switch ($id) {
            case "add":
            case "copy":
            case "gridadd":
            case "register":
            case "addopt":
                return (($allow & 1) == 1);
            case "edit":
            case "gridedit":
            case "update":
            case "changepassword":
            case "resetpassword":
                return (($allow & 4) == 4);
            case "delete":
                return (($allow & 2) == 2);
            case "view":
                return (($allow & 32) == 32);
            case "search":
                return (($allow & 64) == 64);
            case "lookup":
                return (($allow & 256) == 256);
            default:
                return (($allow & 8) == 8);
        }
    }

    /**
     * Get record count
     *
     * @param string|QueryBuilder $sql SQL or QueryBuilder
     * @param mixed $c Connection
     * @return int
     */
    public function getRecordCount($sql, $c = null)
    {
        $cnt = -1;
        $rs = null;
        if ($sql instanceof QueryBuilder) { // Query builder
            $sqlwrk = clone $sql;
            $sqlwrk = $sqlwrk->resetQueryPart("orderBy")->getSQL();
        } else {
            $sqlwrk = $sql;
        }
        $pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';
        // Skip Custom View / SubQuery / SELECT DISTINCT / ORDER BY
        if (
            ($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
            preg_match($pattern, $sqlwrk) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sqlwrk) &&
            !preg_match('/^\s*select\s+distinct\s+/i', $sqlwrk) && !preg_match('/\s+order\s+by\s+/i', $sqlwrk)
        ) {
            $sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sqlwrk);
        } else {
            $sqlwrk = "SELECT COUNT(*) FROM (" . $sqlwrk . ") COUNT_TABLE";
        }
        $conn = $c ?? $this->getConnection();
        $cnt = $conn->fetchOne($sqlwrk);
        if ($cnt !== false) {
            return (int)$cnt;
        }

        // Unable to get count by SELECT COUNT(*), execute the SQL to get record count directly
        return ExecuteRecordCount($sql, $conn);
    }

    // Get SQL
    public function getSql($where, $orderBy = "")
    {
        return $this->getSqlAsQueryBuilder($where, $orderBy)->getSQL();
    }

    // Get QueryBuilder
    public function getSqlAsQueryBuilder($where, $orderBy = "")
    {
        return $this->buildSelectSql(
            $this->getSqlSelect(),
            $this->getSqlFrom(),
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $where,
            $orderBy
        );
    }

    // Table SQL
    public function getCurrentSql()
    {
        $filter = $this->CurrentFilter;
        $filter = $this->applyUserIDFilters($filter);
        $sort = $this->getSessionOrderBy();
        return $this->getSql($filter, $sort);
    }

    /**
     * Table SQL with List page filter
     *
     * @return QueryBuilder
     */
    public function getListSql()
    {
        $filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $select = $this->getSqlSelect();
        $from = $this->getSqlFrom();
        $sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
        $this->Sort = $sort;
        return $this->buildSelectSql(
            $select,
            $from,
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $filter,
            $sort
        );
    }

    // Get ORDER BY clause
    public function getOrderBy()
    {
        $orderBy = $this->getSqlOrderBy();
        $sort = $this->getSessionOrderBy();
        if ($orderBy != "" && $sort != "") {
            $orderBy .= ", " . $sort;
        } elseif ($sort != "") {
            $orderBy = $sort;
        }
        return $orderBy;
    }

    // Get record count based on filter (for detail record count in master table pages)
    public function loadRecordCount($filter)
    {
        $origFilter = $this->CurrentFilter;
        $this->CurrentFilter = $filter;
        $this->recordsetSelecting($this->CurrentFilter);
        $select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
        $having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
        $cnt = $this->getRecordCount($sql);
        $this->CurrentFilter = $origFilter;
        return $cnt;
    }

    // Get record count (for current List page)
    public function listRecordCount()
    {
        $filter = $this->getSessionWhere();
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
        $having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
        $cnt = $this->getRecordCount($sql);
        return $cnt;
    }

    /**
     * INSERT statement
     *
     * @param mixed $rs
     * @return QueryBuilder
     */
    public function insertSql(&$rs)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->insert($this->UpdateTable);
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom) {
                continue;
            }
            $type = GetParameterType($this->Fields[$name], $value, $this->Dbid);
            $queryBuilder->setValue($this->Fields[$name]->Expression, $queryBuilder->createPositionalParameter($value, $type));
        }
        return $queryBuilder;
    }

    // Insert
    public function insert(&$rs)
    {
        $conn = $this->getConnection();
        try {
            $success = $this->insertSql($rs)->execute();
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $success = false;
            $this->DbErrorMessage = $e->getMessage();
        }
        if ($success) {
            if ($this->AuditTrailOnAdd) {
                $this->writeAuditTrailOnAdd($rs);
            }
        }
        return $success;
    }

    /**
     * UPDATE statement
     *
     * @param array $rs Data to be updated
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function updateSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->update($this->UpdateTable);
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom || $this->Fields[$name]->IsAutoIncrement) {
                continue;
            }
            $type = GetParameterType($this->Fields[$name], $value, $this->Dbid);
            $queryBuilder->set($this->Fields[$name]->Expression, $queryBuilder->createPositionalParameter($value, $type));
        }
        $filter = ($curfilter) ? $this->CurrentFilter : "";
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        AddFilter($filter, $where);
        if ($filter != "") {
            $queryBuilder->where($filter);
        }
        return $queryBuilder;
    }

    // Update
    public function update(&$rs, $where = "", $rsold = null, $curfilter = true)
    {
        // If no field is updated, execute may return 0. Treat as success
        try {
            $success = $this->updateSql($rs, $where, $curfilter)->execute();
            $success = ($success > 0) ? $success : true;
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $success = false;
            $this->DbErrorMessage = $e->getMessage();
        }
        if ($success && $this->AuditTrailOnEdit && $rsold) {
            $rsaudit = $rs;
            $fldname = 'volontaireID';
            if (!array_key_exists($fldname, $rsaudit)) {
                $rsaudit[$fldname] = $rsold[$fldname];
            }
            $this->writeAuditTrailOnEdit($rsold, $rsaudit);
        }
        return $success;
    }

    /**
     * DELETE statement
     *
     * @param array $rs Key values
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function deleteSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->delete($this->UpdateTable);
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        if ($rs) {
            if (array_key_exists('volontaireID', $rs)) {
                AddFilter($where, QuotedName('volontaireID', $this->Dbid) . '=' . QuotedValue($rs['volontaireID'], $this->volontaireID->DataType, $this->Dbid));
            }
        }
        $filter = ($curfilter) ? $this->CurrentFilter : "";
        AddFilter($filter, $where);
        return $queryBuilder->where($filter != "" ? $filter : "0=1");
    }

    // Delete
    public function delete(&$rs, $where = "", $curfilter = false)
    {
        $success = true;
        if ($success) {
            try {
                $success = $this->deleteSql($rs, $where, $curfilter)->execute();
                $this->DbErrorMessage = "";
            } catch (\Exception $e) {
                $success = false;
                $this->DbErrorMessage = $e->getMessage();
            }
        }
        if ($success && $this->AuditTrailOnDelete) {
            $this->writeAuditTrailOnDelete($rs);
        }
        return $success;
    }

    // Load DbValue from recordset or array
    protected function loadDbValues($row)
    {
        if (!is_array($row)) {
            return;
        }
        $this->volontaireID->DbValue = $row['volontaireID'];
        $this->Carte_No->DbValue = $row['Carte_No'];
        $this->NIP->DbValue = $row['NIP'];
        $this->Nom->DbValue = $row['Nom'];
        $this->Prenom->DbValue = $row['Prenom'];
        $this->Sexe->DbValue = $row['Sexe'];
        $this->DateNaissance->DbValue = $row['DateNaissance'];
        $this->Lieu->DbValue = $row['Lieu'];
        $this->Photo->Upload->DbValue = $row['Photo'];
        $this->Unique_QR->DbValue = $row['Unique_QR'];
        $this->Groupe_Sanguin->DbValue = $row['Groupe_Sanguin'];
        $this->Delivree->DbValue = $row['Delivree'];
        $this->Expire->DbValue = $row['Expire'];
        $this->Localite->DbValue = $row['Localite'];
        $this->Prevenir->DbValue = $row['Prevenir'];
        $this->Prevenir_Tel->DbValue = $row['Prevenir_Tel'];
        $this->Reference->DbValue = $row['Reference'];
        $this->EmployeeID->DbValue = $row['EmployeeID'];
        $this->Statut->DbValue = $row['Statut'];
    }

    // Delete uploaded files
    public function deleteUploadedFiles($row)
    {
        $this->loadDbValues($row);
        $this->Photo->OldUploadPath = $this->Photo->getUploadPath(); // PHP
        $oldFiles = EmptyValue($row['Photo']) ? [] : [$row['Photo']];
        foreach ($oldFiles as $oldFile) {
            if (file_exists($this->Photo->oldPhysicalUploadPath() . $oldFile)) {
                @unlink($this->Photo->oldPhysicalUploadPath() . $oldFile);
            }
        }
    }

    // Record filter WHERE clause
    protected function sqlKeyFilter()
    {
        return "`volontaireID` = @volontaireID@";
    }

    // Get Key
    public function getKey($current = false)
    {
        $keys = [];
        $val = $current ? $this->volontaireID->CurrentValue : $this->volontaireID->OldValue;
        if (EmptyValue($val)) {
            return "";
        } else {
            $keys[] = $val;
        }
        return implode(Config("COMPOSITE_KEY_SEPARATOR"), $keys);
    }

    // Set Key
    public function setKey($key, $current = false)
    {
        $this->OldKey = strval($key);
        $keys = explode(Config("COMPOSITE_KEY_SEPARATOR"), $this->OldKey);
        if (count($keys) == 1) {
            if ($current) {
                $this->volontaireID->CurrentValue = $keys[0];
            } else {
                $this->volontaireID->OldValue = $keys[0];
            }
        }
    }

    // Get record filter
    public function getRecordFilter($row = null, $current = false)
    {
        $keyFilter = $this->sqlKeyFilter();
        if (is_array($row)) {
            $val = array_key_exists('volontaireID', $row) ? $row['volontaireID'] : null;
        } else {
            $val = !EmptyValue($this->volontaireID->OldValue) && !$current ? $this->volontaireID->OldValue : $this->volontaireID->CurrentValue;
        }
        if (!is_numeric($val)) {
            return "0=1"; // Invalid key
        }
        if ($val === null) {
            return "0=1"; // Invalid key
        } else {
            $keyFilter = str_replace("@volontaireID@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
        }
        return $keyFilter;
    }

    // Return page URL
    public function getReturnUrl()
    {
        $referUrl = ReferUrl();
        $referPageName = ReferPageName();
        $name = PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL");
        // Get referer URL automatically
        if ($referUrl != "" && $referPageName != CurrentPageName() && $referPageName != "login") { // Referer not same page or login page
            $_SESSION[$name] = $referUrl; // Save to Session
        }
        return $_SESSION[$name] ?? GetUrl("volontairelist");
    }

    // Set return page URL
    public function setReturnUrl($v)
    {
        $_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL")] = $v;
    }

    // Get modal caption
    public function getModalCaption($pageName)
    {
        global $Language;
        if ($pageName == "volontaireview") {
            return $Language->phrase("View");
        } elseif ($pageName == "volontaireedit") {
            return $Language->phrase("Edit");
        } elseif ($pageName == "volontaireadd") {
            return $Language->phrase("Add");
        }
        return "";
    }

    // API page name
    public function getApiPageName($action)
    {
        switch (strtolower($action)) {
            case Config("API_VIEW_ACTION"):
                return "VolontaireView";
            case Config("API_ADD_ACTION"):
                return "VolontaireAdd";
            case Config("API_EDIT_ACTION"):
                return "VolontaireEdit";
            case Config("API_DELETE_ACTION"):
                return "VolontaireDelete";
            case Config("API_LIST_ACTION"):
                return "VolontaireList";
            default:
                return "";
        }
    }

    // Current URL
    public function getCurrentUrl($parm = "")
    {
        $url = CurrentPageUrl(false);
        if ($parm != "") {
            $url = $this->keyUrl($url, $parm);
        } else {
            $url = $this->keyUrl($url, Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // List URL
    public function getListUrl()
    {
        return "volontairelist";
    }

    // View URL
    public function getViewUrl($parm = "")
    {
        if ($parm != "") {
            $url = $this->keyUrl("volontaireview", $parm);
        } else {
            $url = $this->keyUrl("volontaireview", Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // Add URL
    public function getAddUrl($parm = "")
    {
        if ($parm != "") {
            $url = "volontaireadd?" . $parm;
        } else {
            $url = "volontaireadd";
        }
        return $this->addMasterUrl($url);
    }

    // Edit URL
    public function getEditUrl($parm = "")
    {
        $url = $this->keyUrl("volontaireedit", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline edit URL
    public function getInlineEditUrl()
    {
        $url = $this->keyUrl("volontairelist", "action=edit");
        return $this->addMasterUrl($url);
    }

    // Copy URL
    public function getCopyUrl($parm = "")
    {
        $url = $this->keyUrl("volontaireadd", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline copy URL
    public function getInlineCopyUrl()
    {
        $url = $this->keyUrl("volontairelist", "action=copy");
        return $this->addMasterUrl($url);
    }

    // Delete URL
    public function getDeleteUrl()
    {
        if ($this->UseAjaxActions && ConvertToBool(Param("infinitescroll")) && CurrentPageID() == "list") {
            return $this->keyUrl(GetApiUrl(Config("API_DELETE_ACTION") . "/" . $this->TableVar));
        } else {
            return $this->keyUrl("volontairedelete");
        }
    }

    // Add master url
    public function addMasterUrl($url)
    {
        return $url;
    }

    public function keyToJson($htmlEncode = false)
    {
        $json = "";
        $json .= "\"volontaireID\":" . JsonEncode($this->volontaireID->CurrentValue, "number");
        $json = "{" . $json . "}";
        if ($htmlEncode) {
            $json = HtmlEncode($json);
        }
        return $json;
    }

    // Add key value to URL
    public function keyUrl($url, $parm = "")
    {
        if ($this->volontaireID->CurrentValue !== null) {
            $url .= "/" . $this->encodeKeyValue($this->volontaireID->CurrentValue);
        } else {
            return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
        }
        if ($parm != "") {
            $url .= "?" . $parm;
        }
        return $url;
    }

    // Render sort
    public function renderFieldHeader($fld)
    {
        global $Security, $Language, $Page;
        $sortUrl = "";
        $attrs = "";
        if ($fld->Sortable) {
            $sortUrl = $this->sortUrl($fld);
            $attrs = ' role="button" data-ew-action="sort" data-ajax="' . ($this->UseAjaxActions ? "true" : "false") . '" data-sort-url="' . $sortUrl . '" data-sort-type="1"';
            if ($this->ContextClass) { // Add context
                $attrs .= ' data-context="' . HtmlEncode($this->ContextClass) . '"';
            }
        }
        $html = '<div class="ew-table-header-caption"' . $attrs . '>' . $fld->caption() . '</div>';
        if ($sortUrl) {
            $html .= '<div class="ew-table-header-sort">' . $fld->getSortIcon() . '</div>';
        }
        if ($fld->UseFilter && $Security->canSearch()) {
            $html .= '<div class="ew-filter-dropdown-btn" data-ew-action="filter" data-table="' . $fld->TableVar . '" data-field="' . $fld->FieldVar .
                '"><div class="ew-table-header-filter" role="button" aria-haspopup="true">' . $Language->phrase("Filter") . '</div></div>';
        }
        $html = '<div class="ew-table-header-btn">' . $html . '</div>';
        if ($this->UseCustomTemplate) {
            $scriptId = str_replace("{id}", $fld->TableVar . "_" . $fld->Param, "tpc_{id}");
            $html = '<template id="' . $scriptId . '">' . $html . '</template>';
        }
        return $html;
    }

    // Sort URL
    public function sortUrl($fld)
    {
        global $DashboardReport;
        if (
            $this->CurrentAction || $this->isExport() ||
            in_array($fld->Type, [128, 204, 205])
        ) { // Unsortable data type
                return "";
        } elseif ($fld->Sortable) {
            $urlParm = "order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->getNextSort();
            if ($DashboardReport) {
                $urlParm .= "&amp;dashboard=true";
            }
            return $this->addMasterUrl($this->CurrentPageName . "?" . $urlParm);
        } else {
            return "";
        }
    }

    // Get record keys from Post/Get/Session
    public function getRecordKeys()
    {
        $arKeys = [];
        $arKey = [];
        if (Param("key_m") !== null) {
            $arKeys = Param("key_m");
            $cnt = count($arKeys);
        } else {
            if (($keyValue = Param("volontaireID") ?? Route("volontaireID")) !== null) {
                $arKeys[] = $keyValue;
            } elseif (IsApi() && (($keyValue = Key(0) ?? Route(2)) !== null)) {
                $arKeys[] = $keyValue;
            } else {
                $arKeys = null; // Do not setup
            }

            //return $arKeys; // Do not return yet, so the values will also be checked by the following code
        }
        // Check keys
        $ar = [];
        if (is_array($arKeys)) {
            foreach ($arKeys as $key) {
                if (!is_numeric($key)) {
                    continue;
                }
                $ar[] = $key;
            }
        }
        return $ar;
    }

    // Get filter from records
    public function getFilterFromRecords($rows)
    {
        $keyFilter = "";
        foreach ($rows as $row) {
            if ($keyFilter != "") {
                $keyFilter .= " OR ";
            }
            $keyFilter .= "(" . $this->getRecordFilter($row) . ")";
        }
        return $keyFilter;
    }

    // Get filter from record keys
    public function getFilterFromRecordKeys($setCurrent = true)
    {
        $arKeys = $this->getRecordKeys();
        $keyFilter = "";
        foreach ($arKeys as $key) {
            if ($keyFilter != "") {
                $keyFilter .= " OR ";
            }
            if ($setCurrent) {
                $this->volontaireID->CurrentValue = $key;
            } else {
                $this->volontaireID->OldValue = $key;
            }
            $keyFilter .= "(" . $this->getRecordFilter() . ")";
        }
        return $keyFilter;
    }

    // Load recordset based on filter / sort
    public function loadRs($filter, $sort = "")
    {
        $sql = $this->getSql($filter, $sort); // Set up filter (WHERE Clause) / sort (ORDER BY Clause)
        $conn = $this->getConnection();
        return $conn->executeQuery($sql);
    }

    // Load row values from record
    public function loadListRowValues(&$rs)
    {
        if (is_array($rs)) {
            $row = $rs;
        } elseif ($rs && property_exists($rs, "fields")) { // Recordset
            $row = $rs->fields;
        } else {
            return;
        }
        $this->volontaireID->setDbValue($row['volontaireID']);
        $this->Carte_No->setDbValue($row['Carte_No']);
        $this->NIP->setDbValue($row['NIP']);
        $this->Nom->setDbValue($row['Nom']);
        $this->Prenom->setDbValue($row['Prenom']);
        $this->Sexe->setDbValue($row['Sexe']);
        $this->DateNaissance->setDbValue($row['DateNaissance']);
        $this->Lieu->setDbValue($row['Lieu']);
        $this->Photo->Upload->DbValue = $row['Photo'];
        $this->Unique_QR->setDbValue($row['Unique_QR']);
        $this->Groupe_Sanguin->setDbValue($row['Groupe_Sanguin']);
        $this->Delivree->setDbValue($row['Delivree']);
        $this->Expire->setDbValue($row['Expire']);
        $this->Localite->setDbValue($row['Localite']);
        $this->Prevenir->setDbValue($row['Prevenir']);
        $this->Prevenir_Tel->setDbValue($row['Prevenir_Tel']);
        $this->Reference->setDbValue($row['Reference']);
        $this->EmployeeID->setDbValue($row['EmployeeID']);
        $this->Statut->setDbValue($row['Statut']);
    }

    // Render list content
    public function renderListContent($filter)
    {
        global $Response;
        $listPage = "VolontaireList";
        $listClass = PROJECT_NAMESPACE . $listPage;
        $page = new $listClass();
        $page->loadRecordsetFromFilter($filter);
        $view = Container("view");
        $template = $listPage . ".php"; // View
        $GLOBALS["Title"] ??= $page->Title; // Title
        try {
            $Response = $view->render($Response, $template, $GLOBALS);
        } finally {
            $page->terminate(); // Terminate page and clean up
        }
    }

    // Render list row values
    public function renderListRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // Common render codes

        // volontaireID
        $this->volontaireID->CellCssStyle = "white-space: nowrap;";

        // Carte_No

        // NIP

        // Nom

        // Prenom

        // Sexe

        // DateNaissance

        // Lieu

        // Photo

        // Unique_QR

        // Groupe_Sanguin

        // Delivree
        $this->Delivree->CellCssStyle = "white-space: nowrap;";

        // Expire
        $this->Expire->CellCssStyle = "white-space: nowrap;";

        // Localite

        // Prevenir

        // Prevenir_Tel

        // Reference

        // EmployeeID
        $this->EmployeeID->CellCssStyle = "white-space: nowrap;";

        // Statut

        // volontaireID
        $this->volontaireID->ViewValue = $this->volontaireID->CurrentValue;

        // Carte_No
        $this->Carte_No->ViewValue = $this->Carte_No->CurrentValue;

        // NIP
        $this->NIP->ViewValue = $this->NIP->CurrentValue;

        // Nom
        $this->Nom->ViewValue = $this->Nom->CurrentValue;

        // Prenom
        $this->Prenom->ViewValue = $this->Prenom->CurrentValue;

        // Sexe
        if (strval($this->Sexe->CurrentValue) != "") {
            $this->Sexe->ViewValue = $this->Sexe->optionCaption($this->Sexe->CurrentValue);
        } else {
            $this->Sexe->ViewValue = null;
        }

        // DateNaissance
        $this->DateNaissance->ViewValue = $this->DateNaissance->CurrentValue;
        $this->DateNaissance->ViewValue = FormatDateTime($this->DateNaissance->ViewValue, $this->DateNaissance->formatPattern());

        // Lieu
        $this->Lieu->ViewValue = $this->Lieu->CurrentValue;

        // Photo
        $this->Photo->UploadPath = $this->Photo->getUploadPath(); // PHP
        if (!EmptyValue($this->Photo->Upload->DbValue)) {
            $this->Photo->ImageWidth = 100;
            $this->Photo->ImageHeight = 100;
            $this->Photo->ImageAlt = $this->Photo->alt();
            $this->Photo->ImageCssClass = "ew-image";
            $this->Photo->ViewValue = $this->Photo->Upload->DbValue;
        } else {
            $this->Photo->ViewValue = "";
        }

        // Unique_QR
        $this->Unique_QR->ViewValue = $this->Unique_QR->CurrentValue;
        $this->Unique_QR->ImageAlt = $this->Unique_QR->alt();
            $this->Unique_QR->ImageCssClass = "ew-image";

        // Groupe_Sanguin
        $this->Groupe_Sanguin->ViewValue = $this->Groupe_Sanguin->CurrentValue;

        // Delivree
        $this->Delivree->ViewValue = $this->Delivree->CurrentValue;
        $this->Delivree->ViewValue = FormatDateTime($this->Delivree->ViewValue, $this->Delivree->formatPattern());

        // Expire
        $this->Expire->ViewValue = $this->Expire->CurrentValue;
        $this->Expire->ViewValue = FormatDateTime($this->Expire->ViewValue, $this->Expire->formatPattern());

        // Localite
        $this->Localite->ViewValue = $this->Localite->CurrentValue;

        // Prevenir
        $this->Prevenir->ViewValue = $this->Prevenir->CurrentValue;

        // Prevenir_Tel
        $this->Prevenir_Tel->ViewValue = $this->Prevenir_Tel->CurrentValue;

        // Reference
        $this->Reference->ViewValue = $this->Reference->CurrentValue;

        // EmployeeID
        $curVal = strval($this->EmployeeID->CurrentValue);
        if ($curVal != "") {
            $this->EmployeeID->ViewValue = $this->EmployeeID->lookupCacheOption($curVal);
            if ($this->EmployeeID->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter("`EmployeeID`", "=", $curVal, DATATYPE_NUMBER, "");
                $sqlWrk = $this->EmployeeID->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCacheImpl($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->EmployeeID->Lookup->renderViewRow($rswrk[0]);
                    $this->EmployeeID->ViewValue = $this->EmployeeID->displayValue($arwrk);
                } else {
                    $this->EmployeeID->ViewValue = FormatNumber($this->EmployeeID->CurrentValue, $this->EmployeeID->formatPattern());
                }
            }
        } else {
            $this->EmployeeID->ViewValue = null;
        }

        // Statut
        if (strval($this->Statut->CurrentValue) != "") {
            $this->Statut->ViewValue = $this->Statut->optionCaption($this->Statut->CurrentValue);
        } else {
            $this->Statut->ViewValue = null;
        }
        $this->Statut->CssClass = "fw-bold";

        // volontaireID
        $this->volontaireID->HrefValue = "";
        $this->volontaireID->TooltipValue = "";

        // Carte_No
        $this->Carte_No->HrefValue = "";
        $this->Carte_No->TooltipValue = "";

        // NIP
        $this->NIP->HrefValue = "";
        $this->NIP->TooltipValue = "";

        // Nom
        $this->Nom->HrefValue = "";
        $this->Nom->TooltipValue = "";

        // Prenom
        $this->Prenom->HrefValue = "";
        $this->Prenom->TooltipValue = "";

        // Sexe
        $this->Sexe->HrefValue = "";
        $this->Sexe->TooltipValue = "";

        // DateNaissance
        $this->DateNaissance->HrefValue = "";
        $this->DateNaissance->TooltipValue = "";

        // Lieu
        $this->Lieu->HrefValue = "";
        $this->Lieu->TooltipValue = "";

        // Photo
        $this->Photo->UploadPath = $this->Photo->getUploadPath(); // PHP
        if (!EmptyValue($this->Photo->Upload->DbValue)) {
            $this->Photo->HrefValue = GetFileUploadUrl($this->Photo, $this->Photo->htmlDecode($this->Photo->Upload->DbValue)); // Add prefix/suffix
            $this->Photo->LinkAttrs["target"] = "_self"; // Add target
            if ($this->isExport()) {
                $this->Photo->HrefValue = FullUrl($this->Photo->HrefValue, "href");
            }
        } else {
            $this->Photo->HrefValue = "";
        }
        $this->Photo->ExportHrefValue = $this->Photo->UploadPath . $this->Photo->Upload->DbValue;
        $this->Photo->TooltipValue = "";
        if ($this->Photo->UseColorbox) {
            if (EmptyValue($this->Photo->TooltipValue)) {
                $this->Photo->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
            }
            $this->Photo->LinkAttrs["data-rel"] = "volontaire_x_Photo";
            $this->Photo->LinkAttrs->appendClass("ew-lightbox");
        }

        // Unique_QR
        $this->Unique_QR->HrefValue = "";
        $this->Unique_QR->ExportHrefValue = PhpBarcode::barcode(true)->getHrefValue($this->Unique_QR->CurrentValue, 'QRCODE', 60);
        $this->Unique_QR->TooltipValue = "";

        // Groupe_Sanguin
        $this->Groupe_Sanguin->HrefValue = "";
        $this->Groupe_Sanguin->TooltipValue = "";

        // Delivree
        $this->Delivree->HrefValue = "";
        $this->Delivree->TooltipValue = "";

        // Expire
        $this->Expire->HrefValue = "";
        $this->Expire->TooltipValue = "";

        // Localite
        $this->Localite->HrefValue = "";
        $this->Localite->TooltipValue = "";

        // Prevenir
        $this->Prevenir->HrefValue = "";
        $this->Prevenir->TooltipValue = "";

        // Prevenir_Tel
        $this->Prevenir_Tel->HrefValue = "";
        $this->Prevenir_Tel->TooltipValue = "";

        // Reference
        $this->Reference->HrefValue = "";
        $this->Reference->TooltipValue = "";

        // EmployeeID
        $this->EmployeeID->HrefValue = "";
        $this->EmployeeID->TooltipValue = "";

        // Statut
        $this->Statut->HrefValue = "";
        $this->Statut->TooltipValue = "";

        // Call Row Rendered event
        $this->rowRendered();

        // Save data for Custom Template
        $this->Rows[] = $this->customTemplateFieldValues();
    }

    // Render edit row values
    public function renderEditRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // volontaireID
        $this->volontaireID->setupEditAttributes();
        $this->volontaireID->EditValue = $this->volontaireID->CurrentValue;
        $this->volontaireID->PlaceHolder = RemoveHtml($this->volontaireID->caption());

        // Carte_No
        $this->Carte_No->setupEditAttributes();
        if (!$this->Carte_No->Raw) {
            $this->Carte_No->CurrentValue = HtmlDecode($this->Carte_No->CurrentValue);
        }
        $this->Carte_No->EditValue = $this->Carte_No->CurrentValue;
        $this->Carte_No->PlaceHolder = RemoveHtml($this->Carte_No->caption());

        // NIP
        $this->NIP->setupEditAttributes();
        if (!$this->NIP->Raw) {
            $this->NIP->CurrentValue = HtmlDecode($this->NIP->CurrentValue);
        }
        $this->NIP->EditValue = $this->NIP->CurrentValue;
        $this->NIP->PlaceHolder = RemoveHtml($this->NIP->caption());

        // Nom
        $this->Nom->setupEditAttributes();
        if (!$this->Nom->Raw) {
            $this->Nom->CurrentValue = HtmlDecode($this->Nom->CurrentValue);
        }
        $this->Nom->EditValue = $this->Nom->CurrentValue;
        $this->Nom->PlaceHolder = RemoveHtml($this->Nom->caption());

        // Prenom
        $this->Prenom->setupEditAttributes();
        if (!$this->Prenom->Raw) {
            $this->Prenom->CurrentValue = HtmlDecode($this->Prenom->CurrentValue);
        }
        $this->Prenom->EditValue = $this->Prenom->CurrentValue;
        $this->Prenom->PlaceHolder = RemoveHtml($this->Prenom->caption());

        // Sexe
        $this->Sexe->EditValue = $this->Sexe->options(false);
        $this->Sexe->PlaceHolder = RemoveHtml($this->Sexe->caption());

        // DateNaissance
        $this->DateNaissance->setupEditAttributes();
        $this->DateNaissance->EditValue = FormatDateTime($this->DateNaissance->CurrentValue, $this->DateNaissance->formatPattern());
        $this->DateNaissance->PlaceHolder = RemoveHtml($this->DateNaissance->caption());

        // Lieu
        $this->Lieu->setupEditAttributes();
        if (!$this->Lieu->Raw) {
            $this->Lieu->CurrentValue = HtmlDecode($this->Lieu->CurrentValue);
        }
        $this->Lieu->EditValue = $this->Lieu->CurrentValue;
        $this->Lieu->PlaceHolder = RemoveHtml($this->Lieu->caption());

        // Photo
        $this->Photo->setupEditAttributes();
        $this->Photo->UploadPath = $this->Photo->getUploadPath(); // PHP
        if (!EmptyValue($this->Photo->Upload->DbValue)) {
            $this->Photo->ImageWidth = 100;
            $this->Photo->ImageHeight = 100;
            $this->Photo->ImageAlt = $this->Photo->alt();
            $this->Photo->ImageCssClass = "ew-image";
            $this->Photo->EditValue = $this->Photo->Upload->DbValue;
        } else {
            $this->Photo->EditValue = "";
        }
        if (!EmptyValue($this->Photo->CurrentValue)) {
            $this->Photo->Upload->FileName = $this->Photo->CurrentValue;
        }

        // Unique_QR
        $this->Unique_QR->setupEditAttributes();
        if (!$this->Unique_QR->Raw) {
            $this->Unique_QR->CurrentValue = HtmlDecode($this->Unique_QR->CurrentValue);
        }
        $this->Unique_QR->EditValue = $this->Unique_QR->CurrentValue;
        $this->Unique_QR->PlaceHolder = RemoveHtml($this->Unique_QR->caption());

        // Groupe_Sanguin
        $this->Groupe_Sanguin->setupEditAttributes();
        if (!$this->Groupe_Sanguin->Raw) {
            $this->Groupe_Sanguin->CurrentValue = HtmlDecode($this->Groupe_Sanguin->CurrentValue);
        }
        $this->Groupe_Sanguin->EditValue = $this->Groupe_Sanguin->CurrentValue;
        $this->Groupe_Sanguin->PlaceHolder = RemoveHtml($this->Groupe_Sanguin->caption());

        // Delivree
        $this->Delivree->setupEditAttributes();
        $this->Delivree->EditValue = FormatDateTime($this->Delivree->CurrentValue, $this->Delivree->formatPattern());
        $this->Delivree->PlaceHolder = RemoveHtml($this->Delivree->caption());

        // Expire
        $this->Expire->setupEditAttributes();
        $this->Expire->EditValue = FormatDateTime($this->Expire->CurrentValue, $this->Expire->formatPattern());
        $this->Expire->PlaceHolder = RemoveHtml($this->Expire->caption());

        // Localite
        $this->Localite->setupEditAttributes();
        if (!$this->Localite->Raw) {
            $this->Localite->CurrentValue = HtmlDecode($this->Localite->CurrentValue);
        }
        $this->Localite->EditValue = $this->Localite->CurrentValue;
        $this->Localite->PlaceHolder = RemoveHtml($this->Localite->caption());

        // Prevenir
        $this->Prevenir->setupEditAttributes();
        if (!$this->Prevenir->Raw) {
            $this->Prevenir->CurrentValue = HtmlDecode($this->Prevenir->CurrentValue);
        }
        $this->Prevenir->EditValue = $this->Prevenir->CurrentValue;
        $this->Prevenir->PlaceHolder = RemoveHtml($this->Prevenir->caption());

        // Prevenir_Tel
        $this->Prevenir_Tel->setupEditAttributes();
        if (!$this->Prevenir_Tel->Raw) {
            $this->Prevenir_Tel->CurrentValue = HtmlDecode($this->Prevenir_Tel->CurrentValue);
        }
        $this->Prevenir_Tel->EditValue = $this->Prevenir_Tel->CurrentValue;
        $this->Prevenir_Tel->PlaceHolder = RemoveHtml($this->Prevenir_Tel->caption());

        // Reference
        $this->Reference->setupEditAttributes();
        if (!$this->Reference->Raw) {
            $this->Reference->CurrentValue = HtmlDecode($this->Reference->CurrentValue);
        }
        $this->Reference->EditValue = $this->Reference->CurrentValue;
        $this->Reference->PlaceHolder = RemoveHtml($this->Reference->caption());

        // EmployeeID
        $this->EmployeeID->setupEditAttributes();
        $curVal = strval($this->EmployeeID->CurrentValue);
        if ($curVal != "") {
            $this->EmployeeID->EditValue = $this->EmployeeID->lookupCacheOption($curVal);
            if ($this->EmployeeID->EditValue === null) { // Lookup from database
                $filterWrk = SearchFilter("`EmployeeID`", "=", $curVal, DATATYPE_NUMBER, "");
                $sqlWrk = $this->EmployeeID->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCacheImpl($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->EmployeeID->Lookup->renderViewRow($rswrk[0]);
                    $this->EmployeeID->EditValue = $this->EmployeeID->displayValue($arwrk);
                } else {
                    $this->EmployeeID->EditValue = FormatNumber($this->EmployeeID->CurrentValue, $this->EmployeeID->formatPattern());
                }
            }
        } else {
            $this->EmployeeID->EditValue = null;
        }

        // Statut
        $this->Statut->setupEditAttributes();
        $this->Statut->EditValue = $this->Statut->options(true);
        $this->Statut->PlaceHolder = RemoveHtml($this->Statut->caption());

        // Call Row Rendered event
        $this->rowRendered();
    }

    // Aggregate list row values
    public function aggregateListRowValues()
    {
    }

    // Aggregate list row (for rendering)
    public function aggregateListRow()
    {
        // Call Row Rendered event
        $this->rowRendered();
    }

    // Export data in HTML/CSV/Word/Excel/Email/PDF format
	// Now including Export Print (printer friendly), modification by UDS Hub, September 27, 2022 
    public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
    {
        if (!$recordset || !$doc) {
            return;
        }
        if (!$doc->ExportCustom) {
            // Write header
            $doc->exportTableHeader();
            if ($doc->Horizontal) { // Horizontal format, write header
                $doc->beginExportRow();
                if ($exportPageType == "view") {
                    $doc->exportCaption($this->Carte_No);
                    $doc->exportCaption($this->NIP);
                    $doc->exportCaption($this->Nom);
                    $doc->exportCaption($this->Prenom);
                    $doc->exportCaption($this->Sexe);
                    $doc->exportCaption($this->DateNaissance);
                    $doc->exportCaption($this->Lieu);
                    $doc->exportCaption($this->Photo);
                    $doc->exportCaption($this->Unique_QR);
                    $doc->exportCaption($this->Groupe_Sanguin);
                    $doc->exportCaption($this->Delivree);
                    $doc->exportCaption($this->Expire);
                    $doc->exportCaption($this->Localite);
                    $doc->exportCaption($this->Prevenir);
                    $doc->exportCaption($this->Prevenir_Tel);
                    $doc->exportCaption($this->Reference);
                    $doc->exportCaption($this->EmployeeID);
                    $doc->exportCaption($this->Statut);
                } else {
                    $doc->exportCaption($this->Carte_No);
                    $doc->exportCaption($this->NIP);
                    $doc->exportCaption($this->Nom);
                    $doc->exportCaption($this->Prenom);
                    $doc->exportCaption($this->Sexe);
                    $doc->exportCaption($this->DateNaissance);
                    $doc->exportCaption($this->Lieu);
                    $doc->exportCaption($this->Photo);
                    $doc->exportCaption($this->Unique_QR);
                    $doc->exportCaption($this->Groupe_Sanguin);
                    $doc->exportCaption($this->Delivree);
                    $doc->exportCaption($this->Expire);
                    $doc->exportCaption($this->Localite);
                    $doc->exportCaption($this->Prevenir);
                    $doc->exportCaption($this->Prevenir_Tel);
                    $doc->exportCaption($this->Reference);
                    $doc->exportCaption($this->Statut);
                }
                $doc->endExportRow();
            }
        }

        // Move to first record
        $recCnt = $startRec - 1;
        $stopRec = ($stopRec > 0) ? $stopRec : PHP_INT_MAX;
		// Begin of modification Record Number in Exported Data by UDS Hub, September 27, 2022
		$seqRec = 0;
		if (CurrentPageID() == "view") { // Modified by UDS Hub, reset seq. number in View Page
		    $_SESSION["First_Record"] = 0;
			$seqRec = (empty($_SESSION["First_Record"])) ? 0 : $_SESSION["First_Record"] - 1; 
		} else {
			$seqRec = (empty($_SESSION["First_Record"])) ? $recCnt : $_SESSION["First_Record"] - 1;
		}
		// End of modification Record Number in Exported Data by UDS Hub, September 27, 2022
        while (!$recordset->EOF && $recCnt < $stopRec) {
            $row = $recordset->fields;
            $recCnt++;
			$seqRec++; // Record Number in Exported Data by UDS Hub, September 27, 2022
            if ($recCnt >= $startRec) {
                $rowCnt = $recCnt - $startRec + 1;
                // Page break
				// Begin of modification PageBreak for Export to PDF dan Export to Word by UDS Hub, September 27, 2022
                if ($this->ExportPageBreakCount > 0 && ($this->Export == "pdf" || $this->Export =="word")) {
                    if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0) {
                        $doc->exportPageBreak();
						$doc->beginExportRow(); // Begin of modification by UDS Hub, table header will be repeated at the top of each page after page break, must be handled from here for Export to PDF that has the possibility to repeat the table header column in each top of page
						$doc->exportCaption($this->Carte_No);
						$doc->exportCaption($this->NIP);
						$doc->exportCaption($this->Nom);
						$doc->exportCaption($this->Prenom);
						$doc->exportCaption($this->Sexe);
						$doc->exportCaption($this->DateNaissance);
						$doc->exportCaption($this->Lieu);
						$doc->exportCaption($this->Photo);
						$doc->exportCaption($this->Unique_QR);
						$doc->exportCaption($this->Groupe_Sanguin);
						$doc->exportCaption($this->Delivree);
						$doc->exportCaption($this->Expire);
						$doc->exportCaption($this->Localite);
						$doc->exportCaption($this->Prevenir);
						$doc->exportCaption($this->Prevenir_Tel);
						$doc->exportCaption($this->Reference);
						$doc->exportCaption($this->Statut);
						$doc->endExportRow(); // End of modification by UDS Hub, table header will be repeated at the top of each page after page break
                    }
                }
				// End of modification PageBreak for Export to PDF dan Export to Word by UDS Hub, September 27, 2022
                $this->loadListRowValues($row);

                // Render row
                $this->RowType = ROWTYPE_VIEW; // Render view
                $this->resetAttributes();
                $this->renderListRow();
                if (!$doc->ExportCustom) {
                    $doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
                    if ($exportPageType == "view") {
                        $doc->exportField($this->Carte_No);
                        $doc->exportField($this->NIP);
                        $doc->exportField($this->Nom);
                        $doc->exportField($this->Prenom);
                        $doc->exportField($this->Sexe);
                        $doc->exportField($this->DateNaissance);
                        $doc->exportField($this->Lieu);
                        $doc->exportField($this->Photo);
                        $doc->exportField($this->Unique_QR);
                        $doc->exportField($this->Groupe_Sanguin);
                        $doc->exportField($this->Delivree);
                        $doc->exportField($this->Expire);
                        $doc->exportField($this->Localite);
                        $doc->exportField($this->Prevenir);
                        $doc->exportField($this->Prevenir_Tel);
                        $doc->exportField($this->Reference);
                        $doc->exportField($this->EmployeeID);
                        $doc->exportField($this->Statut);
                    } else {
                        $doc->exportField($this->Carte_No);
                        $doc->exportField($this->NIP);
                        $doc->exportField($this->Nom);
                        $doc->exportField($this->Prenom);
                        $doc->exportField($this->Sexe);
                        $doc->exportField($this->DateNaissance);
                        $doc->exportField($this->Lieu);
                        $doc->exportField($this->Photo);
                        $doc->exportField($this->Unique_QR);
                        $doc->exportField($this->Groupe_Sanguin);
                        $doc->exportField($this->Delivree);
                        $doc->exportField($this->Expire);
                        $doc->exportField($this->Localite);
                        $doc->exportField($this->Prevenir);
                        $doc->exportField($this->Prevenir_Tel);
                        $doc->exportField($this->Reference);
                        $doc->exportField($this->Statut);
                    }
                    $doc->endExportRow($rowCnt);
                }
            }

            // Call Row Export server event
            if ($doc->ExportCustom) {
                $this->rowExport($doc, $row);
            }
            $recordset->moveNext();
        }
        if (!$doc->ExportCustom) {
            $doc->exportTableFooter();
        }
    }

    // Get file data
    public function getFileData($fldparm, $key, $resize, $width = 0, $height = 0, $plugins = [])
    {
        global $DownloadFileName;
        $width = ($width > 0) ? $width : Config("THUMBNAIL_DEFAULT_WIDTH");
        $height = ($height > 0) ? $height : Config("THUMBNAIL_DEFAULT_HEIGHT");

        // Set up field name / file name field / file type field
        $fldName = "";
        $fileNameFld = "";
        $fileTypeFld = "";
        if ($fldparm == 'Photo') {
            $fldName = "Photo";
            $fileNameFld = "Photo";
        } else {
            return false; // Incorrect field
        }

        // Set up key values
        $ar = explode(Config("COMPOSITE_KEY_SEPARATOR"), $key);
        if (count($ar) == 1) {
            $this->volontaireID->CurrentValue = $ar[0];
        } else {
            return false; // Incorrect key
        }

        // Set up filter (WHERE Clause)
        $filter = $this->getRecordFilter();
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $dbtype = GetConnectionType($this->Dbid);
        if ($row = $conn->fetchAssociative($sql)) {
            $val = $row[$fldName];
            if (!EmptyValue($val)) {
                $fld = $this->Fields[$fldName];

                // Binary data
                if ($fld->DataType == DATATYPE_BLOB) {
                    if ($dbtype != "MYSQL") {
                        if (is_resource($val) && get_resource_type($val) == "stream") { // Byte array
                            $val = stream_get_contents($val);
                        }
                    }
                    if ($resize) {
                        ResizeBinary($val, $width, $height, $plugins);
                    }

                    // Write file type
                    if ($fileTypeFld != "" && !EmptyValue($row[$fileTypeFld])) {
                        AddHeader("Content-type", $row[$fileTypeFld]);
                    } else {
                        AddHeader("Content-type", ContentType($val));
                    }

                    // Write file name
                    $downloadPdf = !Config("EMBED_PDF") && Config("DOWNLOAD_PDF_FILE");
                    if ($fileNameFld != "" && !EmptyValue($row[$fileNameFld])) {
                        $fileName = $row[$fileNameFld];
                        $ext = strtolower($pathinfo["extension"] ?? "");
                        $isPdf = SameText($ext, "pdf");
                        if ($downloadPdf || !$isPdf) { // Skip header if not download PDF
                            AddHeader("Content-Disposition", "attachment; filename=\"" . $fileName . "\"");
                        }
                    } else {
                        $ext = ContentExtension($val);
                        $isPdf = SameText($ext, ".pdf");
                        if ($isPdf && $downloadPdf) { // Add header if download PDF
                            AddHeader("Content-Disposition", "attachment" . ($DownloadFileName ? "; filename=\"" . $DownloadFileName . "\"" : ""));
                        }
                    }

                    // Write file data
                    if (
                        StartsString("PK", $val) &&
                        ContainsString($val, "[Content_Types].xml") &&
                        ContainsString($val, "_rels") &&
                        ContainsString($val, "docProps")
                    ) { // Fix Office 2007 documents
                        if (!EndsString("\0\0\0", $val)) { // Not ends with 3 or 4 \0
                            $val .= "\0\0\0\0";
                        }
                    }

                    // Clear any debug message
                    if (ob_get_length()) {
                        ob_end_clean();
                    }

                    // Write binary data
                    Write($val);

                // Upload to folder
                } else {
                    if ($fld->UploadMultiple) {
                        $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                    } else {
                        $files = [$val];
                    }
                    $data = [];
                    $ar = [];
                    if ($fld->hasMethod("getUploadPath")) { // Check field level upload path
                        $fld->UploadPath = $fld->getUploadPath();
                    }
                    foreach ($files as $file) {
                        if (!EmptyValue($file)) {
                            if (Config("ENCRYPT_FILE_PATH")) {
                                $ar[$file] = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $this->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                            } else {
                                $ar[$file] = FullUrl($fld->hrefPath() . $file);
                            }
                        }
                    }
                    $data[$fld->Param] = $ar;
                    WriteJson($data);
                }
            }
            return true;
        }
        return false;
    }

    // Write audit trail start/end for grid update
    public function writeAuditTrailDummy($typ)
    {
        WriteAuditLog(CurrentUser(), $typ, 'volontaire', "", "", "", "");
    }

    // Write audit trail (add page)
    public function writeAuditTrailOnAdd(&$rs)
    {
        global $Language;
        if (!$this->AuditTrailOnAdd) {
            return;
        }

        // Get key value
        $key = "";
        if ($key != "") {
            $key .= Config("COMPOSITE_KEY_SEPARATOR");
        }
        $key .= $rs['volontaireID'];

        // Write audit trail
        $usr = CurrentUser();
        foreach (array_keys($rs) as $fldname) {
            if (array_key_exists($fldname, $this->Fields) && $this->Fields[$fldname]->DataType != DATATYPE_BLOB) { // Ignore BLOB fields
                if ($this->Fields[$fldname]->HtmlTag == "PASSWORD") { // Password Field
                    $newvalue = $Language->phrase("PasswordMask");
                } elseif ($this->Fields[$fldname]->DataType == DATATYPE_MEMO) { // Memo Field
                    $newvalue = Config("AUDIT_TRAIL_TO_DATABASE") ? $rs[$fldname] : "[MEMO]";
                } elseif ($this->Fields[$fldname]->DataType == DATATYPE_XML) { // XML Field
                    $newvalue = "[XML]";
                } else {
                    $newvalue = $rs[$fldname];
                }
                WriteAuditLog($usr, "A", 'volontaire', $fldname, $key, "", $newvalue);
            }
        }
    }

    // Write audit trail (edit page)
    public function writeAuditTrailOnEdit(&$rsold, &$rsnew)
    {
        global $Language;
        if (!$this->AuditTrailOnEdit) {
            return;
        }

        // Get key value
        $key = "";
        if ($key != "") {
            $key .= Config("COMPOSITE_KEY_SEPARATOR");
        }
        $key .= $rsold['volontaireID'];

        // Write audit trail
        $usr = CurrentUser();
        foreach (array_keys($rsnew) as $fldname) {
            if (array_key_exists($fldname, $this->Fields) && array_key_exists($fldname, $rsold) && $this->Fields[$fldname]->DataType != DATATYPE_BLOB) { // Ignore BLOB fields
                if ($this->Fields[$fldname]->DataType == DATATYPE_DATE) { // DateTime field
                    $modified = (FormatDateTime($rsold[$fldname], 0) != FormatDateTime($rsnew[$fldname], 0));
                } else {
                    $modified = !CompareValue($rsold[$fldname], $rsnew[$fldname]);
                }
                if ($modified) {
                    if ($this->Fields[$fldname]->HtmlTag == "PASSWORD") { // Password Field
                        $oldvalue = $Language->phrase("PasswordMask");
                        $newvalue = $Language->phrase("PasswordMask");
                    } elseif ($this->Fields[$fldname]->DataType == DATATYPE_MEMO) { // Memo field
                        $oldvalue = Config("AUDIT_TRAIL_TO_DATABASE") ? $rsold[$fldname] : "[MEMO]";
                        $newvalue = Config("AUDIT_TRAIL_TO_DATABASE") ? $rsnew[$fldname] : "[MEMO]";
                    } elseif ($this->Fields[$fldname]->DataType == DATATYPE_XML) { // XML field
                        $oldvalue = "[XML]";
                        $newvalue = "[XML]";
                    } else {
                        $oldvalue = $rsold[$fldname];
                        $newvalue = $rsnew[$fldname];
                    }
                    WriteAuditLog($usr, "U", 'volontaire', $fldname, $key, $oldvalue, $newvalue);
                }
            }
        }
    }

    // Write audit trail (delete page)
    public function writeAuditTrailOnDelete(&$rs)
    {
        global $Language;
        if (!$this->AuditTrailOnDelete) {
            return;
        }

        // Get key value
        $key = "";
        if ($key != "") {
            $key .= Config("COMPOSITE_KEY_SEPARATOR");
        }
        $key .= $rs['volontaireID'];

        // Write audit trail
        $usr = CurrentUser();
        foreach (array_keys($rs) as $fldname) {
            if (array_key_exists($fldname, $this->Fields) && $this->Fields[$fldname]->DataType != DATATYPE_BLOB) { // Ignore BLOB fields
                if ($this->Fields[$fldname]->HtmlTag == "PASSWORD") { // Password Field
                    $oldvalue = $Language->phrase("PasswordMask");
                } elseif ($this->Fields[$fldname]->DataType == DATATYPE_MEMO) { // Memo field
                    $oldvalue = Config("AUDIT_TRAIL_TO_DATABASE") ? $rs[$fldname] : "[MEMO]";
                } elseif ($this->Fields[$fldname]->DataType == DATATYPE_XML) { // XML field
                    $oldvalue = "[XML]";
                } else {
                    $oldvalue = $rs[$fldname];
                }
                WriteAuditLog($usr, "D", 'volontaire', $fldname, $key, $oldvalue, "");
            }
        }
    }

    // Send email after add success
    public function sendEmailOnAdd(&$rs)
    {
        global $Language;
        $table = 'volontaire';
        $subject = $table . " " . $Language->phrase("RecordInserted");
        $action = $Language->phrase("ActionInserted");

        // Get key value
        $key = "";
        if ($key != "") {
            $key .= Config("COMPOSITE_KEY_SEPARATOR");
        }
        $key .= $rs['volontaireID'];
        $email = new Email();
        $email->load(Config("EMAIL_NOTIFY_TEMPLATE"));
        $email->replaceSender(Config("SENDER_EMAIL")); // Replace Sender
        $email->replaceRecipient(Config("RECIPIENT_EMAIL")); // Replace Recipient
        $email->replaceSubject($subject); // Replace Subject
        $email->replaceContent("<!--table-->", $table);
        $email->replaceContent("<!--key-->", $key);
        $email->replaceContent("<!--action-->", $action);
        $args = ["rsnew" => $rs];
        $emailSent = false;
        if ($this->emailSending($email, $args)) {
            $emailSent = $email->send();
        }

        // Send email failed
        if (!$emailSent) {
            $this->setFailureMessage($email->SendErrDescription);
        }
    }

    // Send email after update success
    public function sendEmailOnEdit(&$rsold, &$rsnew)
    {
        global $Language;
        $table = 'volontaire';
        $subject = $table . " ". $Language->phrase("RecordUpdated");
        $action = $Language->phrase("ActionUpdated");

        // Get key value
        $key = "";
        if ($key != "") {
            $key .= Config("COMPOSITE_KEY_SEPARATOR");
        }
        $key .= $rsold['volontaireID'];
        $email = new Email();
        $email->load(Config("EMAIL_NOTIFY_TEMPLATE"));
        $email->replaceSender(Config("SENDER_EMAIL")); // Replace Sender
        $email->replaceRecipient(Config("RECIPIENT_EMAIL")); // Replace Recipient
        $email->replaceSubject($subject); // Replace Subject
        $email->replaceContent("<!--table-->", $table);
        $email->replaceContent("<!--key-->", $key);
        $email->replaceContent("<!--action-->", $action);
        $args = [];
        $args["rsold"] = &$rsold;
        $args["rsnew"] = &$rsnew;
        $emailSent = false;
        if ($this->emailSending($email, $args)) {
            $emailSent = $email->send();
        }

        // Send email failed
        if (!$emailSent) {
            $this->setFailureMessage($email->SendErrDescription);
        }
    }

    // Table level events

    // Table Load event
    public function tableLoad()
    {
        // Enter your code here
    }

    // Recordset Selecting event
    public function recordsetSelecting(&$filter)
    {
        // Enter your code here
    }

    // Recordset Selected event
    public function recordsetSelected(&$rs)
    {
        //Log("Recordset Selected");
    }

    // Recordset Search Validated event
    public function recordsetSearchValidated()
    {
        // Example:
        //$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value
    }

    // Recordset Searching event
    public function recordsetSearching(&$filter)
    {
        // Enter your code here
    }

    // Row_Selecting event
    public function rowSelecting(&$filter)
    {
        // Enter your code here
    }

    // Row Selected event
    public function rowSelected(&$rs)
    {
        //Log("Row Selected");
    }

    // Row Inserting event
    public function rowInserting($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Inserted event
    public function rowInserted($rsold, &$rsnew)
    {
        //Log("Row Inserted");
    }

    // Row Updating event
    public function rowUpdating($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Updated event
    public function rowUpdated($rsold, &$rsnew)
    {
        //Log("Row Updated");
    }

    // Row Update Conflict event
    public function rowUpdateConflict($rsold, &$rsnew)
    {
        // Enter your code here
        // To ignore conflict, set return value to false
        return true;
    }

    // Grid Inserting event
    public function gridInserting()
    {
        // Enter your code here
        // To reject grid insert, set return value to false
        return true;
    }

    // Grid Inserted event
    public function gridInserted($rsnew)
    {
        //Log("Grid Inserted");
    }

    // Grid Updating event
    public function gridUpdating($rsold)
    {
        // Enter your code here
        // To reject grid update, set return value to false
        return true;
    }

    // Grid Updated event
    public function gridUpdated($rsold, $rsnew)
    {
        //Log("Grid Updated");
    }

    // Row Deleting event
    public function rowDeleting(&$rs)
    {
        // Enter your code here
        // To cancel, set return value to False
        return true;
    }

    // Row Deleted event
    public function rowDeleted(&$rs)
    {
        //Log("Row Deleted");
    }

    // Email Sending event
    public function emailSending($email, &$args)
    {
        //var_dump($email, $args); exit();
        return true;
    }

    // Lookup Selecting event
    public function lookupSelecting($fld, &$filter)
    {
        //var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
        // Enter your code here
    }

    // Row Rendering event
    public function rowRendering()
    {
        // Enter your code here
    }

    // Update record
    // NOTE: Modify your SQL here, replace the table name, field name and field values
    public function rowRendered()
    {
        // To view properties of field class, use:
        //var_dump($this-><FieldName>);
        if ($this->Statut->ViewValue=="Actif") { 
    $this->Statut->CellAttrs["style"] = "color:#FFFFFF; background-color:#09CE00";    
    }
              if ($this->Statut->ViewValue=="Expiré") { 
    $this->Statut->CellAttrs["style"] = "color:#FFFFFF; background-color:#FF6600";    
    }
        if ($this->Statut->ViewValue=="Décédé") { 
    $this->Statut->CellAttrs["style"] = "color:#FFFFFF; background-color:#FF0000";    
    }
         if ($this->Statut->ViewValue=="Licencié") { 
    $this->Statut->CellAttrs["style"] = "color:#FFFFFF; background-color:#CC0000";    
    }                                             
      if ($this->Statut->ViewValue=="Suspendu") {         
    $this->Statut->CellAttrs["style"] = "color:#000000; background-color:#F4FB03";    
    }   
    }

    // User ID Filtering event
    public function userIdFiltering(&$filter)
    {
        // Enter your code here
    }
}
