<?php

namespace PHPMaker2023\Jack_Jill_school;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\FetchMode;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;

/**
 * Page class
 */
class TasksEdit extends Tasks
{
    use MessagesTrait;

    // Page ID
    public $PageID = "edit";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "TasksEdit";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "tasksedit";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<p id="ew-page-header">' . $header . '</p>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<p id="ew-page-footer">' . $footer . '</p>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->TaskID->setVisibility();
        $this->TaskName->setVisibility();
        $this->ResourceID->setVisibility();
        $this->Start->setVisibility();
        $this->End->setVisibility();
        $this->Description->setVisibility();
        $this->Milestone->setVisibility();
        $this->Duration->setVisibility();
        $this->PercentComplete->setVisibility();
        $this->Dependencies->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'tasks';
        $this->TableName = 'tasks';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-edit-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("language");

        // Table object (tasks)
        if (!isset($GLOBALS["tasks"]) || get_class($GLOBALS["tasks"]) == PROJECT_NAMESPACE . "tasks") {
            $GLOBALS["tasks"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'tasks');
        }

        // Start timer
        $DebugTimer = Container("timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return is_object($Response) ? $Response->getBody() : ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }

        // Global Page Unloaded event (in userfn*.php)
        Page_Unloaded();
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (StartsString("application/json", $Response->getHeaderLine("Content-type")) && $Response->getBody()->getSize()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response (Assume return to modal for simplicity)
            if ($this->IsModal) { // Show as modal
                $result = ["url" => GetUrl($url), "modal" => "1"];
                $pageName = GetPageName($url);
                if ($pageName != $this->getListUrl()) { // Not List page => View page
                    $result["caption"] = $this->getModalCaption($pageName);
                    $result["view"] = $pageName == "tasksview"; // If View page, no primary button
                } else { // List page
                    // $result["list"] = $this->PageID == "search"; // Refresh List page if current page is Search page
                    $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                    $this->clearFailureMessage();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from recordset
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Recordset
            while ($rs && !$rs->EOF) {
                $this->loadRowValues($rs); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($rs->fields);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
                $rs->moveNext();
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DATATYPE_BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['TaskID'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
    }

    // Lookup data
    public function lookup($ar = null)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $ar["field"] ?? Post("field");
        $lookup = $this->Fields[$fieldName]->Lookup;
        $name = $ar["name"] ?? Post("name");
        $isQuery = ContainsString($name, "query_builder_rule");
        if ($isQuery) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $ar["ajax"] ?? Post("ajax", "unknown");
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $ar["q"] ?? Param("q") ?? $ar["sv"] ?? Post("sv", "");
            $pageSize = $ar["n"] ?? Param("n") ?? $ar["recperpage"] ?? Post("recperpage", 10);
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $ar["q"] ?? Param("q", "");
            $pageSize = $ar["n"] ?? Param("n", -1);
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $ar["start"] ?? Param("start", -1);
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $ar["page"] ?? Param("page", -1);
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($ar["s"] ?? Post("s", ""));
        $userFilter = Decrypt($ar["f"] ?? Post("f", ""));
        $userOrderBy = Decrypt($ar["o"] ?? Post("o", ""));
        $keys = $ar["keys"] ?? Post("keys");
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $ar["v0"] ?? $ar["lookupValue"] ?? Post("v0", Post("lookupValue", ""));
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $ar["v" . $i] ?? Post("v" . $i, "");
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, !is_array($ar)); // Use settings from current page
    }

    // Properties
    public $FormClassName = "ew-form ew-edit-form overlay-wrapper";
    public $IsModal = false;
    public $IsMobileOrModal = false;
    public $DbMasterFilter;
    public $DbDetailFilter;
    public $HashValue; // Hash Value
    public $DisplayRecords = 1;
    public $StartRecord;
    public $StopRecord;
    public $TotalRecords = 0;
    public $RecordRange = 10;
    public $RecordCount;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $UserProfile, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

// Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Update last accessed time
        if (!IsSysAdmin() && !$UserProfile->isValidUser(CurrentUserName(), session_id())) {
            $this->setFailureMessage($Language->phrase("UserProfileCorrupted"));
            $this->terminate('logout');
            // return;
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        Page_Loading();

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }
		My_Global_Check(); // Modified by Unique Digital Solutions Ltd, October 6, 2021

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;

        // Load record by position
        $loadByPosition = false;
        $loaded = false;
        $postBack = false;

        // Set up current action and primary key
        if (IsApi()) {
            // Load key values
            $loaded = true;
            if (($keyValue = Get("TaskID") ?? Key(0) ?? Route(2)) !== null) {
                $this->TaskID->setQueryStringValue($keyValue);
                $this->TaskID->setOldValue($this->TaskID->QueryStringValue);
            } elseif (Post("TaskID") !== null) {
                $this->TaskID->setFormValue(Post("TaskID"));
                $this->TaskID->setOldValue($this->TaskID->FormValue);
            } else {
                $loaded = false; // Unable to load key
            }

            // Load record
            if ($loaded) {
                $loaded = $this->loadRow();
            }
            if (!$loaded) {
                $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
                $this->terminate();
                return;
            }
            $this->CurrentAction = "update"; // Update record directly
            $this->OldKey = $this->getKey(true); // Get from CurrentValue
            $postBack = true;
        } else {
            if (Post("action", "") !== "") {
                $this->CurrentAction = Post("action"); // Get action code
                if (!$this->isShow()) { // Not reload record, handle as postback
                    $postBack = true;
                }

                // Get key from Form
                $this->setKey(Post($this->OldKeyName), $this->isShow());
            } else {
                $this->CurrentAction = "show"; // Default action is display

                // Load key from QueryString
                $loadByQuery = false;
                if (($keyValue = Get("TaskID") ?? Route("TaskID")) !== null) {
                    $this->TaskID->setQueryStringValue($keyValue);
                    $loadByQuery = true;
                } else {
                    $this->TaskID->CurrentValue = null;
                }
                if (!$loadByQuery || Get(Config("TABLE_START_REC")) !== null || Get(Config("TABLE_PAGE_NUMBER")) !== null) {
                    $loadByPosition = true;
                }
            }

            // Load recordset
            if ($this->isShow()) {
                if (!$this->IsModal) { // Normal edit page
                    $this->StartRecord = 1; // Initialize start position
                    if ($rs = $this->loadRecordset()) { // Load records
                        $this->TotalRecords = $rs->recordCount(); // Get record count
                    }
                    if ($this->TotalRecords <= 0) { // No record found
                        if ($this->getSuccessMessage() == "" && $this->getFailureMessage() == "") {
                            $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
                        }
                        $this->terminate("taskslist"); // Return to list page
                        return;
                    } elseif ($loadByPosition) { // Load record by position
                        $this->setupStartRecord(); // Set up start record position
                        // Point to current record
                        if ($this->StartRecord <= $this->TotalRecords) {
                            $rs->move($this->StartRecord - 1);
                            // Redirect to correct record
                            $this->loadRowValues($rs);
                            $url = $this->getCurrentUrl();
                            $this->terminate($url);
                            return;
                        }
                    } else { // Match key values
                        if ($this->TaskID->CurrentValue != null) {
                            while (!$rs->EOF) {
                                if (SameString($this->TaskID->CurrentValue, $rs->fields['TaskID'])) {
                                    $this->setStartRecordNumber($this->StartRecord); // Save record position
                                    $loaded = true;
                                    break;
                                } else {
                                    $this->StartRecord++;
                                    $rs->moveNext();
                                }
                            }
                        }
                    }

                    // Load current row values
                    if ($loaded) {
                        $this->loadRowValues($rs);
                    }
                } else {
                    // Load current record
                    $loaded = $this->loadRow();
                } // End modal checking
                $this->OldKey = $loaded ? $this->getKey(true) : ""; // Get from CurrentValue
            }
        }

        // Process form if post back
        if ($postBack) {
            $this->loadFormValues(); // Get form values
        }

        // Validate form if post back
        if ($postBack) {
            if (!$this->validateForm()) {
                $this->EventCancelled = true; // Event cancelled
                $this->restoreFormValues();
                if (IsApi()) {
                    $this->terminate();
                    return;
                } else {
                    $this->CurrentAction = ""; // Form error, reset action
                }
            }
        }

        // Perform current action
        switch ($this->CurrentAction) {
            case "show": // Get a record to display
                if (!$this->IsModal) { // Normal edit page
                    if (!$loaded) {
                        if ($this->getSuccessMessage() == "" && $this->getFailureMessage() == "") {
                            $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
                        }
                        $this->terminate("taskslist"); // Return to list page
                        return;
                    } else {
                    }
                } else { // Modal edit page
                    if (!$loaded) { // Load record based on key
                        if ($this->getFailureMessage() == "") {
                            $this->setFailureMessage($Language->phrase("NoRecord")); // No record found
                        }
                        $this->terminate("taskslist"); // No matching record, return to list
                        return;
                    }
                } // End modal checking
                break;
            case "update": // Update
                $returnUrl = $this->getReturnUrl();
                if (GetPageName($returnUrl) == "taskslist") {
                    $returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
                }
                $this->SendEmail = true; // Send email on update success
                if ($this->editRow()) {
                    // Handle UseAjaxActions with return page
                    if ($this->IsModal && $this->UseAjaxActions) {
                        $this->IsModal = false;
                        if (GetPageName($returnUrl) != "taskslist") {
                            Container("flash")->addMessage("Return-Url", $returnUrl); // Save return URL
                            $returnUrl = "taskslist"; // Return list page content
                        }
                    }
                    if ($this->getSuccessMessage() == "") {
                        $this->setSuccessMessage($Language->phrase("UpdateSuccess")); // Update success
                    }
                    if (IsJsonResponse()) {
                        $this->terminate(true);
                        return;
                    } else {
                        $this->terminate($returnUrl); // Return to caller
                        return;
                    }
                } elseif (IsApi()) { // API request, return
                    $this->terminate();
                    return;
                } elseif ($this->IsModal && $this->UseAjaxActions) { // Return JSON error message
                    WriteJson([ "success" => false, "validation" => $this->getValidationErrors(), "error" => $this->getFailureMessage() ]);
                    $this->clearFailureMessage();
                    $this->terminate();
                    return;
                } elseif ($this->getFailureMessage() == $Language->phrase("NoRecord")) {
                    $this->terminate($returnUrl); // Return to caller
                    return;
                } else {
                    $this->EventCancelled = true; // Event cancelled
                    $this->restoreFormValues(); // Restore form values if update failed
                }
        }

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Render the record
        $this->RowType = ROWTYPE_EDIT; // Render as Edit
        $this->resetAttributes();
        $this->renderRow();
        if (!$this->IsModal) { // Normal view page
            $this->Pager = new PrevNextPager($this, $this->StartRecord, $this->DisplayRecords, $this->TotalRecords, "", $this->RecordRange, $this->AutoHidePager, false, false);
            $this->Pager->PageNumberName = Config("TABLE_PAGE_NUMBER");
            $this->Pager->PagePhraseId = "Record"; // Show as record
        }

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            Page_Rendering();

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

// Get upload files
    protected function getUploadFiles()
    {
        global $CurrentForm, $Language;
    }

    // Load form values
    protected function loadFormValues()
    {
        // Load from form
        global $CurrentForm;
        $validate = !Config("SERVER_VALIDATE");

        // Check field name 'TaskID' first before field var 'x_TaskID'
        $val = $CurrentForm->hasValue("TaskID") ? $CurrentForm->getValue("TaskID") : $CurrentForm->getValue("x_TaskID");
        if (!$this->TaskID->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->TaskID->Visible = false; // Disable update for API request
            } else {
                $this->TaskID->setFormValue($val);
            }
        }
        if ($CurrentForm->hasValue("o_TaskID")) {
            $this->TaskID->setOldValue($CurrentForm->getValue("o_TaskID"));
        }

        // Check field name 'TaskName' first before field var 'x_TaskName'
        $val = $CurrentForm->hasValue("TaskName") ? $CurrentForm->getValue("TaskName") : $CurrentForm->getValue("x_TaskName");
        if (!$this->TaskName->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->TaskName->Visible = false; // Disable update for API request
            } else {
                $this->TaskName->setFormValue($val);
            }
        }

        // Check field name 'ResourceID' first before field var 'x_ResourceID'
        $val = $CurrentForm->hasValue("ResourceID") ? $CurrentForm->getValue("ResourceID") : $CurrentForm->getValue("x_ResourceID");
        if (!$this->ResourceID->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->ResourceID->Visible = false; // Disable update for API request
            } else {
                $this->ResourceID->setFormValue($val);
            }
        }

        // Check field name 'Start' first before field var 'x_Start'
        $val = $CurrentForm->hasValue("Start") ? $CurrentForm->getValue("Start") : $CurrentForm->getValue("x_Start");
        if (!$this->Start->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->Start->Visible = false; // Disable update for API request
            } else {
                $this->Start->setFormValue($val, true, $validate);
            }
            $this->Start->CurrentValue = UnFormatDateTime($this->Start->CurrentValue, $this->Start->formatPattern());
        }

        // Check field name 'End' first before field var 'x_End'
        $val = $CurrentForm->hasValue("End") ? $CurrentForm->getValue("End") : $CurrentForm->getValue("x_End");
        if (!$this->End->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->End->Visible = false; // Disable update for API request
            } else {
                $this->End->setFormValue($val, true, $validate);
            }
            $this->End->CurrentValue = UnFormatDateTime($this->End->CurrentValue, $this->End->formatPattern());
        }

        // Check field name 'Description' first before field var 'x_Description'
        $val = $CurrentForm->hasValue("Description") ? $CurrentForm->getValue("Description") : $CurrentForm->getValue("x_Description");
        if (!$this->Description->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->Description->Visible = false; // Disable update for API request
            } else {
                $this->Description->setFormValue($val);
            }
        }

        // Check field name 'Milestone' first before field var 'x_Milestone'
        $val = $CurrentForm->hasValue("Milestone") ? $CurrentForm->getValue("Milestone") : $CurrentForm->getValue("x_Milestone");
        if (!$this->Milestone->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->Milestone->Visible = false; // Disable update for API request
            } else {
                $this->Milestone->setFormValue($val, true, $validate);
            }
            $this->Milestone->CurrentValue = UnFormatDateTime($this->Milestone->CurrentValue, $this->Milestone->formatPattern());
        }

        // Check field name 'Duration' first before field var 'x_Duration'
        $val = $CurrentForm->hasValue("Duration") ? $CurrentForm->getValue("Duration") : $CurrentForm->getValue("x_Duration");
        if (!$this->Duration->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->Duration->Visible = false; // Disable update for API request
            } else {
                $this->Duration->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'PercentComplete' first before field var 'x_PercentComplete'
        $val = $CurrentForm->hasValue("PercentComplete") ? $CurrentForm->getValue("PercentComplete") : $CurrentForm->getValue("x_PercentComplete");
        if (!$this->PercentComplete->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->PercentComplete->Visible = false; // Disable update for API request
            } else {
                $this->PercentComplete->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'Dependencies' first before field var 'x_Dependencies'
        $val = $CurrentForm->hasValue("Dependencies") ? $CurrentForm->getValue("Dependencies") : $CurrentForm->getValue("x_Dependencies");
        if (!$this->Dependencies->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->Dependencies->Visible = false; // Disable update for API request
            } else {
                $this->Dependencies->setFormValue($val);
            }
        }
    }

    // Restore form values
    public function restoreFormValues()
    {
        global $CurrentForm;
        $this->TaskID->CurrentValue = $this->TaskID->FormValue;
        $this->TaskName->CurrentValue = $this->TaskName->FormValue;
        $this->ResourceID->CurrentValue = $this->ResourceID->FormValue;
        $this->Start->CurrentValue = $this->Start->FormValue;
        $this->Start->CurrentValue = UnFormatDateTime($this->Start->CurrentValue, $this->Start->formatPattern());
        $this->End->CurrentValue = $this->End->FormValue;
        $this->End->CurrentValue = UnFormatDateTime($this->End->CurrentValue, $this->End->formatPattern());
        $this->Description->CurrentValue = $this->Description->FormValue;
        $this->Milestone->CurrentValue = $this->Milestone->FormValue;
        $this->Milestone->CurrentValue = UnFormatDateTime($this->Milestone->CurrentValue, $this->Milestone->formatPattern());
        $this->Duration->CurrentValue = $this->Duration->FormValue;
        $this->PercentComplete->CurrentValue = $this->PercentComplete->FormValue;
        $this->Dependencies->CurrentValue = $this->Dependencies->FormValue;
    }

    // Load recordset
    public function loadRecordset($offset = -1, $rowcnt = -1)
    {
        // Load List page SQL (QueryBuilder)
        $sql = $this->getListSql();

        // Load recordset
        if ($offset > -1) {
            $sql->setFirstResult($offset);
        }
        if ($rowcnt > 0) {
            $sql->setMaxResults($rowcnt);
        }
        $result = $sql->execute();
        $rs = new Recordset($result, $sql);

        // Call Recordset Selected event
        $this->recordsetSelected($rs);
        return $rs;
    }

    // Load records as associative array
    public function loadRows($offset = -1, $rowcnt = -1)
    {
        // Load List page SQL (QueryBuilder)
        $sql = $this->getListSql();

        // Load recordset
        if ($offset > -1) {
            $sql->setFirstResult($offset);
        }
        if ($rowcnt > 0) {
            $sql->setMaxResults($rowcnt);
        }
        $result = $sql->execute();
        return $result->fetchAllAssociative();
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from recordset or record
     *
     * @param Recordset|array $rs Record
     * @return void
     */
    public function loadRowValues($rs = null)
    {
        if (is_array($rs)) {
            $row = $rs;
        } elseif ($rs && property_exists($rs, "fields")) { // Recordset
            $row = $rs->fields;
        } else {
            $row = $this->newRow();
        }
        if (!$row) {
            return;
        }

        // Call Row Selected event
        $this->rowSelected($row);
        $this->TaskID->setDbValue($row['TaskID']);
        $this->TaskName->setDbValue($row['TaskName']);
        $this->ResourceID->setDbValue($row['ResourceID']);
        $this->Start->setDbValue($row['Start']);
        $this->End->setDbValue($row['End']);
        $this->Description->setDbValue($row['Description']);
        $this->Milestone->setDbValue($row['Milestone']);
        $this->Duration->setDbValue($row['Duration']);
        $this->PercentComplete->setDbValue($row['PercentComplete']);
        $this->Dependencies->setDbValue($row['Dependencies']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['TaskID'] = $this->TaskID->DefaultValue;
        $row['TaskName'] = $this->TaskName->DefaultValue;
        $row['ResourceID'] = $this->ResourceID->DefaultValue;
        $row['Start'] = $this->Start->DefaultValue;
        $row['End'] = $this->End->DefaultValue;
        $row['Description'] = $this->Description->DefaultValue;
        $row['Milestone'] = $this->Milestone->DefaultValue;
        $row['Duration'] = $this->Duration->DefaultValue;
        $row['PercentComplete'] = $this->PercentComplete->DefaultValue;
        $row['Dependencies'] = $this->Dependencies->DefaultValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load old record
        if ($this->OldKey != "") {
            $this->setKey($this->OldKey);
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $rs = LoadRecordset($sql, $conn);
            if ($rs && ($row = $rs->fields)) {
                $this->loadRowValues($row); // Load row values
                return $row;
            }
        }
        $this->loadRowValues(); // Load default row values
        return null;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // TaskID
        $this->TaskID->RowCssClass = "row";

        // TaskName
        $this->TaskName->RowCssClass = "row";

        // ResourceID
        $this->ResourceID->RowCssClass = "row";

        // Start
        $this->Start->RowCssClass = "row";

        // End
        $this->End->RowCssClass = "row";

        // Description
        $this->Description->RowCssClass = "row";

        // Milestone
        $this->Milestone->RowCssClass = "row";

        // Duration
        $this->Duration->RowCssClass = "row";

        // PercentComplete
        $this->PercentComplete->RowCssClass = "row";

        // Dependencies
        $this->Dependencies->RowCssClass = "row";

        // View row
        if ($this->RowType == ROWTYPE_VIEW) {
            // TaskID
            $this->TaskID->ViewValue = $this->TaskID->CurrentValue;

            // TaskName
            $this->TaskName->ViewValue = $this->TaskName->CurrentValue;

            // ResourceID
            $this->ResourceID->ViewValue = $this->ResourceID->CurrentValue;

            // Start
            $this->Start->ViewValue = $this->Start->CurrentValue;
            $this->Start->ViewValue = FormatDateTime($this->Start->ViewValue, $this->Start->formatPattern());

            // End
            $this->End->ViewValue = $this->End->CurrentValue;
            $this->End->ViewValue = FormatDateTime($this->End->ViewValue, $this->End->formatPattern());

            // Description
            $this->Description->ViewValue = $this->Description->CurrentValue;

            // Milestone
            $this->Milestone->ViewValue = $this->Milestone->CurrentValue;
            $this->Milestone->ViewValue = FormatDateTime($this->Milestone->ViewValue, $this->Milestone->formatPattern());

            // Duration
            $this->Duration->ViewValue = $this->Duration->CurrentValue;
            $this->Duration->ViewValue = FormatNumber($this->Duration->ViewValue, $this->Duration->formatPattern());

            // PercentComplete
            $this->PercentComplete->ViewValue = $this->PercentComplete->CurrentValue;
            $this->PercentComplete->ViewValue = FormatNumber($this->PercentComplete->ViewValue, $this->PercentComplete->formatPattern());

            // Dependencies
            $this->Dependencies->ViewValue = $this->Dependencies->CurrentValue;

            // TaskID
            $this->TaskID->HrefValue = "";

            // TaskName
            $this->TaskName->HrefValue = "";

            // ResourceID
            $this->ResourceID->HrefValue = "";

            // Start
            $this->Start->HrefValue = "";

            // End
            $this->End->HrefValue = "";

            // Description
            $this->Description->HrefValue = "";

            // Milestone
            $this->Milestone->HrefValue = "";

            // Duration
            $this->Duration->HrefValue = "";

            // PercentComplete
            $this->PercentComplete->HrefValue = "";

            // Dependencies
            $this->Dependencies->HrefValue = "";
        } elseif ($this->RowType == ROWTYPE_EDIT) {
            // TaskID
            $this->TaskID->setupEditAttributes();
            if (!$this->TaskID->Raw) {
                $this->TaskID->CurrentValue = HtmlDecode($this->TaskID->CurrentValue);
            }
            $this->TaskID->EditValue = HtmlEncode($this->TaskID->CurrentValue);
            $this->TaskID->PlaceHolder = RemoveHtml($this->TaskID->caption());

            // TaskName
            $this->TaskName->setupEditAttributes();
            if (!$this->TaskName->Raw) {
                $this->TaskName->CurrentValue = HtmlDecode($this->TaskName->CurrentValue);
            }
            $this->TaskName->EditValue = HtmlEncode($this->TaskName->CurrentValue);
            $this->TaskName->PlaceHolder = RemoveHtml($this->TaskName->caption());

            // ResourceID
            $this->ResourceID->setupEditAttributes();
            if (!$this->ResourceID->Raw) {
                $this->ResourceID->CurrentValue = HtmlDecode($this->ResourceID->CurrentValue);
            }
            $this->ResourceID->EditValue = HtmlEncode($this->ResourceID->CurrentValue);
            $this->ResourceID->PlaceHolder = RemoveHtml($this->ResourceID->caption());

            // Start
            $this->Start->setupEditAttributes();
            $this->Start->EditValue = HtmlEncode(FormatDateTime($this->Start->CurrentValue, $this->Start->formatPattern()));
            $this->Start->PlaceHolder = RemoveHtml($this->Start->caption());

            // End
            $this->End->setupEditAttributes();
            $this->End->EditValue = HtmlEncode(FormatDateTime($this->End->CurrentValue, $this->End->formatPattern()));
            $this->End->PlaceHolder = RemoveHtml($this->End->caption());

            // Description
            $this->Description->setupEditAttributes();
            if (!$this->Description->Raw) {
                $this->Description->CurrentValue = HtmlDecode($this->Description->CurrentValue);
            }
            $this->Description->EditValue = HtmlEncode($this->Description->CurrentValue);
            $this->Description->PlaceHolder = RemoveHtml($this->Description->caption());

            // Milestone
            $this->Milestone->setupEditAttributes();
            $this->Milestone->EditValue = HtmlEncode(FormatDateTime($this->Milestone->CurrentValue, $this->Milestone->formatPattern()));
            $this->Milestone->PlaceHolder = RemoveHtml($this->Milestone->caption());

            // Duration
            $this->Duration->setupEditAttributes();
            $this->Duration->EditValue = HtmlEncode($this->Duration->CurrentValue);
            $this->Duration->PlaceHolder = RemoveHtml($this->Duration->caption());
            if (strval($this->Duration->EditValue) != "" && is_numeric($this->Duration->EditValue)) {
                $this->Duration->EditValue = FormatNumber($this->Duration->EditValue, null);
            }

            // PercentComplete
            $this->PercentComplete->setupEditAttributes();
            $this->PercentComplete->EditValue = HtmlEncode($this->PercentComplete->CurrentValue);
            $this->PercentComplete->PlaceHolder = RemoveHtml($this->PercentComplete->caption());
            if (strval($this->PercentComplete->EditValue) != "" && is_numeric($this->PercentComplete->EditValue)) {
                $this->PercentComplete->EditValue = FormatNumber($this->PercentComplete->EditValue, null);
            }

            // Dependencies
            $this->Dependencies->setupEditAttributes();
            if (!$this->Dependencies->Raw) {
                $this->Dependencies->CurrentValue = HtmlDecode($this->Dependencies->CurrentValue);
            }
            $this->Dependencies->EditValue = HtmlEncode($this->Dependencies->CurrentValue);
            $this->Dependencies->PlaceHolder = RemoveHtml($this->Dependencies->caption());

            // Edit refer script

            // TaskID
            $this->TaskID->HrefValue = "";

            // TaskName
            $this->TaskName->HrefValue = "";

            // ResourceID
            $this->ResourceID->HrefValue = "";

            // Start
            $this->Start->HrefValue = "";

            // End
            $this->End->HrefValue = "";

            // Description
            $this->Description->HrefValue = "";

            // Milestone
            $this->Milestone->HrefValue = "";

            // Duration
            $this->Duration->HrefValue = "";

            // PercentComplete
            $this->PercentComplete->HrefValue = "";

            // Dependencies
            $this->Dependencies->HrefValue = "";
        }
        if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != ROWTYPE_AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate form
    protected function validateForm()
    {
        global $Language, $Security;

        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        $validateForm = true;
        if ($this->TaskID->Required) {
            if (!$this->TaskID->IsDetailKey && EmptyValue($this->TaskID->FormValue)) {
                $this->TaskID->addErrorMessage(str_replace("%s", $this->TaskID->caption(), $this->TaskID->RequiredErrorMessage));
            }
        }
        if ($this->TaskName->Required) {
            if (!$this->TaskName->IsDetailKey && EmptyValue($this->TaskName->FormValue)) {
                $this->TaskName->addErrorMessage(str_replace("%s", $this->TaskName->caption(), $this->TaskName->RequiredErrorMessage));
            }
        }
        if ($this->ResourceID->Required) {
            if (!$this->ResourceID->IsDetailKey && EmptyValue($this->ResourceID->FormValue)) {
                $this->ResourceID->addErrorMessage(str_replace("%s", $this->ResourceID->caption(), $this->ResourceID->RequiredErrorMessage));
            }
        }
        if ($this->Start->Required) {
            if (!$this->Start->IsDetailKey && EmptyValue($this->Start->FormValue)) {
                $this->Start->addErrorMessage(str_replace("%s", $this->Start->caption(), $this->Start->RequiredErrorMessage));
            }
        }
        if (!CheckDate($this->Start->FormValue, $this->Start->formatPattern())) {
            $this->Start->addErrorMessage($this->Start->getErrorMessage(false));
        }
        if ($this->End->Required) {
            if (!$this->End->IsDetailKey && EmptyValue($this->End->FormValue)) {
                $this->End->addErrorMessage(str_replace("%s", $this->End->caption(), $this->End->RequiredErrorMessage));
            }
        }
        if (!CheckDate($this->End->FormValue, $this->End->formatPattern())) {
            $this->End->addErrorMessage($this->End->getErrorMessage(false));
        }
        if ($this->Description->Required) {
            if (!$this->Description->IsDetailKey && EmptyValue($this->Description->FormValue)) {
                $this->Description->addErrorMessage(str_replace("%s", $this->Description->caption(), $this->Description->RequiredErrorMessage));
            }
        }
        if ($this->Milestone->Required) {
            if (!$this->Milestone->IsDetailKey && EmptyValue($this->Milestone->FormValue)) {
                $this->Milestone->addErrorMessage(str_replace("%s", $this->Milestone->caption(), $this->Milestone->RequiredErrorMessage));
            }
        }
        if (!CheckDate($this->Milestone->FormValue, $this->Milestone->formatPattern())) {
            $this->Milestone->addErrorMessage($this->Milestone->getErrorMessage(false));
        }
        if ($this->Duration->Required) {
            if (!$this->Duration->IsDetailKey && EmptyValue($this->Duration->FormValue)) {
                $this->Duration->addErrorMessage(str_replace("%s", $this->Duration->caption(), $this->Duration->RequiredErrorMessage));
            }
        }
        if (!CheckNumber($this->Duration->FormValue)) {
            $this->Duration->addErrorMessage($this->Duration->getErrorMessage(false));
        }
        if ($this->PercentComplete->Required) {
            if (!$this->PercentComplete->IsDetailKey && EmptyValue($this->PercentComplete->FormValue)) {
                $this->PercentComplete->addErrorMessage(str_replace("%s", $this->PercentComplete->caption(), $this->PercentComplete->RequiredErrorMessage));
            }
        }
        if (!CheckNumber($this->PercentComplete->FormValue)) {
            $this->PercentComplete->addErrorMessage($this->PercentComplete->getErrorMessage(false));
        }
        if ($this->Dependencies->Required) {
            if (!$this->Dependencies->IsDetailKey && EmptyValue($this->Dependencies->FormValue)) {
                $this->Dependencies->addErrorMessage(str_replace("%s", $this->Dependencies->caption(), $this->Dependencies->RequiredErrorMessage));
            }
        }

        // Return validate result
        $validateForm = $validateForm && !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Update record based on key values
    protected function editRow()
    {
        global $Security, $Language;
        $oldKeyFilter = $this->getRecordFilter();
        $filter = $this->applyUserIDFilters($oldKeyFilter);
        $conn = $this->getConnection();

        // Load old row
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $rsold = $conn->fetchAssociative($sql);
        if (!$rsold) {
            $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
            return false; // Update Failed
        } else {
            // Save old values
            $this->loadDbValues($rsold);
        }

        // Set new row
        $rsnew = [];

        // TaskID
        $this->TaskID->setDbValueDef($rsnew, $this->TaskID->CurrentValue, $this->TaskID->ReadOnly);

        // TaskName
        $this->TaskName->setDbValueDef($rsnew, $this->TaskName->CurrentValue, $this->TaskName->ReadOnly);

        // ResourceID
        $this->ResourceID->setDbValueDef($rsnew, $this->ResourceID->CurrentValue, $this->ResourceID->ReadOnly);

        // Start
        $this->Start->setDbValueDef($rsnew, UnFormatDateTime($this->Start->CurrentValue, $this->Start->formatPattern()), $this->Start->ReadOnly);

        // End
        $this->End->setDbValueDef($rsnew, UnFormatDateTime($this->End->CurrentValue, $this->End->formatPattern()), $this->End->ReadOnly);

        // Description
        $this->Description->setDbValueDef($rsnew, $this->Description->CurrentValue, $this->Description->ReadOnly);

        // Milestone
        $this->Milestone->setDbValueDef($rsnew, UnFormatDateTime($this->Milestone->CurrentValue, $this->Milestone->formatPattern()), $this->Milestone->ReadOnly);

        // Duration
        $this->Duration->setDbValueDef($rsnew, $this->Duration->CurrentValue, $this->Duration->ReadOnly);

        // PercentComplete
        $this->PercentComplete->setDbValueDef($rsnew, $this->PercentComplete->CurrentValue, $this->PercentComplete->ReadOnly);

        // Dependencies
        $this->Dependencies->setDbValueDef($rsnew, $this->Dependencies->CurrentValue, $this->Dependencies->ReadOnly);

        // Update current values
        $this->setCurrentValues($rsnew);

        // Call Row Updating event
        $updateRow = $this->rowUpdating($rsold, $rsnew);

        // Check for duplicate key when key changed
        if ($updateRow) {
            $newKeyFilter = $this->getRecordFilter($rsnew);
            if ($newKeyFilter != $oldKeyFilter) {
                $rsChk = $this->loadRs($newKeyFilter)->fetch();
                if ($rsChk !== false) {
                    $keyErrMsg = str_replace("%f", $newKeyFilter, $Language->phrase("DupKey"));
                    $this->setFailureMessage($keyErrMsg);
                    $updateRow = false;
                }
            }
        }
        if ($updateRow) {
            if (count($rsnew) > 0) {
                $this->CurrentFilter = $filter; // Set up current filter
                $editRow = $this->update($rsnew, "", $rsold);
                if (!$editRow && !EmptyValue($this->DbErrorMessage)) { // Show database error
                    $this->setFailureMessage($this->DbErrorMessage);
                }
            } else {
                $editRow = true; // No field to update
            }
            if ($editRow) {
            }
        } else {
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("UpdateCancelled"));
            }
            $editRow = false;
        }

        // Call Row_Updated event
        if ($editRow) {
            $this->rowUpdated($rsold, $rsnew);
        }

        // Write JSON response
        if (IsJsonResponse() && $editRow) {
            $row = $this->getRecordsFromRecordset([$rsnew], true);
            $table = $this->TableVar;
            WriteJson(["success" => true, "action" => Config("API_EDIT_ACTION"), $table => $row]);
        }
        return $editRow;
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("index");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("taskslist"), "", $this->TableVar, true);
        $pageId = "edit";
        $Breadcrumb->add("edit", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup !== null && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Set up starting record parameters
    public function setupStartRecord()
    {
        if ($this->DisplayRecords == 0) {
            return;
        }
        $pageNo = Get(Config("TABLE_PAGE_NUMBER"));
        $startRec = Get(Config("TABLE_START_REC"));
        $infiniteScroll = false;
        $recordNo = $pageNo ?? $startRec; // Record number = page number or start record
        if ($recordNo !== null && is_numeric($recordNo)) {
            $this->StartRecord = $recordNo;
        } else {
            $this->StartRecord = $this->getStartRecordNumber();
        }

        // Check if correct start record counter
        if (!is_numeric($this->StartRecord) || intval($this->StartRecord) <= 0) { // Avoid invalid start record counter
            $this->StartRecord = 1; // Reset start record counter
        } elseif ($this->StartRecord > $this->TotalRecords) { // Avoid starting record > total records
            $this->StartRecord = (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to last page first record
        } elseif (($this->StartRecord - 1) % $this->DisplayRecords != 0) {
            $this->StartRecord = (int)(($this->StartRecord - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to page boundary
        }
        if (!$infiniteScroll) {
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Get page count
    public function pageCount() {
        return ceil($this->TotalRecords / $this->DisplayRecords);
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == 'success') {
            //$msg = "your success message";
        } elseif ($type == 'failure') {
            //$msg = "your failure message";
        } elseif ($type == 'warning') {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
