<?php

namespace PHPMaker2023\Jack_Jill_school;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\FetchMode;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;

/**
 * Table class for student
 */
class Student extends DbTable
{
    protected $SqlFrom = "";
    protected $SqlSelect = null;
    protected $SqlSelectList = null;
    protected $SqlWhere = "";
    protected $SqlGroupBy = "";
    protected $SqlHaving = "";
    protected $SqlOrderBy = "";
    public $DbErrorMessage = "";
    public $UseSessionForListSql = true;

    // Column CSS classes
    public $LeftColumnClass = "col-sm-4 col-form-label ew-label";
    public $RightColumnClass = "col-sm-8";
    public $OffsetColumnClass = "col-sm-8 offset-sm-4";
    public $TableLeftColumnClass = "w-col-4";

    // Audit trail
    public $AuditTrailOnAdd = true;
    public $AuditTrailOnEdit = true;
    public $AuditTrailOnDelete = true;
    public $AuditTrailOnView = false;
    public $AuditTrailOnViewData = false;
    public $AuditTrailOnSearch = false;

    // Ajax / Modal
    public $UseAjaxActions = false;
    public $ModalSearch = false;
    public $ModalView = true;
    public $ModalAdd = true;
    public $ModalEdit = true;
    public $ModalUpdate = true;
    public $InlineDelete = true;
    public $ModalGridAdd = false;
    public $ModalGridEdit = false;
    public $ModalMultiEdit = false;

    // Fields
    public $studentID;
    public $PIN;
    public $Last_Name;
    public $First_Name;
    public $Gender;
    public $Date_Of_Birth;
    public $Place_Of_Birth;
    public $Card_No;
    public $Unique_QR;
    public $Photo;
    public $Address;
    public $Start_Date;
    public $Expiry_Date;
    public $SClass;
    public $Contact_Incase;
    public $Contact_Tel;
    public $Reference;
    public $EmployeeID;
    public $Status;

    // Page ID
    public $PageID = ""; // To be overridden by subclass

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $CurrentLanguage, $CurrentLocale;

        // Language object
        $Language = Container("language");
        $this->TableVar = "student";
        $this->TableName = 'student';
        $this->TableType = "TABLE";
        $this->ImportUseTransaction = $this->supportsTransaction() && Config("IMPORT_USE_TRANSACTION");
        $this->UseTransaction = $this->supportsTransaction() && Config("USE_TRANSACTION");

        // Update Table
        $this->UpdateTable = "student";
        $this->Dbid = 'DB';
        $this->ExportAll = false;
        $this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)

        // PDF
        $this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
        $this->ExportPageSize = "a4"; // Page size (PDF only)

        // PhpSpreadsheet
        $this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
        $this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)

        // PHPWord
        $this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
        $this->ExportWordPageSize = "A4"; // Page orientation (PHPWord only)
        $this->ExportWordColumnWidth = null; // Cell width (PHPWord only)
        $this->DetailAdd = false; // Allow detail add
        $this->DetailEdit = false; // Allow detail edit
        $this->DetailView = false; // Allow detail view
        $this->ShowMultipleDetails = false; // Show multiple details
        $this->GridAddRowCount = 5;
        $this->AllowAddDeleteRow = true; // Allow add/delete row
        $this->UseAjaxActions = $this->UseAjaxActions || Config("USE_AJAX_ACTIONS");
        $this->UseColumnVisibility = true;
        $this->UserIDAllowSecurity = Config("DEFAULT_USER_ID_ALLOW_SECURITY"); // Default User ID allowed permissions
        $this->BasicSearch = new BasicSearch($this);

        // studentID
        $this->studentID = new DbField(
            $this, // Table
            'x_studentID', // Variable name
            'studentID', // Name
            '`studentID`', // Expression
            '`studentID`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`studentID`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->studentID->InputTextType = "text";
        $this->studentID->IsPrimaryKey = true; // Primary key field
        $this->studentID->Nullable = false; // NOT NULL field
        $this->studentID->Required = true; // Required field
        $this->studentID->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->studentID->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['studentID'] = &$this->studentID;

        // PIN
        $this->PIN = new DbField(
            $this, // Table
            'x_PIN', // Variable name
            'PIN', // Name
            '`PIN`', // Expression
            '`PIN`', // Basic search expression
            200, // Type
            57, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`PIN`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->PIN->InputTextType = "text";
        switch ($CurrentLanguage) {
            case "en-US":
                $this->PIN->Lookup = new Lookup('PIN', 'student', true, 'PIN', ["PIN","","",""], '', '', [], [], [], [], [], [], '', '', "`PIN`");
                break;
            case "fr":
                $this->PIN->Lookup = new Lookup('PIN', 'student', true, 'PIN', ["PIN","","",""], '', '', [], [], [], [], [], [], '', '', "`PIN`");
                break;
            default:
                $this->PIN->Lookup = new Lookup('PIN', 'student', true, 'PIN', ["PIN","","",""], '', '', [], [], [], [], [], [], '', '', "`PIN`");
                break;
        }
        $this->PIN->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['PIN'] = &$this->PIN;

        // Last_Name
        $this->Last_Name = new DbField(
            $this, // Table
            'x_Last_Name', // Variable name
            'Last_Name', // Name
            '`Last_Name`', // Expression
            '`Last_Name`', // Basic search expression
            201, // Type
            260, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Last_Name`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->Last_Name->InputTextType = "text";
        $this->Last_Name->Nullable = false; // NOT NULL field
        $this->Last_Name->Required = true; // Required field
        switch ($CurrentLanguage) {
            case "en-US":
                $this->Last_Name->Lookup = new Lookup('Last_Name', 'student', true, 'Last_Name', ["Last_Name","","",""], '', '', [], [], [], [], [], [], '', '', "`Last_Name`");
                break;
            case "fr":
                $this->Last_Name->Lookup = new Lookup('Last_Name', 'student', true, 'Last_Name', ["Last_Name","","",""], '', '', [], [], [], [], [], [], '', '', "`Last_Name`");
                break;
            default:
                $this->Last_Name->Lookup = new Lookup('Last_Name', 'student', true, 'Last_Name', ["Last_Name","","",""], '', '', [], [], [], [], [], [], '', '', "`Last_Name`");
                break;
        }
        $this->Last_Name->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['Last_Name'] = &$this->Last_Name;

        // First_Name
        $this->First_Name = new DbField(
            $this, // Table
            'x_First_Name', // Variable name
            'First_Name', // Name
            '`First_Name`', // Expression
            '`First_Name`', // Basic search expression
            200, // Type
            60, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`First_Name`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->First_Name->InputTextType = "text";
        $this->First_Name->Nullable = false; // NOT NULL field
        $this->First_Name->Required = true; // Required field
        $this->First_Name->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['First_Name'] = &$this->First_Name;

        // Gender
        $this->Gender = new DbField(
            $this, // Table
            'x_Gender', // Variable name
            'Gender', // Name
            '`Gender`', // Expression
            '`Gender`', // Basic search expression
            200, // Type
            12, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Gender`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->Gender->InputTextType = "text";
        $this->Gender->setSelectMultiple(false); // Select one
        $this->Gender->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->Gender->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        switch ($CurrentLanguage) {
            case "en-US":
                $this->Gender->Lookup = new Lookup('Gender', 'student', false, '', ["","","",""], '', '', [], [], [], [], [], [], '', '', "");
                break;
            case "fr":
                $this->Gender->Lookup = new Lookup('Gender', 'student', false, '', ["","","",""], '', '', [], [], [], [], [], [], '', '', "");
                break;
            default:
                $this->Gender->Lookup = new Lookup('Gender', 'student', false, '', ["","","",""], '', '', [], [], [], [], [], [], '', '', "");
                break;
        }
        $this->Gender->OptionCount = 2;
        $this->Gender->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['Gender'] = &$this->Gender;

        // Date_Of_Birth
        $this->Date_Of_Birth = new DbField(
            $this, // Table
            'x_Date_Of_Birth', // Variable name
            'Date_Of_Birth', // Name
            '`Date_Of_Birth`', // Expression
            CastDateFieldForLike("`Date_Of_Birth`", 7, "DB"), // Basic search expression
            133, // Type
            10, // Size
            7, // Date/Time format
            false, // Is upload field
            '`Date_Of_Birth`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->Date_Of_Birth->InputTextType = "text";
        $this->Date_Of_Birth->DefaultErrorMessage = str_replace("%s", DateFormat(7), $Language->phrase("IncorrectDate"));
        $this->Date_Of_Birth->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['Date_Of_Birth'] = &$this->Date_Of_Birth;

        // Place_Of_Birth
        $this->Place_Of_Birth = new DbField(
            $this, // Table
            'x_Place_Of_Birth', // Variable name
            'Place_Of_Birth', // Name
            '`Place_Of_Birth`', // Expression
            '`Place_Of_Birth`', // Basic search expression
            200, // Type
            50, // Size
            7, // Date/Time format
            false, // Is upload field
            '`Place_Of_Birth`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->Place_Of_Birth->InputTextType = "text";
        $this->Place_Of_Birth->Nullable = false; // NOT NULL field
        $this->Place_Of_Birth->Required = true; // Required field
        $this->Place_Of_Birth->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['Place_Of_Birth'] = &$this->Place_Of_Birth;

        // Card_No
        $this->Card_No = new DbField(
            $this, // Table
            'x_Card_No', // Variable name
            'Card_No', // Name
            '`Card_No`', // Expression
            '`Card_No`', // Basic search expression
            200, // Type
            20, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Card_No`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->Card_No->InputTextType = "text";
        $this->Card_No->Nullable = false; // NOT NULL field
        $this->Card_No->Required = true; // Required field
        switch ($CurrentLanguage) {
            case "en-US":
                $this->Card_No->Lookup = new Lookup('Card_No', 'student', true, 'Card_No', ["Card_No","","",""], '', '', [], [], [], [], [], [], '', '', "`Card_No`");
                break;
            case "fr":
                $this->Card_No->Lookup = new Lookup('Card_No', 'student', true, 'Card_No', ["Card_No","","",""], '', '', [], [], [], [], [], [], '', '', "`Card_No`");
                break;
            default:
                $this->Card_No->Lookup = new Lookup('Card_No', 'student', true, 'Card_No', ["Card_No","","",""], '', '', [], [], [], [], [], [], '', '', "`Card_No`");
                break;
        }
        $this->Card_No->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['Card_No'] = &$this->Card_No;

        // Unique_QR
        $this->Unique_QR = new DbField(
            $this, // Table
            'x_Unique_QR', // Variable name
            'Unique_QR', // Name
            '`Unique_QR`', // Expression
            '`Unique_QR`', // Basic search expression
            200, // Type
            12, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Unique_QR`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->Unique_QR->InputTextType = "text";
        $this->Unique_QR->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['Unique_QR'] = &$this->Unique_QR;

        // Photo
        $this->Photo = new DbField(
            $this, // Table
            'x_Photo', // Variable name
            'Photo', // Name
            '`Photo`', // Expression
            '`Photo`', // Basic search expression
            200, // Type
            60, // Size
            -1, // Date/Time format
            true, // Is upload field
            '`Photo`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'IMAGE', // View Tag
            'FILE' // Edit Tag
        );
        $this->Photo->addMethod("getUploadPath", fn() => "upload/students/");
        $this->Photo->InputTextType = "text";
        $this->Photo->SearchOperators = ["=", "<>", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['Photo'] = &$this->Photo;

        // Address
        $this->Address = new DbField(
            $this, // Table
            'x_Address', // Variable name
            'Address', // Name
            '`Address`', // Expression
            '`Address`', // Basic search expression
            200, // Type
            100, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Address`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->Address->InputTextType = "text";
        $this->Address->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['Address'] = &$this->Address;

        // Start_Date
        $this->Start_Date = new DbField(
            $this, // Table
            'x_Start_Date', // Variable name
            'Start_Date', // Name
            '`Start_Date`', // Expression
            CastDateFieldForLike("`Start_Date`", 7, "DB"), // Basic search expression
            133, // Type
            10, // Size
            7, // Date/Time format
            false, // Is upload field
            '`Start_Date`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->Start_Date->InputTextType = "text";
        $this->Start_Date->DefaultErrorMessage = str_replace("%s", DateFormat(7), $Language->phrase("IncorrectDate"));
        $this->Start_Date->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['Start_Date'] = &$this->Start_Date;

        // Expiry_Date
        $this->Expiry_Date = new DbField(
            $this, // Table
            'x_Expiry_Date', // Variable name
            'Expiry_Date', // Name
            '`Expiry_Date`', // Expression
            CastDateFieldForLike("`Expiry_Date`", 7, "DB"), // Basic search expression
            133, // Type
            10, // Size
            7, // Date/Time format
            false, // Is upload field
            '`Expiry_Date`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->Expiry_Date->InputTextType = "text";
        $this->Expiry_Date->DefaultErrorMessage = str_replace("%s", DateFormat(7), $Language->phrase("IncorrectDate"));
        $this->Expiry_Date->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['Expiry_Date'] = &$this->Expiry_Date;

        // SClass
        $this->SClass = new DbField(
            $this, // Table
            'x_SClass', // Variable name
            'SClass', // Name
            '`SClass`', // Expression
            '`SClass`', // Basic search expression
            200, // Type
            60, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`SClass`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->SClass->InputTextType = "text";
        $this->SClass->Nullable = false; // NOT NULL field
        $this->SClass->Required = true; // Required field
        $this->SClass->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['SClass'] = &$this->SClass;

        // Contact_Incase
        $this->Contact_Incase = new DbField(
            $this, // Table
            'x_Contact_Incase', // Variable name
            'Contact_Incase', // Name
            '`Contact_Incase`', // Expression
            '`Contact_Incase`', // Basic search expression
            200, // Type
            70, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Contact_Incase`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->Contact_Incase->InputTextType = "text";
        $this->Contact_Incase->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['Contact_Incase'] = &$this->Contact_Incase;

        // Contact_Tel
        $this->Contact_Tel = new DbField(
            $this, // Table
            'x_Contact_Tel', // Variable name
            'Contact_Tel', // Name
            '`Contact_Tel`', // Expression
            '`Contact_Tel`', // Basic search expression
            200, // Type
            25, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Contact_Tel`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->Contact_Tel->InputTextType = "text";
        $this->Contact_Tel->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['Contact_Tel'] = &$this->Contact_Tel;

        // Reference
        $this->Reference = new DbField(
            $this, // Table
            'x_Reference', // Variable name
            'Reference', // Name
            '`Reference`', // Expression
            '`Reference`', // Basic search expression
            200, // Type
            100, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Reference`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->Reference->InputTextType = "text";
        $this->Reference->Nullable = false; // NOT NULL field
        $this->Reference->Required = true; // Required field
        $this->Reference->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['Reference'] = &$this->Reference;

        // EmployeeID
        $this->EmployeeID = new DbField(
            $this, // Table
            'x_EmployeeID', // Variable name
            'EmployeeID', // Name
            '`EmployeeID`', // Expression
            '`EmployeeID`', // Basic search expression
            16, // Type
            4, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`EmployeeID`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->EmployeeID->InputTextType = "text";
        $this->EmployeeID->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->EmployeeID->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['EmployeeID'] = &$this->EmployeeID;

        // Status
        $this->Status = new DbField(
            $this, // Table
            'x_Status', // Variable name
            'Status', // Name
            '`Status`', // Expression
            '`Status`', // Basic search expression
            200, // Type
            50, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Status`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->Status->InputTextType = "text";
        $this->Status->setSelectMultiple(false); // Select one
        $this->Status->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->Status->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        switch ($CurrentLanguage) {
            case "en-US":
                $this->Status->Lookup = new Lookup('Status', 'student', false, '', ["","","",""], '', '', [], [], [], [], [], [], '', '', "");
                break;
            case "fr":
                $this->Status->Lookup = new Lookup('Status', 'student', false, '', ["","","",""], '', '', [], [], [], [], [], [], '', '', "");
                break;
            default:
                $this->Status->Lookup = new Lookup('Status', 'student', false, '', ["","","",""], '', '', [], [], [], [], [], [], '', '', "");
                break;
        }
        $this->Status->OptionCount = 5;
        $this->Status->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['Status'] = &$this->Status;

        // Add Doctrine Cache
        $this->Cache = new ArrayCache();
        $this->CacheProfile = new \Doctrine\DBAL\Cache\QueryCacheProfile(0, $this->TableVar);

        // Call Table Load event
        $this->tableLoad();
    }

    // Field Visibility
    public function getFieldVisibility($fldParm)
    {
        global $Security;
        return $this->$fldParm->Visible; // Returns original value
    }

    // Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
    public function setLeftColumnClass($class)
    {
        if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
            $this->LeftColumnClass = $class . " col-form-label ew-label";
            $this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
            $this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
            $this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
        }
    }

    // Single column sort
    public function updateSort(&$fld)
    {
        if ($this->CurrentOrder == $fld->Name) {
            $sortField = $fld->Expression;
            $lastSort = $fld->getSort();
            if (in_array($this->CurrentOrderType, ["ASC", "DESC", "NO"])) {
                $curSort = $this->CurrentOrderType;
            } else {
                $curSort = $lastSort;
            }
            $orderBy = in_array($curSort, ["ASC", "DESC"]) ? $sortField . " " . $curSort : "";
            $this->setSessionOrderBy($orderBy); // Save to Session
        }
    }

    // Update field sort
    public function updateFieldSort()
    {
        $orderBy = $this->getSessionOrderBy(); // Get ORDER BY from Session
        $flds = GetSortFields($orderBy);
        foreach ($this->Fields as $field) {
            $fldSort = "";
            foreach ($flds as $fld) {
                if ($fld[0] == $field->Expression || $fld[0] == $field->VirtualExpression) {
                    $fldSort = $fld[1];
                }
            }
            $field->setSort($fldSort);
        }
    }

    // Render X Axis for chart
    public function renderChartXAxis($chartVar, $chartRow)
    {
        return $chartRow;
    }

    // Table level SQL
    public function getSqlFrom() // From
    {
        return ($this->SqlFrom != "") ? $this->SqlFrom : "student";
    }

    public function sqlFrom() // For backward compatibility
    {
        return $this->getSqlFrom();
    }

    public function setSqlFrom($v)
    {
        $this->SqlFrom = $v;
    }

    public function getSqlSelect() // Select
    {
        return $this->SqlSelect ?? $this->getQueryBuilder()->select("*");
    }

    public function sqlSelect() // For backward compatibility
    {
        return $this->getSqlSelect();
    }

    public function setSqlSelect($v)
    {
        $this->SqlSelect = $v;
    }

    public function getSqlWhere() // Where
    {
        $where = ($this->SqlWhere != "") ? $this->SqlWhere : "";
        $this->DefaultFilter = "";
        AddFilter($where, $this->DefaultFilter);
        return $where;
    }

    public function sqlWhere() // For backward compatibility
    {
        return $this->getSqlWhere();
    }

    public function setSqlWhere($v)
    {
        $this->SqlWhere = $v;
    }

    public function getSqlGroupBy() // Group By
    {
        return ($this->SqlGroupBy != "") ? $this->SqlGroupBy : "";
    }

    public function sqlGroupBy() // For backward compatibility
    {
        return $this->getSqlGroupBy();
    }

    public function setSqlGroupBy($v)
    {
        $this->SqlGroupBy = $v;
    }

    public function getSqlHaving() // Having
    {
        return ($this->SqlHaving != "") ? $this->SqlHaving : "";
    }

    public function sqlHaving() // For backward compatibility
    {
        return $this->getSqlHaving();
    }

    public function setSqlHaving($v)
    {
        $this->SqlHaving = $v;
    }

    public function getSqlOrderBy() // Order By
    {
        return ($this->SqlOrderBy != "") ? $this->SqlOrderBy : "";
    }

    public function sqlOrderBy() // For backward compatibility
    {
        return $this->getSqlOrderBy();
    }

    public function setSqlOrderBy($v)
    {
        $this->SqlOrderBy = $v;
    }

    // Apply User ID filters
    public function applyUserIDFilters($filter, $id = "")
    {
        return $filter;
    }

    // Check if User ID security allows view all
    public function userIDAllow($id = "")
    {
        $allow = $this->UserIDAllowSecurity;
        switch ($id) {
            case "add":
            case "copy":
            case "gridadd":
            case "register":
            case "addopt":
                return (($allow & 1) == 1);
            case "edit":
            case "gridedit":
            case "update":
            case "changepassword":
            case "resetpassword":
                return (($allow & 4) == 4);
            case "delete":
                return (($allow & 2) == 2);
            case "view":
                return (($allow & 32) == 32);
            case "search":
                return (($allow & 64) == 64);
            case "lookup":
                return (($allow & 256) == 256);
            default:
                return (($allow & 8) == 8);
        }
    }

    /**
     * Get record count
     *
     * @param string|QueryBuilder $sql SQL or QueryBuilder
     * @param mixed $c Connection
     * @return int
     */
    public function getRecordCount($sql, $c = null)
    {
        $cnt = -1;
        $rs = null;
        if ($sql instanceof QueryBuilder) { // Query builder
            $sqlwrk = clone $sql;
            $sqlwrk = $sqlwrk->resetQueryPart("orderBy")->getSQL();
        } else {
            $sqlwrk = $sql;
        }
        $pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';
        // Skip Custom View / SubQuery / SELECT DISTINCT / ORDER BY
        if (
            ($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
            preg_match($pattern, $sqlwrk) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sqlwrk) &&
            !preg_match('/^\s*select\s+distinct\s+/i', $sqlwrk) && !preg_match('/\s+order\s+by\s+/i', $sqlwrk)
        ) {
            $sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sqlwrk);
        } else {
            $sqlwrk = "SELECT COUNT(*) FROM (" . $sqlwrk . ") COUNT_TABLE";
        }
        $conn = $c ?? $this->getConnection();
        $cnt = $conn->fetchOne($sqlwrk);
        if ($cnt !== false) {
            return (int)$cnt;
        }

        // Unable to get count by SELECT COUNT(*), execute the SQL to get record count directly
        return ExecuteRecordCount($sql, $conn);
    }

    // Get SQL
    public function getSql($where, $orderBy = "")
    {
        return $this->getSqlAsQueryBuilder($where, $orderBy)->getSQL();
    }

    // Get QueryBuilder
    public function getSqlAsQueryBuilder($where, $orderBy = "")
    {
        return $this->buildSelectSql(
            $this->getSqlSelect(),
            $this->getSqlFrom(),
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $where,
            $orderBy
        );
    }

    // Table SQL
    public function getCurrentSql()
    {
        $filter = $this->CurrentFilter;
        $filter = $this->applyUserIDFilters($filter);
        $sort = $this->getSessionOrderBy();
        return $this->getSql($filter, $sort);
    }

    /**
     * Table SQL with List page filter
     *
     * @return QueryBuilder
     */
    public function getListSql()
    {
        $filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $select = $this->getSqlSelect();
        $from = $this->getSqlFrom();
        $sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
        $this->Sort = $sort;
        return $this->buildSelectSql(
            $select,
            $from,
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $filter,
            $sort
        );
    }

    // Get ORDER BY clause
    public function getOrderBy()
    {
        $orderBy = $this->getSqlOrderBy();
        $sort = $this->getSessionOrderBy();
        if ($orderBy != "" && $sort != "") {
            $orderBy .= ", " . $sort;
        } elseif ($sort != "") {
            $orderBy = $sort;
        }
        return $orderBy;
    }

    // Get record count based on filter (for detail record count in master table pages)
    public function loadRecordCount($filter)
    {
        $origFilter = $this->CurrentFilter;
        $this->CurrentFilter = $filter;
        $this->recordsetSelecting($this->CurrentFilter);
        $select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
        $having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
        $cnt = $this->getRecordCount($sql);
        $this->CurrentFilter = $origFilter;
        return $cnt;
    }

    // Get record count (for current List page)
    public function listRecordCount()
    {
        $filter = $this->getSessionWhere();
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
        $having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
        $cnt = $this->getRecordCount($sql);
        return $cnt;
    }

    /**
     * INSERT statement
     *
     * @param mixed $rs
     * @return QueryBuilder
     */
    public function insertSql(&$rs)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->insert($this->UpdateTable);
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom) {
                continue;
            }
            $type = GetParameterType($this->Fields[$name], $value, $this->Dbid);
            $queryBuilder->setValue($this->Fields[$name]->Expression, $queryBuilder->createPositionalParameter($value, $type));
        }
        return $queryBuilder;
    }

    // Insert
    public function insert(&$rs)
    {
        $conn = $this->getConnection();
        try {
            $success = $this->insertSql($rs)->execute();
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $success = false;
            $this->DbErrorMessage = $e->getMessage();
        }
        if ($success) {
            if ($this->AuditTrailOnAdd) {
                $this->writeAuditTrailOnAdd($rs);
            }
        }
        return $success;
    }

    /**
     * UPDATE statement
     *
     * @param array $rs Data to be updated
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function updateSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->update($this->UpdateTable);
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom || $this->Fields[$name]->IsAutoIncrement) {
                continue;
            }
            $type = GetParameterType($this->Fields[$name], $value, $this->Dbid);
            $queryBuilder->set($this->Fields[$name]->Expression, $queryBuilder->createPositionalParameter($value, $type));
        }
        $filter = ($curfilter) ? $this->CurrentFilter : "";
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        AddFilter($filter, $where);
        if ($filter != "") {
            $queryBuilder->where($filter);
        }
        return $queryBuilder;
    }

    // Update
    public function update(&$rs, $where = "", $rsold = null, $curfilter = true)
    {
        // If no field is updated, execute may return 0. Treat as success
        try {
            $success = $this->updateSql($rs, $where, $curfilter)->execute();
            $success = ($success > 0) ? $success : true;
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $success = false;
            $this->DbErrorMessage = $e->getMessage();
        }
        if ($success && $this->AuditTrailOnEdit && $rsold) {
            $rsaudit = $rs;
            $fldname = 'studentID';
            if (!array_key_exists($fldname, $rsaudit)) {
                $rsaudit[$fldname] = $rsold[$fldname];
            }
            $this->writeAuditTrailOnEdit($rsold, $rsaudit);
        }
        return $success;
    }

    /**
     * DELETE statement
     *
     * @param array $rs Key values
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function deleteSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->delete($this->UpdateTable);
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        if ($rs) {
            if (array_key_exists('studentID', $rs)) {
                AddFilter($where, QuotedName('studentID', $this->Dbid) . '=' . QuotedValue($rs['studentID'], $this->studentID->DataType, $this->Dbid));
            }
        }
        $filter = ($curfilter) ? $this->CurrentFilter : "";
        AddFilter($filter, $where);
        return $queryBuilder->where($filter != "" ? $filter : "0=1");
    }

    // Delete
    public function delete(&$rs, $where = "", $curfilter = false)
    {
        $success = true;
        if ($success) {
            try {
                $success = $this->deleteSql($rs, $where, $curfilter)->execute();
                $this->DbErrorMessage = "";
            } catch (\Exception $e) {
                $success = false;
                $this->DbErrorMessage = $e->getMessage();
            }
        }
        if ($success && $this->AuditTrailOnDelete) {
            $this->writeAuditTrailOnDelete($rs);
        }
        return $success;
    }

    // Load DbValue from recordset or array
    protected function loadDbValues($row)
    {
        if (!is_array($row)) {
            return;
        }
        $this->studentID->DbValue = $row['studentID'];
        $this->PIN->DbValue = $row['PIN'];
        $this->Last_Name->DbValue = $row['Last_Name'];
        $this->First_Name->DbValue = $row['First_Name'];
        $this->Gender->DbValue = $row['Gender'];
        $this->Date_Of_Birth->DbValue = $row['Date_Of_Birth'];
        $this->Place_Of_Birth->DbValue = $row['Place_Of_Birth'];
        $this->Card_No->DbValue = $row['Card_No'];
        $this->Unique_QR->DbValue = $row['Unique_QR'];
        $this->Photo->Upload->DbValue = $row['Photo'];
        $this->Address->DbValue = $row['Address'];
        $this->Start_Date->DbValue = $row['Start_Date'];
        $this->Expiry_Date->DbValue = $row['Expiry_Date'];
        $this->SClass->DbValue = $row['SClass'];
        $this->Contact_Incase->DbValue = $row['Contact_Incase'];
        $this->Contact_Tel->DbValue = $row['Contact_Tel'];
        $this->Reference->DbValue = $row['Reference'];
        $this->EmployeeID->DbValue = $row['EmployeeID'];
        $this->Status->DbValue = $row['Status'];
    }

    // Delete uploaded files
    public function deleteUploadedFiles($row)
    {
        $this->loadDbValues($row);
        $this->Photo->OldUploadPath = $this->Photo->getUploadPath(); // PHP
        $oldFiles = EmptyValue($row['Photo']) ? [] : [$row['Photo']];
        foreach ($oldFiles as $oldFile) {
            if (file_exists($this->Photo->oldPhysicalUploadPath() . $oldFile)) {
                @unlink($this->Photo->oldPhysicalUploadPath() . $oldFile);
            }
        }
    }

    // Record filter WHERE clause
    protected function sqlKeyFilter()
    {
        return "`studentID` = @studentID@";
    }

    // Get Key
    public function getKey($current = false)
    {
        $keys = [];
        $val = $current ? $this->studentID->CurrentValue : $this->studentID->OldValue;
        if (EmptyValue($val)) {
            return "";
        } else {
            $keys[] = $val;
        }
        return implode(Config("COMPOSITE_KEY_SEPARATOR"), $keys);
    }

    // Set Key
    public function setKey($key, $current = false)
    {
        $this->OldKey = strval($key);
        $keys = explode(Config("COMPOSITE_KEY_SEPARATOR"), $this->OldKey);
        if (count($keys) == 1) {
            if ($current) {
                $this->studentID->CurrentValue = $keys[0];
            } else {
                $this->studentID->OldValue = $keys[0];
            }
        }
    }

    // Get record filter
    public function getRecordFilter($row = null, $current = false)
    {
        $keyFilter = $this->sqlKeyFilter();
        if (is_array($row)) {
            $val = array_key_exists('studentID', $row) ? $row['studentID'] : null;
        } else {
            $val = !EmptyValue($this->studentID->OldValue) && !$current ? $this->studentID->OldValue : $this->studentID->CurrentValue;
        }
        if (!is_numeric($val)) {
            return "0=1"; // Invalid key
        }
        if ($val === null) {
            return "0=1"; // Invalid key
        } else {
            $keyFilter = str_replace("@studentID@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
        }
        return $keyFilter;
    }

    // Return page URL
    public function getReturnUrl()
    {
        $referUrl = ReferUrl();
        $referPageName = ReferPageName();
        $name = PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL");
        // Get referer URL automatically
        if ($referUrl != "" && $referPageName != CurrentPageName() && $referPageName != "login") { // Referer not same page or login page
            $_SESSION[$name] = $referUrl; // Save to Session
        }
        return $_SESSION[$name] ?? GetUrl("studentlist");
    }

    // Set return page URL
    public function setReturnUrl($v)
    {
        $_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL")] = $v;
    }

    // Get modal caption
    public function getModalCaption($pageName)
    {
        global $Language;
        if ($pageName == "studentview") {
            return $Language->phrase("View");
        } elseif ($pageName == "studentedit") {
            return $Language->phrase("Edit");
        } elseif ($pageName == "studentadd") {
            return $Language->phrase("Add");
        }
        return "";
    }

    // API page name
    public function getApiPageName($action)
    {
        switch (strtolower($action)) {
            case Config("API_VIEW_ACTION"):
                return "StudentView";
            case Config("API_ADD_ACTION"):
                return "StudentAdd";
            case Config("API_EDIT_ACTION"):
                return "StudentEdit";
            case Config("API_DELETE_ACTION"):
                return "StudentDelete";
            case Config("API_LIST_ACTION"):
                return "StudentList";
            default:
                return "";
        }
    }

    // Current URL
    public function getCurrentUrl($parm = "")
    {
        $url = CurrentPageUrl(false);
        if ($parm != "") {
            $url = $this->keyUrl($url, $parm);
        } else {
            $url = $this->keyUrl($url, Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // List URL
    public function getListUrl()
    {
        return "studentlist";
    }

    // View URL
    public function getViewUrl($parm = "")
    {
        if ($parm != "") {
            $url = $this->keyUrl("studentview", $parm);
        } else {
            $url = $this->keyUrl("studentview", Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // Add URL
    public function getAddUrl($parm = "")
    {
        if ($parm != "") {
            $url = "studentadd?" . $parm;
        } else {
            $url = "studentadd";
        }
        return $this->addMasterUrl($url);
    }

    // Edit URL
    public function getEditUrl($parm = "")
    {
        $url = $this->keyUrl("studentedit", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline edit URL
    public function getInlineEditUrl()
    {
        $url = $this->keyUrl("studentlist", "action=edit");
        return $this->addMasterUrl($url);
    }

    // Copy URL
    public function getCopyUrl($parm = "")
    {
        $url = $this->keyUrl("studentadd", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline copy URL
    public function getInlineCopyUrl()
    {
        $url = $this->keyUrl("studentlist", "action=copy");
        return $this->addMasterUrl($url);
    }

    // Delete URL
    public function getDeleteUrl()
    {
        if ($this->UseAjaxActions && ConvertToBool(Param("infinitescroll")) && CurrentPageID() == "list") {
            return $this->keyUrl(GetApiUrl(Config("API_DELETE_ACTION") . "/" . $this->TableVar));
        } else {
            return $this->keyUrl("studentdelete");
        }
    }

    // Add master url
    public function addMasterUrl($url)
    {
        return $url;
    }

    public function keyToJson($htmlEncode = false)
    {
        $json = "";
        $json .= "\"studentID\":" . JsonEncode($this->studentID->CurrentValue, "number");
        $json = "{" . $json . "}";
        if ($htmlEncode) {
            $json = HtmlEncode($json);
        }
        return $json;
    }

    // Add key value to URL
    public function keyUrl($url, $parm = "")
    {
        if ($this->studentID->CurrentValue !== null) {
            $url .= "/" . $this->encodeKeyValue($this->studentID->CurrentValue);
        } else {
            return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
        }
        if ($parm != "") {
            $url .= "?" . $parm;
        }
        return $url;
    }

    // Render sort
    public function renderFieldHeader($fld)
    {
        global $Security, $Language, $Page;
        $sortUrl = "";
        $attrs = "";
        if ($fld->Sortable) {
            $sortUrl = $this->sortUrl($fld);
            $attrs = ' role="button" data-ew-action="sort" data-ajax="' . ($this->UseAjaxActions ? "true" : "false") . '" data-sort-url="' . $sortUrl . '" data-sort-type="1"';
            if ($this->ContextClass) { // Add context
                $attrs .= ' data-context="' . HtmlEncode($this->ContextClass) . '"';
            }
        }
        $html = '<div class="ew-table-header-caption"' . $attrs . '>' . $fld->caption() . '</div>';
        if ($sortUrl) {
            $html .= '<div class="ew-table-header-sort">' . $fld->getSortIcon() . '</div>';
        }
        if ($fld->UseFilter && $Security->canSearch()) {
            $html .= '<div class="ew-filter-dropdown-btn" data-ew-action="filter" data-table="' . $fld->TableVar . '" data-field="' . $fld->FieldVar .
                '"><div class="ew-table-header-filter" role="button" aria-haspopup="true">' . $Language->phrase("Filter") . '</div></div>';
        }
        $html = '<div class="ew-table-header-btn">' . $html . '</div>';
        if ($this->UseCustomTemplate) {
            $scriptId = str_replace("{id}", $fld->TableVar . "_" . $fld->Param, "tpc_{id}");
            $html = '<template id="' . $scriptId . '">' . $html . '</template>';
        }
        return $html;
    }

    // Sort URL
    public function sortUrl($fld)
    {
        global $DashboardReport;
        if (
            $this->CurrentAction || $this->isExport() ||
            in_array($fld->Type, [128, 204, 205])
        ) { // Unsortable data type
                return "";
        } elseif ($fld->Sortable) {
            $urlParm = "order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->getNextSort();
            if ($DashboardReport) {
                $urlParm .= "&amp;dashboard=true";
            }
            return $this->addMasterUrl($this->CurrentPageName . "?" . $urlParm);
        } else {
            return "";
        }
    }

    // Get record keys from Post/Get/Session
    public function getRecordKeys()
    {
        $arKeys = [];
        $arKey = [];
        if (Param("key_m") !== null) {
            $arKeys = Param("key_m");
            $cnt = count($arKeys);
        } else {
            if (($keyValue = Param("studentID") ?? Route("studentID")) !== null) {
                $arKeys[] = $keyValue;
            } elseif (IsApi() && (($keyValue = Key(0) ?? Route(2)) !== null)) {
                $arKeys[] = $keyValue;
            } else {
                $arKeys = null; // Do not setup
            }

            //return $arKeys; // Do not return yet, so the values will also be checked by the following code
        }
        // Check keys
        $ar = [];
        if (is_array($arKeys)) {
            foreach ($arKeys as $key) {
                if (!is_numeric($key)) {
                    continue;
                }
                $ar[] = $key;
            }
        }
        return $ar;
    }

    // Get filter from records
    public function getFilterFromRecords($rows)
    {
        $keyFilter = "";
        foreach ($rows as $row) {
            if ($keyFilter != "") {
                $keyFilter .= " OR ";
            }
            $keyFilter .= "(" . $this->getRecordFilter($row) . ")";
        }
        return $keyFilter;
    }

    // Get filter from record keys
    public function getFilterFromRecordKeys($setCurrent = true)
    {
        $arKeys = $this->getRecordKeys();
        $keyFilter = "";
        foreach ($arKeys as $key) {
            if ($keyFilter != "") {
                $keyFilter .= " OR ";
            }
            if ($setCurrent) {
                $this->studentID->CurrentValue = $key;
            } else {
                $this->studentID->OldValue = $key;
            }
            $keyFilter .= "(" . $this->getRecordFilter() . ")";
        }
        return $keyFilter;
    }

    // Load recordset based on filter / sort
    public function loadRs($filter, $sort = "")
    {
        $sql = $this->getSql($filter, $sort); // Set up filter (WHERE Clause) / sort (ORDER BY Clause)
        $conn = $this->getConnection();
        return $conn->executeQuery($sql);
    }

    // Load row values from record
    public function loadListRowValues(&$rs)
    {
        if (is_array($rs)) {
            $row = $rs;
        } elseif ($rs && property_exists($rs, "fields")) { // Recordset
            $row = $rs->fields;
        } else {
            return;
        }
        $this->studentID->setDbValue($row['studentID']);
        $this->PIN->setDbValue($row['PIN']);
        $this->Last_Name->setDbValue($row['Last_Name']);
        $this->First_Name->setDbValue($row['First_Name']);
        $this->Gender->setDbValue($row['Gender']);
        $this->Date_Of_Birth->setDbValue($row['Date_Of_Birth']);
        $this->Place_Of_Birth->setDbValue($row['Place_Of_Birth']);
        $this->Card_No->setDbValue($row['Card_No']);
        $this->Unique_QR->setDbValue($row['Unique_QR']);
        $this->Photo->Upload->DbValue = $row['Photo'];
        $this->Address->setDbValue($row['Address']);
        $this->Start_Date->setDbValue($row['Start_Date']);
        $this->Expiry_Date->setDbValue($row['Expiry_Date']);
        $this->SClass->setDbValue($row['SClass']);
        $this->Contact_Incase->setDbValue($row['Contact_Incase']);
        $this->Contact_Tel->setDbValue($row['Contact_Tel']);
        $this->Reference->setDbValue($row['Reference']);
        $this->EmployeeID->setDbValue($row['EmployeeID']);
        $this->Status->setDbValue($row['Status']);
    }

    // Render list content
    public function renderListContent($filter)
    {
        global $Response;
        $listPage = "StudentList";
        $listClass = PROJECT_NAMESPACE . $listPage;
        $page = new $listClass();
        $page->loadRecordsetFromFilter($filter);
        $view = Container("view");
        $template = $listPage . ".php"; // View
        $GLOBALS["Title"] ??= $page->Title; // Title
        try {
            $Response = $view->render($Response, $template, $GLOBALS);
        } finally {
            $page->terminate(); // Terminate page and clean up
        }
    }

    // Render list row values
    public function renderListRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // Common render codes

        // studentID

        // PIN

        // Last_Name

        // First_Name

        // Gender

        // Date_Of_Birth

        // Place_Of_Birth

        // Card_No

        // Unique_QR

        // Photo

        // Address

        // Start_Date

        // Expiry_Date

        // SClass

        // Contact_Incase

        // Contact_Tel

        // Reference

        // EmployeeID

        // Status

        // studentID
        $this->studentID->ViewValue = $this->studentID->CurrentValue;

        // PIN
        $this->PIN->ViewValue = $this->PIN->CurrentValue;

        // Last_Name
        $this->Last_Name->ViewValue = $this->Last_Name->CurrentValue;

        // First_Name
        $this->First_Name->ViewValue = $this->First_Name->CurrentValue;

        // Gender
        if (strval($this->Gender->CurrentValue) != "") {
            $this->Gender->ViewValue = $this->Gender->optionCaption($this->Gender->CurrentValue);
        } else {
            $this->Gender->ViewValue = null;
        }

        // Date_Of_Birth
        $this->Date_Of_Birth->ViewValue = $this->Date_Of_Birth->CurrentValue;
        $this->Date_Of_Birth->ViewValue = FormatDateTime($this->Date_Of_Birth->ViewValue, $this->Date_Of_Birth->formatPattern());

        // Place_Of_Birth
        $this->Place_Of_Birth->ViewValue = $this->Place_Of_Birth->CurrentValue;

        // Card_No
        $this->Card_No->ViewValue = $this->Card_No->CurrentValue;

        // Unique_QR
        $this->Unique_QR->ViewValue = $this->Unique_QR->CurrentValue;

        // Photo
        $this->Photo->UploadPath = $this->Photo->getUploadPath(); // PHP
        if (!EmptyValue($this->Photo->Upload->DbValue)) {
            $this->Photo->ImageWidth = 100;
            $this->Photo->ImageHeight = 100;
            $this->Photo->ImageAlt = $this->Photo->alt();
            $this->Photo->ImageCssClass = "ew-image";
            $this->Photo->ViewValue = $this->Photo->Upload->DbValue;
        } else {
            $this->Photo->ViewValue = "";
        }

        // Address
        $this->Address->ViewValue = $this->Address->CurrentValue;

        // Start_Date
        $this->Start_Date->ViewValue = $this->Start_Date->CurrentValue;
        $this->Start_Date->ViewValue = FormatDateTime($this->Start_Date->ViewValue, $this->Start_Date->formatPattern());

        // Expiry_Date
        $this->Expiry_Date->ViewValue = $this->Expiry_Date->CurrentValue;
        $this->Expiry_Date->ViewValue = FormatDateTime($this->Expiry_Date->ViewValue, $this->Expiry_Date->formatPattern());

        // SClass
        $this->SClass->ViewValue = $this->SClass->CurrentValue;

        // Contact_Incase
        $this->Contact_Incase->ViewValue = $this->Contact_Incase->CurrentValue;

        // Contact_Tel
        $this->Contact_Tel->ViewValue = $this->Contact_Tel->CurrentValue;

        // Reference
        $this->Reference->ViewValue = $this->Reference->CurrentValue;

        // EmployeeID
        $this->EmployeeID->ViewValue = $this->EmployeeID->CurrentValue;
        $this->EmployeeID->ViewValue = FormatNumber($this->EmployeeID->ViewValue, $this->EmployeeID->formatPattern());

        // Status
        if (strval($this->Status->CurrentValue) != "") {
            $this->Status->ViewValue = $this->Status->optionCaption($this->Status->CurrentValue);
        } else {
            $this->Status->ViewValue = null;
        }

        // studentID
        $this->studentID->HrefValue = "";
        $this->studentID->TooltipValue = "";

        // PIN
        $this->PIN->HrefValue = "";
        $this->PIN->TooltipValue = "";

        // Last_Name
        $this->Last_Name->HrefValue = "";
        $this->Last_Name->TooltipValue = "";

        // First_Name
        $this->First_Name->HrefValue = "";
        $this->First_Name->TooltipValue = "";

        // Gender
        $this->Gender->HrefValue = "";
        $this->Gender->TooltipValue = "";

        // Date_Of_Birth
        $this->Date_Of_Birth->HrefValue = "";
        $this->Date_Of_Birth->TooltipValue = "";

        // Place_Of_Birth
        $this->Place_Of_Birth->HrefValue = "";
        $this->Place_Of_Birth->TooltipValue = "";

        // Card_No
        $this->Card_No->HrefValue = "";
        $this->Card_No->TooltipValue = "";

        // Unique_QR
        $this->Unique_QR->HrefValue = "";
        $this->Unique_QR->ExportHrefValue = PhpBarcode::barcode(true)->getHrefValue($this->Unique_QR->CurrentValue, 'QRCODE', 60);
        $this->Unique_QR->TooltipValue = "";

        // Photo
        $this->Photo->UploadPath = $this->Photo->getUploadPath(); // PHP
        if (!EmptyValue($this->Photo->Upload->DbValue)) {
            $this->Photo->HrefValue = GetFileUploadUrl($this->Photo, $this->Photo->htmlDecode($this->Photo->Upload->DbValue)); // Add prefix/suffix
            $this->Photo->LinkAttrs["target"] = ""; // Add target
            if ($this->isExport()) {
                $this->Photo->HrefValue = FullUrl($this->Photo->HrefValue, "href");
            }
        } else {
            $this->Photo->HrefValue = "";
        }
        $this->Photo->ExportHrefValue = $this->Photo->UploadPath . $this->Photo->Upload->DbValue;
        $this->Photo->TooltipValue = "";
        if ($this->Photo->UseColorbox) {
            if (EmptyValue($this->Photo->TooltipValue)) {
                $this->Photo->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
            }
            $this->Photo->LinkAttrs["data-rel"] = "student_x_Photo";
            $this->Photo->LinkAttrs->appendClass("ew-lightbox");
        }

        // Address
        $this->Address->HrefValue = "";
        $this->Address->TooltipValue = "";

        // Start_Date
        $this->Start_Date->HrefValue = "";
        $this->Start_Date->TooltipValue = "";

        // Expiry_Date
        $this->Expiry_Date->HrefValue = "";
        $this->Expiry_Date->TooltipValue = "";

        // SClass
        $this->SClass->HrefValue = "";
        $this->SClass->TooltipValue = "";

        // Contact_Incase
        $this->Contact_Incase->HrefValue = "";
        $this->Contact_Incase->TooltipValue = "";

        // Contact_Tel
        $this->Contact_Tel->HrefValue = "";
        $this->Contact_Tel->TooltipValue = "";

        // Reference
        $this->Reference->HrefValue = "";
        $this->Reference->TooltipValue = "";

        // EmployeeID
        $this->EmployeeID->HrefValue = "";
        $this->EmployeeID->TooltipValue = "";

        // Status
        $this->Status->HrefValue = "";
        $this->Status->TooltipValue = "";

        // Call Row Rendered event
        $this->rowRendered();

        // Save data for Custom Template
        $this->Rows[] = $this->customTemplateFieldValues();
    }

    // Render edit row values
    public function renderEditRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // studentID
        $this->studentID->setupEditAttributes();
        $this->studentID->EditValue = $this->studentID->CurrentValue;
        $this->studentID->PlaceHolder = RemoveHtml($this->studentID->caption());

        // PIN
        $this->PIN->setupEditAttributes();
        if (!$this->PIN->Raw) {
            $this->PIN->CurrentValue = HtmlDecode($this->PIN->CurrentValue);
        }
        $this->PIN->EditValue = $this->PIN->CurrentValue;
        $this->PIN->PlaceHolder = RemoveHtml($this->PIN->caption());

        // Last_Name
        $this->Last_Name->setupEditAttributes();
        if (!$this->Last_Name->Raw) {
            $this->Last_Name->CurrentValue = HtmlDecode($this->Last_Name->CurrentValue);
        }
        $this->Last_Name->EditValue = $this->Last_Name->CurrentValue;
        $this->Last_Name->PlaceHolder = RemoveHtml($this->Last_Name->caption());

        // First_Name
        $this->First_Name->setupEditAttributes();
        if (!$this->First_Name->Raw) {
            $this->First_Name->CurrentValue = HtmlDecode($this->First_Name->CurrentValue);
        }
        $this->First_Name->EditValue = $this->First_Name->CurrentValue;
        $this->First_Name->PlaceHolder = RemoveHtml($this->First_Name->caption());

        // Gender
        $this->Gender->setupEditAttributes();
        $this->Gender->EditValue = $this->Gender->options(true);
        $this->Gender->PlaceHolder = RemoveHtml($this->Gender->caption());

        // Date_Of_Birth
        $this->Date_Of_Birth->setupEditAttributes();
        $this->Date_Of_Birth->EditValue = FormatDateTime($this->Date_Of_Birth->CurrentValue, $this->Date_Of_Birth->formatPattern());
        $this->Date_Of_Birth->PlaceHolder = RemoveHtml($this->Date_Of_Birth->caption());

        // Place_Of_Birth
        $this->Place_Of_Birth->setupEditAttributes();
        if (!$this->Place_Of_Birth->Raw) {
            $this->Place_Of_Birth->CurrentValue = HtmlDecode($this->Place_Of_Birth->CurrentValue);
        }
        $this->Place_Of_Birth->EditValue = $this->Place_Of_Birth->CurrentValue;
        $this->Place_Of_Birth->PlaceHolder = RemoveHtml($this->Place_Of_Birth->caption());

        // Card_No
        $this->Card_No->setupEditAttributes();
        if (!$this->Card_No->Raw) {
            $this->Card_No->CurrentValue = HtmlDecode($this->Card_No->CurrentValue);
        }
        $this->Card_No->EditValue = $this->Card_No->CurrentValue;
        $this->Card_No->PlaceHolder = RemoveHtml($this->Card_No->caption());

        // Unique_QR
        $this->Unique_QR->setupEditAttributes();
        if (!$this->Unique_QR->Raw) {
            $this->Unique_QR->CurrentValue = HtmlDecode($this->Unique_QR->CurrentValue);
        }
        $this->Unique_QR->EditValue = $this->Unique_QR->CurrentValue;
        $this->Unique_QR->PlaceHolder = RemoveHtml($this->Unique_QR->caption());

        // Photo
        $this->Photo->setupEditAttributes();
        $this->Photo->UploadPath = $this->Photo->getUploadPath(); // PHP
        if (!EmptyValue($this->Photo->Upload->DbValue)) {
            $this->Photo->ImageWidth = 100;
            $this->Photo->ImageHeight = 100;
            $this->Photo->ImageAlt = $this->Photo->alt();
            $this->Photo->ImageCssClass = "ew-image";
            $this->Photo->EditValue = $this->Photo->Upload->DbValue;
        } else {
            $this->Photo->EditValue = "";
        }
        if (!EmptyValue($this->Photo->CurrentValue)) {
            $this->Photo->Upload->FileName = $this->Photo->CurrentValue;
        }

        // Address
        $this->Address->setupEditAttributes();
        if (!$this->Address->Raw) {
            $this->Address->CurrentValue = HtmlDecode($this->Address->CurrentValue);
        }
        $this->Address->EditValue = $this->Address->CurrentValue;
        $this->Address->PlaceHolder = RemoveHtml($this->Address->caption());

        // Start_Date
        $this->Start_Date->setupEditAttributes();
        $this->Start_Date->EditValue = FormatDateTime($this->Start_Date->CurrentValue, $this->Start_Date->formatPattern());
        $this->Start_Date->PlaceHolder = RemoveHtml($this->Start_Date->caption());

        // Expiry_Date
        $this->Expiry_Date->setupEditAttributes();
        $this->Expiry_Date->EditValue = FormatDateTime($this->Expiry_Date->CurrentValue, $this->Expiry_Date->formatPattern());
        $this->Expiry_Date->PlaceHolder = RemoveHtml($this->Expiry_Date->caption());

        // SClass
        $this->SClass->setupEditAttributes();
        if (!$this->SClass->Raw) {
            $this->SClass->CurrentValue = HtmlDecode($this->SClass->CurrentValue);
        }
        $this->SClass->EditValue = $this->SClass->CurrentValue;
        $this->SClass->PlaceHolder = RemoveHtml($this->SClass->caption());

        // Contact_Incase
        $this->Contact_Incase->setupEditAttributes();
        if (!$this->Contact_Incase->Raw) {
            $this->Contact_Incase->CurrentValue = HtmlDecode($this->Contact_Incase->CurrentValue);
        }
        $this->Contact_Incase->EditValue = $this->Contact_Incase->CurrentValue;
        $this->Contact_Incase->PlaceHolder = RemoveHtml($this->Contact_Incase->caption());

        // Contact_Tel
        $this->Contact_Tel->setupEditAttributes();
        if (!$this->Contact_Tel->Raw) {
            $this->Contact_Tel->CurrentValue = HtmlDecode($this->Contact_Tel->CurrentValue);
        }
        $this->Contact_Tel->EditValue = $this->Contact_Tel->CurrentValue;
        $this->Contact_Tel->PlaceHolder = RemoveHtml($this->Contact_Tel->caption());

        // Reference
        $this->Reference->setupEditAttributes();
        if (!$this->Reference->Raw) {
            $this->Reference->CurrentValue = HtmlDecode($this->Reference->CurrentValue);
        }
        $this->Reference->EditValue = $this->Reference->CurrentValue;
        $this->Reference->PlaceHolder = RemoveHtml($this->Reference->caption());

        // EmployeeID
        $this->EmployeeID->setupEditAttributes();
        $this->EmployeeID->EditValue = $this->EmployeeID->CurrentValue;
        $this->EmployeeID->PlaceHolder = RemoveHtml($this->EmployeeID->caption());
        if (strval($this->EmployeeID->EditValue) != "" && is_numeric($this->EmployeeID->EditValue)) {
            $this->EmployeeID->EditValue = FormatNumber($this->EmployeeID->EditValue, null);
        }

        // Status
        $this->Status->setupEditAttributes();
        $this->Status->EditValue = $this->Status->options(true);
        $this->Status->PlaceHolder = RemoveHtml($this->Status->caption());

        // Call Row Rendered event
        $this->rowRendered();
    }

    // Aggregate list row values
    public function aggregateListRowValues()
    {
    }

    // Aggregate list row (for rendering)
    public function aggregateListRow()
    {
        // Call Row Rendered event
        $this->rowRendered();
    }

    // Export data in HTML/CSV/Word/Excel/Email/PDF format
	// Now including Export Print (printer friendly), modification by Unique Digital Solutions Ltd, September 27, 2022 
    public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
    {
        if (!$recordset || !$doc) {
            return;
        }
        if (!$doc->ExportCustom) {
            // Write header
            $doc->exportTableHeader();
            if ($doc->Horizontal) { // Horizontal format, write header
                $doc->beginExportRow();
                if ($exportPageType == "view") {
                    $doc->exportCaption($this->studentID);
                    $doc->exportCaption($this->PIN);
                    $doc->exportCaption($this->Last_Name);
                    $doc->exportCaption($this->First_Name);
                    $doc->exportCaption($this->Gender);
                    $doc->exportCaption($this->Date_Of_Birth);
                    $doc->exportCaption($this->Place_Of_Birth);
                    $doc->exportCaption($this->Card_No);
                    $doc->exportCaption($this->Unique_QR);
                    $doc->exportCaption($this->Photo);
                    $doc->exportCaption($this->Address);
                    $doc->exportCaption($this->Start_Date);
                    $doc->exportCaption($this->Expiry_Date);
                    $doc->exportCaption($this->SClass);
                    $doc->exportCaption($this->Contact_Incase);
                    $doc->exportCaption($this->Contact_Tel);
                    $doc->exportCaption($this->Reference);
                    $doc->exportCaption($this->EmployeeID);
                    $doc->exportCaption($this->Status);
                } else {
                    $doc->exportCaption($this->studentID);
                    $doc->exportCaption($this->PIN);
                    $doc->exportCaption($this->First_Name);
                    $doc->exportCaption($this->Gender);
                    $doc->exportCaption($this->Date_Of_Birth);
                    $doc->exportCaption($this->Place_Of_Birth);
                    $doc->exportCaption($this->Card_No);
                    $doc->exportCaption($this->Unique_QR);
                    $doc->exportCaption($this->Photo);
                    $doc->exportCaption($this->Address);
                    $doc->exportCaption($this->Start_Date);
                    $doc->exportCaption($this->Expiry_Date);
                    $doc->exportCaption($this->SClass);
                    $doc->exportCaption($this->Contact_Incase);
                    $doc->exportCaption($this->Contact_Tel);
                    $doc->exportCaption($this->Reference);
                    $doc->exportCaption($this->EmployeeID);
                    $doc->exportCaption($this->Status);
                }
                $doc->endExportRow();
            }
        }

        // Move to first record
        $recCnt = $startRec - 1;
        $stopRec = ($stopRec > 0) ? $stopRec : PHP_INT_MAX;
		// Begin of modification Record Number in Exported Data by Unique Digital Solutions Ltd, September 27, 2022
		$seqRec = 0;
		if (CurrentPageID() == "view") { // Modified by Unique Digital Solutions Ltd, reset seq. number in View Page
		    $_SESSION["First_Record"] = 0;
			$seqRec = (empty($_SESSION["First_Record"])) ? 0 : $_SESSION["First_Record"] - 1; 
		} else {
			$seqRec = (empty($_SESSION["First_Record"])) ? $recCnt : $_SESSION["First_Record"] - 1;
		}
		// End of modification Record Number in Exported Data by Unique Digital Solutions Ltd, September 27, 2022
        while (!$recordset->EOF && $recCnt < $stopRec) {
            $row = $recordset->fields;
            $recCnt++;
			$seqRec++; // Record Number in Exported Data by Unique Digital Solutions Ltd, September 27, 2022
            if ($recCnt >= $startRec) {
                $rowCnt = $recCnt - $startRec + 1;
                // Page break
				// Begin of modification PageBreak for Export to PDF dan Export to Word by Unique Digital Solutions Ltd, September 27, 2022
                if ($this->ExportPageBreakCount > 0 && ($this->Export == "pdf" || $this->Export =="word")) {
                    if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0) {
                        $doc->exportPageBreak();
						$doc->beginExportRow(); // Begin of modification by Unique Digital Solutions Ltd, table header will be repeated at the top of each page after page break, must be handled from here for Export to PDF that has the possibility to repeat the table header column in each top of page
						$doc->exportCaption($this->studentID);
						$doc->exportCaption($this->PIN);
						$doc->exportCaption($this->First_Name);
						$doc->exportCaption($this->Gender);
						$doc->exportCaption($this->Date_Of_Birth);
						$doc->exportCaption($this->Place_Of_Birth);
						$doc->exportCaption($this->Card_No);
						$doc->exportCaption($this->Unique_QR);
						$doc->exportCaption($this->Photo);
						$doc->exportCaption($this->Address);
						$doc->exportCaption($this->Start_Date);
						$doc->exportCaption($this->Expiry_Date);
						$doc->exportCaption($this->SClass);
						$doc->exportCaption($this->Contact_Incase);
						$doc->exportCaption($this->Contact_Tel);
						$doc->exportCaption($this->Reference);
						$doc->exportCaption($this->EmployeeID);
						$doc->exportCaption($this->Status);
						$doc->endExportRow(); // End of modification by Unique Digital Solutions Ltd, table header will be repeated at the top of each page after page break
                    }
                }
				// End of modification PageBreak for Export to PDF dan Export to Word by Unique Digital Solutions Ltd, September 27, 2022
                $this->loadListRowValues($row);

                // Render row
                $this->RowType = ROWTYPE_VIEW; // Render view
                $this->resetAttributes();
                $this->renderListRow();
                if (!$doc->ExportCustom) {
                    $doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
                    if ($exportPageType == "view") {
                        $doc->exportField($this->studentID);
                        $doc->exportField($this->PIN);
                        $doc->exportField($this->Last_Name);
                        $doc->exportField($this->First_Name);
                        $doc->exportField($this->Gender);
                        $doc->exportField($this->Date_Of_Birth);
                        $doc->exportField($this->Place_Of_Birth);
                        $doc->exportField($this->Card_No);
                        $doc->exportField($this->Unique_QR);
                        $doc->exportField($this->Photo);
                        $doc->exportField($this->Address);
                        $doc->exportField($this->Start_Date);
                        $doc->exportField($this->Expiry_Date);
                        $doc->exportField($this->SClass);
                        $doc->exportField($this->Contact_Incase);
                        $doc->exportField($this->Contact_Tel);
                        $doc->exportField($this->Reference);
                        $doc->exportField($this->EmployeeID);
                        $doc->exportField($this->Status);
                    } else {
                        $doc->exportField($this->studentID);
                        $doc->exportField($this->PIN);
                        $doc->exportField($this->First_Name);
                        $doc->exportField($this->Gender);
                        $doc->exportField($this->Date_Of_Birth);
                        $doc->exportField($this->Place_Of_Birth);
                        $doc->exportField($this->Card_No);
                        $doc->exportField($this->Unique_QR);
                        $doc->exportField($this->Photo);
                        $doc->exportField($this->Address);
                        $doc->exportField($this->Start_Date);
                        $doc->exportField($this->Expiry_Date);
                        $doc->exportField($this->SClass);
                        $doc->exportField($this->Contact_Incase);
                        $doc->exportField($this->Contact_Tel);
                        $doc->exportField($this->Reference);
                        $doc->exportField($this->EmployeeID);
                        $doc->exportField($this->Status);
                    }
                    $doc->endExportRow($rowCnt);
                }
            }

            // Call Row Export server event
            if ($doc->ExportCustom) {
                $this->rowExport($doc, $row);
            }
            $recordset->moveNext();
        }
        if (!$doc->ExportCustom) {
            $doc->exportTableFooter();
        }
    }

    // Get file data
    public function getFileData($fldparm, $key, $resize, $width = 0, $height = 0, $plugins = [])
    {
        global $DownloadFileName;
        $width = ($width > 0) ? $width : Config("THUMBNAIL_DEFAULT_WIDTH");
        $height = ($height > 0) ? $height : Config("THUMBNAIL_DEFAULT_HEIGHT");

        // Set up field name / file name field / file type field
        $fldName = "";
        $fileNameFld = "";
        $fileTypeFld = "";
        if ($fldparm == 'Photo') {
            $fldName = "Photo";
            $fileNameFld = "Photo";
        } else {
            return false; // Incorrect field
        }

        // Set up key values
        $ar = explode(Config("COMPOSITE_KEY_SEPARATOR"), $key);
        if (count($ar) == 1) {
            $this->studentID->CurrentValue = $ar[0];
        } else {
            return false; // Incorrect key
        }

        // Set up filter (WHERE Clause)
        $filter = $this->getRecordFilter();
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $dbtype = GetConnectionType($this->Dbid);
        if ($row = $conn->fetchAssociative($sql)) {
            $val = $row[$fldName];
            if (!EmptyValue($val)) {
                $fld = $this->Fields[$fldName];

                // Binary data
                if ($fld->DataType == DATATYPE_BLOB) {
                    if ($dbtype != "MYSQL") {
                        if (is_resource($val) && get_resource_type($val) == "stream") { // Byte array
                            $val = stream_get_contents($val);
                        }
                    }
                    if ($resize) {
                        ResizeBinary($val, $width, $height, $plugins);
                    }

                    // Write file type
                    if ($fileTypeFld != "" && !EmptyValue($row[$fileTypeFld])) {
                        AddHeader("Content-type", $row[$fileTypeFld]);
                    } else {
                        AddHeader("Content-type", ContentType($val));
                    }

                    // Write file name
                    $downloadPdf = !Config("EMBED_PDF") && Config("DOWNLOAD_PDF_FILE");
                    if ($fileNameFld != "" && !EmptyValue($row[$fileNameFld])) {
                        $fileName = $row[$fileNameFld];
                        $ext = strtolower($pathinfo["extension"] ?? "");
                        $isPdf = SameText($ext, "pdf");
                        if ($downloadPdf || !$isPdf) { // Skip header if not download PDF
                            AddHeader("Content-Disposition", "attachment; filename=\"" . $fileName . "\"");
                        }
                    } else {
                        $ext = ContentExtension($val);
                        $isPdf = SameText($ext, ".pdf");
                        if ($isPdf && $downloadPdf) { // Add header if download PDF
                            AddHeader("Content-Disposition", "attachment" . ($DownloadFileName ? "; filename=\"" . $DownloadFileName . "\"" : ""));
                        }
                    }

                    // Write file data
                    if (
                        StartsString("PK", $val) &&
                        ContainsString($val, "[Content_Types].xml") &&
                        ContainsString($val, "_rels") &&
                        ContainsString($val, "docProps")
                    ) { // Fix Office 2007 documents
                        if (!EndsString("\0\0\0", $val)) { // Not ends with 3 or 4 \0
                            $val .= "\0\0\0\0";
                        }
                    }

                    // Clear any debug message
                    if (ob_get_length()) {
                        ob_end_clean();
                    }

                    // Write binary data
                    Write($val);

                // Upload to folder
                } else {
                    if ($fld->UploadMultiple) {
                        $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                    } else {
                        $files = [$val];
                    }
                    $data = [];
                    $ar = [];
                    if ($fld->hasMethod("getUploadPath")) { // Check field level upload path
                        $fld->UploadPath = $fld->getUploadPath();
                    }
                    foreach ($files as $file) {
                        if (!EmptyValue($file)) {
                            if (Config("ENCRYPT_FILE_PATH")) {
                                $ar[$file] = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $this->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                            } else {
                                $ar[$file] = FullUrl($fld->hrefPath() . $file);
                            }
                        }
                    }
                    $data[$fld->Param] = $ar;
                    WriteJson($data);
                }
            }
            return true;
        }
        return false;
    }

    // Write audit trail start/end for grid update
    public function writeAuditTrailDummy($typ)
    {
        WriteAuditLog(CurrentUser(), $typ, 'student', "", "", "", "");
    }

    // Write audit trail (add page)
    public function writeAuditTrailOnAdd(&$rs)
    {
        global $Language;
        if (!$this->AuditTrailOnAdd) {
            return;
        }

        // Get key value
        $key = "";
        if ($key != "") {
            $key .= Config("COMPOSITE_KEY_SEPARATOR");
        }
        $key .= $rs['studentID'];

        // Write audit trail
        $usr = CurrentUser();
        foreach (array_keys($rs) as $fldname) {
            if (array_key_exists($fldname, $this->Fields) && $this->Fields[$fldname]->DataType != DATATYPE_BLOB) { // Ignore BLOB fields
                if ($this->Fields[$fldname]->HtmlTag == "PASSWORD") { // Password Field
                    $newvalue = $Language->phrase("PasswordMask");
                } elseif ($this->Fields[$fldname]->DataType == DATATYPE_MEMO) { // Memo Field
                    $newvalue = Config("AUDIT_TRAIL_TO_DATABASE") ? $rs[$fldname] : "[MEMO]";
                } elseif ($this->Fields[$fldname]->DataType == DATATYPE_XML) { // XML Field
                    $newvalue = "[XML]";
                } else {
                    $newvalue = $rs[$fldname];
                }
                WriteAuditLog($usr, "A", 'student', $fldname, $key, "", $newvalue);
            }
        }
    }

    // Write audit trail (edit page)
    public function writeAuditTrailOnEdit(&$rsold, &$rsnew)
    {
        global $Language;
        if (!$this->AuditTrailOnEdit) {
            return;
        }

        // Get key value
        $key = "";
        if ($key != "") {
            $key .= Config("COMPOSITE_KEY_SEPARATOR");
        }
        $key .= $rsold['studentID'];

        // Write audit trail
        $usr = CurrentUser();
        foreach (array_keys($rsnew) as $fldname) {
            if (array_key_exists($fldname, $this->Fields) && array_key_exists($fldname, $rsold) && $this->Fields[$fldname]->DataType != DATATYPE_BLOB) { // Ignore BLOB fields
                if ($this->Fields[$fldname]->DataType == DATATYPE_DATE) { // DateTime field
                    $modified = (FormatDateTime($rsold[$fldname], 0) != FormatDateTime($rsnew[$fldname], 0));
                } else {
                    $modified = !CompareValue($rsold[$fldname], $rsnew[$fldname]);
                }
                if ($modified) {
                    if ($this->Fields[$fldname]->HtmlTag == "PASSWORD") { // Password Field
                        $oldvalue = $Language->phrase("PasswordMask");
                        $newvalue = $Language->phrase("PasswordMask");
                    } elseif ($this->Fields[$fldname]->DataType == DATATYPE_MEMO) { // Memo field
                        $oldvalue = Config("AUDIT_TRAIL_TO_DATABASE") ? $rsold[$fldname] : "[MEMO]";
                        $newvalue = Config("AUDIT_TRAIL_TO_DATABASE") ? $rsnew[$fldname] : "[MEMO]";
                    } elseif ($this->Fields[$fldname]->DataType == DATATYPE_XML) { // XML field
                        $oldvalue = "[XML]";
                        $newvalue = "[XML]";
                    } else {
                        $oldvalue = $rsold[$fldname];
                        $newvalue = $rsnew[$fldname];
                    }
                    WriteAuditLog($usr, "U", 'student', $fldname, $key, $oldvalue, $newvalue);
                }
            }
        }
    }

    // Write audit trail (delete page)
    public function writeAuditTrailOnDelete(&$rs)
    {
        global $Language;
        if (!$this->AuditTrailOnDelete) {
            return;
        }

        // Get key value
        $key = "";
        if ($key != "") {
            $key .= Config("COMPOSITE_KEY_SEPARATOR");
        }
        $key .= $rs['studentID'];

        // Write audit trail
        $usr = CurrentUser();
        foreach (array_keys($rs) as $fldname) {
            if (array_key_exists($fldname, $this->Fields) && $this->Fields[$fldname]->DataType != DATATYPE_BLOB) { // Ignore BLOB fields
                if ($this->Fields[$fldname]->HtmlTag == "PASSWORD") { // Password Field
                    $oldvalue = $Language->phrase("PasswordMask");
                } elseif ($this->Fields[$fldname]->DataType == DATATYPE_MEMO) { // Memo field
                    $oldvalue = Config("AUDIT_TRAIL_TO_DATABASE") ? $rs[$fldname] : "[MEMO]";
                } elseif ($this->Fields[$fldname]->DataType == DATATYPE_XML) { // XML field
                    $oldvalue = "[XML]";
                } else {
                    $oldvalue = $rs[$fldname];
                }
                WriteAuditLog($usr, "D", 'student', $fldname, $key, $oldvalue, "");
            }
        }
    }

    // Send email after add success
    public function sendEmailOnAdd(&$rs)
    {
        global $Language;
        $table = 'student';
        $subject = $table . " " . $Language->phrase("RecordInserted");
        $action = $Language->phrase("ActionInserted");

        // Get key value
        $key = "";
        if ($key != "") {
            $key .= Config("COMPOSITE_KEY_SEPARATOR");
        }
        $key .= $rs['studentID'];
        $email = new Email();
        $email->load(Config("EMAIL_NOTIFY_TEMPLATE"));
        $email->replaceSender(Config("SENDER_EMAIL")); // Replace Sender
        $email->replaceRecipient(Config("RECIPIENT_EMAIL")); // Replace Recipient
        $email->replaceSubject($subject); // Replace Subject
        $email->replaceContent("<!--table-->", $table);
        $email->replaceContent("<!--key-->", $key);
        $email->replaceContent("<!--action-->", $action);
        $args = ["rsnew" => $rs];
        $emailSent = false;
        if ($this->emailSending($email, $args)) {
            $emailSent = $email->send();
        }

        // Send email failed
        if (!$emailSent) {
            $this->setFailureMessage($email->SendErrDescription);
        }
    }

    // Send email after update success
    public function sendEmailOnEdit(&$rsold, &$rsnew)
    {
        global $Language;
        $table = 'student';
        $subject = $table . " ". $Language->phrase("RecordUpdated");
        $action = $Language->phrase("ActionUpdated");

        // Get key value
        $key = "";
        if ($key != "") {
            $key .= Config("COMPOSITE_KEY_SEPARATOR");
        }
        $key .= $rsold['studentID'];
        $email = new Email();
        $email->load(Config("EMAIL_NOTIFY_TEMPLATE"));
        $email->replaceSender(Config("SENDER_EMAIL")); // Replace Sender
        $email->replaceRecipient(Config("RECIPIENT_EMAIL")); // Replace Recipient
        $email->replaceSubject($subject); // Replace Subject
        $email->replaceContent("<!--table-->", $table);
        $email->replaceContent("<!--key-->", $key);
        $email->replaceContent("<!--action-->", $action);
        $args = [];
        $args["rsold"] = &$rsold;
        $args["rsnew"] = &$rsnew;
        $emailSent = false;
        if ($this->emailSending($email, $args)) {
            $emailSent = $email->send();
        }

        // Send email failed
        if (!$emailSent) {
            $this->setFailureMessage($email->SendErrDescription);
        }
    }

    // Table level events

    // Table Load event
    public function tableLoad()
    {
        // Enter your code here
    }

    // Recordset Selecting event
    public function recordsetSelecting(&$filter)
    {
        // Enter your code here
    }

    // Recordset Selected event
    public function recordsetSelected(&$rs)
    {
        //Log("Recordset Selected");
    }

    // Recordset Search Validated event
    public function recordsetSearchValidated()
    {
        // Example:
        //$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value
    }

    // Recordset Searching event
    public function recordsetSearching(&$filter)
    {
        // Enter your code here
    }

    // Row_Selecting event
    public function rowSelecting(&$filter)
    {
        // Enter your code here
    }

    // Row Selected event
    public function rowSelected(&$rs)
    {
        //Log("Row Selected");
    }

    // Row Inserting event
    public function rowInserting($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Inserted event
    public function rowInserted($rsold, &$rsnew)
    {
        //Log("Row Inserted");
    }

    // Row Updating event
    public function rowUpdating($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Updated event
    public function rowUpdated($rsold, &$rsnew)
    {
        //Log("Row Updated");
    }

    // Row Update Conflict event
    public function rowUpdateConflict($rsold, &$rsnew)
    {
        // Enter your code here
        // To ignore conflict, set return value to false
        return true;
    }

    // Grid Inserting event
    public function gridInserting()
    {
        // Enter your code here
        // To reject grid insert, set return value to false
        return true;
    }

    // Grid Inserted event
    public function gridInserted($rsnew)
    {
        //Log("Grid Inserted");
    }

    // Grid Updating event
    public function gridUpdating($rsold)
    {
        // Enter your code here
        // To reject grid update, set return value to false
        return true;
    }

    // Grid Updated event
    public function gridUpdated($rsold, $rsnew)
    {
        //Log("Grid Updated");
    }

    // Row Deleting event
    public function rowDeleting(&$rs)
    {
        // Enter your code here
        // To cancel, set return value to False
        return true;
    }

    // Row Deleted event
    public function rowDeleted(&$rs)
    {
        //Log("Row Deleted");
    }

    // Email Sending event
    public function emailSending($email, &$args)
    {
        //var_dump($email, $args); exit();
        return true;
    }

    // Lookup Selecting event
    public function lookupSelecting($fld, &$filter)
    {
        //var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
        // Enter your code here
    }

    // Row Rendering event
    public function rowRendering()
    {
        // Enter your code here
    }

    // Row Rendered event
    public function rowRendered()
    {
        // To view properties of field class, use:
        //var_dump($this-><FieldName>);
    }

    // User ID Filtering event
    public function userIdFiltering(&$filter)
    {
        // Enter your code here
    }
}
