<?php

namespace PHPMaker2023\Jack_Jill_school;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\FetchMode;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;

/**
 * Table class for events
 */
class Events extends DbTable
{
    protected $SqlFrom = "";
    protected $SqlSelect = null;
    protected $SqlSelectList = null;
    protected $SqlWhere = "";
    protected $SqlGroupBy = "";
    protected $SqlHaving = "";
    protected $SqlOrderBy = "";
    public $DbErrorMessage = "";
    public $UseSessionForListSql = true;

    // Column CSS classes
    public $LeftColumnClass = "col-sm-4 col-form-label ew-label";
    public $RightColumnClass = "col-sm-8";
    public $OffsetColumnClass = "col-sm-8 offset-sm-4";
    public $TableLeftColumnClass = "w-col-4";

    // Ajax / Modal
    public $UseAjaxActions = false;
    public $ModalSearch = false;
    public $ModalView = false;
    public $ModalAdd = false;
    public $ModalEdit = false;
    public $ModalUpdate = false;
    public $InlineDelete = false;
    public $ModalGridAdd = false;
    public $ModalGridEdit = false;
    public $ModalMultiEdit = false;

    // Fields
    public $Event_ID;
    public $Event_Title;
    public $Event_Color;
    public $Event_Start;
    public $Event_End;
    public $Event_Description;
    public $Event_User;
    public $Repeat_Type;
    public $Repeat_ID;
    public $Event_AllDay;
    public $Event_URL;
    public $Event_Category;
    public $Event_Timezone;
    public $Added_By;
    public $Date_Added;
    public $Updated_By;
    public $Date_Updated;

    // Page ID
    public $PageID = ""; // To be overridden by subclass

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $CurrentLanguage, $CurrentLocale;

        // Language object
        $Language = Container("language");
        $this->TableVar = "events";
        $this->TableName = 'events';
        $this->TableType = "TABLE";
        $this->ImportUseTransaction = $this->supportsTransaction() && Config("IMPORT_USE_TRANSACTION");
        $this->UseTransaction = $this->supportsTransaction() && Config("USE_TRANSACTION");

        // Update Table
        $this->UpdateTable = "events";
        $this->Dbid = 'DB';
        $this->ExportAll = false;
        $this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)

        // PDF
        $this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
        $this->ExportPageSize = "a4"; // Page size (PDF only)

        // PhpSpreadsheet
        $this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
        $this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)

        // PHPWord
        $this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
        $this->ExportWordPageSize = "A4"; // Page orientation (PHPWord only)
        $this->ExportWordColumnWidth = null; // Cell width (PHPWord only)
        $this->DetailAdd = false; // Allow detail add
        $this->DetailEdit = false; // Allow detail edit
        $this->DetailView = false; // Allow detail view
        $this->ShowMultipleDetails = false; // Show multiple details
        $this->GridAddRowCount = 5;
        $this->AllowAddDeleteRow = true; // Allow add/delete row
        $this->UseAjaxActions = $this->UseAjaxActions || Config("USE_AJAX_ACTIONS");
        $this->UserIDAllowSecurity = Config("DEFAULT_USER_ID_ALLOW_SECURITY"); // Default User ID allowed permissions
        $this->BasicSearch = new BasicSearch($this);

        // Event_ID
        $this->Event_ID = new DbField(
            $this, // Table
            'x_Event_ID', // Variable name
            'Event_ID', // Name
            '`Event_ID`', // Expression
            '`Event_ID`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Event_ID`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'NO' // Edit Tag
        );
        $this->Event_ID->InputTextType = "text";
        $this->Event_ID->IsAutoIncrement = true; // Autoincrement field
        $this->Event_ID->IsPrimaryKey = true; // Primary key field
        $this->Event_ID->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->Event_ID->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['Event_ID'] = &$this->Event_ID;

        // Event_Title
        $this->Event_Title = new DbField(
            $this, // Table
            'x_Event_Title', // Variable name
            'Event_Title', // Name
            '`Event_Title`', // Expression
            '`Event_Title`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Event_Title`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->Event_Title->InputTextType = "text";
        $this->Event_Title->Nullable = false; // NOT NULL field
        $this->Event_Title->Required = true; // Required field
        $this->Event_Title->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['Event_Title'] = &$this->Event_Title;

        // Event_Color
        $this->Event_Color = new DbField(
            $this, // Table
            'x_Event_Color', // Variable name
            'Event_Color', // Name
            '`Event_Color`', // Expression
            '`Event_Color`', // Basic search expression
            200, // Type
            7, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Event_Color`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->Event_Color->InputTextType = "text";
        $this->Event_Color->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['Event_Color'] = &$this->Event_Color;

        // Event_Start
        $this->Event_Start = new DbField(
            $this, // Table
            'x_Event_Start', // Variable name
            'Event_Start', // Name
            '`Event_Start`', // Expression
            CastDateFieldForLike("`Event_Start`", 0, "DB"), // Basic search expression
            135, // Type
            19, // Size
            0, // Date/Time format
            false, // Is upload field
            '`Event_Start`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->Event_Start->InputTextType = "text";
        $this->Event_Start->Nullable = false; // NOT NULL field
        $this->Event_Start->Required = true; // Required field
        $this->Event_Start->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
        $this->Event_Start->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['Event_Start'] = &$this->Event_Start;

        // Event_End
        $this->Event_End = new DbField(
            $this, // Table
            'x_Event_End', // Variable name
            'Event_End', // Name
            '`Event_End`', // Expression
            CastDateFieldForLike("`Event_End`", 0, "DB"), // Basic search expression
            135, // Type
            19, // Size
            0, // Date/Time format
            false, // Is upload field
            '`Event_End`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->Event_End->InputTextType = "text";
        $this->Event_End->Nullable = false; // NOT NULL field
        $this->Event_End->Required = true; // Required field
        $this->Event_End->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
        $this->Event_End->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['Event_End'] = &$this->Event_End;

        // Event_Description
        $this->Event_Description = new DbField(
            $this, // Table
            'x_Event_Description', // Variable name
            'Event_Description', // Name
            '`Event_Description`', // Expression
            '`Event_Description`', // Basic search expression
            201, // Type
            65535, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Event_Description`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXTAREA' // Edit Tag
        );
        $this->Event_Description->InputTextType = "text";
        $this->Event_Description->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['Event_Description'] = &$this->Event_Description;

        // Event_User
        $this->Event_User = new DbField(
            $this, // Table
            'x_Event_User', // Variable name
            'Event_User', // Name
            '`Event_User`', // Expression
            '`Event_User`', // Basic search expression
            200, // Type
            20, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Event_User`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->Event_User->InputTextType = "text";
        $this->Event_User->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['Event_User'] = &$this->Event_User;

        // Repeat_Type
        $this->Repeat_Type = new DbField(
            $this, // Table
            'x_Repeat_Type', // Variable name
            'Repeat_Type', // Name
            '`Repeat_Type`', // Expression
            '`Repeat_Type`', // Basic search expression
            200, // Type
            20, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Repeat_Type`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->Repeat_Type->InputTextType = "text";
        $this->Repeat_Type->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['Repeat_Type'] = &$this->Repeat_Type;

        // Repeat_ID
        $this->Repeat_ID = new DbField(
            $this, // Table
            'x_Repeat_ID', // Variable name
            'Repeat_ID', // Name
            '`Repeat_ID`', // Expression
            '`Repeat_ID`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Repeat_ID`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->Repeat_ID->InputTextType = "text";
        $this->Repeat_ID->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->Repeat_ID->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['Repeat_ID'] = &$this->Repeat_ID;

        // Event_AllDay
        $this->Event_AllDay = new DbField(
            $this, // Table
            'x_Event_AllDay', // Variable name
            'Event_AllDay', // Name
            '`Event_AllDay`', // Expression
            '`Event_AllDay`', // Basic search expression
            200, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Event_AllDay`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->Event_AllDay->InputTextType = "text";
        $this->Event_AllDay->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['Event_AllDay'] = &$this->Event_AllDay;

        // Event_URL
        $this->Event_URL = new DbField(
            $this, // Table
            'x_Event_URL', // Variable name
            'Event_URL', // Name
            '`Event_URL`', // Expression
            '`Event_URL`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Event_URL`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->Event_URL->InputTextType = "text";
        $this->Event_URL->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['Event_URL'] = &$this->Event_URL;

        // Event_Category
        $this->Event_Category = new DbField(
            $this, // Table
            'x_Event_Category', // Variable name
            'Event_Category', // Name
            '`Event_Category`', // Expression
            '`Event_Category`', // Basic search expression
            200, // Type
            50, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Event_Category`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->Event_Category->InputTextType = "text";
        $this->Event_Category->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['Event_Category'] = &$this->Event_Category;

        // Event_Timezone
        $this->Event_Timezone = new DbField(
            $this, // Table
            'x_Event_Timezone', // Variable name
            'Event_Timezone', // Name
            '`Event_Timezone`', // Expression
            '`Event_Timezone`', // Basic search expression
            200, // Type
            64, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Event_Timezone`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->Event_Timezone->InputTextType = "text";
        $this->Event_Timezone->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['Event_Timezone'] = &$this->Event_Timezone;

        // Added_By
        $this->Added_By = new DbField(
            $this, // Table
            'x_Added_By', // Variable name
            'Added_By', // Name
            '`Added_By`', // Expression
            '`Added_By`', // Basic search expression
            200, // Type
            20, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Added_By`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->Added_By->InputTextType = "text";
        $this->Added_By->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['Added_By'] = &$this->Added_By;

        // Date_Added
        $this->Date_Added = new DbField(
            $this, // Table
            'x_Date_Added', // Variable name
            'Date_Added', // Name
            '`Date_Added`', // Expression
            CastDateFieldForLike("`Date_Added`", 0, "DB"), // Basic search expression
            135, // Type
            19, // Size
            0, // Date/Time format
            false, // Is upload field
            '`Date_Added`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->Date_Added->InputTextType = "text";
        $this->Date_Added->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
        $this->Date_Added->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['Date_Added'] = &$this->Date_Added;

        // Updated_By
        $this->Updated_By = new DbField(
            $this, // Table
            'x_Updated_By', // Variable name
            'Updated_By', // Name
            '`Updated_By`', // Expression
            '`Updated_By`', // Basic search expression
            200, // Type
            20, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Updated_By`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->Updated_By->InputTextType = "text";
        $this->Updated_By->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['Updated_By'] = &$this->Updated_By;

        // Date_Updated
        $this->Date_Updated = new DbField(
            $this, // Table
            'x_Date_Updated', // Variable name
            'Date_Updated', // Name
            '`Date_Updated`', // Expression
            CastDateFieldForLike("`Date_Updated`", 0, "DB"), // Basic search expression
            135, // Type
            19, // Size
            0, // Date/Time format
            false, // Is upload field
            '`Date_Updated`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->Date_Updated->InputTextType = "text";
        $this->Date_Updated->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
        $this->Date_Updated->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['Date_Updated'] = &$this->Date_Updated;

        // Add Doctrine Cache
        $this->Cache = new ArrayCache();
        $this->CacheProfile = new \Doctrine\DBAL\Cache\QueryCacheProfile(0, $this->TableVar);

        // Call Table Load event
        $this->tableLoad();
    }

    // Field Visibility
    public function getFieldVisibility($fldParm)
    {
        global $Security;
        return $this->$fldParm->Visible; // Returns original value
    }

    // Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
    public function setLeftColumnClass($class)
    {
        if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
            $this->LeftColumnClass = $class . " col-form-label ew-label";
            $this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
            $this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
            $this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
        }
    }

    // Single column sort
    public function updateSort(&$fld)
    {
        if ($this->CurrentOrder == $fld->Name) {
            $sortField = $fld->Expression;
            $lastSort = $fld->getSort();
            if (in_array($this->CurrentOrderType, ["ASC", "DESC", "NO"])) {
                $curSort = $this->CurrentOrderType;
            } else {
                $curSort = $lastSort;
            }
            $orderBy = in_array($curSort, ["ASC", "DESC"]) ? $sortField . " " . $curSort : "";
            $this->setSessionOrderBy($orderBy); // Save to Session
        }
    }

    // Update field sort
    public function updateFieldSort()
    {
        $orderBy = $this->getSessionOrderBy(); // Get ORDER BY from Session
        $flds = GetSortFields($orderBy);
        foreach ($this->Fields as $field) {
            $fldSort = "";
            foreach ($flds as $fld) {
                if ($fld[0] == $field->Expression || $fld[0] == $field->VirtualExpression) {
                    $fldSort = $fld[1];
                }
            }
            $field->setSort($fldSort);
        }
    }

    // Render X Axis for chart
    public function renderChartXAxis($chartVar, $chartRow)
    {
        return $chartRow;
    }

    // Table level SQL
    public function getSqlFrom() // From
    {
        return ($this->SqlFrom != "") ? $this->SqlFrom : "events";
    }

    public function sqlFrom() // For backward compatibility
    {
        return $this->getSqlFrom();
    }

    public function setSqlFrom($v)
    {
        $this->SqlFrom = $v;
    }

    public function getSqlSelect() // Select
    {
        return $this->SqlSelect ?? $this->getQueryBuilder()->select("*");
    }

    public function sqlSelect() // For backward compatibility
    {
        return $this->getSqlSelect();
    }

    public function setSqlSelect($v)
    {
        $this->SqlSelect = $v;
    }

    public function getSqlWhere() // Where
    {
        $where = ($this->SqlWhere != "") ? $this->SqlWhere : "";
        $this->DefaultFilter = "";
        AddFilter($where, $this->DefaultFilter);
        return $where;
    }

    public function sqlWhere() // For backward compatibility
    {
        return $this->getSqlWhere();
    }

    public function setSqlWhere($v)
    {
        $this->SqlWhere = $v;
    }

    public function getSqlGroupBy() // Group By
    {
        return ($this->SqlGroupBy != "") ? $this->SqlGroupBy : "";
    }

    public function sqlGroupBy() // For backward compatibility
    {
        return $this->getSqlGroupBy();
    }

    public function setSqlGroupBy($v)
    {
        $this->SqlGroupBy = $v;
    }

    public function getSqlHaving() // Having
    {
        return ($this->SqlHaving != "") ? $this->SqlHaving : "";
    }

    public function sqlHaving() // For backward compatibility
    {
        return $this->getSqlHaving();
    }

    public function setSqlHaving($v)
    {
        $this->SqlHaving = $v;
    }

    public function getSqlOrderBy() // Order By
    {
        return ($this->SqlOrderBy != "") ? $this->SqlOrderBy : "";
    }

    public function sqlOrderBy() // For backward compatibility
    {
        return $this->getSqlOrderBy();
    }

    public function setSqlOrderBy($v)
    {
        $this->SqlOrderBy = $v;
    }

    // Apply User ID filters
    public function applyUserIDFilters($filter, $id = "")
    {
        return $filter;
    }

    // Check if User ID security allows view all
    public function userIDAllow($id = "")
    {
        $allow = $this->UserIDAllowSecurity;
        switch ($id) {
            case "add":
            case "copy":
            case "gridadd":
            case "register":
            case "addopt":
                return (($allow & 1) == 1);
            case "edit":
            case "gridedit":
            case "update":
            case "changepassword":
            case "resetpassword":
                return (($allow & 4) == 4);
            case "delete":
                return (($allow & 2) == 2);
            case "view":
                return (($allow & 32) == 32);
            case "search":
                return (($allow & 64) == 64);
            case "lookup":
                return (($allow & 256) == 256);
            default:
                return (($allow & 8) == 8);
        }
    }

    /**
     * Get record count
     *
     * @param string|QueryBuilder $sql SQL or QueryBuilder
     * @param mixed $c Connection
     * @return int
     */
    public function getRecordCount($sql, $c = null)
    {
        $cnt = -1;
        $rs = null;
        if ($sql instanceof QueryBuilder) { // Query builder
            $sqlwrk = clone $sql;
            $sqlwrk = $sqlwrk->resetQueryPart("orderBy")->getSQL();
        } else {
            $sqlwrk = $sql;
        }
        $pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';
        // Skip Custom View / SubQuery / SELECT DISTINCT / ORDER BY
        if (
            ($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
            preg_match($pattern, $sqlwrk) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sqlwrk) &&
            !preg_match('/^\s*select\s+distinct\s+/i', $sqlwrk) && !preg_match('/\s+order\s+by\s+/i', $sqlwrk)
        ) {
            $sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sqlwrk);
        } else {
            $sqlwrk = "SELECT COUNT(*) FROM (" . $sqlwrk . ") COUNT_TABLE";
        }
        $conn = $c ?? $this->getConnection();
        $cnt = $conn->fetchOne($sqlwrk);
        if ($cnt !== false) {
            return (int)$cnt;
        }

        // Unable to get count by SELECT COUNT(*), execute the SQL to get record count directly
        return ExecuteRecordCount($sql, $conn);
    }

    // Get SQL
    public function getSql($where, $orderBy = "")
    {
        return $this->getSqlAsQueryBuilder($where, $orderBy)->getSQL();
    }

    // Get QueryBuilder
    public function getSqlAsQueryBuilder($where, $orderBy = "")
    {
        return $this->buildSelectSql(
            $this->getSqlSelect(),
            $this->getSqlFrom(),
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $where,
            $orderBy
        );
    }

    // Table SQL
    public function getCurrentSql()
    {
        $filter = $this->CurrentFilter;
        $filter = $this->applyUserIDFilters($filter);
        $sort = $this->getSessionOrderBy();
        return $this->getSql($filter, $sort);
    }

    /**
     * Table SQL with List page filter
     *
     * @return QueryBuilder
     */
    public function getListSql()
    {
        $filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $select = $this->getSqlSelect();
        $from = $this->getSqlFrom();
        $sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
        $this->Sort = $sort;
        return $this->buildSelectSql(
            $select,
            $from,
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $filter,
            $sort
        );
    }

    // Get ORDER BY clause
    public function getOrderBy()
    {
        $orderBy = $this->getSqlOrderBy();
        $sort = $this->getSessionOrderBy();
        if ($orderBy != "" && $sort != "") {
            $orderBy .= ", " . $sort;
        } elseif ($sort != "") {
            $orderBy = $sort;
        }
        return $orderBy;
    }

    // Get record count based on filter (for detail record count in master table pages)
    public function loadRecordCount($filter)
    {
        $origFilter = $this->CurrentFilter;
        $this->CurrentFilter = $filter;
        $this->recordsetSelecting($this->CurrentFilter);
        $select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
        $having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
        $cnt = $this->getRecordCount($sql);
        $this->CurrentFilter = $origFilter;
        return $cnt;
    }

    // Get record count (for current List page)
    public function listRecordCount()
    {
        $filter = $this->getSessionWhere();
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
        $having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
        $cnt = $this->getRecordCount($sql);
        return $cnt;
    }

    /**
     * INSERT statement
     *
     * @param mixed $rs
     * @return QueryBuilder
     */
    public function insertSql(&$rs)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->insert($this->UpdateTable);
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom) {
                continue;
            }
            $type = GetParameterType($this->Fields[$name], $value, $this->Dbid);
            $queryBuilder->setValue($this->Fields[$name]->Expression, $queryBuilder->createPositionalParameter($value, $type));
        }
        return $queryBuilder;
    }

    // Insert
    public function insert(&$rs)
    {
        $conn = $this->getConnection();
        try {
            $success = $this->insertSql($rs)->execute();
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $success = false;
            $this->DbErrorMessage = $e->getMessage();
        }
        if ($success) {
            // Get insert id if necessary
            $this->Event_ID->setDbValue($conn->lastInsertId());
            $rs['Event_ID'] = $this->Event_ID->DbValue;
        }
        return $success;
    }

    /**
     * UPDATE statement
     *
     * @param array $rs Data to be updated
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function updateSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->update($this->UpdateTable);
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom || $this->Fields[$name]->IsAutoIncrement) {
                continue;
            }
            $type = GetParameterType($this->Fields[$name], $value, $this->Dbid);
            $queryBuilder->set($this->Fields[$name]->Expression, $queryBuilder->createPositionalParameter($value, $type));
        }
        $filter = ($curfilter) ? $this->CurrentFilter : "";
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        AddFilter($filter, $where);
        if ($filter != "") {
            $queryBuilder->where($filter);
        }
        return $queryBuilder;
    }

    // Update
    public function update(&$rs, $where = "", $rsold = null, $curfilter = true)
    {
        // If no field is updated, execute may return 0. Treat as success
        try {
            $success = $this->updateSql($rs, $where, $curfilter)->execute();
            $success = ($success > 0) ? $success : true;
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $success = false;
            $this->DbErrorMessage = $e->getMessage();
        }

        // Return auto increment field
        if ($success) {
            if (!isset($rs['Event_ID']) && !EmptyValue($this->Event_ID->CurrentValue)) {
                $rs['Event_ID'] = $this->Event_ID->CurrentValue;
            }
        }
        return $success;
    }

    /**
     * DELETE statement
     *
     * @param array $rs Key values
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function deleteSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->delete($this->UpdateTable);
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        if ($rs) {
            if (array_key_exists('Event_ID', $rs)) {
                AddFilter($where, QuotedName('Event_ID', $this->Dbid) . '=' . QuotedValue($rs['Event_ID'], $this->Event_ID->DataType, $this->Dbid));
            }
        }
        $filter = ($curfilter) ? $this->CurrentFilter : "";
        AddFilter($filter, $where);
        return $queryBuilder->where($filter != "" ? $filter : "0=1");
    }

    // Delete
    public function delete(&$rs, $where = "", $curfilter = false)
    {
        $success = true;
        if ($success) {
            try {
                $success = $this->deleteSql($rs, $where, $curfilter)->execute();
                $this->DbErrorMessage = "";
            } catch (\Exception $e) {
                $success = false;
                $this->DbErrorMessage = $e->getMessage();
            }
        }
        return $success;
    }

    // Load DbValue from recordset or array
    protected function loadDbValues($row)
    {
        if (!is_array($row)) {
            return;
        }
        $this->Event_ID->DbValue = $row['Event_ID'];
        $this->Event_Title->DbValue = $row['Event_Title'];
        $this->Event_Color->DbValue = $row['Event_Color'];
        $this->Event_Start->DbValue = $row['Event_Start'];
        $this->Event_End->DbValue = $row['Event_End'];
        $this->Event_Description->DbValue = $row['Event_Description'];
        $this->Event_User->DbValue = $row['Event_User'];
        $this->Repeat_Type->DbValue = $row['Repeat_Type'];
        $this->Repeat_ID->DbValue = $row['Repeat_ID'];
        $this->Event_AllDay->DbValue = $row['Event_AllDay'];
        $this->Event_URL->DbValue = $row['Event_URL'];
        $this->Event_Category->DbValue = $row['Event_Category'];
        $this->Event_Timezone->DbValue = $row['Event_Timezone'];
        $this->Added_By->DbValue = $row['Added_By'];
        $this->Date_Added->DbValue = $row['Date_Added'];
        $this->Updated_By->DbValue = $row['Updated_By'];
        $this->Date_Updated->DbValue = $row['Date_Updated'];
    }

    // Delete uploaded files
    public function deleteUploadedFiles($row)
    {
        $this->loadDbValues($row);
    }

    // Record filter WHERE clause
    protected function sqlKeyFilter()
    {
        return "`Event_ID` = @Event_ID@";
    }

    // Get Key
    public function getKey($current = false)
    {
        $keys = [];
        $val = $current ? $this->Event_ID->CurrentValue : $this->Event_ID->OldValue;
        if (EmptyValue($val)) {
            return "";
        } else {
            $keys[] = $val;
        }
        return implode(Config("COMPOSITE_KEY_SEPARATOR"), $keys);
    }

    // Set Key
    public function setKey($key, $current = false)
    {
        $this->OldKey = strval($key);
        $keys = explode(Config("COMPOSITE_KEY_SEPARATOR"), $this->OldKey);
        if (count($keys) == 1) {
            if ($current) {
                $this->Event_ID->CurrentValue = $keys[0];
            } else {
                $this->Event_ID->OldValue = $keys[0];
            }
        }
    }

    // Get record filter
    public function getRecordFilter($row = null, $current = false)
    {
        $keyFilter = $this->sqlKeyFilter();
        if (is_array($row)) {
            $val = array_key_exists('Event_ID', $row) ? $row['Event_ID'] : null;
        } else {
            $val = !EmptyValue($this->Event_ID->OldValue) && !$current ? $this->Event_ID->OldValue : $this->Event_ID->CurrentValue;
        }
        if (!is_numeric($val)) {
            return "0=1"; // Invalid key
        }
        if ($val === null) {
            return "0=1"; // Invalid key
        } else {
            $keyFilter = str_replace("@Event_ID@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
        }
        return $keyFilter;
    }

    // Return page URL
    public function getReturnUrl()
    {
        $referUrl = ReferUrl();
        $referPageName = ReferPageName();
        $name = PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL");
        // Get referer URL automatically
        if ($referUrl != "" && $referPageName != CurrentPageName() && $referPageName != "login") { // Referer not same page or login page
            $_SESSION[$name] = $referUrl; // Save to Session
        }
        return $_SESSION[$name] ?? GetUrl("eventslist");
    }

    // Set return page URL
    public function setReturnUrl($v)
    {
        $_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL")] = $v;
    }

    // Get modal caption
    public function getModalCaption($pageName)
    {
        global $Language;
        if ($pageName == "eventsview") {
            return $Language->phrase("View");
        } elseif ($pageName == "eventsedit") {
            return $Language->phrase("Edit");
        } elseif ($pageName == "eventsadd") {
            return $Language->phrase("Add");
        }
        return "";
    }

    // API page name
    public function getApiPageName($action)
    {
        switch (strtolower($action)) {
            case Config("API_VIEW_ACTION"):
                return "EventsView";
            case Config("API_ADD_ACTION"):
                return "EventsAdd";
            case Config("API_EDIT_ACTION"):
                return "EventsEdit";
            case Config("API_DELETE_ACTION"):
                return "EventsDelete";
            case Config("API_LIST_ACTION"):
                return "EventsList";
            default:
                return "";
        }
    }

    // Current URL
    public function getCurrentUrl($parm = "")
    {
        $url = CurrentPageUrl(false);
        if ($parm != "") {
            $url = $this->keyUrl($url, $parm);
        } else {
            $url = $this->keyUrl($url, Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // List URL
    public function getListUrl()
    {
        return "eventslist";
    }

    // View URL
    public function getViewUrl($parm = "")
    {
        if ($parm != "") {
            $url = $this->keyUrl("eventsview", $parm);
        } else {
            $url = $this->keyUrl("eventsview", Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // Add URL
    public function getAddUrl($parm = "")
    {
        if ($parm != "") {
            $url = "eventsadd?" . $parm;
        } else {
            $url = "eventsadd";
        }
        return $this->addMasterUrl($url);
    }

    // Edit URL
    public function getEditUrl($parm = "")
    {
        $url = $this->keyUrl("eventsedit", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline edit URL
    public function getInlineEditUrl()
    {
        $url = $this->keyUrl("eventslist", "action=edit");
        return $this->addMasterUrl($url);
    }

    // Copy URL
    public function getCopyUrl($parm = "")
    {
        $url = $this->keyUrl("eventsadd", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline copy URL
    public function getInlineCopyUrl()
    {
        $url = $this->keyUrl("eventslist", "action=copy");
        return $this->addMasterUrl($url);
    }

    // Delete URL
    public function getDeleteUrl()
    {
        if ($this->UseAjaxActions && ConvertToBool(Param("infinitescroll")) && CurrentPageID() == "list") {
            return $this->keyUrl(GetApiUrl(Config("API_DELETE_ACTION") . "/" . $this->TableVar));
        } else {
            return $this->keyUrl("eventsdelete");
        }
    }

    // Add master url
    public function addMasterUrl($url)
    {
        return $url;
    }

    public function keyToJson($htmlEncode = false)
    {
        $json = "";
        $json .= "\"Event_ID\":" . JsonEncode($this->Event_ID->CurrentValue, "number");
        $json = "{" . $json . "}";
        if ($htmlEncode) {
            $json = HtmlEncode($json);
        }
        return $json;
    }

    // Add key value to URL
    public function keyUrl($url, $parm = "")
    {
        if ($this->Event_ID->CurrentValue !== null) {
            $url .= "/" . $this->encodeKeyValue($this->Event_ID->CurrentValue);
        } else {
            return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
        }
        if ($parm != "") {
            $url .= "?" . $parm;
        }
        return $url;
    }

    // Render sort
    public function renderFieldHeader($fld)
    {
        global $Security, $Language, $Page;
        $sortUrl = "";
        $attrs = "";
        if ($fld->Sortable) {
            $sortUrl = $this->sortUrl($fld);
            $attrs = ' role="button" data-ew-action="sort" data-ajax="' . ($this->UseAjaxActions ? "true" : "false") . '" data-sort-url="' . $sortUrl . '" data-sort-type="1"';
            if ($this->ContextClass) { // Add context
                $attrs .= ' data-context="' . HtmlEncode($this->ContextClass) . '"';
            }
        }
        $html = '<div class="ew-table-header-caption"' . $attrs . '>' . $fld->caption() . '</div>';
        if ($sortUrl) {
            $html .= '<div class="ew-table-header-sort">' . $fld->getSortIcon() . '</div>';
        }
        if ($fld->UseFilter && $Security->canSearch()) {
            $html .= '<div class="ew-filter-dropdown-btn" data-ew-action="filter" data-table="' . $fld->TableVar . '" data-field="' . $fld->FieldVar .
                '"><div class="ew-table-header-filter" role="button" aria-haspopup="true">' . $Language->phrase("Filter") . '</div></div>';
        }
        $html = '<div class="ew-table-header-btn">' . $html . '</div>';
        if ($this->UseCustomTemplate) {
            $scriptId = str_replace("{id}", $fld->TableVar . "_" . $fld->Param, "tpc_{id}");
            $html = '<template id="' . $scriptId . '">' . $html . '</template>';
        }
        return $html;
    }

    // Sort URL
    public function sortUrl($fld)
    {
        global $DashboardReport;
        if (
            $this->CurrentAction || $this->isExport() ||
            in_array($fld->Type, [128, 204, 205])
        ) { // Unsortable data type
                return "";
        } elseif ($fld->Sortable) {
            $urlParm = "order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->getNextSort();
            if ($DashboardReport) {
                $urlParm .= "&amp;dashboard=true";
            }
            return $this->addMasterUrl($this->CurrentPageName . "?" . $urlParm);
        } else {
            return "";
        }
    }

    // Get record keys from Post/Get/Session
    public function getRecordKeys()
    {
        $arKeys = [];
        $arKey = [];
        if (Param("key_m") !== null) {
            $arKeys = Param("key_m");
            $cnt = count($arKeys);
        } else {
            if (($keyValue = Param("Event_ID") ?? Route("Event_ID")) !== null) {
                $arKeys[] = $keyValue;
            } elseif (IsApi() && (($keyValue = Key(0) ?? Route(2)) !== null)) {
                $arKeys[] = $keyValue;
            } else {
                $arKeys = null; // Do not setup
            }

            //return $arKeys; // Do not return yet, so the values will also be checked by the following code
        }
        // Check keys
        $ar = [];
        if (is_array($arKeys)) {
            foreach ($arKeys as $key) {
                if (!is_numeric($key)) {
                    continue;
                }
                $ar[] = $key;
            }
        }
        return $ar;
    }

    // Get filter from records
    public function getFilterFromRecords($rows)
    {
        $keyFilter = "";
        foreach ($rows as $row) {
            if ($keyFilter != "") {
                $keyFilter .= " OR ";
            }
            $keyFilter .= "(" . $this->getRecordFilter($row) . ")";
        }
        return $keyFilter;
    }

    // Get filter from record keys
    public function getFilterFromRecordKeys($setCurrent = true)
    {
        $arKeys = $this->getRecordKeys();
        $keyFilter = "";
        foreach ($arKeys as $key) {
            if ($keyFilter != "") {
                $keyFilter .= " OR ";
            }
            if ($setCurrent) {
                $this->Event_ID->CurrentValue = $key;
            } else {
                $this->Event_ID->OldValue = $key;
            }
            $keyFilter .= "(" . $this->getRecordFilter() . ")";
        }
        return $keyFilter;
    }

    // Load recordset based on filter / sort
    public function loadRs($filter, $sort = "")
    {
        $sql = $this->getSql($filter, $sort); // Set up filter (WHERE Clause) / sort (ORDER BY Clause)
        $conn = $this->getConnection();
        return $conn->executeQuery($sql);
    }

    // Load row values from record
    public function loadListRowValues(&$rs)
    {
        if (is_array($rs)) {
            $row = $rs;
        } elseif ($rs && property_exists($rs, "fields")) { // Recordset
            $row = $rs->fields;
        } else {
            return;
        }
        $this->Event_ID->setDbValue($row['Event_ID']);
        $this->Event_Title->setDbValue($row['Event_Title']);
        $this->Event_Color->setDbValue($row['Event_Color']);
        $this->Event_Start->setDbValue($row['Event_Start']);
        $this->Event_End->setDbValue($row['Event_End']);
        $this->Event_Description->setDbValue($row['Event_Description']);
        $this->Event_User->setDbValue($row['Event_User']);
        $this->Repeat_Type->setDbValue($row['Repeat_Type']);
        $this->Repeat_ID->setDbValue($row['Repeat_ID']);
        $this->Event_AllDay->setDbValue($row['Event_AllDay']);
        $this->Event_URL->setDbValue($row['Event_URL']);
        $this->Event_Category->setDbValue($row['Event_Category']);
        $this->Event_Timezone->setDbValue($row['Event_Timezone']);
        $this->Added_By->setDbValue($row['Added_By']);
        $this->Date_Added->setDbValue($row['Date_Added']);
        $this->Updated_By->setDbValue($row['Updated_By']);
        $this->Date_Updated->setDbValue($row['Date_Updated']);
    }

    // Render list content
    public function renderListContent($filter)
    {
        global $Response;
        $listPage = "EventsList";
        $listClass = PROJECT_NAMESPACE . $listPage;
        $page = new $listClass();
        $page->loadRecordsetFromFilter($filter);
        $view = Container("view");
        $template = $listPage . ".php"; // View
        $GLOBALS["Title"] ??= $page->Title; // Title
        try {
            $Response = $view->render($Response, $template, $GLOBALS);
        } finally {
            $page->terminate(); // Terminate page and clean up
        }
    }

    // Render list row values
    public function renderListRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // Common render codes

        // Event_ID

        // Event_Title

        // Event_Color

        // Event_Start

        // Event_End

        // Event_Description

        // Event_User

        // Repeat_Type

        // Repeat_ID

        // Event_AllDay

        // Event_URL

        // Event_Category

        // Event_Timezone

        // Added_By

        // Date_Added

        // Updated_By

        // Date_Updated

        // Event_ID
        $this->Event_ID->ViewValue = $this->Event_ID->CurrentValue;

        // Event_Title
        $this->Event_Title->ViewValue = $this->Event_Title->CurrentValue;

        // Event_Color
        $this->Event_Color->ViewValue = $this->Event_Color->CurrentValue;

        // Event_Start
        $this->Event_Start->ViewValue = $this->Event_Start->CurrentValue;
        $this->Event_Start->ViewValue = FormatDateTime($this->Event_Start->ViewValue, $this->Event_Start->formatPattern());

        // Event_End
        $this->Event_End->ViewValue = $this->Event_End->CurrentValue;
        $this->Event_End->ViewValue = FormatDateTime($this->Event_End->ViewValue, $this->Event_End->formatPattern());

        // Event_Description
        $this->Event_Description->ViewValue = $this->Event_Description->CurrentValue;

        // Event_User
        $this->Event_User->ViewValue = $this->Event_User->CurrentValue;

        // Repeat_Type
        $this->Repeat_Type->ViewValue = $this->Repeat_Type->CurrentValue;

        // Repeat_ID
        $this->Repeat_ID->ViewValue = $this->Repeat_ID->CurrentValue;
        $this->Repeat_ID->ViewValue = FormatNumber($this->Repeat_ID->ViewValue, $this->Repeat_ID->formatPattern());

        // Event_AllDay
        $this->Event_AllDay->ViewValue = $this->Event_AllDay->CurrentValue;

        // Event_URL
        $this->Event_URL->ViewValue = $this->Event_URL->CurrentValue;

        // Event_Category
        $this->Event_Category->ViewValue = $this->Event_Category->CurrentValue;

        // Event_Timezone
        $this->Event_Timezone->ViewValue = $this->Event_Timezone->CurrentValue;

        // Added_By
        $this->Added_By->ViewValue = $this->Added_By->CurrentValue;

        // Date_Added
        $this->Date_Added->ViewValue = $this->Date_Added->CurrentValue;
        $this->Date_Added->ViewValue = FormatDateTime($this->Date_Added->ViewValue, $this->Date_Added->formatPattern());

        // Updated_By
        $this->Updated_By->ViewValue = $this->Updated_By->CurrentValue;

        // Date_Updated
        $this->Date_Updated->ViewValue = $this->Date_Updated->CurrentValue;
        $this->Date_Updated->ViewValue = FormatDateTime($this->Date_Updated->ViewValue, $this->Date_Updated->formatPattern());

        // Event_ID
        $this->Event_ID->HrefValue = "";
        $this->Event_ID->TooltipValue = "";

        // Event_Title
        $this->Event_Title->HrefValue = "";
        $this->Event_Title->TooltipValue = "";

        // Event_Color
        $this->Event_Color->HrefValue = "";
        $this->Event_Color->TooltipValue = "";

        // Event_Start
        $this->Event_Start->HrefValue = "";
        $this->Event_Start->TooltipValue = "";

        // Event_End
        $this->Event_End->HrefValue = "";
        $this->Event_End->TooltipValue = "";

        // Event_Description
        $this->Event_Description->HrefValue = "";
        $this->Event_Description->TooltipValue = "";

        // Event_User
        $this->Event_User->HrefValue = "";
        $this->Event_User->TooltipValue = "";

        // Repeat_Type
        $this->Repeat_Type->HrefValue = "";
        $this->Repeat_Type->TooltipValue = "";

        // Repeat_ID
        $this->Repeat_ID->HrefValue = "";
        $this->Repeat_ID->TooltipValue = "";

        // Event_AllDay
        $this->Event_AllDay->HrefValue = "";
        $this->Event_AllDay->TooltipValue = "";

        // Event_URL
        $this->Event_URL->HrefValue = "";
        $this->Event_URL->TooltipValue = "";

        // Event_Category
        $this->Event_Category->HrefValue = "";
        $this->Event_Category->TooltipValue = "";

        // Event_Timezone
        $this->Event_Timezone->HrefValue = "";
        $this->Event_Timezone->TooltipValue = "";

        // Added_By
        $this->Added_By->HrefValue = "";
        $this->Added_By->TooltipValue = "";

        // Date_Added
        $this->Date_Added->HrefValue = "";
        $this->Date_Added->TooltipValue = "";

        // Updated_By
        $this->Updated_By->HrefValue = "";
        $this->Updated_By->TooltipValue = "";

        // Date_Updated
        $this->Date_Updated->HrefValue = "";
        $this->Date_Updated->TooltipValue = "";

        // Call Row Rendered event
        $this->rowRendered();

        // Save data for Custom Template
        $this->Rows[] = $this->customTemplateFieldValues();
    }

    // Render edit row values
    public function renderEditRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // Event_ID
        $this->Event_ID->setupEditAttributes();
        $this->Event_ID->EditValue = $this->Event_ID->CurrentValue;

        // Event_Title
        $this->Event_Title->setupEditAttributes();
        if (!$this->Event_Title->Raw) {
            $this->Event_Title->CurrentValue = HtmlDecode($this->Event_Title->CurrentValue);
        }
        $this->Event_Title->EditValue = $this->Event_Title->CurrentValue;
        $this->Event_Title->PlaceHolder = RemoveHtml($this->Event_Title->caption());

        // Event_Color
        $this->Event_Color->setupEditAttributes();
        if (!$this->Event_Color->Raw) {
            $this->Event_Color->CurrentValue = HtmlDecode($this->Event_Color->CurrentValue);
        }
        $this->Event_Color->EditValue = $this->Event_Color->CurrentValue;
        $this->Event_Color->PlaceHolder = RemoveHtml($this->Event_Color->caption());

        // Event_Start
        $this->Event_Start->setupEditAttributes();
        $this->Event_Start->EditValue = FormatDateTime($this->Event_Start->CurrentValue, $this->Event_Start->formatPattern());
        $this->Event_Start->PlaceHolder = RemoveHtml($this->Event_Start->caption());

        // Event_End
        $this->Event_End->setupEditAttributes();
        $this->Event_End->EditValue = FormatDateTime($this->Event_End->CurrentValue, $this->Event_End->formatPattern());
        $this->Event_End->PlaceHolder = RemoveHtml($this->Event_End->caption());

        // Event_Description
        $this->Event_Description->setupEditAttributes();
        $this->Event_Description->EditValue = $this->Event_Description->CurrentValue;
        $this->Event_Description->PlaceHolder = RemoveHtml($this->Event_Description->caption());

        // Event_User
        $this->Event_User->setupEditAttributes();
        if (!$this->Event_User->Raw) {
            $this->Event_User->CurrentValue = HtmlDecode($this->Event_User->CurrentValue);
        }
        $this->Event_User->EditValue = $this->Event_User->CurrentValue;
        $this->Event_User->PlaceHolder = RemoveHtml($this->Event_User->caption());

        // Repeat_Type
        $this->Repeat_Type->setupEditAttributes();
        if (!$this->Repeat_Type->Raw) {
            $this->Repeat_Type->CurrentValue = HtmlDecode($this->Repeat_Type->CurrentValue);
        }
        $this->Repeat_Type->EditValue = $this->Repeat_Type->CurrentValue;
        $this->Repeat_Type->PlaceHolder = RemoveHtml($this->Repeat_Type->caption());

        // Repeat_ID
        $this->Repeat_ID->setupEditAttributes();
        $this->Repeat_ID->EditValue = $this->Repeat_ID->CurrentValue;
        $this->Repeat_ID->PlaceHolder = RemoveHtml($this->Repeat_ID->caption());
        if (strval($this->Repeat_ID->EditValue) != "" && is_numeric($this->Repeat_ID->EditValue)) {
            $this->Repeat_ID->EditValue = FormatNumber($this->Repeat_ID->EditValue, null);
        }

        // Event_AllDay
        $this->Event_AllDay->setupEditAttributes();
        if (!$this->Event_AllDay->Raw) {
            $this->Event_AllDay->CurrentValue = HtmlDecode($this->Event_AllDay->CurrentValue);
        }
        $this->Event_AllDay->EditValue = $this->Event_AllDay->CurrentValue;
        $this->Event_AllDay->PlaceHolder = RemoveHtml($this->Event_AllDay->caption());

        // Event_URL
        $this->Event_URL->setupEditAttributes();
        if (!$this->Event_URL->Raw) {
            $this->Event_URL->CurrentValue = HtmlDecode($this->Event_URL->CurrentValue);
        }
        $this->Event_URL->EditValue = $this->Event_URL->CurrentValue;
        $this->Event_URL->PlaceHolder = RemoveHtml($this->Event_URL->caption());

        // Event_Category
        $this->Event_Category->setupEditAttributes();
        if (!$this->Event_Category->Raw) {
            $this->Event_Category->CurrentValue = HtmlDecode($this->Event_Category->CurrentValue);
        }
        $this->Event_Category->EditValue = $this->Event_Category->CurrentValue;
        $this->Event_Category->PlaceHolder = RemoveHtml($this->Event_Category->caption());

        // Event_Timezone
        $this->Event_Timezone->setupEditAttributes();
        if (!$this->Event_Timezone->Raw) {
            $this->Event_Timezone->CurrentValue = HtmlDecode($this->Event_Timezone->CurrentValue);
        }
        $this->Event_Timezone->EditValue = $this->Event_Timezone->CurrentValue;
        $this->Event_Timezone->PlaceHolder = RemoveHtml($this->Event_Timezone->caption());

        // Added_By
        $this->Added_By->setupEditAttributes();
        if (!$this->Added_By->Raw) {
            $this->Added_By->CurrentValue = HtmlDecode($this->Added_By->CurrentValue);
        }
        $this->Added_By->EditValue = $this->Added_By->CurrentValue;
        $this->Added_By->PlaceHolder = RemoveHtml($this->Added_By->caption());

        // Date_Added
        $this->Date_Added->setupEditAttributes();
        $this->Date_Added->EditValue = FormatDateTime($this->Date_Added->CurrentValue, $this->Date_Added->formatPattern());
        $this->Date_Added->PlaceHolder = RemoveHtml($this->Date_Added->caption());

        // Updated_By
        $this->Updated_By->setupEditAttributes();
        if (!$this->Updated_By->Raw) {
            $this->Updated_By->CurrentValue = HtmlDecode($this->Updated_By->CurrentValue);
        }
        $this->Updated_By->EditValue = $this->Updated_By->CurrentValue;
        $this->Updated_By->PlaceHolder = RemoveHtml($this->Updated_By->caption());

        // Date_Updated
        $this->Date_Updated->setupEditAttributes();
        $this->Date_Updated->EditValue = FormatDateTime($this->Date_Updated->CurrentValue, $this->Date_Updated->formatPattern());
        $this->Date_Updated->PlaceHolder = RemoveHtml($this->Date_Updated->caption());

        // Call Row Rendered event
        $this->rowRendered();
    }

    // Aggregate list row values
    public function aggregateListRowValues()
    {
    }

    // Aggregate list row (for rendering)
    public function aggregateListRow()
    {
        // Call Row Rendered event
        $this->rowRendered();
    }

    // Export data in HTML/CSV/Word/Excel/Email/PDF format
	// Now including Export Print (printer friendly), modification by Unique Digital Solutions Ltd, September 27, 2022 
    public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
    {
        if (!$recordset || !$doc) {
            return;
        }
        if (!$doc->ExportCustom) {
            // Write header
            $doc->exportTableHeader();
            if ($doc->Horizontal) { // Horizontal format, write header
                $doc->beginExportRow();
                if ($exportPageType == "view") {
                    $doc->exportCaption($this->Event_ID);
                    $doc->exportCaption($this->Event_Title);
                    $doc->exportCaption($this->Event_Color);
                    $doc->exportCaption($this->Event_Start);
                    $doc->exportCaption($this->Event_End);
                    $doc->exportCaption($this->Event_Description);
                    $doc->exportCaption($this->Event_User);
                    $doc->exportCaption($this->Repeat_Type);
                    $doc->exportCaption($this->Repeat_ID);
                    $doc->exportCaption($this->Event_AllDay);
                    $doc->exportCaption($this->Event_URL);
                    $doc->exportCaption($this->Event_Category);
                    $doc->exportCaption($this->Event_Timezone);
                    $doc->exportCaption($this->Added_By);
                    $doc->exportCaption($this->Date_Added);
                    $doc->exportCaption($this->Updated_By);
                    $doc->exportCaption($this->Date_Updated);
                } else {
                    $doc->exportCaption($this->Event_ID);
                    $doc->exportCaption($this->Event_Title);
                    $doc->exportCaption($this->Event_Color);
                    $doc->exportCaption($this->Event_Start);
                    $doc->exportCaption($this->Event_End);
                    $doc->exportCaption($this->Event_User);
                    $doc->exportCaption($this->Repeat_Type);
                    $doc->exportCaption($this->Repeat_ID);
                    $doc->exportCaption($this->Event_AllDay);
                    $doc->exportCaption($this->Event_URL);
                    $doc->exportCaption($this->Event_Category);
                    $doc->exportCaption($this->Event_Timezone);
                    $doc->exportCaption($this->Added_By);
                    $doc->exportCaption($this->Date_Added);
                    $doc->exportCaption($this->Updated_By);
                    $doc->exportCaption($this->Date_Updated);
                }
                $doc->endExportRow();
            }
        }

        // Move to first record
        $recCnt = $startRec - 1;
        $stopRec = ($stopRec > 0) ? $stopRec : PHP_INT_MAX;
		// Begin of modification Record Number in Exported Data by Unique Digital Solutions Ltd, September 27, 2022
		$seqRec = 0;
		if (CurrentPageID() == "view") { // Modified by Unique Digital Solutions Ltd, reset seq. number in View Page
		    $_SESSION["First_Record"] = 0;
			$seqRec = (empty($_SESSION["First_Record"])) ? 0 : $_SESSION["First_Record"] - 1; 
		} else {
			$seqRec = (empty($_SESSION["First_Record"])) ? $recCnt : $_SESSION["First_Record"] - 1;
		}
		// End of modification Record Number in Exported Data by Unique Digital Solutions Ltd, September 27, 2022
        while (!$recordset->EOF && $recCnt < $stopRec) {
            $row = $recordset->fields;
            $recCnt++;
			$seqRec++; // Record Number in Exported Data by Unique Digital Solutions Ltd, September 27, 2022
            if ($recCnt >= $startRec) {
                $rowCnt = $recCnt - $startRec + 1;
                // Page break
				// Begin of modification PageBreak for Export to PDF dan Export to Word by Unique Digital Solutions Ltd, September 27, 2022
                if ($this->ExportPageBreakCount > 0 && ($this->Export == "pdf" || $this->Export =="word")) {
                    if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0) {
                        $doc->exportPageBreak();
						$doc->beginExportRow(); // Begin of modification by Unique Digital Solutions Ltd, table header will be repeated at the top of each page after page break, must be handled from here for Export to PDF that has the possibility to repeat the table header column in each top of page
						$doc->exportCaption($this->Event_ID);
						$doc->exportCaption($this->Event_Title);
						$doc->exportCaption($this->Event_Color);
						$doc->exportCaption($this->Event_Start);
						$doc->exportCaption($this->Event_End);
						$doc->exportCaption($this->Event_User);
						$doc->exportCaption($this->Repeat_Type);
						$doc->exportCaption($this->Repeat_ID);
						$doc->exportCaption($this->Event_AllDay);
						$doc->exportCaption($this->Event_URL);
						$doc->exportCaption($this->Event_Category);
						$doc->exportCaption($this->Event_Timezone);
						$doc->exportCaption($this->Added_By);
						$doc->exportCaption($this->Date_Added);
						$doc->exportCaption($this->Updated_By);
						$doc->exportCaption($this->Date_Updated);
						$doc->endExportRow(); // End of modification by Unique Digital Solutions Ltd, table header will be repeated at the top of each page after page break
                    }
                }
				// End of modification PageBreak for Export to PDF dan Export to Word by Unique Digital Solutions Ltd, September 27, 2022
                $this->loadListRowValues($row);

                // Render row
                $this->RowType = ROWTYPE_VIEW; // Render view
                $this->resetAttributes();
                $this->renderListRow();
                if (!$doc->ExportCustom) {
                    $doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
                    if ($exportPageType == "view") {
                        $doc->exportField($this->Event_ID);
                        $doc->exportField($this->Event_Title);
                        $doc->exportField($this->Event_Color);
                        $doc->exportField($this->Event_Start);
                        $doc->exportField($this->Event_End);
                        $doc->exportField($this->Event_Description);
                        $doc->exportField($this->Event_User);
                        $doc->exportField($this->Repeat_Type);
                        $doc->exportField($this->Repeat_ID);
                        $doc->exportField($this->Event_AllDay);
                        $doc->exportField($this->Event_URL);
                        $doc->exportField($this->Event_Category);
                        $doc->exportField($this->Event_Timezone);
                        $doc->exportField($this->Added_By);
                        $doc->exportField($this->Date_Added);
                        $doc->exportField($this->Updated_By);
                        $doc->exportField($this->Date_Updated);
                    } else {
                        $doc->exportField($this->Event_ID);
                        $doc->exportField($this->Event_Title);
                        $doc->exportField($this->Event_Color);
                        $doc->exportField($this->Event_Start);
                        $doc->exportField($this->Event_End);
                        $doc->exportField($this->Event_User);
                        $doc->exportField($this->Repeat_Type);
                        $doc->exportField($this->Repeat_ID);
                        $doc->exportField($this->Event_AllDay);
                        $doc->exportField($this->Event_URL);
                        $doc->exportField($this->Event_Category);
                        $doc->exportField($this->Event_Timezone);
                        $doc->exportField($this->Added_By);
                        $doc->exportField($this->Date_Added);
                        $doc->exportField($this->Updated_By);
                        $doc->exportField($this->Date_Updated);
                    }
                    $doc->endExportRow($rowCnt);
                }
            }

            // Call Row Export server event
            if ($doc->ExportCustom) {
                $this->rowExport($doc, $row);
            }
            $recordset->moveNext();
        }
        if (!$doc->ExportCustom) {
            $doc->exportTableFooter();
        }
    }

    // Get file data
    public function getFileData($fldparm, $key, $resize, $width = 0, $height = 0, $plugins = [])
    {
        global $DownloadFileName;

        // No binary fields
        return false;
    }

    // Table level events

    // Table Load event
    public function tableLoad()
    {
        // Enter your code here
    }

    // Recordset Selecting event
    public function recordsetSelecting(&$filter)
    {
        // Enter your code here
    }

    // Recordset Selected event
    public function recordsetSelected(&$rs)
    {
        //Log("Recordset Selected");
    }

    // Recordset Search Validated event
    public function recordsetSearchValidated()
    {
        // Example:
        //$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value
    }

    // Recordset Searching event
    public function recordsetSearching(&$filter)
    {
        // Enter your code here
    }

    // Row_Selecting event
    public function rowSelecting(&$filter)
    {
        // Enter your code here
    }

    // Row Selected event
    public function rowSelected(&$rs)
    {
        //Log("Row Selected");
    }

    // Row Inserting event
    public function rowInserting($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Inserted event
    public function rowInserted($rsold, &$rsnew)
    {
        //Log("Row Inserted");
    }

    // Row Updating event
    public function rowUpdating($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Updated event
    public function rowUpdated($rsold, &$rsnew)
    {
        //Log("Row Updated");
    }

    // Row Update Conflict event
    public function rowUpdateConflict($rsold, &$rsnew)
    {
        // Enter your code here
        // To ignore conflict, set return value to false
        return true;
    }

    // Grid Inserting event
    public function gridInserting()
    {
        // Enter your code here
        // To reject grid insert, set return value to false
        return true;
    }

    // Grid Inserted event
    public function gridInserted($rsnew)
    {
        //Log("Grid Inserted");
    }

    // Grid Updating event
    public function gridUpdating($rsold)
    {
        // Enter your code here
        // To reject grid update, set return value to false
        return true;
    }

    // Grid Updated event
    public function gridUpdated($rsold, $rsnew)
    {
        //Log("Grid Updated");
    }

    // Row Deleting event
    public function rowDeleting(&$rs)
    {
        // Enter your code here
        // To cancel, set return value to False
        return true;
    }

    // Row Deleted event
    public function rowDeleted(&$rs)
    {
        //Log("Row Deleted");
    }

    // Email Sending event
    public function emailSending($email, &$args)
    {
        //var_dump($email, $args); exit();
        return true;
    }

    // Lookup Selecting event
    public function lookupSelecting($fld, &$filter)
    {
        //var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
        // Enter your code here
    }

    // Row Rendering event
    public function rowRendering()
    {
        // Enter your code here
    }

    // Row Rendered event
    public function rowRendered()
    {
        // To view properties of field class, use:
        //var_dump($this-><FieldName>);
    }

    // User ID Filtering event
    public function userIdFiltering(&$filter)
    {
        // Enter your code here
    }
}
