<?php

namespace PHPMaker2023\Jack_Jill_school;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\FetchMode;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;

/**
 * Page class
 */
class CiitiesReportSummary extends CiitiesReport
{
    use MessagesTrait;

    // Page ID
    public $PageID = "summary";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "CiitiesReportSummary";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $ReportContainerClass = "ew-grid";
    public $CurrentPageName = "ciitiesreport";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<p id="ew-page-header">' . $header . '</p>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<p id="ew-page-footer">' . $footer . '</p>';
        }
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'Ciities_Report';
        $this->TableName = 'Ciities Report';

        // CSS class name as context
        $this->ContextClass = CheckClassName($this->TableVar);
        AppendClass($this->ReportContainerClass, $this->ContextClass);

        // Fixed header table
        if (!$this->UseCustomTemplate) {
            $this->setFixedHeaderTable(Config("USE_FIXED_HEADER_TABLE"), Config("FIXED_HEADER_TABLE_HEIGHT"));
        }

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("language");

        // Table object (Ciities_Report)
        if (!isset($GLOBALS["Ciities_Report"]) || get_class($GLOBALS["Ciities_Report"]) == PROJECT_NAMESPACE . "Ciities_Report") {
            $GLOBALS["Ciities_Report"] = &$this;
        }

        // Page URL
        $pageUrl = $this->pageUrl(false);

        // Initialize URLs

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'Ciities Report');
        }

        // Start timer
        $DebugTimer = Container("timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");

        // Export options
        $this->ExportOptions = new ListOptions(["TagClassName" => "ew-export-option"]);

        // Filter options
        $this->FilterOptions = new ListOptions(["TagClassName" => "ew-filter-option"]);
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return is_object($Response) ? $Response->getBody() : ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }

        // Global Page Unloaded event (in userfn*.php)
        Page_Unloaded();
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection if not in dashboard
        if (!$DashboardReport) {
            CloseConnections();
        }

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (StartsString("application/json", $Response->getHeaderLine("Content-type")) && $Response->getBody()->getSize()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }
            SaveDebugMessage();
            Redirect(GetUrl($url));
        }
        return; // Return to controller
    }

    // Lookup data
    public function lookup($ar = null)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $ar["field"] ?? Post("field");
        $lookup = $this->Fields[$fieldName]->Lookup;
        $name = $ar["name"] ?? Post("name");
        $isQuery = ContainsString($name, "query_builder_rule");
        if ($isQuery) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }
        if ($lookup->LinkTable == $this->TableVar || property_exists($this, "ReportSourceTable") && $lookup->LinkTable == $this->ReportSourceTable) {
            $lookup->RenderViewFunc = "renderLookup"; // Set up view renderer
        }
        $lookup->RenderEditFunc = ""; // Set up edit renderer

        // Get lookup parameters
        $lookupType = $ar["ajax"] ?? Post("ajax", "unknown");
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $ar["q"] ?? Param("q") ?? $ar["sv"] ?? Post("sv", "");
            $pageSize = $ar["n"] ?? Param("n") ?? $ar["recperpage"] ?? Post("recperpage", 10);
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $ar["q"] ?? Param("q", "");
            $pageSize = $ar["n"] ?? Param("n", -1);
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $ar["start"] ?? Param("start", -1);
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $ar["page"] ?? Param("page", -1);
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($ar["s"] ?? Post("s", ""));
        $userFilter = Decrypt($ar["f"] ?? Post("f", ""));
        $userOrderBy = Decrypt($ar["o"] ?? Post("o", ""));
        $keys = $ar["keys"] ?? Post("keys");
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $ar["v0"] ?? $ar["lookupValue"] ?? Post("v0", Post("lookupValue", ""));
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $ar["v" . $i] ?? Post("v" . $i, "");
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, !is_array($ar)); // Use settings from current page
    }

    // Options
    public $HideOptions = false;
    public $ExportOptions; // Export options
    public $SearchOptions; // Search options
    public $FilterOptions; // Filter options

    // Records
    public $GroupRecords = [];
    public $DetailRecords = [];
    public $DetailRecordCount = 0;

    // Paging variables
    public $RecordIndex = 0; // Record index
    public $RecordCount = 0; // Record count (start from 1 for each group)
    public $StartGroup = 0; // Start group
    public $StopGroup = 0; // Stop group
    public $TotalGroups = 0; // Total groups
    public $GroupCount = 0; // Group count
    public $GroupCounter = []; // Group counter
    public $DisplayGroups = 1; // Groups per page
    public $GroupRange = 10;
    public $PageSizes = ""; // Page sizes (comma separated)
    public $PageFirstGroupFilter = "";
    public $UserIDFilter = "";
    public $DefaultSearchWhere = ""; // Default search WHERE clause
    public $SearchWhere = "";
    public $SearchPanelClass = "ew-search-panel collapse"; // Search Panel class
    public $SearchColumnCount = 0; // For extended search
    public $SearchFieldsPerRow = 1; // For extended search
    public $DrillDownList = "";
    public $DbMasterFilter = ""; // Master filter
    public $DbDetailFilter = ""; // Detail filter
    public $SearchCommand = false;
    public $ShowHeader = true;
    public $GroupColumnCount = 0;
    public $SubGroupColumnCount = 0;
    public $DetailColumnCount = 0;
    public $TotalCount;
    public $PageTotalCount;
    public $TopContentClass = "ew-top";
    public $MiddleContentClass = "ew-middle";
    public $BottomContentClass = "ew-bottom";

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $UserProfile,
            $Security, $DrillDownInPanel, $Breadcrumb,
            $DashboardReport;

        // Set up dashboard report
        $DashboardReport = $DashboardReport || ConvertToBool(Param(Config("PAGE_DASHBOARD"), false));
        if ($DashboardReport) {
            $this->UseAjaxActions = true;
        }

// Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Get export parameters
        $custom = "";
        if (Param("export") !== null) {
            $this->Export = Param("export");
            $custom = Param("custom", "");
        }
        $ExportType = $this->Export; // Get export parameter, used in header
        if ($ExportType != "") {
            global $SkipHeaderFooter;
            $SkipHeaderFooter = true;
        }
        $this->CurrentAction = Param("action"); // Set up current action

        // Setup export options
        $this->setupExportOptions();

        // Global Page Loading event (in userfn*.php)
        Page_Loading();

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Setup other options
        $this->setupOtherOptions();

        // Set up table class
        if ($this->isExport("word") || $this->isExport("excel") || $this->isExport("pdf")) {
            $this->TableClass = "ew-table table-bordered table-sm";
        } else {
            PrependClass($this->TableClass, "table ew-table table-bordered table-sm");
        }

        // Set up report container class
        if (!$this->isExport("word") && !$this->isExport("excel")) {
            $this->ReportContainerClass .= " card ew-card";
        }
		My_Global_Check(); // Modified by UDS Hub, October 6, 2021

        // Set field visibility for detail fields
        $this->NIP->setVisibility();
        $this->Carte_No->setVisibility();
        $this->Nom->setVisibility();
        $this->Prenom->setVisibility();
        $this->Photo->setVisibility();
        $this->DateNaissance->setVisibility();
        $this->Lieu->setVisibility();
        $this->Unique_QR->setVisibility();
        $this->Statut->setVisibility();
        $this->Reference->setVisibility();

        // Set up Breadcrumb
        if (!$this->isExport() && !$DashboardReport) {
            $this->setupBreadcrumb();
        }

        // Check if search command
        $this->SearchCommand = (Get("cmd", "") == "search");

        // Load custom filters
        $this->pageFilterLoad();

        // Process filter list
        if ($this->processFilterList()) {
            $this->terminate();
            return;
        }

        // Extended filter
        $extendedFilter = "";

        // Restore filter list
        $this->restoreFilterList();

        // Build extended filter
        $extendedFilter = $this->getExtendedFilter();
        AddFilter($this->SearchWhere, $extendedFilter);

        // Call Page Selecting event
        $this->pageSelecting($this->SearchWhere);

        // Set up search panel class
        if ($this->SearchWhere != "") {
            AppendClass($this->SearchPanelClass, "show");
        }

        // Get sort
        $this->Sort = $this->getSort();

        // Search options
        $this->setupSearchOptions();

        // Update filter
        AddFilter($this->Filter, $this->SearchWhere);

        // Get total group count
        $sql = $this->buildReportSql($this->getSqlSelectGroup(), $this->getSqlFrom(), $this->getSqlWhere(), $this->getSqlGroupBy(), $this->getSqlHaving(), "", $this->Filter, "");
        $this->TotalGroups = $this->getRecordCount($sql);
        if ($this->DisplayGroups <= 0 || $this->DrillDown) { // Display all groups
            $this->DisplayGroups = $this->TotalGroups;
        }
        $this->StartGroup = 1;

        // Set up start position if not export all
        if ($this->ExportAll && $this->isExport()) {
            $this->DisplayGroups = $this->TotalGroups;
        } else {
            $this->setupStartGroup();
        }

        // Set no record found message
        if ($this->TotalGroups == 0) {
            $this->ShowHeader = false;
            if ($Security->canList()) {
                if ($this->SearchWhere == "0=101") {
                    $this->setWarningMessage($Language->phrase("EnterSearchCriteria"));
                } else {
                    $this->setWarningMessage($Language->phrase("NoRecord"));
                }
            } else {
                $this->setWarningMessage(DeniedMessage());
            }
        }

        // Hide export options if export/dashboard report/hide options
        if ($this->isExport() || $DashboardReport || $this->HideOptions) {
            $this->ExportOptions->hideAllOptions();
        }

        // Hide search/filter options if export/drilldown/dashboard report/hide options
        if ($this->isExport() || $this->DrillDown || $DashboardReport || $this->HideOptions) {
            $this->SearchOptions->hideAllOptions();
            $this->FilterOptions->hideAllOptions();
        }

        // Get group records
        if ($this->TotalGroups > 0) {
            $grpSort = UpdateSortFields($this->getSqlOrderByGroup(), $this->Sort, 2); // Get grouping field only
            $sql = $this->buildReportSql($this->getSqlSelectGroup(), $this->getSqlFrom(), $this->getSqlWhere(), $this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderByGroup(), $this->Filter, $grpSort);
            $grpRs = $sql->setFirstResult(max($this->StartGroup - 1, 0))->setMaxResults($this->DisplayGroups)->execute();
            $this->GroupRecords = $grpRs->fetchAll(); // Get records of first grouping field
            $this->loadGroupRowValues();
            $this->GroupCount = 1;
        }

        // Init detail records
        $this->DetailRecords = [];
        $this->setupFieldCount();

        // Set the last group to display if not export all
        if ($this->ExportAll && $this->isExport()) {
            $this->StopGroup = $this->TotalGroups;
        } else {
            $this->StopGroup = $this->StartGroup + $this->DisplayGroups - 1;
        }

        // Stop group <= total number of groups
        if (intval($this->StopGroup) > intval($this->TotalGroups)) {
            $this->StopGroup = $this->TotalGroups;
        }
        $this->RecordCount = 0;
        $this->RecordIndex = 0;

        // Set up pager
        $this->Pager = new PrevNextPager($this, $this->StartGroup, $this->DisplayGroups, $this->TotalGroups, $this->PageSizes, $this->GroupRange, $this->AutoHidePager, $this->AutoHidePageSizeSelector);

        // Check if no records
        if ($this->TotalGroups == 0) {
            $this->ReportContainerClass .= " ew-no-record";
        }

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            Page_Rendering();

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Load group row values
    public function loadGroupRowValues()
    {
        $cnt = count($this->GroupRecords); // Get record count
        if ($this->GroupCount < $cnt) {
            $this->Localite->setGroupValue(reset($this->GroupRecords[$this->GroupCount]));
        } else {
            $this->Localite->setGroupValue("");
        }
    }

    // Load row values
    public function loadRowValues($record)
    {
        $data = [];
        $data["volontaireID"] = $record['volontaireID'];
        $data["NIP"] = $record['NIP'];
        $data["Carte_No"] = $record['Carte_No'];
        $data["Prenom"] = $record['Prenom'];
        $data["Photo"] = $record['Photo'];
        $data["Sexe"] = $record['Sexe'];
        $data["DateNaissance"] = $record['DateNaissance'];
        $data["Lieu"] = $record['Lieu'];
        $data["Groupe_Sanguin"] = $record['Groupe_Sanguin'];
        $data["Delivree"] = $record['Delivree'];
        $data["Expire"] = $record['Expire'];
        $data["Prevenir"] = $record['Prevenir'];
        $data["Prevenir_Tel"] = $record['Prevenir_Tel'];
        $data["Unique_QR"] = $record['Unique_QR'];
        $data["EmployeeID"] = $record['EmployeeID'];
        $data["Localite"] = $record['Localite'];
        $data["Statut"] = $record['Statut'];
        $data["Reference"] = $record['Reference'];
        $this->Rows[] = $data;
        $this->volontaireID->setDbValue($record['volontaireID']);
        $this->NIP->setDbValue($record['NIP']);
        $this->Carte_No->setDbValue($record['Carte_No']);
        $this->Nom->setDbValue($record['Nom']);
        $this->Prenom->setDbValue($record['Prenom']);
        $this->Photo->Upload->DbValue = $record['Photo'];
        $this->Sexe->setDbValue($record['Sexe']);
        $this->DateNaissance->setDbValue($record['DateNaissance']);
        $this->Lieu->setDbValue($record['Lieu']);
        $this->Groupe_Sanguin->setDbValue($record['Groupe_Sanguin']);
        $this->Delivree->setDbValue($record['Delivree']);
        $this->Expire->setDbValue($record['Expire']);
        $this->Prevenir->setDbValue($record['Prevenir']);
        $this->Prevenir_Tel->setDbValue($record['Prevenir_Tel']);
        $this->Unique_QR->setDbValue($record['Unique_QR']);
        $this->EmployeeID->setDbValue($record['EmployeeID']);
        $this->Localite->setDbValue(GroupValue($this->Localite, $record['Localite']));
        $this->Statut->setDbValue($record['Statut']);
        $this->Reference->setDbValue($record['Reference']);
    }

    // Render row
    public function renderRow()
    {
        global $Security, $Language, $Language;
        $conn = $this->getConnection();
        if ($this->RowType == ROWTYPE_TOTAL && $this->RowTotalSubType == ROWTOTAL_FOOTER && $this->RowTotalType == ROWTOTAL_PAGE) {
            // Build detail SQL
            $firstGrpFld = &$this->Localite;
            $firstGrpFld->getDistinctValues($this->GroupRecords);
            $where = DetailFilterSql($firstGrpFld, $this->getSqlFirstGroupField(), $firstGrpFld->DistinctValues, $this->Dbid);
            if ($this->Filter != "") {
                $where = "($this->Filter) AND ($where)";
            }
            $sql = $this->buildReportSql($this->getSqlSelect(), $this->getSqlFrom(), $this->getSqlWhere(), $this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(), $where, $this->Sort);
            $rs = $sql->execute();
            $records = $rs ? $rs->fetchAll() : [];
            $this->PageTotalCount = count($records);
        } elseif ($this->RowType == ROWTYPE_TOTAL && $this->RowTotalSubType == ROWTOTAL_FOOTER && $this->RowTotalType == ROWTOTAL_GRAND) { // Get Grand total
            $hasCount = false;
            $hasSummary = false;

            // Get total count from SQL directly
            $sql = $this->buildReportSql($this->getSqlSelectCount(), $this->getSqlFrom(), $this->getSqlWhere(), $this->getSqlGroupBy(), $this->getSqlHaving(), "", $this->Filter, "");
            $rstot = $conn->executeQuery($sql);
            if ($rstot && $cnt = $rstot->fetchOne()) {
                $hasCount = true;
            } else {
                $cnt = 0;
            }
            $this->TotalCount = $cnt;
            $hasSummary = true;

            // Accumulate grand summary from detail records
            if (!$hasCount || !$hasSummary) {
                $sql = $this->buildReportSql($this->getSqlSelect(), $this->getSqlFrom(), $this->getSqlWhere(), $this->getSqlGroupBy(), $this->getSqlHaving(), "", $this->Filter, "");
                $rs = $sql->execute();
                $this->DetailRecords = $rs ? $rs->fetchAll() : [];
            }
        }

        // Call Row_Rendering event
        $this->rowRendering();

        // Localite

        // NIP

        // Carte_No

        // Nom

        // Prenom

        // Photo

        // DateNaissance

        // Lieu

        // Unique_QR

        // Statut

        // Reference
        if ($this->RowType == ROWTYPE_SEARCH) {
            // Carte_No
            $this->Carte_No->setupEditAttributes();
            if (!$this->Carte_No->Raw) {
                $this->Carte_No->AdvancedSearch->SearchValue = HtmlDecode($this->Carte_No->AdvancedSearch->SearchValue);
            }
            $this->Carte_No->EditValue = HtmlEncode($this->Carte_No->AdvancedSearch->SearchValue);
            $arwrk = [];
            $arwrk["lf"] = $this->Carte_No->CurrentValue;
            $arwrk["df"] = $this->Carte_No->CurrentValue;
            $arwrk = $this->Carte_No->Lookup->renderViewRow($arwrk, $this);
            $dispVal = $this->Carte_No->displayValue($arwrk);
            if ($dispVal != "") {
                $this->Carte_No->EditValue = $dispVal;
            }
            $this->Carte_No->PlaceHolder = RemoveHtml($this->Carte_No->caption());

            // Unique_QR
            $this->Unique_QR->setupEditAttributes();
            if (!$this->Unique_QR->Raw) {
                $this->Unique_QR->AdvancedSearch->SearchValue = HtmlDecode($this->Unique_QR->AdvancedSearch->SearchValue);
            }
            $this->Unique_QR->EditValue = HtmlEncode($this->Unique_QR->AdvancedSearch->SearchValue);
            $arwrk = [];
            $arwrk["lf"] = $this->Unique_QR->CurrentValue;
            $arwrk["df"] = $this->Unique_QR->CurrentValue;
            $arwrk = $this->Unique_QR->Lookup->renderViewRow($arwrk, $this);
            $dispVal = $this->Unique_QR->displayValue($arwrk);
            if ($dispVal != "") {
                $this->Unique_QR->EditValue = $dispVal;
            }
            $this->Unique_QR->PlaceHolder = RemoveHtml($this->Unique_QR->caption());

            // Localite
            $this->Localite->setupEditAttributes();
            if (!$this->Localite->Raw) {
                $this->Localite->AdvancedSearch->SearchValue = HtmlDecode($this->Localite->AdvancedSearch->SearchValue);
            }
            $this->Localite->EditValue = HtmlEncode($this->Localite->AdvancedSearch->SearchValue);
            $arwrk = [];
            $arwrk["lf"] = $this->Localite->CurrentValue;
            $arwrk["df"] = $this->Localite->CurrentValue;
            $arwrk = $this->Localite->Lookup->renderViewRow($arwrk, $this);
            $dispVal = $this->Localite->displayValue($arwrk);
            if ($dispVal != "") {
                $this->Localite->EditValue = $dispVal;
            }
            $this->Localite->PlaceHolder = RemoveHtml($this->Localite->caption());
        } elseif ($this->RowType == ROWTYPE_TOTAL && !($this->RowTotalType == ROWTOTAL_GROUP && $this->RowTotalSubType == ROWTOTAL_HEADER)) { // Summary row
            $this->RowAttrs->prependClass(($this->RowTotalType == ROWTOTAL_PAGE || $this->RowTotalType == ROWTOTAL_GRAND) ? "ew-rpt-grp-aggregate" : ""); // Set up row class
            if ($this->RowTotalType == ROWTOTAL_GROUP) {
                $this->RowAttrs["data-group"] = $this->Localite->groupValue(); // Set up group attribute
            }

            // Localite
            $this->Localite->GroupViewValue = $this->Localite->groupValue();
            $arwrk = [];
            $arwrk["lf"] = $this->Localite->CurrentValue;
            $arwrk["df"] = $this->Localite->CurrentValue;
            $arwrk = $this->Localite->Lookup->renderViewRow($arwrk, $this);
            $dispVal = $this->Localite->displayValue($arwrk);
            if ($dispVal != "") {
                $this->Localite->GroupViewValue = $dispVal;
            }
            $this->Localite->CssClass = "fw-bold";
            $this->Localite->CellCssClass = "ew-rpt-grp-field-%g";
            $this->Localite->GroupViewValue = DisplayGroupValue($this->Localite, $this->Localite->GroupViewValue);

            // Localite
            $this->Localite->HrefValue = "";

            // NIP
            $this->NIP->HrefValue = "";

            // Carte_No
            $this->Carte_No->HrefValue = "";

            // Nom
            $this->Nom->HrefValue = "";

            // Prenom
            $this->Prenom->HrefValue = "";

            // Photo
            $this->Photo->UploadPath = $this->Photo->getUploadPath(); // PHP
            if (!EmptyValue($this->Photo->Upload->DbValue)) {
                $this->Photo->HrefValue = GetFileUploadUrl($this->Photo, $this->Photo->htmlDecode($this->Photo->Upload->DbValue)); // Add prefix/suffix
                $this->Photo->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->Photo->HrefValue = FullUrl($this->Photo->HrefValue, "href");
                }
            } else {
                $this->Photo->HrefValue = "";
            }
            $this->Photo->ExportHrefValue = $this->Photo->UploadPath . $this->Photo->Upload->DbValue;

            // DateNaissance
            $this->DateNaissance->HrefValue = "";

            // Lieu
            $this->Lieu->HrefValue = "";

            // Unique_QR
            $this->Unique_QR->HrefValue = "";
            $this->Unique_QR->ExportHrefValue = PhpBarcode::barcode(true)->getHrefValue($this->Unique_QR->CurrentValue, 'QRCODE', 60);

            // Statut
            $this->Statut->HrefValue = "";

            // Reference
            $this->Reference->HrefValue = "";
        } else {
            if ($this->RowTotalType == ROWTOTAL_GROUP && $this->RowTotalSubType == ROWTOTAL_HEADER) {
                $this->RowAttrs["data-group"] = $this->Localite->groupValue(); // Set up group attribute
            } else {
                $this->RowAttrs["data-group"] = $this->Localite->groupValue(); // Set up group attribute
            }

            // Localite
            $this->Localite->GroupViewValue = $this->Localite->groupValue();
            $arwrk = [];
            $arwrk["lf"] = $this->Localite->CurrentValue;
            $arwrk["df"] = $this->Localite->CurrentValue;
            $arwrk = $this->Localite->Lookup->renderViewRow($arwrk, $this);
            $dispVal = $this->Localite->displayValue($arwrk);
            if ($dispVal != "") {
                $this->Localite->GroupViewValue = $dispVal;
            }
            $this->Localite->CssClass = "fw-bold";
            $this->Localite->CellCssClass = "ew-rpt-grp-field-1";
            $this->Localite->GroupViewValue = DisplayGroupValue($this->Localite, $this->Localite->GroupViewValue);
            if (!$this->Localite->LevelBreak) {
                $this->Localite->GroupViewValue = "";
            } else {
                $this->Localite->LevelBreak = false;
            }

            // NIP
            $this->NIP->ViewValue = $this->NIP->CurrentValue;
            $this->NIP->CellCssClass = ($this->RecordCount % 2 != 1 ? "ew-table-alt-row" : "");

            // Carte_No
            $this->Carte_No->ViewValue = $this->Carte_No->CurrentValue;
            $arwrk = [];
            $arwrk["lf"] = $this->Carte_No->CurrentValue;
            $arwrk["df"] = $this->Carte_No->CurrentValue;
            $arwrk = $this->Carte_No->Lookup->renderViewRow($arwrk, $this);
            $dispVal = $this->Carte_No->displayValue($arwrk);
            if ($dispVal != "") {
                $this->Carte_No->ViewValue = $dispVal;
            }
            $this->Carte_No->CellCssClass = ($this->RecordCount % 2 != 1 ? "ew-table-alt-row" : "");

            // Nom
            $this->Nom->ViewValue = $this->Nom->CurrentValue;
            $arwrk = [];
            $arwrk["lf"] = $this->Nom->CurrentValue;
            $arwrk["df"] = $this->Nom->CurrentValue;
            $arwrk = $this->Nom->Lookup->renderViewRow($arwrk, $this);
            $dispVal = $this->Nom->displayValue($arwrk);
            if ($dispVal != "") {
                $this->Nom->ViewValue = $dispVal;
            }
            $this->Nom->CellCssClass = ($this->RecordCount % 2 != 1 ? "ew-table-alt-row" : "");

            // Prenom
            $this->Prenom->ViewValue = $this->Prenom->CurrentValue;
            $this->Prenom->CellCssClass = ($this->RecordCount % 2 != 1 ? "ew-table-alt-row" : "");

            // Photo
            $this->Photo->UploadPath = $this->Photo->getUploadPath(); // PHP
            if (!EmptyValue($this->Photo->Upload->DbValue)) {
                $this->Photo->ImageWidth = 100;
                $this->Photo->ImageHeight = 100;
                $this->Photo->ImageAlt = $this->Photo->alt();
                $this->Photo->ImageCssClass = "ew-image";
                $this->Photo->ViewValue = $this->Photo->Upload->DbValue;
            } else {
                $this->Photo->ViewValue = "";
            }
            $this->Photo->CellCssClass = ($this->RecordCount % 2 != 1 ? "ew-table-alt-row" : "");

            // DateNaissance
            $this->DateNaissance->ViewValue = $this->DateNaissance->CurrentValue;
            $this->DateNaissance->ViewValue = FormatDateTime($this->DateNaissance->ViewValue, $this->DateNaissance->formatPattern());
            $this->DateNaissance->CellCssClass = ($this->RecordCount % 2 != 1 ? "ew-table-alt-row" : "");

            // Lieu
            $this->Lieu->ViewValue = $this->Lieu->CurrentValue;
            $arwrk = [];
            $arwrk["lf"] = $this->Lieu->CurrentValue;
            $arwrk["df"] = $this->Lieu->CurrentValue;
            $arwrk = $this->Lieu->Lookup->renderViewRow($arwrk, $this);
            $dispVal = $this->Lieu->displayValue($arwrk);
            if ($dispVal != "") {
                $this->Lieu->ViewValue = $dispVal;
            }
            $this->Lieu->CellCssClass = ($this->RecordCount % 2 != 1 ? "ew-table-alt-row" : "");

            // Unique_QR
            $this->Unique_QR->ViewValue = $this->Unique_QR->CurrentValue;
            $arwrk = [];
            $arwrk["lf"] = $this->Unique_QR->CurrentValue;
            $arwrk["df"] = $this->Unique_QR->CurrentValue;
            $arwrk = $this->Unique_QR->Lookup->renderViewRow($arwrk, $this);
            $dispVal = $this->Unique_QR->displayValue($arwrk);
            if ($dispVal != "") {
                $this->Unique_QR->ViewValue = $dispVal;
            }
            $this->Unique_QR->CellCssClass = ($this->RecordCount % 2 != 1 ? "ew-table-alt-row" : "");

            // Statut
            $this->Statut->ViewValue = $this->Statut->CurrentValue;
            $this->Statut->CellCssClass = ($this->RecordCount % 2 != 1 ? "ew-table-alt-row" : "");

            // Reference
            $this->Reference->ViewValue = $this->Reference->CurrentValue;
            $this->Reference->CellCssClass = ($this->RecordCount % 2 != 1 ? "ew-table-alt-row" : "");

            // Localite
            $this->Localite->HrefValue = "";
            $this->Localite->TooltipValue = "";

            // NIP
            $this->NIP->HrefValue = "";
            $this->NIP->TooltipValue = "";

            // Carte_No
            $this->Carte_No->HrefValue = "";
            $this->Carte_No->TooltipValue = "";

            // Nom
            $this->Nom->HrefValue = "";
            $this->Nom->TooltipValue = "";

            // Prenom
            $this->Prenom->HrefValue = "";
            $this->Prenom->TooltipValue = "";

            // Photo
            $this->Photo->UploadPath = $this->Photo->getUploadPath(); // PHP
            if (!EmptyValue($this->Photo->Upload->DbValue)) {
                $this->Photo->HrefValue = GetFileUploadUrl($this->Photo, $this->Photo->htmlDecode($this->Photo->Upload->DbValue)); // Add prefix/suffix
                $this->Photo->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->Photo->HrefValue = FullUrl($this->Photo->HrefValue, "href");
                }
            } else {
                $this->Photo->HrefValue = "";
            }
            $this->Photo->ExportHrefValue = $this->Photo->UploadPath . $this->Photo->Upload->DbValue;
            $this->Photo->TooltipValue = "";
            if ($this->Photo->UseColorbox) {
                if (EmptyValue($this->Photo->TooltipValue)) {
                    $this->Photo->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
                }
                $this->Photo->LinkAttrs["data-rel"] = "Ciities_Report_x_Photo";
                $this->Photo->LinkAttrs->appendClass("ew-lightbox");
            }

            // DateNaissance
            $this->DateNaissance->HrefValue = "";
            $this->DateNaissance->TooltipValue = "";

            // Lieu
            $this->Lieu->HrefValue = "";
            $this->Lieu->TooltipValue = "";

            // Unique_QR
            $this->Unique_QR->HrefValue = "";
            $this->Unique_QR->ExportHrefValue = PhpBarcode::barcode(true)->getHrefValue($this->Unique_QR->CurrentValue, 'QRCODE', 60);
            $this->Unique_QR->TooltipValue = "";

            // Statut
            $this->Statut->HrefValue = "";
            $this->Statut->TooltipValue = "";

            // Reference
            $this->Reference->HrefValue = "";
            $this->Reference->TooltipValue = "";
        }

        // Call Cell_Rendered event
        if ($this->RowType == ROWTYPE_TOTAL) {
            // Localite
            $currentValue = $this->Localite->GroupViewValue;
            $viewValue = &$this->Localite->GroupViewValue;
            $viewAttrs = &$this->Localite->ViewAttrs;
            $cellAttrs = &$this->Localite->CellAttrs;
            $hrefValue = &$this->Localite->HrefValue;
            $linkAttrs = &$this->Localite->LinkAttrs;
            $this->cellRendered($this->Localite, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);
        } else {
            // Localite
            $currentValue = $this->Localite->groupValue();
            $viewValue = &$this->Localite->GroupViewValue;
            $viewAttrs = &$this->Localite->ViewAttrs;
            $cellAttrs = &$this->Localite->CellAttrs;
            $hrefValue = &$this->Localite->HrefValue;
            $linkAttrs = &$this->Localite->LinkAttrs;
            $this->cellRendered($this->Localite, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

            // NIP
            $currentValue = $this->NIP->CurrentValue;
            $viewValue = &$this->NIP->ViewValue;
            $viewAttrs = &$this->NIP->ViewAttrs;
            $cellAttrs = &$this->NIP->CellAttrs;
            $hrefValue = &$this->NIP->HrefValue;
            $linkAttrs = &$this->NIP->LinkAttrs;
            $this->cellRendered($this->NIP, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

            // Carte_No
            $currentValue = $this->Carte_No->CurrentValue;
            $viewValue = &$this->Carte_No->ViewValue;
            $viewAttrs = &$this->Carte_No->ViewAttrs;
            $cellAttrs = &$this->Carte_No->CellAttrs;
            $hrefValue = &$this->Carte_No->HrefValue;
            $linkAttrs = &$this->Carte_No->LinkAttrs;
            $this->cellRendered($this->Carte_No, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

            // Nom
            $currentValue = $this->Nom->CurrentValue;
            $viewValue = &$this->Nom->ViewValue;
            $viewAttrs = &$this->Nom->ViewAttrs;
            $cellAttrs = &$this->Nom->CellAttrs;
            $hrefValue = &$this->Nom->HrefValue;
            $linkAttrs = &$this->Nom->LinkAttrs;
            $this->cellRendered($this->Nom, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

            // Prenom
            $currentValue = $this->Prenom->CurrentValue;
            $viewValue = &$this->Prenom->ViewValue;
            $viewAttrs = &$this->Prenom->ViewAttrs;
            $cellAttrs = &$this->Prenom->CellAttrs;
            $hrefValue = &$this->Prenom->HrefValue;
            $linkAttrs = &$this->Prenom->LinkAttrs;
            $this->cellRendered($this->Prenom, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

            // Photo
            $currentValue = $this->Photo->CurrentValue;
            $viewValue = &$this->Photo->ViewValue;
            $viewAttrs = &$this->Photo->ViewAttrs;
            $cellAttrs = &$this->Photo->CellAttrs;
            $hrefValue = &$this->Photo->HrefValue;
            $linkAttrs = &$this->Photo->LinkAttrs;
            $this->cellRendered($this->Photo, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

            // DateNaissance
            $currentValue = $this->DateNaissance->CurrentValue;
            $viewValue = &$this->DateNaissance->ViewValue;
            $viewAttrs = &$this->DateNaissance->ViewAttrs;
            $cellAttrs = &$this->DateNaissance->CellAttrs;
            $hrefValue = &$this->DateNaissance->HrefValue;
            $linkAttrs = &$this->DateNaissance->LinkAttrs;
            $this->cellRendered($this->DateNaissance, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

            // Lieu
            $currentValue = $this->Lieu->CurrentValue;
            $viewValue = &$this->Lieu->ViewValue;
            $viewAttrs = &$this->Lieu->ViewAttrs;
            $cellAttrs = &$this->Lieu->CellAttrs;
            $hrefValue = &$this->Lieu->HrefValue;
            $linkAttrs = &$this->Lieu->LinkAttrs;
            $this->cellRendered($this->Lieu, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

            // Unique_QR
            $currentValue = $this->Unique_QR->CurrentValue;
            $viewValue = &$this->Unique_QR->ViewValue;
            $viewAttrs = &$this->Unique_QR->ViewAttrs;
            $cellAttrs = &$this->Unique_QR->CellAttrs;
            $hrefValue = &$this->Unique_QR->HrefValue;
            $linkAttrs = &$this->Unique_QR->LinkAttrs;
            $this->cellRendered($this->Unique_QR, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

            // Statut
            $currentValue = $this->Statut->CurrentValue;
            $viewValue = &$this->Statut->ViewValue;
            $viewAttrs = &$this->Statut->ViewAttrs;
            $cellAttrs = &$this->Statut->CellAttrs;
            $hrefValue = &$this->Statut->HrefValue;
            $linkAttrs = &$this->Statut->LinkAttrs;
            $this->cellRendered($this->Statut, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

            // Reference
            $currentValue = $this->Reference->CurrentValue;
            $viewValue = &$this->Reference->ViewValue;
            $viewAttrs = &$this->Reference->ViewAttrs;
            $cellAttrs = &$this->Reference->CellAttrs;
            $hrefValue = &$this->Reference->HrefValue;
            $linkAttrs = &$this->Reference->LinkAttrs;
            $this->cellRendered($this->Reference, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);
        }

        // Call Row_Rendered event
        $this->rowRendered();
        $this->setupFieldCount();
    }
    private $groupCounts = [];

    // Get group count
    public function getGroupCount(...$args)
    {
        $key = "";
        foreach ($args as $arg) {
            if ($key != "") {
                $key .= "_";
            }
            $key .= strval($arg);
        }
        if ($key == "") {
            return -1;
        } elseif ($key == "0") { // Number of first level groups
            $i = 1;
            while (isset($this->groupCounts[strval($i)])) {
                $i++;
            }
            return $i - 1;
        }
        return isset($this->groupCounts[$key]) ? $this->groupCounts[$key] : -1;
    }

    // Set group count
    public function setGroupCount($value, ...$args)
    {
        $key = "";
        foreach ($args as $arg) {
            if ($key != "") {
                $key .= "_";
            }
            $key .= strval($arg);
        }
        if ($key == "") {
            return;
        }
        $this->groupCounts[$key] = $value;
    }

    // Setup field count
    protected function setupFieldCount()
    {
        $this->GroupColumnCount = 0;
        $this->SubGroupColumnCount = 0;
        $this->DetailColumnCount = 0;
        if ($this->Localite->Visible) {
            $this->GroupColumnCount += 1;
        }
        if ($this->NIP->Visible) {
            $this->DetailColumnCount += 1;
        }
        if ($this->Carte_No->Visible) {
            $this->DetailColumnCount += 1;
        }
        if ($this->Nom->Visible) {
            $this->DetailColumnCount += 1;
        }
        if ($this->Prenom->Visible) {
            $this->DetailColumnCount += 1;
        }
        if ($this->Photo->Visible) {
            $this->DetailColumnCount += 1;
        }
        if ($this->DateNaissance->Visible) {
            $this->DetailColumnCount += 1;
        }
        if ($this->Lieu->Visible) {
            $this->DetailColumnCount += 1;
        }
        if ($this->Unique_QR->Visible) {
            $this->DetailColumnCount += 1;
        }
        if ($this->Statut->Visible) {
            $this->DetailColumnCount += 1;
        }
        if ($this->Reference->Visible) {
            $this->DetailColumnCount += 1;
        }
    }

// Get export HTML tag
    protected function getExportTag($type, $custom = false)
    {
        global $Language;

        // if ($type == "print" || $custom) {
        //    $pageUrl = $this->pageUrl(false); // removed by UDS Hub, Sept 27, 2022 ... Printer Friendly (print) using API EXPORT ACTION, too!

        //    $exportUrl = GetUrl($pageUrl . "export=" . $type . ($custom ? "&amp;custom=1" : "")); // removed by UDS Hub, Sept 27, 2022 ... Printer Friendly (print) using API EXPORT ACTION, too!
        // } else {
            //$query = GetCsrfAsQuery();

            //$exportUrl = GetApiUrl(Config("API_EXPORT_ACTION") . "/" . $type . "/" . $this->TableVar, $query);
        // } // removed by UDS Hub, Sept 27, 2022 ... Printer Friendly (print) using API EXPORT ACTION, too!

		// Begin of modification, moved to Client-Side into masinoew.js file, by UDS Hub, September 27, 2022
		if ($type == "print" || $custom) { // Begin of added Printer Friendly, by UDS Hub, September 27, 2022
			$pageUrl = $this->pageUrl(false);
			$exportUrl = GetUrl($pageUrl . "export=" . $type . ($custom ? "&amp;custom=1" : ""));
		} else { // else for Export other than Printer Friendly
			$exportUrl = GetApiUrl(Config("API_EXPORT_ACTION") . "/" . $type . "/" . $this->TableVar);
		}
		// End of modification, moved to Client-Side into masinoew.js file, by UDS Hub, September 27, 2022
        if (SameText($type, "excel")) {
            return '<button type="button" class="btn btn-default ew-export-link ew-excel" title="' . HtmlEncode($Language->phrase("ExportToExcel", true)) . '" data-caption="' . HtmlEncode($Language->phrase("ExportToExcel", true)) . '" data-ew-action="export" data-export="excel" data-custom="false" data-export-selected="false" data-url="' . $exportUrl . '">' . $Language->phrase("ExportToExcel") . '</button>';
        } elseif (SameText($type, "word")) {
            return '<button type="button" class="btn btn-default ew-export-link ew-word" title="' . HtmlEncode($Language->phrase("ExportToWord", true)) . '" data-caption="' . HtmlEncode($Language->phrase("ExportToWord", true)) . '" data-ew-action="export" data-export="word" data-custom="false" data-export-selected="false" data-url="' . $exportUrl . '">' . $Language->phrase("ExportToWord") . '</button>';
        } elseif (SameText($type, "pdf")) {
            return '<button type="button" class="btn btn-default ew-export-link ew-pdf" title="' . HtmlEncode($Language->phrase("ExportToPdf", true)) . '" data-caption="' . HtmlEncode($Language->phrase("ExportToPdf", true)) . '" data-ew-action="export" data-export="pdf" data-custom="false" data-export-selected="false" data-url="' . $exportUrl . '">' . $Language->phrase("ExportToPdf") . '</button>';
        } elseif (SameText($type, "html")) {
            return '<button type="button" class="btn btn-default ew-export-link ew-html" title="' . HtmlEncode($Language->phrase("ExportToHtml", true)) . '" data-caption="' . HtmlEncode($Language->phrase("ExportToHtml", true)) . '" data-ew-action="export" data-export="html" data-custom="false" data-export-selected="false" data-url="' . $exportUrl . '">' . $Language->phrase("ExportToHtml") . '</button>';
        } elseif (SameText($type, "email")) {
            return '<button type="button" class="btn btn-default ew-export-link ew-email" title="' . HtmlEncode($Language->phrase("ExportToEmail", true)) . '" data-caption="' . HtmlEncode($Language->phrase("ExportToEmail", true)) . '" data-ew-action="email" data-custom="false" data-export-selected="false" data-hdr="' . HtmlEncode($Language->phrase("ExportToEmail", true)) . '" data-url="' . $exportUrl . '">' . $Language->phrase("ExportToEmail") . '</button>';
        } elseif (SameText($type, "print")) {
            return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-print\" title=\"" . HtmlEncode($Language->phrase("PrinterFriendly", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("PrinterFriendly", true)) . "\">" . $Language->phrase("PrinterFriendly") . "</a>";
        }
    }

    // Set up export options
    protected function setupExportOptions()
    {
        global $Language, $Security;

        // Printer friendly
        $item = &$this->ExportOptions->add("print");
        $item->Body = $this->getExportTag("print");
        if (MS_ENABLE_PERMISSION_FOR_EXPORT_DATA == TRUE) { // customized by UDS Hub, September 25, 2020
			$item->Visible = $Security->canExportToPrint();
		} else {
			$item->Visible = true;
		}

        // Export to Excel
        $item = &$this->ExportOptions->add("excel");
        $item->Body = $this->getExportTag("excel");
        if (MS_ENABLE_PERMISSION_FOR_EXPORT_DATA == TRUE) { // customized by UDS Hub, September 25, 2020
			$item->Visible = $Security->canExportToExcel();
		} else {
			$item->Visible = true;
		}

        // Export to Word
        $item = &$this->ExportOptions->add("word");
        $item->Body = $this->getExportTag("word");
        if (MS_ENABLE_PERMISSION_FOR_EXPORT_DATA == TRUE) { // customized by UDS Hub, September 25, 2020
			$item->Visible = $Security->canExportToWord();
		} else {
			$item->Visible = true;
		}

        // Export to HTML
        $item = &$this->ExportOptions->add("html");
        $item->Body = $this->getExportTag("html");
        if (MS_ENABLE_PERMISSION_FOR_EXPORT_DATA == TRUE) { // customized by UDS Hub, September 25, 2020
			$item->Visible = $Security->canExportToHTML();
		} else {
			$item->Visible = true;
		}

        // Export to PDF
        $item = &$this->ExportOptions->add("pdf");
        $item->Body = $this->getExportTag("pdf");
        if (MS_ENABLE_PERMISSION_FOR_EXPORT_DATA == TRUE) { // customized by UDS Hub, September 25, 2020
			$item->Visible = $Security->canExportToPDF();
		} else {
			$item->Visible = false;
		}

        // Export to Email
        $item = &$this->ExportOptions->add("email");
        $item->Body = $this->getExportTag("email");
        if (MS_ENABLE_PERMISSION_FOR_EXPORT_DATA == TRUE) { // customized by UDS Hub, September 25, 2020
			$item->Visible = $Security->canExportToEmail();
		} else {
			$item->Visible = true;
		}

        // Drop down button for export
        $this->ExportOptions->UseButtonGroup = true;
        $this->ExportOptions->UseDropDownButton = true;
        if ($this->ExportOptions->UseButtonGroup && IsMobile()) {
            $this->ExportOptions->UseDropDownButton = true;
        }
        $this->ExportOptions->DropDownButtonPhrase = $Language->phrase("ButtonExport");

        // Add group option item
        $item = &$this->ExportOptions->addGroupOption();
        $item->Body = "";
        $item->Visible = false;

        // Hide options for export
        if ($this->isExport()) {
            $this->ExportOptions->hideAllOptions();
        }
        if (!$Security->canExport()) { // Export not allowed
            $this->ExportOptions->hideAllOptions();
        }
    }

    // Set up search options
    protected function setupSearchOptions()
    {
        global $Language, $Security;
        $pageUrl = $this->pageUrl(false);
        $this->SearchOptions = new ListOptions(["TagClassName" => "ew-search-option"]);

	    // Search button
        $item = &$this->SearchOptions->add("searchtoggle");
		if (@$_COOKIE['Ciities_Report_searchpanel'] == 'notactive') {
			$item->Body = "<a class=\"btn btn-default ew-search-toggle\" role=\"button\" title=\"" . $Language->phrase("SearchPanel") . "\" data-caption=\"" . $Language->phrase("SearchPanel") . "\" data-ew-action=\"search-toggle\" data-form=\"fCiities_Reportsrch\" aria-pressed=\"false\">" . $Language->phrase("SearchLink") . "</a>";
		} else {
			// $item->Body = "<a class=\"btn btn-default ew-search-toggle\" role=\"button\" title=\"" . $Language->phrase("SearchPanel") . "\" data-caption=\"" . $Language->phrase("SearchPanel") . "\" data-ew-action=\"search-toggle\" data-form=\"fCiities_Reportsrch\" aria-pressed=\"false\">" . $Language->phrase("SearchLink") . "</a>";
			$item->Body = "<a class=\"btn btn-default ew-search-toggle active\" role=\"button\" title=\"" . $Language->phrase("SearchPanel") . "\" data-caption=\"" . $Language->phrase("SearchPanel") . "\" data-ew-action=\"search-toggle\" data-form=\"fCiities_Reportsrch\" aria-pressed=\"true\">" . $Language->phrase("SearchLink") . "</a>";
		}
        $item->Visible = true;

        // Show all button
        $item = &$this->SearchOptions->add("showall");
        if ($this->UseCustomTemplate || !$this->UseAjaxActions) {
            $item->Body = "<a class=\"btn btn-default ew-show-all\" role=\"button\" title=\"" . $Language->phrase("ShowAll") . "\" data-caption=\"" . $Language->phrase("ShowAll") . "\" href=\"" . $pageUrl . "cmd=reset\">" . $Language->phrase("ShowAllBtn") . "</a>";
        } else {
            $item->Body = "<a class=\"btn btn-default ew-show-all\" role=\"button\" title=\"" . $Language->phrase("ShowAll") . "\" data-caption=\"" . $Language->phrase("ShowAll") . "\" data-ew-action=\"refresh\" data-url=\"" . $pageUrl . "cmd=reset\">" . $Language->phrase("ShowAllBtn") . "</a>";
        }
        $item->Visible = ($this->SearchWhere != $this->DefaultSearchWhere && $this->SearchWhere != "0=101");

        // Button group for search
        $this->SearchOptions->UseDropDownButton = false;
        $this->SearchOptions->UseButtonGroup = true;
        $this->SearchOptions->DropDownButtonPhrase = $Language->phrase("ButtonSearch");

        // Add group option item
        $item = &$this->SearchOptions->addGroupOption();
        $item->Body = "";
        $item->Visible = false;

        // Hide search options
        if ($this->isExport() || $this->CurrentAction && $this->CurrentAction != "search") {
            $this->SearchOptions->hideAllOptions();
        }
        if (!$Security->canSearch()) {
            $this->SearchOptions->hideAllOptions();
            $this->FilterOptions->hideAllOptions();
        }
    }

    // Check if any search fields
    public function hasSearchFields()
    {
        return $this->Carte_No->Visible || $this->Unique_QR->Visible || $this->Localite->Visible;
    }

    // Render search options
    protected function renderSearchOptions()
    {
        if (!$this->hasSearchFields() && $this->SearchOptions["searchtoggle"]) {
            $this->SearchOptions["searchtoggle"]->Visible = false;
        }
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("index");
        $url = CurrentUrl();
        $url = preg_replace('/\?cmd=reset(all){0,1}$/i', '', $url); // Remove cmd=reset(all)
        $Breadcrumb->add("summary", $this->TableVar, $url, "", $this->TableVar, true);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup !== null && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_Carte_No":
                    break;
                case "x_Nom":
                    break;
                case "x_Sexe":
                    break;
                case "x_Lieu":
                    break;
                case "x_Unique_QR":
                    break;
                case "x_EmployeeID":
                    break;
                case "x_Localite":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Set up other options
    protected function setupOtherOptions()
    {
        global $Language, $Security;

        // Filter button
        $item = &$this->FilterOptions->add("savecurrentfilter");
        $item->Body = "<a class=\"ew-save-filter\" data-form=\"fCiities_Reportsrch\" data-ew-action=\"none\">" . $Language->phrase("SaveCurrentFilter") . "</a>";
        $item->Visible = true;
        $item = &$this->FilterOptions->add("deletefilter");
        $item->Body = "<a class=\"ew-delete-filter\" data-form=\"fCiities_Reportsrch\" data-ew-action=\"none\">" . $Language->phrase("DeleteFilter") . "</a>";
        $item->Visible = true;
        $this->FilterOptions->UseDropDownButton = true;
        $this->FilterOptions->UseButtonGroup = !$this->FilterOptions->UseDropDownButton;
        $this->FilterOptions->DropDownButtonPhrase = $Language->phrase("Filters");

        // Add group option item
        $item = &$this->FilterOptions->addGroupOption();
        $item->Body = "";
        $item->Visible = false;
    }

    // Set up starting group
    protected function setupStartGroup()
    {
        // Exit if no groups
        if ($this->DisplayGroups == 0) {
            return;
        }
        $startGrp = Param(Config("TABLE_START_GROUP"));
        $pageNo = Param(Config("TABLE_PAGE_NUMBER"));

        // Check for a 'start' parameter
        if ($startGrp !== null) {
            $this->StartGroup = $startGrp;
            $this->setStartGroup($this->StartGroup);
        } elseif ($pageNo !== null) {
            $pageNo = ParseInteger($pageNo);
            if (is_numeric($pageNo)) {
                $this->StartGroup = ($pageNo - 1) * $this->DisplayGroups + 1;
                if ($this->StartGroup <= 0) {
                    $this->StartGroup = 1;
                } elseif ($this->StartGroup >= intval(($this->TotalGroups - 1) / $this->DisplayGroups) * $this->DisplayGroups + 1) {
                    $this->StartGroup = intval(($this->TotalGroups - 1) / $this->DisplayGroups) * $this->DisplayGroups + 1;
                }
                $this->setStartGroup($this->StartGroup);
            } else {
                $this->StartGroup = $this->getStartGroup();
            }
        } else {
            $this->StartGroup = $this->getStartGroup();
        }

        // Check if correct start group counter
        if (!is_numeric($this->StartGroup) || intval($this->StartGroup) <= 0) { // Avoid invalid start group counter
            $this->StartGroup = 1; // Reset start group counter
            $this->setStartGroup($this->StartGroup);
        } elseif (intval($this->StartGroup) > intval($this->TotalGroups)) { // Avoid starting group > total groups
            $this->StartGroup = intval(($this->TotalGroups - 1) / $this->DisplayGroups) * $this->DisplayGroups + 1; // Point to last page first group
            $this->setStartGroup($this->StartGroup);
        } elseif (($this->StartGroup - 1) % $this->DisplayGroups != 0) {
            $this->StartGroup = intval(($this->StartGroup - 1) / $this->DisplayGroups) * $this->DisplayGroups + 1; // Point to page boundary
            $this->setStartGroup($this->StartGroup);
        }
    }

    // Reset pager
    protected function resetPager()
    {
        // Reset start position (reset command)
        $this->StartGroup = 1;
        $this->setStartGroup($this->StartGroup);
    }

    // Get sort parameters based on sort links clicked
    protected function getSort()
    {
        if ($this->DrillDown) {
            return "Carte_No ASC";
        }
        $resetSort = Param("cmd") === "resetsort";
        $orderBy = Param("order", "");
        $orderType = Param("ordertype", "");

        // Check for a resetsort command
        if ($resetSort) {
            $this->setOrderBy("");
            $this->setStartGroup(1);
            $this->NIP->setSort("");
            $this->Carte_No->setSort("");
            $this->Nom->setSort("");
            $this->Prenom->setSort("");
            $this->Photo->setSort("");
            $this->DateNaissance->setSort("");
            $this->Lieu->setSort("");
            $this->Unique_QR->setSort("");
            $this->Localite->setSort("");
            $this->Statut->setSort("");
            $this->Reference->setSort("");

        // Check for an Order parameter
        } elseif ($orderBy != "") {
            $this->CurrentOrder = $orderBy;
            $this->CurrentOrderType = $orderType;
            $this->updateSort($this->NIP); // NIP
            $this->updateSort($this->Carte_No); // Carte_No
            $this->updateSort($this->Nom); // Nom
            $this->updateSort($this->Prenom); // Prenom
            $this->updateSort($this->Photo); // Photo
            $this->updateSort($this->DateNaissance); // DateNaissance
            $this->updateSort($this->Lieu); // Lieu
            $this->updateSort($this->Unique_QR); // Unique_QR
            $this->updateSort($this->Localite); // Localite
            $this->updateSort($this->Statut); // Statut
            $this->updateSort($this->Reference); // Reference
            $sortSql = $this->sortSql();
            $this->setOrderBy($sortSql);
            $this->setStartGroup(1);
        }

        // Set up default sort
        if ($this->getOrderBy() == "") {
            $useDefaultSort = true;
            if ($useDefaultSort) {
                $this->setOrderBy("Carte_No ASC");
            }
        }
        return $this->getOrderBy();
    }

    // Return extended filter
    protected function getExtendedFilter()
    {
        $filter = "";
        if ($this->DrillDown) {
            return "";
        }
        $restoreSession = false;
        $restoreDefault = false;
        // Reset search command
        if (Get("cmd") == "reset") {
            // Set default values
            $this->Carte_No->AdvancedSearch->unsetSession();
            $this->Unique_QR->AdvancedSearch->unsetSession();
            $this->Localite->AdvancedSearch->unsetSession();
            $restoreDefault = true;
        } else {
            $restoreSession = !$this->SearchCommand;

            // Field Carte_No
            if ($this->Carte_No->AdvancedSearch->get()) {
            if ($this->Carte_No->DataType == DATATYPE_DATE) { // Format default date format
                $this->Carte_No->AdvancedSearch->SearchValue = FormatDateTime($this->Carte_No->AdvancedSearch->SearchValue, 0);
            }
            }

            // Field Unique_QR
            if ($this->Unique_QR->AdvancedSearch->get()) {
            if ($this->Unique_QR->DataType == DATATYPE_DATE) { // Format default date format
                $this->Unique_QR->AdvancedSearch->SearchValue = FormatDateTime($this->Unique_QR->AdvancedSearch->SearchValue, 0);
            }
            }

            // Field Localite
            if ($this->Localite->AdvancedSearch->get()) {
            if ($this->Localite->DataType == DATATYPE_DATE) { // Format default date format
                $this->Localite->AdvancedSearch->SearchValue = FormatDateTime($this->Localite->AdvancedSearch->SearchValue, 0);
            }
            }
            if (!$this->validateForm()) {
                return $filter;
            }
        }

        // Restore session
        if ($restoreSession) {
            $restoreDefault = true;
            if ($this->Carte_No->AdvancedSearch->issetSession()) { // Field Carte_No
                $this->Carte_No->AdvancedSearch->load();
                $restoreDefault = false;
            }
            if ($this->Unique_QR->AdvancedSearch->issetSession()) { // Field Unique_QR
                $this->Unique_QR->AdvancedSearch->load();
                $restoreDefault = false;
            }
            if ($this->Localite->AdvancedSearch->issetSession()) { // Field Localite
                $this->Localite->AdvancedSearch->load();
                $restoreDefault = false;
            }
        }

        // Restore default
        if ($restoreDefault) {
            $this->loadDefaultFilters();
        }

        // Call page filter validated event
        $this->pageFilterValidated();

        // Build SQL and save to session
        $this->buildExtendedFilter($this->Carte_No, $filter, false, true); // Field Carte_No
        $this->Carte_No->AdvancedSearch->save();
        $this->buildExtendedFilter($this->Unique_QR, $filter, false, true); // Field Unique_QR
        $this->Unique_QR->AdvancedSearch->save();
        $this->buildExtendedFilter($this->Localite, $filter, false, true); // Field Localite
        $this->Localite->AdvancedSearch->save();
        return $filter;
    }

    // Build dropdown filter
    protected function buildDropDownFilter(&$fld, &$filterClause, $default = false, $saveFilter = false)
    {
        $fldVal = $default ? $fld->AdvancedSearch->SearchValueDefault : $fld->AdvancedSearch->SearchValue;
        $fldOpr = $default ? $fld->AdvancedSearch->SearchOperatorDefault : $fld->AdvancedSearch->SearchOperator;
        $fldVal2 = $default ? $fld->AdvancedSearch->SearchValue2Default : $fld->AdvancedSearch->SearchValue2;
        if (!EmptyValue($fld->DateFilter)) {
            $fldOpr = $fld->DateFilter;
            $fldVal2 = "";
        } elseif ($fld->UseFilter) {
            $fldOpr = "";
            $fldVal2 = "";
        }
        $sql = "";
        if (is_array($fldVal)) {
            foreach ($fldVal as $val) {
                $wrk = $this->getDropDownFilter($fld, $val, $fldOpr);
                if ($wrk != "") {
                    if ($sql != "") {
                        $sql .= " OR " . $wrk;
                    } else {
                        $sql = $wrk;
                    }
                }
            }
        } else {
            $sql = $this->getDropDownFilter($fld, $fldVal, $fldOpr, $fldVal2);
        }
        if ($sql != "") {
            $cond = SameText($this->SearchOption, "OR") ? "OR" : "AND";
            AddFilter($filterClause, $sql, $cond);
            if ($saveFilter) {
                $fld->CurrentFilter = $sql;
            }
        }
    }

    /**
     * Get dropdown filter
     *
     * @param ReportField $fld Report field object
     * @param string $fldVal Filter value
     * @param string $fldOpr Filter operator
     * @param string $fldVal2 Filter value 2
     * @return string WHERE clause
     */
    protected function getDropDownFilter($fld, $fldVal, $fldOpr, $fldVal2 = "")
    {
        $fldName = $fld->Name;
        $fldExpression = $fld->Expression;
        $fldDataType = $fld->DataType;
        $fldOpr = $fldOpr ?: "=";
        $fldVal = ConvertSearchValue($fldVal, $fldOpr, $fld);
        $wrk = "";
        if (SameString($fldVal, Config("NULL_VALUE"))) {
            $wrk = $fldExpression . " IS NULL";
        } elseif (SameString($fldVal, Config("NOT_NULL_VALUE"))) {
            $wrk = $fldExpression . " IS NOT NULL";
        } elseif (SameString($fldVal, Config("EMPTY_VALUE"))) {
            $wrk = $fldExpression . " = ''";
        } elseif (SameString($fldVal, Config("ALL_VALUE"))) {
            $wrk = "1 = 1";
        } else {
            if ($fld->GroupSql != "") { // Use grouping SQL for search if exists
                $fldExpression = str_replace("%s", $fldExpression, $fld->GroupSql);
            }
            if (StartsString("@@", $fldVal)) {
                $wrk = $this->getCustomFilter($fld, $fldVal, $this->Dbid);
            } elseif (($fld->isMultiSelect() || $fld->UseFilter) && IsMultiSearchOperator($fldOpr) && !EmptyValue($fldVal) && $fldVal != Config("INIT_VALUE")) {
                $wrk = GetMultiSearchSql($fld, $fldOpr, trim($fldVal), $this->Dbid);
            } elseif ($fldOpr == "BETWEEN" && !EmptyValue($fldVal) && $fldVal != Config("INIT_VALUE") && !EmptyValue($fldVal2) && $fldVal2 != Config("INIT_VALUE")) {
                $wrk = $fldExpression ." " . $fldOpr . " " . QuotedValue($fldVal, $fldDataType, $this->Dbid) . " AND " . QuotedValue($fldVal2, $fldDataType, $this->Dbid);
            } else {
                if ($fldVal != "" && $fldVal != Config("INIT_VALUE")) {
                    if ($fldDataType == DATATYPE_DATE && $fldOpr != "") {
                        $wrk = GetDateFilterSql($fld->Expression, $fldOpr, $fldVal, $fldDataType, $this->Dbid);
                    } else {
                        $wrk = SearchFilter($fldExpression, $fldOpr, $fldVal, $fldDataType, $this->Dbid);
                    }
                }
            }
        }

        // Call Page Filtering event
        if (!StartsString("@@", $fldVal)) {
            $this->pageFiltering($fld, $wrk, "dropdown", $fldOpr, $fldVal, "", "", $fldVal2);
        }
        return $wrk;
    }

    // Get custom filter
    protected function getCustomFilter(&$fld, $fldVal, $dbid = 0)
    {
        $wrk = "";
        if (is_array($fld->AdvancedFilters)) {
            foreach ($fld->AdvancedFilters as $filter) {
                if ($filter->ID == $fldVal && $filter->Enabled) {
                    $fldExpr = $fld->Expression;
                    $fn = $filter->FunctionName;
                    $wrkid = StartsString("@@", $filter->ID) ? substr($filter->ID, 2) : $filter->ID;
                    $fn = $fn != "" && !function_exists($fn) ? PROJECT_NAMESPACE . $fn : $fn;
                    if (function_exists($fn)) {
                        $wrk = $fn($fldExpr, $dbid);
                    } else {
                        $wrk = "";
                    }
                    $this->pageFiltering($fld, $wrk, "custom", $wrkid);
                    break;
                }
            }
        }
        return $wrk;
    }

    // Build extended filter
    protected function buildExtendedFilter(&$fld, &$filterClause, $default = false, $saveFilter = false)
    {
        $wrk = GetExtendedFilter($fld, $default, $this->Dbid);
        if (!$default) {
            $this->pageFiltering($fld, $wrk, "extended", $fld->AdvancedSearch->SearchOperator, $fld->AdvancedSearch->SearchValue, $fld->AdvancedSearch->SearchCondition, $fld->AdvancedSearch->SearchOperator2, $fld->AdvancedSearch->SearchValue2);
        }
        if ($wrk != "") {
            $cond = SameText($this->SearchOption, "OR") ? "OR" : "AND";
            AddFilter($filterClause, $wrk, $cond);
            if ($saveFilter) {
                $fld->CurrentFilter = $wrk;
            }
        }
    }

    // Get drop down value from querystring
    protected function getDropDownValue(&$fld)
    {
        if (IsPost()) {
            return false; // Skip post back
        }
        $res = false;
        $parm = $fld->Param;
        $opr = Get("z_$parm");
        if ($opr !== null) {
            $fld->AdvancedSearch->SearchOperator = $opr;
        }
        $val = Get("x_$parm");
        if ($val !== null) {
            if (is_array($val)) {
                $val = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $val);
            }
            $fld->AdvancedSearch->setSearchValue($val);
            $res = true;
        }
        $val2 = Get("y_$parm");
        if ($val2 !== null) {
            if (is_array($val2)) {
                $val2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $val2);
            }
            $fld->AdvancedSearch->setSearchValue2($val2);
            $res = true;
        }
        return $res;
    }

    // Dropdown filter exist
    protected function dropDownFilterExist(&$fld)
    {
        $wrk = "";
        $this->buildDropDownFilter($fld, $wrk);
        return ($wrk != "");
    }

    // Extended filter exist
    protected function extendedFilterExist(&$fld)
    {
        $extWrk = "";
        $this->buildExtendedFilter($fld, $extWrk);
        return ($extWrk != "");
    }

    // Validate form
    protected function validateForm()
    {
        global $Language;

        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }

        // Return validate result
        $validateForm = !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Load default value for filters
    protected function loadDefaultFilters()
    {
        // Field Carte_No
        $this->Carte_No->AdvancedSearch->loadDefault();

        // Field Unique_QR
        $this->Unique_QR->AdvancedSearch->loadDefault();

        // Field Localite
        $this->Localite->AdvancedSearch->loadDefault();
    }

    // Show list of filters
    public function showFilterList()
    {
        global $Language;

        // Initialize
        $filterList = "";
        $captionClass = $this->isExport("email") ? "ew-filter-caption-email" : "ew-filter-caption";
        $captionSuffix = $this->isExport("email") ? ": " : "";

        // Field Carte_No
        $extWrk = "";
        $this->buildExtendedFilter($this->Carte_No, $extWrk);
        $filter = "";
        if ($extWrk != "") {
            $filter .= "<span class=\"ew-filter-value\">$extWrk</span>";
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->Carte_No->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field Unique_QR
        $extWrk = "";
        $this->buildExtendedFilter($this->Unique_QR, $extWrk);
        $filter = "";
        if ($extWrk != "") {
            $filter .= "<span class=\"ew-filter-value\">$extWrk</span>";
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->Unique_QR->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field Localite
        $extWrk = "";
        $this->buildExtendedFilter($this->Localite, $extWrk);
        $filter = "";
        if ($extWrk != "") {
            $filter .= "<span class=\"ew-filter-value\">$extWrk</span>";
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->Localite->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Show Filters
        if ($filterList != "") {
            $message = "<div id=\"ew-filter-list\" class=\"callout callout-info d-table\"><div id=\"ew-current-filters\">" .
                $Language->phrase("CurrentFilters") . "</div>" . $filterList . "</div>";
            $this->messageShowing($message, "");
            Write($message);
        } else { // Output empty tag
            Write("<div id=\"ew-filter-list\"></div>");
        }
    }

    // Get list of filters
    public function getFilterList()
    {
        global $UserProfile;

        // Initialize
        $filterList = "";
        $savedFilterList = "";

        // Load server side filters
        if (Config("SEARCH_FILTER_OPTION") == "Server" && isset($UserProfile)) {
            $savedFilterList = $UserProfile->getSearchFilters(CurrentUserName(), "fCiities_Reportsrch");
        }

        // Field Carte_No
        $wrk = "";
        if ($this->Carte_No->AdvancedSearch->SearchValue != "" || $this->Carte_No->AdvancedSearch->SearchValue2 != "") {
            $wrk = "\"x_Carte_No\":\"" . JsEncode($this->Carte_No->AdvancedSearch->SearchValue) . "\"," .
                "\"z_Carte_No\":\"" . JsEncode($this->Carte_No->AdvancedSearch->SearchOperator) . "\"," .
                "\"v_Carte_No\":\"" . JsEncode($this->Carte_No->AdvancedSearch->SearchCondition) . "\"," .
                "\"y_Carte_No\":\"" . JsEncode($this->Carte_No->AdvancedSearch->SearchValue2) . "\"," .
                "\"w_Carte_No\":\"" . JsEncode($this->Carte_No->AdvancedSearch->SearchOperator2) . "\"";
        }
        if ($wrk != "") {
            if ($filterList != "") {
                $filterList .= ",";
            }
            $filterList .= $wrk;
        }

        // Field Unique_QR
        $wrk = "";
        if ($this->Unique_QR->AdvancedSearch->SearchValue != "" || $this->Unique_QR->AdvancedSearch->SearchValue2 != "") {
            $wrk = "\"x_Unique_QR\":\"" . JsEncode($this->Unique_QR->AdvancedSearch->SearchValue) . "\"," .
                "\"z_Unique_QR\":\"" . JsEncode($this->Unique_QR->AdvancedSearch->SearchOperator) . "\"," .
                "\"v_Unique_QR\":\"" . JsEncode($this->Unique_QR->AdvancedSearch->SearchCondition) . "\"," .
                "\"y_Unique_QR\":\"" . JsEncode($this->Unique_QR->AdvancedSearch->SearchValue2) . "\"," .
                "\"w_Unique_QR\":\"" . JsEncode($this->Unique_QR->AdvancedSearch->SearchOperator2) . "\"";
        }
        if ($wrk != "") {
            if ($filterList != "") {
                $filterList .= ",";
            }
            $filterList .= $wrk;
        }

        // Field Localite
        $wrk = "";
        if ($this->Localite->AdvancedSearch->SearchValue != "" || $this->Localite->AdvancedSearch->SearchValue2 != "") {
            $wrk = "\"x_Localite\":\"" . JsEncode($this->Localite->AdvancedSearch->SearchValue) . "\"," .
                "\"z_Localite\":\"" . JsEncode($this->Localite->AdvancedSearch->SearchOperator) . "\"," .
                "\"v_Localite\":\"" . JsEncode($this->Localite->AdvancedSearch->SearchCondition) . "\"," .
                "\"y_Localite\":\"" . JsEncode($this->Localite->AdvancedSearch->SearchValue2) . "\"," .
                "\"w_Localite\":\"" . JsEncode($this->Localite->AdvancedSearch->SearchOperator2) . "\"";
        }
        if ($wrk != "") {
            if ($filterList != "") {
                $filterList .= ",";
            }
            $filterList .= $wrk;
        }

        // Return filter list in json
        if ($filterList != "") {
            $filterList = "\"data\":{" . $filterList . "}";
        }
        if ($savedFilterList != "") {
            $filterList = Concat($filterList, "\"filters\":" . $savedFilterList, ",");
        }
        return ($filterList != "") ? "{" . $filterList . "}" : "null";
    }

    // Process filter list
    protected function processFilterList()
    {
        global $UserProfile;
        if (Post("ajax") == "savefilters") { // Save filter request (Ajax)
            $filters = Post("filters");
            $UserProfile->setSearchFilters(CurrentUserName(), "fCiities_Reportsrch", $filters);
            WriteJson([["success" => true]]); // Success
            return true;
        } elseif (Post("cmd") == "resetfilter") {
            $this->restoreFilterList();
        }
        return false;
    }

    // Restore list of filters
    protected function restoreFilterList()
    {
        // Return if not reset filter
        if (Post("cmd", "") != "resetfilter") {
            return false;
        }
        $filter = json_decode(Post("filter", ""), true);
        return $this->setupFilterList($filter);
    }

    // Setup list of filters
    protected function setupFilterList($filter)
    {
        if (!is_array($filter)) {
            return false;
        }

        // Field Carte_No
        if (!$this->Carte_No->AdvancedSearch->get($filter)) {
            $this->Carte_No->AdvancedSearch->loadDefault(); // Clear filter
        }
        $this->Carte_No->AdvancedSearch->save();

        // Field Unique_QR
        if (!$this->Unique_QR->AdvancedSearch->get($filter)) {
            $this->Unique_QR->AdvancedSearch->loadDefault(); // Clear filter
        }
        $this->Unique_QR->AdvancedSearch->save();

        // Field Localite
        if (!$this->Localite->AdvancedSearch->get($filter)) {
            $this->Localite->AdvancedSearch->loadDefault(); // Clear filter
        }
        $this->Localite->AdvancedSearch->save();
        return true;
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == 'success') {
            //$msg = "your success message";
        } elseif ($type == 'failure') {
            //$msg = "your failure message";
        } elseif ($type == 'warning') {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Page Selecting event
    public function pageSelecting(&$filter)
    {
        // Enter your code here
    }

    // Load Filters event
    public function pageFilterLoad()
    {
        // Enter your code here
        // Example: Register/Unregister Custom Extended Filter
        //RegisterFilter($this-><Field>, 'StartsWithA', 'Starts With A', 'GetStartsWithAFilter'); // With function, or
        //RegisterFilter($this-><Field>, 'StartsWithA', 'Starts With A'); // No function, use Page_Filtering event
        //UnregisterFilter($this-><Field>, 'StartsWithA');
    }

    // Page Filter Validated event
    public function pageFilterValidated()
    {
        // Example:
        //$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value
    }

    // Page Filtering event
    public function pageFiltering(&$fld, &$filter, $typ, $opr = "", $val = "", $cond = "", $opr2 = "", $val2 = "")
    {
        // Note: ALWAYS CHECK THE FILTER TYPE ($typ)! Example:
        //if ($typ == "dropdown" && $fld->Name == "MyField") // Dropdown filter
        //    $filter = "..."; // Modify the filter
        //if ($typ == "extended" && $fld->Name == "MyField") // Extended filter
        //    $filter = "..."; // Modify the filter
        //if ($typ == "custom" && $opr == "..." && $fld->Name == "MyField") // Custom filter, $opr is the custom filter ID
        //    $filter = "..."; // Modify the filter
    }

    // Cell Rendered event
    public function cellRendered(&$Field, $CurrentValue, &$ViewValue, &$ViewAttrs, &$CellAttrs, &$HrefValue, &$LinkAttrs)
    {
        //$ViewValue = "xxx";
        //$ViewAttrs["class"] = "xxx";
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
