<?php

namespace PHPMaker2023\Jack_Jill_school;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\FetchMode;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;

/**
 * Page class
 */
class Calendar1Calendar extends Calendar1
{
    use MessagesTrait;

    // Page ID
    public $PageID = "calendar";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "Calendar1Calendar";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $ReportContainerClass = "ew-grid";
    public $CurrentPageName = "calendar1";

    // Page URLs
    public $AddUrl;
    public $EditUrl;
    public $DeleteUrl;
    public $ViewUrl;
    public $CopyUrl;

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<p id="ew-page-header">' . $header . '</p>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<p id="ew-page-footer">' . $footer . '</p>';
        }
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'Calendar1';
        $this->TableName = 'Calendar1';

        // Start/End fields
        $this->Fields['Start']->DateTimeFormat = 1;
        $this->Fields['End']->DateTimeFormat = 1;

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("language");

        // Table object (Calendar1)
        if (!isset($GLOBALS["Calendar1"]) || get_class($GLOBALS["Calendar1"]) == PROJECT_NAMESPACE . "Calendar1") {
            $GLOBALS["Calendar1"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'Calendar1');
        }

        // Start timer
        $DebugTimer = Container("timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return is_object($Response) ? $Response->getBody() : ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }

        // Global Page Unloaded event (in userfn*.php)
        Page_Unloaded();
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection if not in dashboard
        if (!$DashboardReport) {
            CloseConnections();
        }

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (StartsString("application/json", $Response->getHeaderLine("Content-type")) && $Response->getBody()->getSize()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }
            SaveDebugMessage();
            Redirect(GetUrl($url));
        }
        return; // Return to controller
    }

    /**
     * Full calendar event object fields (see https://fullcalendar.io/docs/event-object)
     *
     * @var array
     */
    public $EventFields = [
        "id" => "Id",
        "groupId" => "GroupId",
        "allDay" => "AllDay",
        "start" => "Start",
        "end" => "End",
        "startStr" => null,
        "endStr" => null,
        "title" => "Title",
        "url" => "Url",
        "classNames" => "ClassNames",
        "editable" => null,
        "startEditable" => null,
        "durationEditable" => null,
        "resourceEditable" => null,
        "display" => "Display",
        "overlap" => null,
        "constraint" => null,
        "backgroundColor" => "BackgroundColor",
        "borderColor" => null,
        "textColor" => null,
        "extendedProps" => null,
        "source" => null,
        "description" => "Description",
    ];

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $UserProfile, $Language, $Security, $CurrentForm;

// Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));
        $this->CurrentAction = Param("action"); // Set up current action

        // Global Page Loading event (in userfn*.php)
        Page_Loading();

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }
		My_Global_Check(); // Modified by Unique Digital Solutions Ltd, October 6, 2021

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Set up View/Add/Edit/Delete URL
        $this->ViewUrl = $Security->canView() ? "calendar1view" : "";
        $this->AddUrl = $Security->canAdd() ? "calendar1add" : "";
        $this->EditUrl = $Security->canEdit() ? "calendar1edit" : "";
        $this->CopyUrl = $Security->canAdd() ? "calendar1add" : "";
        $this->DeleteUrl = $Security->canDelete() ? "calendar1delete" : "";

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            Page_Rendering();

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get event field name
    public function getEventFieldName($id)
    {
        return $this->EventFields[$id] ?? "";
    }

    /**
     * Get events
     *
     * Note: Use ISO8601 string for date fields so FullCalendar can parse (see https://fullcalendar.io/docs/date-parsing)
     * No UTC offset specified, parsing will depend on the default time zone 'local' (see https://fullcalendar.io/docs/timeZone)
     * @return array
     */
    public function getEvents()
    {
        // Call Page Selecting event
        $this->pageSelecting($this->Filter);
        $sql = $this->buildSelectSql($this->getSqlSelect(), $this->getSqlFrom(), $this->getSqlWhere(), "", "", "", $this->Filter, "");
        $result = $sql->execute();
        $events = $result->fetchAllAssociative();
        $this->Fields['Start']->FormatPattern = "yyyy-MM-dd'T'HH:mm:ss";
        $this->Fields['End']->FormatPattern = "yyyy-MM-dd'T'HH:mm:ss";
        return array_map(function ($event) {
            $this->loadRowValues($event);
            $this->resetAttributes();
            $this->RowType = ROWTYPE_VIEW;
            $this->renderRow();
            return $this->getEvent();
        }, $events);
    }

    /**
     * Load row values from record
     *
     * @param array $row Record
     * @return void
     */
    protected function loadRowValues($row)
    {
        $this->Id->setDbValue($row['Id']);
        $this->_Title->setDbValue($row['Title']);
        $this->Start->setDbValue($row['Start']);
        $this->End->setDbValue($row['End']);
        $this->AllDay->setDbValue($row['AllDay']);
        $this->Description->setDbValue($row['Description']);
        $this->GroupId->setDbValue($row['GroupId']);
        $this->Url->setDbValue($row['Url']);
        $this->ClassNames->setDbValue($row['ClassNames']);
        $this->Display->setDbValue($row['Display']);
        $this->BackgroundColor->setDbValue($row['BackgroundColor']);
    }

    /**
     * Render row
     *
     * @return void
     */
    public function renderRow()
    {
        global $Security, $Language;
        $conn = $this->getConnection();

        // Call Row_Rendering event
        $this->rowRendering();

        // Id

        // Title

        // Start

        // End

        // AllDay

        // Description

        // GroupId

        // Url

        // ClassNames

        // Display

        // BackgroundColor
        if ($this->RowType == ROWTYPE_VIEW) {
            // Id
            $this->Id->ViewValue = $this->Id->CurrentValue;

            // Title
            $this->_Title->ViewValue = $this->_Title->CurrentValue;

            // Start
            $this->Start->ViewValue = $this->Start->CurrentValue;
            $this->Start->ViewValue = FormatDateTime($this->Start->ViewValue, $this->Start->formatPattern());

            // End
            $this->End->ViewValue = $this->End->CurrentValue;
            $this->End->ViewValue = FormatDateTime($this->End->ViewValue, $this->End->formatPattern());

            // AllDay
            if (ConvertToBool($this->AllDay->CurrentValue)) {
                $this->AllDay->ViewValue = $this->AllDay->tagCaption(1) != "" ? $this->AllDay->tagCaption(1) : "Yes";
            } else {
                $this->AllDay->ViewValue = $this->AllDay->tagCaption(2) != "" ? $this->AllDay->tagCaption(2) : "No";
            }

            // Description
            $this->Description->ViewValue = $this->Description->CurrentValue;

            // GroupId
            $this->GroupId->ViewValue = $this->GroupId->CurrentValue;

            // Url
            $this->Url->ViewValue = $this->Url->CurrentValue;

            // ClassNames
            $this->ClassNames->ViewValue = $this->ClassNames->CurrentValue;

            // Display
            if (strval($this->Display->CurrentValue) != "") {
                $this->Display->ViewValue = $this->Display->optionCaption($this->Display->CurrentValue);
            } else {
                $this->Display->ViewValue = null;
            }

            // BackgroundColor
            $this->BackgroundColor->ViewValue = $this->BackgroundColor->CurrentValue;

            // Id
            $this->Id->HrefValue = "";
            $this->Id->TooltipValue = "";

            // Title
            $this->_Title->HrefValue = "";
            $this->_Title->TooltipValue = "";

            // Start
            $this->Start->HrefValue = "";
            $this->Start->TooltipValue = "";

            // End
            $this->End->HrefValue = "";
            $this->End->TooltipValue = "";

            // AllDay
            $this->AllDay->HrefValue = "";
            $this->AllDay->TooltipValue = "";

            // Description
            $this->Description->HrefValue = "";
            $this->Description->TooltipValue = "";

            // GroupId
            $this->GroupId->HrefValue = "";
            $this->GroupId->TooltipValue = "";

            // Url
            $this->Url->HrefValue = "";
            $this->Url->TooltipValue = "";

            // ClassNames
            $this->ClassNames->HrefValue = "";
            $this->ClassNames->TooltipValue = "";

            // Display
            $this->Display->HrefValue = "";
            $this->Display->TooltipValue = "";

            // BackgroundColor
            $this->BackgroundColor->HrefValue = "";
            $this->BackgroundColor->TooltipValue = "";
        }

        // Call Row_Rendered event
        $this->rowRendered();
    }

    /**
     * Get event
     *
     * @return array Output data
     */
    protected function getEvent()
    {
        $eventListFields = ["Id","Title","Start","End","AllDay","Description","GroupId","Url","ClassNames","Display","BackgroundColor"];
        $event = [];
        foreach ($this->Fields as $fld) {
            if ($fld->DataType == DATATYPE_BLOB || !in_array($fld->Name, $eventListFields)) { // Skip blob fields / non list fields
                continue;
            }
            $name = array_search($fld->Name, $this->EventFields) ?: $fld->Name;
            $value = $fld->isBoolean()
                ? ConvertToBool($fld->CurrentValue)
                : (is_null($fld->CurrentValue) ? "" : $fld->getViewValue());
            $event[$name] = $value;
        }
        return $event;
    }

    /**
     * Get calendar options As JSON
     *
     * @return string
     */
    public function getCalendarOptions() {
		global $TIME_FORMAT;
		$defaultDate = CurrentDate();
		if (!empty(@$_COOKIE['calendarDefaultDate'])) {
			$defaultDate = $_COOKIE['calendarDefaultDate'];
		}
		$defaultView = 'dayGridMonth';
		if (!empty(@$_COOKIE['calendarDefaultView'])) {
			$defaultView = $_COOKIE['calendarDefaultView'];
		}
        return ArrayToJson([
            "fullCalendarOptions" => [
                "selectable" => true,
                "direction" => IsRTL() ? "rtl" : "ltr",
                "locale" => CurrentLanguageID(),
				"eventTimeFormat" => $TIME_FORMAT,
                "events" => $this->getEvents(),
				"initialDate" => $defaultDate,
				"initialView" => $defaultView,
				"firstDay" => 1, // first day, 0 = Sunday, 1 = Monday, etc...,
				"navLinks" => true,
				"weekNumbers" => true,
				"businessHours" => true
            ],
            "updateTable" => $this->UpdateTable,
            "viewUrl" => $this->ViewUrl,
            "editUrl" => $this->EditUrl,
            "deleteUrl" => $this->DeleteUrl,
            "addUrl" => $this->AddUrl,
			"copyUrl" => $this->CopyUrl,
            "eventFields" => $this->EventFields
        ]);
    }

// Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("index");
        $url = CurrentUrl();
        $url = preg_replace('/\?cmd=reset(all){0,1}$/i', '', $url); // Remove cmd=reset(all)
        $Breadcrumb->add("calendar", $this->TableVar, $url, "", $this->TableVar, true);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup !== null && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_AllDay":
                    break;
                case "x_ClassNames":
                    break;
                case "x_Display":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Set up other options
    protected function setupOtherOptions()
    {
        global $Language, $Security;

        // Filter button
        $item = &$this->FilterOptions->add("savecurrentfilter");
        $item->Body = "<a class=\"ew-save-filter\" data-form=\"fCalendar1srch\" data-ew-action=\"none\">" . $Language->phrase("SaveCurrentFilter") . "</a>";
        $item->Visible = false;
        $item = &$this->FilterOptions->add("deletefilter");
        $item->Body = "<a class=\"ew-delete-filter\" data-form=\"fCalendar1srch\" data-ew-action=\"none\">" . $Language->phrase("DeleteFilter") . "</a>";
        $item->Visible = false;
        $this->FilterOptions->UseDropDownButton = true;
        $this->FilterOptions->UseButtonGroup = !$this->FilterOptions->UseDropDownButton;
        $this->FilterOptions->DropDownButtonPhrase = $Language->phrase("Filters");

        // Add group option item
        $item = &$this->FilterOptions->addGroupOption();
        $item->Body = "";
        $item->Visible = false;
    }

    // Set up starting group
    protected function setupStartGroup()
    {
        // Exit if no groups
        if ($this->DisplayGroups == 0) {
            return;
        }
        $startGrp = Param(Config("TABLE_START_GROUP"));
        $pageNo = Param(Config("TABLE_PAGE_NUMBER"));

        // Check for a 'start' parameter
        if ($startGrp !== null) {
            $this->StartGroup = $startGrp;
            $this->setStartGroup($this->StartGroup);
        } elseif ($pageNo !== null) {
            $pageNo = ParseInteger($pageNo);
            if (is_numeric($pageNo)) {
                $this->StartGroup = ($pageNo - 1) * $this->DisplayGroups + 1;
                if ($this->StartGroup <= 0) {
                    $this->StartGroup = 1;
                } elseif ($this->StartGroup >= intval(($this->TotalGroups - 1) / $this->DisplayGroups) * $this->DisplayGroups + 1) {
                    $this->StartGroup = intval(($this->TotalGroups - 1) / $this->DisplayGroups) * $this->DisplayGroups + 1;
                }
                $this->setStartGroup($this->StartGroup);
            } else {
                $this->StartGroup = $this->getStartGroup();
            }
        } else {
            $this->StartGroup = $this->getStartGroup();
        }

        // Check if correct start group counter
        if (!is_numeric($this->StartGroup) || intval($this->StartGroup) <= 0) { // Avoid invalid start group counter
            $this->StartGroup = 1; // Reset start group counter
            $this->setStartGroup($this->StartGroup);
        } elseif (intval($this->StartGroup) > intval($this->TotalGroups)) { // Avoid starting group > total groups
            $this->StartGroup = intval(($this->TotalGroups - 1) / $this->DisplayGroups) * $this->DisplayGroups + 1; // Point to last page first group
            $this->setStartGroup($this->StartGroup);
        } elseif (($this->StartGroup - 1) % $this->DisplayGroups != 0) {
            $this->StartGroup = intval(($this->StartGroup - 1) / $this->DisplayGroups) * $this->DisplayGroups + 1; // Point to page boundary
            $this->setStartGroup($this->StartGroup);
        }
    }

    // Reset pager
    protected function resetPager()
    {
        // Reset start position (reset command)
        $this->StartGroup = 1;
        $this->setStartGroup($this->StartGroup);
    }

    // Get sort parameters based on sort links clicked
    protected function getSort()
    {
        if ($this->DrillDown) {
            return "";
        }
        $resetSort = Param("cmd") === "resetsort";
        $orderBy = Param("order", "");
        $orderType = Param("ordertype", "");

        // Check for a resetsort command
        if ($resetSort) {
            $this->setOrderBy("");
            $this->setStartGroup(1);
            $this->Id->setSort("");
            $this->_Title->setSort("");
            $this->Start->setSort("");
            $this->End->setSort("");
            $this->AllDay->setSort("");
            $this->Description->setSort("");
            $this->GroupId->setSort("");
            $this->Url->setSort("");
            $this->ClassNames->setSort("");
            $this->Display->setSort("");
            $this->BackgroundColor->setSort("");

        // Check for an Order parameter
        } elseif ($orderBy != "") {
            $this->CurrentOrder = $orderBy;
            $this->CurrentOrderType = $orderType;
            $this->updateSort($this->Id); // Id
            $this->updateSort($this->_Title); // Title
            $this->updateSort($this->Start); // Start
            $this->updateSort($this->End); // End
            $this->updateSort($this->AllDay); // AllDay
            $this->updateSort($this->Description); // Description
            $this->updateSort($this->GroupId); // GroupId
            $this->updateSort($this->Url); // Url
            $this->updateSort($this->ClassNames); // ClassNames
            $this->updateSort($this->Display); // Display
            $this->updateSort($this->BackgroundColor); // BackgroundColor
            $sortSql = $this->sortSql();
            $this->setOrderBy($sortSql);
            $this->setStartGroup(1);
        }
        return $this->getOrderBy();
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == 'success') {
            //$msg = "your success message";
        } elseif ($type == 'failure') {
            //$msg = "your failure message";
        } elseif ($type == 'warning') {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        $footer = <<<'EOD'
        <script type="text/html" data-name="event-popover" data-seq="10">
        Start: {{:extendedProps.dateStart}}
        <br>End: {{:extendedProps.dateEnd}}
        <br>Desc: {{:extendedProps.description}}
        </script>
        EOD;
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Page Selecting event
    public function pageSelecting(&$filter)
    {
        // Enter your code here
    }
}
