/*!
  * Tempus Dominus v6.2.10 (https://getdatepicker.com/)
  * Copyright 2013-2022 Jonathan Peterson
  * Licensed under MIT (https://github.com/Eonasdan/tempus-dominus/blob/master/LICENSE)
  */
var tempusDominus=function(e,t){"use strict";function s(e){return e&&"object"==typeof e&&"default"in e?e:{default:e}}function i(e){if(e&&e.__esModule)return e;var t=Object.create(null);return e&&Object.keys(e).forEach((function(s){if("default"!==s){var i=Object.getOwnPropertyDescriptor(e,s);Object.defineProperty(t,s,i.get?i:{enumerable:!0,get:function(){return e[s]}})}})),t.default=e,t}var a,o=s(e),n=i(t);!function(e){e.seconds="seconds",e.minutes="minutes",e.hours="hours",e.date="date",e.month="month",e.year="year"}(a||(a={}));const r={month:"2-digit",day:"2-digit",year:"numeric",hour:"2-digit",minute:"2-digit",second:"2-digit"},c=e=>{switch(e){case"date":return{dateStyle:"short"};case"month":return{month:"numeric",year:"numeric"};case"year":return{year:"numeric"}}};class DateTime extends Date{constructor(){super(...arguments),this.locale="default",this.nonLeapLadder=[0,31,59,90,120,151,181,212,243,273,304,334],this.leapLadder=[0,31,60,91,121,152,182,213,244,274,305,335]}setLocale(e){return this.locale=e,this}static convert(e,t="default"){if(!e)throw new Error("A date is required");return new DateTime(e.getFullYear(),e.getMonth(),e.getDate(),e.getHours(),e.getMinutes(),e.getSeconds(),e.getMilliseconds()).setLocale(t)}static fromString(e,t){return new DateTime(e)}get clone(){return new DateTime(this.year,this.month,this.date,this.hours,this.minutes,this.seconds,this.getMilliseconds()).setLocale(this.locale)}startOf(e,t=0){if(void 0===this[e])throw new Error(`Unit '${e}' is not valid`);switch(e){case"seconds":this.setMilliseconds(0);break;case"minutes":this.setSeconds(0,0);break;case"hours":this.setMinutes(0,0,0);break;case"date":this.setHours(0,0,0,0);break;case"weekDay":{if(this.startOf(a.date),this.weekDay===t)break;let e=this.weekDay;0!==t&&0===this.weekDay&&(e=8-t),this.manipulate(t-e,a.date);break}case"month":this.startOf(a.date),this.setDate(1);break;case"year":this.startOf(a.date),this.setMonth(0,1)}return this}endOf(e,t=0){if(void 0===this[e])throw new Error(`Unit '${e}' is not valid`);switch(e){case"seconds":this.setMilliseconds(999);break;case"minutes":this.setSeconds(59,999);break;case"hours":this.setMinutes(59,59,999);break;case"date":this.setHours(23,59,59,999);break;case"weekDay":{this.endOf(a.date);const e=6+t;if(this.weekDay===e)break;this.manipulate(e-this.weekDay,a.date);break}case"month":this.endOf(a.date),this.manipulate(1,a.month),this.setDate(0);break;case"year":this.endOf(a.date),this.setMonth(11,31)}return this}manipulate(e,t){if(void 0===this[t])throw new Error(`Unit '${t}' is not valid`);return this[t]+=e,this}format(e,t=this.locale){return new Intl.DateTimeFormat(t,e).format(this)}isBefore(e,t){if(!t)return this.valueOf()<e.valueOf();if(void 0===this[t])throw new Error(`Unit '${t}' is not valid`);return this.clone.startOf(t).valueOf()<e.clone.startOf(t).valueOf()}isAfter(e,t){if(!t)return this.valueOf()>e.valueOf();if(void 0===this[t])throw new Error(`Unit '${t}' is not valid`);return this.clone.startOf(t).valueOf()>e.clone.startOf(t).valueOf()}isSame(e,t){if(!t)return this.valueOf()===e.valueOf();if(void 0===this[t])throw new Error(`Unit '${t}' is not valid`);return e=DateTime.convert(e),this.clone.startOf(t).valueOf()===e.startOf(t).valueOf()}isBetween(e,t,s,i="()"){if(s&&void 0===this[s])throw new Error(`Unit '${s}' is not valid`);const a="("===i[0],o=")"===i[1];return(a?this.isAfter(e,s):!this.isBefore(e,s))&&(o?this.isBefore(t,s):!this.isAfter(t,s))||(a?this.isBefore(e,s):!this.isAfter(e,s))&&(o?this.isAfter(t,s):!this.isBefore(t,s))}parts(e=this.locale,t={dateStyle:"full",timeStyle:"long"}){const s={};return new Intl.DateTimeFormat(e,t).formatToParts(this).filter((e=>"literal"!==e.type)).forEach((e=>s[e.type]=e.value)),s}get seconds(){return this.getSeconds()}set seconds(e){this.setSeconds(e)}get secondsFormatted(){return this.parts(void 0,r).second}get minutes(){return this.getMinutes()}set minutes(e){this.setMinutes(e)}get minutesFormatted(){return this.parts(void 0,r).minute}get hours(){return this.getHours()}set hours(e){this.setHours(e)}getHoursFormatted(e="h12"){return this.parts(void 0,{...r,hourCycle:e}).hour}meridiem(e=this.locale){return new Intl.DateTimeFormat(e,{hour:"numeric",hour12:!0}).formatToParts(this).find((e=>"dayPeriod"===e.type))?.value}get date(){return this.getDate()}set date(e){this.setDate(e)}get dateFormatted(){return this.parts(void 0,r).day}get weekDay(){return this.getDay()}get month(){return this.getMonth()}set month(e){const t=new Date(this.year,e+1);t.setDate(0);const s=t.getDate();this.date>s&&(this.date=s),this.setMonth(e)}get monthFormatted(){return this.parts(void 0,r).month}get year(){return this.getFullYear()}set year(e){this.setFullYear(e)}get week(){const e=this.computeOrdinal(),t=this.getUTCDay();let s=Math.floor((e-t+10)/7);return s<1?s=this.weeksInWeekYear(this.year-1):s>this.weeksInWeekYear(this.year)&&(s=1),s}weeksInWeekYear(e){const t=(e+Math.floor(e/4)-Math.floor(e/100)+Math.floor(e/400))%7,s=e-1,i=(s+Math.floor(s/4)-Math.floor(s/100)+Math.floor(s/400))%7;return 4===t||3===i?53:52}get isLeapYear(){return this.year%4==0&&(this.year%100!=0||this.year%400==0)}computeOrdinal(){return this.date+(this.isLeapYear?this.leapLadder:this.nonLeapLadder)[this.month]}}class TdError extends Error{}const d="tempus-dominus";class Namespace{}Namespace.NAME=d,Namespace.dataKey="td",Namespace.events=new class Events{constructor(){this.key=".td",this.change=`change${this.key}`,this.update=`update${this.key}`,this.error=`error${this.key}`,this.show=`show${this.key}`,this.hide=`hide${this.key}`,this.blur=`blur${this.key}`,this.focus=`focus${this.key}`,this.keyup=`keyup${this.key}`,this.keydown=`keydown${this.key}`}},Namespace.css=new class Css{constructor(){this.widget=`${d}-widget`,this.calendarHeader="calendar-header",this.switch="picker-switch",this.toolbar="toolbar",this.noHighlight="no-highlight",this.sideBySide="timepicker-sbs",this.previous="previous",this.next="next",this.disabled="disabled",this.old="old",this.new="new",this.active="active",this.dateContainer="date-container",this.decadesContainer=`${this.dateContainer}-decades`,this.decade="decade",this.yearsContainer=`${this.dateContainer}-years`,this.year="year",this.monthsContainer=`${this.dateContainer}-months`,this.month="month",this.daysContainer=`${this.dateContainer}-days`,this.day="day",this.calendarWeeks="cw",this.dayOfTheWeek="dow",this.today="today",this.weekend="weekend",this.timeContainer="time-container",this.separator="separator",this.clockContainer=`${this.timeContainer}-clock`,this.hourContainer=`${this.timeContainer}-hour`,this.minuteContainer=`${this.timeContainer}-minute`,this.secondContainer=`${this.timeContainer}-second`,this.hour="hour",this.minute="minute",this.second="second",this.toggleMeridiem="toggleMeridiem",this.show="show",this.collapsing="td-collapsing",this.collapse="td-collapse",this.inline="inline",this.lightTheme="light",this.darkTheme="dark",this.isDarkPreferredQuery="(prefers-color-scheme: dark)"}},Namespace.errorMessages=new class ErrorMessages{constructor(){this.base="TD:",this.failedToSetInvalidDate="Failed to set invalid date",this.failedToParseInput="Failed parse input field"}unexpectedOption(e){const t=new TdError(`${this.base} Unexpected option: ${e} does not match a known option.`);throw t.code=1,t}unexpectedOptions(e){const t=new TdError(`${this.base}: ${e.join(", ")}`);throw t.code=1,t}unexpectedOptionValue(e,t,s){const i=new TdError(`${this.base} Unexpected option value: ${e} does not accept a value of "${t}". Valid values are: ${s.join(", ")}`);throw i.code=2,i}typeMismatch(e,t,s){const i=new TdError(`${this.base} Mismatch types: ${e} has a type of ${t} instead of the required ${s}`);throw i.code=3,i}numbersOutOfRange(e,t,s){const i=new TdError(`${this.base} ${e} expected an array of number between ${t} and ${s}.`);throw i.code=4,i}failedToParseDate(e,t,s=!1){const i=new TdError(`${this.base} Could not correctly parse "${t}" to a date for ${e}.`);if(i.code=5,!s)throw i;console.warn(i)}mustProvideElement(){const e=new TdError(`${this.base} No element was provided.`);throw e.code=6,e}subscribeMismatch(){const e=new TdError(`${this.base} The subscribed events does not match the number of callbacks`);throw e.code=7,e}conflictingConfiguration(e){const t=new TdError(`${this.base} A configuration value conflicts with another rule. ${e}`);throw t.code=8,t}customDateFormatError(e){const t=new TdError(`${this.base} customDateFormat: ${e}`);throw t.code=9,t}dateString(){console.warn(`${this.base} Using a string for date options is not recommended unless you specify an ISO string or use the customDateFormat plugin.`)}deprecatedWarning(e,t){console.warn(`${this.base} Warning ${e} is deprecated and will be removed in a future version. ${t}`)}throwError(e){const t=new TdError(`${this.base} ${e}`);throw t.code=9,t}};class ServiceLocator{constructor(){this.cache=new Map}locate(e){const t=this.cache.get(e);if(t)return t;const s=new e;return this.cache.set(e,s),s}}let l;const p=[{name:"calendar",className:Namespace.css.daysContainer,unit:a.month,step:1},{name:"months",className:Namespace.css.monthsContainer,unit:a.year,step:1},{name:"years",className:Namespace.css.yearsContainer,unit:a.year,step:10},{name:"decades",className:Namespace.css.decadesContainer,unit:a.year,step:100}];class OptionsStore{constructor(){this._currentCalendarViewMode=0,this._viewDate=new DateTime,this.minimumCalendarViewMode=0,this.currentView="calendar"}get currentCalendarViewMode(){return this._currentCalendarViewMode}set currentCalendarViewMode(e){this._currentCalendarViewMode=e,this.currentView=p[e].name}get viewDate(){return this._viewDate}set viewDate(e){this._viewDate=e,this.options&&(this.options.viewDate=e)}refreshCurrentView(){this.currentView=p[this.currentCalendarViewMode].name}get isTwelveHour(){return["h12","h11"].includes(this.options.localization.hourCycle)}}class Validation{constructor(){this.optionsStore=l.locate(OptionsStore)}isValid(e,t){if(t!==a.month&&this.optionsStore.options.restrictions.disabledDates.length>0&&this._isInDisabledDates(e))return!1;if(t!==a.month&&this.optionsStore.options.restrictions.enabledDates.length>0&&!this._isInEnabledDates(e))return!1;if(t!==a.month&&t!==a.year&&this.optionsStore.options.restrictions.daysOfWeekDisabled?.length>0&&-1!==this.optionsStore.options.restrictions.daysOfWeekDisabled.indexOf(e.weekDay))return!1;if(this.optionsStore.options.restrictions.minDate&&e.isBefore(this.optionsStore.options.restrictions.minDate,t))return!1;if(this.optionsStore.options.restrictions.maxDate&&e.isAfter(this.optionsStore.options.restrictions.maxDate,t))return!1;if(t===a.hours||t===a.minutes||t===a.seconds){if(this.optionsStore.options.restrictions.disabledHours.length>0&&this._isInDisabledHours(e))return!1;if(this.optionsStore.options.restrictions.enabledHours.length>0&&!this._isInEnabledHours(e))return!1;if(this.optionsStore.options.restrictions.disabledTimeIntervals.length>0)for(const t of this.optionsStore.options.restrictions.disabledTimeIntervals)if(e.isBetween(t.from,t.to))return!1}return!0}_isInDisabledDates(e){return!(!this.optionsStore.options.restrictions.disabledDates||0===this.optionsStore.options.restrictions.disabledDates.length)&&this.optionsStore.options.restrictions.disabledDates.find((t=>t.isSame(e,a.date)))}_isInEnabledDates(e){return!this.optionsStore.options.restrictions.enabledDates||0===this.optionsStore.options.restrictions.enabledDates.length||this.optionsStore.options.restrictions.enabledDates.find((t=>t.isSame(e,a.date)))}_isInDisabledHours(e){if(!this.optionsStore.options.restrictions.disabledHours||0===this.optionsStore.options.restrictions.disabledHours.length)return!1;const t=e.hours;return this.optionsStore.options.restrictions.disabledHours.find((e=>e===t))}_isInEnabledHours(e){if(!this.optionsStore.options.restrictions.enabledHours||0===this.optionsStore.options.restrictions.enabledHours.length)return!0;const t=e.hours;return this.optionsStore.options.restrictions.enabledHours.find((e=>e===t))}}class EventEmitter{constructor(){this.subscribers=[]}subscribe(e){return this.subscribers.push(e),this.unsubscribe.bind(this,this.subscribers.length-1)}unsubscribe(e){this.subscribers.splice(e,1)}emit(e){this.subscribers.forEach((t=>{t(e)}))}destroy(){this.subscribers=null,this.subscribers=[]}}class EventEmitters{constructor(){this.triggerEvent=new EventEmitter,this.viewUpdate=new EventEmitter,this.updateDisplay=new EventEmitter,this.action=new EventEmitter,this.updateViewDate=new EventEmitter}destroy(){this.triggerEvent.destroy(),this.viewUpdate.destroy(),this.updateDisplay.destroy(),this.action.destroy(),this.updateViewDate.destroy()}}const h={restrictions:{minDate:void 0,maxDate:void 0,disabledDates:[],enabledDates:[],daysOfWeekDisabled:[],disabledTimeIntervals:[],disabledHours:[],enabledHours:[]},display:{icons:{type:"icons",time:"fa-solid fa-clock",date:"fa-solid fa-calendar",up:"fa-solid fa-arrow-up",down:"fa-solid fa-arrow-down",previous:"fa-solid fa-chevron-left",next:"fa-solid fa-chevron-right",today:"fa-solid fa-calendar-check",clear:"fa-solid fa-trash",close:"fa-solid fa-xmark"},sideBySide:!1,calendarWeeks:!1,viewMode:"calendar",toolbarPlacement:"bottom",keepOpen:!1,buttons:{today:!1,clear:!1,close:!1},components:{calendar:!0,date:!0,month:!0,year:!0,decades:!0,clock:!0,hours:!0,minutes:!0,seconds:!1,useTwentyfourHour:void 0},inline:!1,theme:"auto"},stepping:1,useCurrent:!0,defaultDate:void 0,localization:{today:"Go to today",clear:"Clear selection",close:"Close the picker",selectMonth:"Select Month",previousMonth:"Previous Month",nextMonth:"Next Month",selectYear:"Select Year",previousYear:"Previous Year",nextYear:"Next Year",selectDecade:"Select Decade",previousDecade:"Previous Decade",nextDecade:"Next Decade",previousCentury:"Previous Century",nextCentury:"Next Century",pickHour:"Pick Hour",incrementHour:"Increment Hour",decrementHour:"Decrement Hour",pickMinute:"Pick Minute",incrementMinute:"Increment Minute",decrementMinute:"Decrement Minute",pickSecond:"Pick Second",incrementSecond:"Increment Second",decrementSecond:"Decrement Second",toggleMeridiem:"Toggle Meridiem",selectTime:"Select Time",selectDate:"Select Date",dayViewHeaderFormat:{month:"long",year:"2-digit"},locale:"default",hourCycle:void 0,startOfTheWeek:0,dateFormats:{LTS:"h:mm:ss T",LT:"h:mm T",L:"MM/dd/yyyy",LL:"MMMM d, yyyy",LLL:"MMMM d, yyyy h:mm T",LLLL:"dddd, MMMM d, yyyy h:mm T"},ordinal:e=>e,format:"L LT"},keepInvalid:!1,debug:!1,allowInputToggle:!1,viewDate:new DateTime,multipleDates:!1,multipleDatesSeparator:"; ",promptTimeOnDateChange:!1,promptTimeOnDateChangeTransitionDelay:200,meta:{},container:void 0};function u(e,t){if(e.constructor.name===DateTime.name)return e;if(e.constructor.name===Date.name)return DateTime.convert(e);if("string"==typeof e){const s=DateTime.fromString(e,t);return"null"===JSON.stringify(s)?null:s}return null}function m(e,t,s){"string"==typeof e&&"input"!==t&&Namespace.errorMessages.dateString();const i=u(e,s);return i||Namespace.errorMessages.failedToParseDate(t,e,"input"===t),i}function y(e,t,s,i){Array.isArray(t)||Namespace.errorMessages.typeMismatch(e,s,"array of DateTime or Date");for(let s=0;s<t.length;s++){const a=t[s],o=m(a,e,i);o||Namespace.errorMessages.typeMismatch(e,typeof a,"DateTime or Date"),o.setLocale(i?.locale??"default"),t[s]=o}}function v(e,t,s){Array.isArray(t)&&!t.some((e=>"number"!=typeof e))||Namespace.errorMessages.typeMismatch(e,s,"array of numbers")}function g(e){return({value:t,providedType:s,localization:i})=>{const a=m(t,e,i);if(void 0!==a)return a.setLocale(i.locale),a;Namespace.errorMessages.typeMismatch(e,s,"DateTime or Date")}}function S(e){const t=g(e);return e=>void 0===e.value?e.value:t(e)}function f(e,t,s){return({value:i,providedType:a})=>void 0===i?[]:(v(e,i,a),i.some((e=>e<t||e>s))&&Namespace.errorMessages.numbersOutOfRange(e,t,s),i)}function w(e){return f(e,0,23)}function b(e){return({value:t,providedType:s,localization:i})=>void 0===t?[]:(y(e,t,s,i),t)}function D(e){return({value:t,path:s})=>(e.includes(t)||Namespace.errorMessages.unexpectedOptionValue(s.substring(1),t,e),t)}const C=Object.freeze({defaultDate:g("defaultDate"),viewDate:g("viewDate"),minDate:S("restrictions.minDate"),maxDate:S("restrictions.maxDate"),disabledHours:w("restrictions.disabledHours"),enabledHours:w("restrictions.enabledHours"),disabledDates:b("restrictions.disabledDates"),enabledDates:b("restrictions.enabledDates"),daysOfWeekDisabled:f("restrictions.daysOfWeekDisabled",0,6),disabledTimeIntervals:({key:e,value:t,providedType:s,localization:i})=>{if(void 0===t)return[];Array.isArray(t)||Namespace.errorMessages.typeMismatch(e,s,"array of { from: DateTime|Date, to: DateTime|Date }");const a=t;for(let t=0;t<a.length;t++)Object.keys(a[t]).forEach((s=>{const o=`${e}[${t}].${s}`,n=a[t][s],r=m(n,o,i);r||Namespace.errorMessages.typeMismatch(o,typeof n,"DateTime or Date"),r.setLocale(i.locale),a[t][s]=r}));return a},toolbarPlacement:D(["top","bottom","default"]),type:D(["icons","sprites"]),viewMode:D(["clock","calendar","months","years","decades"]),theme:D(["light","dark","auto"]),meta:({value:e})=>e,dayViewHeaderFormat:({value:e})=>e,container:({value:e,path:t})=>(e&&!(e instanceof HTMLElement||e instanceof Element||e?.appendChild)&&Namespace.errorMessages.typeMismatch(t.substring(1),typeof e,"HTMLElement"),e),useTwentyfourHour:({value:e,path:t,providedType:s,defaultType:i})=>{if(Namespace.errorMessages.deprecatedWarning("useTwentyfourHour",'Please use "options.localization.hourCycle" instead'),void 0===e||"boolean"===s)return e;Namespace.errorMessages.typeMismatch(t,s,i)},hourCycle:D(["h11","h12","h23","h24"])}),_=({value:e,defaultType:t,providedType:s,path:i})=>{switch(t){case"boolean":return"true"===e||!0===e;case"number":return+e;case"string":return e.toString();case"object":return{};case"function":return e;default:Namespace.errorMessages.typeMismatch(i,s,t)}};function k(e){return(C[e.key]||_)(e)}class OptionConverter{static deepCopy(e){const t={};return Object.keys(e).forEach((s=>{const i=e[s];i instanceof DateTime?t[s]=i.clone:i instanceof Date?t[s]=new Date(i.valueOf()):(t[s]=i,"object"!=typeof i||i instanceof HTMLElement||i instanceof Element||Array.isArray(i)||(t[s]=OptionConverter.deepCopy(i)))})),t}static objectPath(e,t){return"."===e.charAt(0)&&(e=e.slice(1)),e?e.split(".").reduce(((e,t)=>OptionConverter.isValue(e)||OptionConverter.isValue(e[t])?e[t]:void 0),t):t}static spread(e,t,s="",i){const a=OptionConverter.objectPath(s,h),o=Object.keys(e).filter((e=>!Object.keys(a).includes(e)));if(o.length>0){const e=OptionConverter.getFlattenDefaultOptions(),t=o.map((t=>{let i=`"${s}.${t}" in not a known option.`;const a=e.find((e=>e.includes(t)));return a&&(i+=` Did you mean "${a}"?`),i}));Namespace.errorMessages.unexpectedOptions(t)}Object.keys(e).filter((e=>"__proto__"!==e&&"constructor"!==e)).forEach((o=>{"."===(s+=`.${o}`).charAt(0)&&(s=s.slice(1));const n=a[o],r=typeof e[o],c=typeof n,d=e[o];if(null==d)return t[o]=d,void(s=s.substring(0,s.lastIndexOf(`.${o}`)));"object"!=typeof n||Array.isArray(e[o])||n instanceof Date||OptionConverter.ignoreProperties.includes(o)?t[o]=OptionConverter.processKey(o,d,r,c,s,i):OptionConverter.spread(e[o],t[o],s,i),s=s.substring(0,s.lastIndexOf(`.${o}`))}))}static processKey(e,t,s,i,a,o){return k({key:e,value:t,providedType:s,defaultType:i,path:a,localization:o})}static _mergeOptions(e,t){const s=OptionConverter.deepCopy(t),i="default"!==t.localization?.locale?t.localization:e?.localization||h.localization;return OptionConverter.spread(e,s,"",i),s}static _dataToOptions(e,t){const s=JSON.parse(JSON.stringify(e.dataset));if(s?.tdTargetInput&&delete s.tdTargetInput,s?.tdTargetToggle&&delete s.tdTargetToggle,!s||0===Object.keys(s).length||s.constructor!==DOMStringMap)return t;const i={},a=e=>{const t={};return Object.keys(e).forEach((e=>{t[e.toLowerCase()]=e})),t},o=(e,t,s,i)=>{const n=a(s)[e[t].toLowerCase()],r={};return void 0===n||(s[n].constructor===Object?(t++,r[n]=o(e,t,s[n],i)):r[n]=i),r},n=a(t);return Object.keys(s).filter((e=>e.startsWith(Namespace.dataKey))).map((e=>e.substring(2))).forEach((e=>{let a=n[e.toLowerCase()];if(e.includes("_")){const r=e.split("_");a=n[r[0].toLowerCase()],void 0!==a&&t[a].constructor===Object&&(i[a]=o(r,1,t[a],s[`td${e}`]))}else void 0!==a&&(i[a]=s[`td${e}`])})),this._mergeOptions(i,t)}static _dateTypeCheck(e,t){return u(e,t)}static _typeCheckDateArray(e,t,s,i){return y(e,t,s,i)}static _typeCheckNumberArray(e,t,s){return v(e,t,s)}static dateConversion(e,t,s){return m(e,t,s)}static getFlattenDefaultOptions(){if(this._flattenDefaults)return this._flattenDefaults;const e=(t,s=[])=>Array.isArray(t)?[]:Object(t)===t?Object.entries(t).flatMap((([t,i])=>e(i,[...s,t]))):s.join(".");return this._flattenDefaults=e(h),this._flattenDefaults}static _validateConflicts(e){!e.display.sideBySide||e.display.components.clock&&(e.display.components.hours||e.display.components.minutes||e.display.components.seconds)||Namespace.errorMessages.conflictingConfiguration("Cannot use side by side mode without the clock components"),e.restrictions.minDate&&e.restrictions.maxDate&&(e.restrictions.minDate.isAfter(e.restrictions.maxDate)&&Namespace.errorMessages.conflictingConfiguration("minDate is after maxDate"),e.restrictions.maxDate.isBefore(e.restrictions.minDate)&&Namespace.errorMessages.conflictingConfiguration("maxDate is before minDate"))}}OptionConverter.ignoreProperties=["meta","dayViewHeaderFormat","container","dateForms","ordinal"],OptionConverter.isValue=e=>null!=e;class Dates{constructor(){this._dates=[],this.optionsStore=l.locate(OptionsStore),this.validation=l.locate(Validation),this._eventEmitters=l.locate(EventEmitters)}get picked(){return this._dates}get lastPicked(){return this._dates[this.lastPickedIndex]}get lastPickedIndex(){return 0===this._dates.length?0:this._dates.length-1}formatInput(e){const t=this.optionsStore.options.display.components;return e?e.format({year:t.calendar&&t.year?"numeric":void 0,month:t.calendar&&t.month?"2-digit":void 0,day:t.calendar&&t.date?"2-digit":void 0,hour:t.clock&&t.hours?"2-digit":void 0,minute:t.clock&&t.minutes?"2-digit":void 0,second:t.clock&&t.seconds?"2-digit":void 0,hourCycle:this.optionsStore.options.localization.hourCycle}):""}parseInput(e){return OptionConverter.dateConversion(e,"input",this.optionsStore.options.localization)}setFromInput(e,t){if(!e)return void this.setValue(void 0,t);const s=this.parseInput(e);s&&(s.setLocale(this.optionsStore.options.localization.locale),this.setValue(s,t))}add(e){this._dates.push(e)}isPicked(e,t){if(!t)return void 0!==this._dates.find((t=>t===e));const s=c(t),i=e.format(s);return void 0!==this._dates.map((e=>e.format(s))).find((e=>e===i))}pickedIndex(e,t){if(!t)return this._dates.indexOf(e);const s=c(t),i=e.format(s);return this._dates.map((e=>e.format(s))).indexOf(i)}clear(){this.optionsStore.unset=!0,this._eventEmitters.triggerEvent.emit({type:Namespace.events.change,date:void 0,oldDate:this.lastPicked,isClear:!0,isValid:!0}),this._dates=[]}static getStartEndYear(e,t){const s=e/10,i=Math.floor(t/e)*e;return[i,i+9*s,Math.floor(t/s)*s]}updateInput(e){if(!this.optionsStore.input)return;let t=this.formatInput(e);this.optionsStore.options.multipleDates&&(t=this._dates.map((e=>this.formatInput(e))).join(this.optionsStore.options.multipleDatesSeparator)),this.optionsStore.input.value!=t&&(this.optionsStore.input.value=t)}setValue(e,t){const s=void 0===t,i=!e&&s;let a=this.optionsStore.unset?null:this._dates[t];if(!a&&!this.optionsStore.unset&&s&&i&&(a=this.lastPicked),e&&a?.isSame(e))this.updateInput(e);else{if(!e)return!this.optionsStore.options.multipleDates||1===this._dates.length||i?(this.optionsStore.unset=!0,this._dates=[]):this._dates.splice(t,1),this.updateInput(),this._eventEmitters.triggerEvent.emit({type:Namespace.events.change,date:void 0,oldDate:a,isClear:i,isValid:!0}),void this._eventEmitters.updateDisplay.emit("all");if(t=t||0,e=e.clone,1!==this.optionsStore.options.stepping&&(e.minutes=Math.round(e.minutes/this.optionsStore.options.stepping)*this.optionsStore.options.stepping,e.seconds=0),this.validation.isValid(e))return this._dates[t]=e,this._eventEmitters.updateViewDate.emit(e.clone),this.updateInput(e),this.optionsStore.unset=!1,this._eventEmitters.updateDisplay.emit("all"),void this._eventEmitters.triggerEvent.emit({type:Namespace.events.change,date:e,oldDate:a,isClear:i,isValid:!0});this.optionsStore.options.keepInvalid&&(this._dates[t]=e,this._eventEmitters.updateViewDate.emit(e.clone),this.updateInput(e),this._eventEmitters.triggerEvent.emit({type:Namespace.events.change,date:e,oldDate:a,isClear:i,isValid:!1})),this._eventEmitters.triggerEvent.emit({type:Namespace.events.error,reason:Namespace.errorMessages.failedToSetInvalidDate,date:e,oldDate:a})}}}var N;!function(e){e.next="next",e.previous="previous",e.changeCalendarView="changeCalendarView",e.selectMonth="selectMonth",e.selectYear="selectYear",e.selectDecade="selectDecade",e.selectDay="selectDay",e.selectHour="selectHour",e.selectMinute="selectMinute",e.selectSecond="selectSecond",e.incrementHours="incrementHours",e.incrementMinutes="incrementMinutes",e.incrementSeconds="incrementSeconds",e.decrementHours="decrementHours",e.decrementMinutes="decrementMinutes",e.decrementSeconds="decrementSeconds",e.toggleMeridiem="toggleMeridiem",e.togglePicker="togglePicker",e.showClock="showClock",e.showHours="showHours",e.showMinutes="showMinutes",e.showSeconds="showSeconds",e.clear="clear",e.close="close",e.today="today"}(N||(N={}));var E=N;class DateDisplay{constructor(){this.optionsStore=l.locate(OptionsStore),this.dates=l.locate(Dates),this.validation=l.locate(Validation)}getPicker(){const e=document.createElement("div");if(e.classList.add(Namespace.css.daysContainer),e.append(...this._daysOfTheWeek()),this.optionsStore.options.display.calendarWeeks){const t=document.createElement("div");t.classList.add(Namespace.css.calendarWeeks,Namespace.css.noHighlight),e.appendChild(t)}for(let t=0;t<42;t++){if(0!==t&&t%7==0&&this.optionsStore.options.display.calendarWeeks){const t=document.createElement("div");t.classList.add(Namespace.css.calendarWeeks,Namespace.css.noHighlight),e.appendChild(t)}const s=document.createElement("div");s.setAttribute("data-action",E.selectDay),e.appendChild(s)}return e}_update(e,t){const s=e.getElementsByClassName(Namespace.css.daysContainer)[0];if("calendar"===this.optionsStore.currentView){const[e,t,i]=s.parentElement.getElementsByClassName(Namespace.css.calendarHeader)[0].getElementsByTagName("div");t.setAttribute(Namespace.css.daysContainer,this.optionsStore.viewDate.format(this.optionsStore.options.localization.dayViewHeaderFormat)),this.optionsStore.options.display.components.month?t.classList.remove(Namespace.css.disabled):t.classList.add(Namespace.css.disabled),this.validation.isValid(this.optionsStore.viewDate.clone.manipulate(-1,a.month),a.month)?e.classList.remove(Namespace.css.disabled):e.classList.add(Namespace.css.disabled),this.validation.isValid(this.optionsStore.viewDate.clone.manipulate(1,a.month),a.month)?i.classList.remove(Namespace.css.disabled):i.classList.add(Namespace.css.disabled)}const i=this.optionsStore.viewDate.clone.startOf(a.month).startOf("weekDay",this.optionsStore.options.localization.startOfTheWeek).manipulate(12,a.hours);s.querySelectorAll(`[data-action="${E.selectDay}"], .${Namespace.css.calendarWeeks}`).forEach((e=>{if(this.optionsStore.options.display.calendarWeeks&&e.classList.contains(Namespace.css.calendarWeeks)){if("#"===e.innerText)return;return void(e.innerText=`${i.week}`)}const s=[];s.push(Namespace.css.day),i.isBefore(this.optionsStore.viewDate,a.month)&&s.push(Namespace.css.old),i.isAfter(this.optionsStore.viewDate,a.month)&&s.push(Namespace.css.new),!this.optionsStore.unset&&this.dates.isPicked(i,a.date)&&s.push(Namespace.css.active),this.validation.isValid(i,a.date)||s.push(Namespace.css.disabled),i.isSame(new DateTime,a.date)&&s.push(Namespace.css.today),0!==i.weekDay&&6!==i.weekDay||s.push(Namespace.css.weekend),t(a.date,i,s,e),e.classList.remove(...e.classList),e.classList.add(...s),e.setAttribute("data-value",`${i.year}-${i.monthFormatted}-${i.dateFormatted}`),e.setAttribute("data-day",`${i.date}`),e.innerText=i.format({day:"numeric"}),i.manipulate(1,a.date)}))}_daysOfTheWeek(){const e=this.optionsStore.viewDate.clone.startOf("weekDay",this.optionsStore.options.localization.startOfTheWeek).startOf(a.date),t=[];if(document.createElement("div"),this.optionsStore.options.display.calendarWeeks){const e=document.createElement("div");e.classList.add(Namespace.css.calendarWeeks,Namespace.css.noHighlight),e.innerText="#",t.push(e)}for(let s=0;s<7;s++){const s=document.createElement("div");s.classList.add(Namespace.css.dayOfTheWeek,Namespace.css.noHighlight),s.innerText=e.format({weekday:"short"}),e.manipulate(1,a.date),t.push(s)}return t}}class MonthDisplay{constructor(){this.optionsStore=l.locate(OptionsStore),this.dates=l.locate(Dates),this.validation=l.locate(Validation)}getPicker(){const e=document.createElement("div");e.classList.add(Namespace.css.monthsContainer);for(let t=0;t<12;t++){const t=document.createElement("div");t.setAttribute("data-action",E.selectMonth),e.appendChild(t)}return e}_update(e,t){const s=e.getElementsByClassName(Namespace.css.monthsContainer)[0];if("months"===this.optionsStore.currentView){const[e,t,i]=s.parentElement.getElementsByClassName(Namespace.css.calendarHeader)[0].getElementsByTagName("div");t.setAttribute(Namespace.css.monthsContainer,this.optionsStore.viewDate.format({year:"numeric"})),this.optionsStore.options.display.components.year?t.classList.remove(Namespace.css.disabled):t.classList.add(Namespace.css.disabled),this.validation.isValid(this.optionsStore.viewDate.clone.manipulate(-1,a.year),a.year)?e.classList.remove(Namespace.css.disabled):e.classList.add(Namespace.css.disabled),this.validation.isValid(this.optionsStore.viewDate.clone.manipulate(1,a.year),a.year)?i.classList.remove(Namespace.css.disabled):i.classList.add(Namespace.css.disabled)}const i=this.optionsStore.viewDate.clone.startOf(a.year);s.querySelectorAll(`[data-action="${E.selectMonth}"]`).forEach(((e,s)=>{const o=[];o.push(Namespace.css.month),!this.optionsStore.unset&&this.dates.isPicked(i,a.month)&&o.push(Namespace.css.active),this.validation.isValid(i,a.month)||o.push(Namespace.css.disabled),t(a.month,i,o,e),e.classList.remove(...e.classList),e.classList.add(...o),e.setAttribute("data-value",`${s}`),e.innerText=`${i.format({month:"short"})}`,i.manipulate(1,a.month)}))}}class YearDisplay{constructor(){this.optionsStore=l.locate(OptionsStore),this.dates=l.locate(Dates),this.validation=l.locate(Validation)}getPicker(){const e=document.createElement("div");e.classList.add(Namespace.css.yearsContainer);for(let t=0;t<12;t++){const t=document.createElement("div");t.setAttribute("data-action",E.selectYear),e.appendChild(t)}return e}_update(e,t){this._startYear=this.optionsStore.viewDate.clone.manipulate(-1,a.year),this._endYear=this.optionsStore.viewDate.clone.manipulate(10,a.year);const s=e.getElementsByClassName(Namespace.css.yearsContainer)[0];if("years"===this.optionsStore.currentView){const[e,t,i]=s.parentElement.getElementsByClassName(Namespace.css.calendarHeader)[0].getElementsByTagName("div");t.setAttribute(Namespace.css.yearsContainer,`${this._startYear.format({year:"numeric"})}-${this._endYear.format({year:"numeric"})}`),this.optionsStore.options.display.components.decades?t.classList.remove(Namespace.css.disabled):t.classList.add(Namespace.css.disabled),this.validation.isValid(this._startYear,a.year)?e.classList.remove(Namespace.css.disabled):e.classList.add(Namespace.css.disabled),this.validation.isValid(this._endYear,a.year)?i.classList.remove(Namespace.css.disabled):i.classList.add(Namespace.css.disabled)}const i=this.optionsStore.viewDate.clone.startOf(a.year).manipulate(-1,a.year);s.querySelectorAll(`[data-action="${E.selectYear}"]`).forEach((e=>{const s=[];s.push(Namespace.css.year),!this.optionsStore.unset&&this.dates.isPicked(i,a.year)&&s.push(Namespace.css.active),this.validation.isValid(i,a.year)||s.push(Namespace.css.disabled),t(a.year,i,s,e),e.classList.remove(...e.classList),e.classList.add(...s),e.setAttribute("data-value",`${i.year}`),e.innerText=i.format({year:"numeric"}),i.manipulate(1,a.year)}))}}class DecadeDisplay{constructor(){this.optionsStore=l.locate(OptionsStore),this.dates=l.locate(Dates),this.validation=l.locate(Validation)}getPicker(){const e=document.createElement("div");e.classList.add(Namespace.css.decadesContainer);for(let t=0;t<12;t++){const t=document.createElement("div");t.setAttribute("data-action",E.selectDecade),e.appendChild(t)}return e}_update(e,t){const[s,i]=Dates.getStartEndYear(100,this.optionsStore.viewDate.year);this._startDecade=this.optionsStore.viewDate.clone.startOf(a.year),this._startDecade.year=s,this._endDecade=this.optionsStore.viewDate.clone.startOf(a.year),this._endDecade.year=i;const o=e.getElementsByClassName(Namespace.css.decadesContainer)[0],[n,r,c]=o.parentElement.getElementsByClassName(Namespace.css.calendarHeader)[0].getElementsByTagName("div");"decades"===this.optionsStore.currentView&&(r.setAttribute(Namespace.css.decadesContainer,`${this._startDecade.format({year:"numeric"})}-${this._endDecade.format({year:"numeric"})}`),this.validation.isValid(this._startDecade,a.year)?n.classList.remove(Namespace.css.disabled):n.classList.add(Namespace.css.disabled),this.validation.isValid(this._endDecade,a.year)?c.classList.remove(Namespace.css.disabled):c.classList.add(Namespace.css.disabled));const d=this.dates.picked.map((e=>e.year));o.querySelectorAll(`[data-action="${E.selectDecade}"]`).forEach(((e,s)=>{if(0===s)return e.classList.add(Namespace.css.old),this._startDecade.year-10<0?(e.textContent=" ",n.classList.add(Namespace.css.disabled),e.classList.add(Namespace.css.disabled),void e.setAttribute("data-value","")):(e.innerText=this._startDecade.clone.manipulate(-10,a.year).format({year:"numeric"}),void e.setAttribute("data-value",`${this._startDecade.year}`));const i=[];i.push(Namespace.css.decade);const o=this._startDecade.year,r=this._startDecade.year+9;!this.optionsStore.unset&&d.filter((e=>e>=o&&e<=r)).length>0&&i.push(Namespace.css.active),t("decade",this._startDecade,i,e),e.classList.remove(...e.classList),e.classList.add(...i),e.setAttribute("data-value",`${this._startDecade.year}`),e.innerText=`${this._startDecade.format({year:"numeric"})}`,this._startDecade.manipulate(10,a.year)}))}}class TimeDisplay{constructor(){this._gridColumns="",this.optionsStore=l.locate(OptionsStore),this.dates=l.locate(Dates),this.validation=l.locate(Validation)}getPicker(e){const t=document.createElement("div");return t.classList.add(Namespace.css.clockContainer),t.append(...this._grid(e)),t}_update(e){const t=e.getElementsByClassName(Namespace.css.clockContainer)[0],s=(this.dates.lastPicked||this.optionsStore.viewDate).clone;if(t.querySelectorAll(".disabled").forEach((e=>e.classList.remove(Namespace.css.disabled))),this.optionsStore.options.display.components.hours&&(this.validation.isValid(this.optionsStore.viewDate.clone.manipulate(1,a.hours),a.hours)||t.querySelector(`[data-action=${E.incrementHours}]`).classList.add(Namespace.css.disabled),this.validation.isValid(this.optionsStore.viewDate.clone.manipulate(-1,a.hours),a.hours)||t.querySelector(`[data-action=${E.decrementHours}]`).classList.add(Namespace.css.disabled),t.querySelector(`[data-time-component=${a.hours}]`).innerText=s.getHoursFormatted(this.optionsStore.options.localization.hourCycle)),this.optionsStore.options.display.components.minutes&&(this.validation.isValid(this.optionsStore.viewDate.clone.manipulate(1,a.minutes),a.minutes)||t.querySelector(`[data-action=${E.incrementMinutes}]`).classList.add(Namespace.css.disabled),this.validation.isValid(this.optionsStore.viewDate.clone.manipulate(-1,a.minutes),a.minutes)||t.querySelector(`[data-action=${E.decrementMinutes}]`).classList.add(Namespace.css.disabled),t.querySelector(`[data-time-component=${a.minutes}]`).innerText=s.minutesFormatted),this.optionsStore.options.display.components.seconds&&(this.validation.isValid(this.optionsStore.viewDate.clone.manipulate(1,a.seconds),a.seconds)||t.querySelector(`[data-action=${E.incrementSeconds}]`).classList.add(Namespace.css.disabled),this.validation.isValid(this.optionsStore.viewDate.clone.manipulate(-1,a.seconds),a.seconds)||t.querySelector(`[data-action=${E.decrementSeconds}]`).classList.add(Namespace.css.disabled),t.querySelector(`[data-time-component=${a.seconds}]`).innerText=s.secondsFormatted),this.optionsStore.isTwelveHour){const e=t.querySelector(`[data-action=${E.toggleMeridiem}]`);e.innerText=s.meridiem(),this.validation.isValid(s.clone.manipulate(s.hours>=12?-12:12,a.hours))?e.classList.remove(Namespace.css.disabled):e.classList.add(Namespace.css.disabled)}t.style.gridTemplateAreas=`"${this._gridColumns}"`}_grid(e){this._gridColumns="";const t=[],s=[],i=[],o=document.createElement("div"),n=e(this.optionsStore.options.display.icons.up),r=e(this.optionsStore.options.display.icons.down);o.classList.add(Namespace.css.separator,Namespace.css.noHighlight);const c=o.cloneNode(!0);c.innerHTML=":";const d=(e=!1)=>e?c.cloneNode(!0):o.cloneNode(!0);if(this.optionsStore.options.display.components.hours){let e=document.createElement("div");e.setAttribute("title",this.optionsStore.options.localization.incrementHour),e.setAttribute("data-action",E.incrementHours),e.appendChild(n.cloneNode(!0)),t.push(e),e=document.createElement("div"),e.setAttribute("title",this.optionsStore.options.localization.pickHour),e.setAttribute("data-action",E.showHours),e.setAttribute("data-time-component",a.hours),s.push(e),e=document.createElement("div"),e.setAttribute("title",this.optionsStore.options.localization.decrementHour),e.setAttribute("data-action",E.decrementHours),e.appendChild(r.cloneNode(!0)),i.push(e),this._gridColumns+="a"}if(this.optionsStore.options.display.components.minutes){this._gridColumns+=" a",this.optionsStore.options.display.components.hours&&(t.push(d()),s.push(d(!0)),i.push(d()),this._gridColumns+=" a");let e=document.createElement("div");e.setAttribute("title",this.optionsStore.options.localization.incrementMinute),e.setAttribute("data-action",E.incrementMinutes),e.appendChild(n.cloneNode(!0)),t.push(e),e=document.createElement("div"),e.setAttribute("title",this.optionsStore.options.localization.pickMinute),e.setAttribute("data-action",E.showMinutes),e.setAttribute("data-time-component",a.minutes),s.push(e),e=document.createElement("div"),e.setAttribute("title",this.optionsStore.options.localization.decrementMinute),e.setAttribute("data-action",E.decrementMinutes),e.appendChild(r.cloneNode(!0)),i.push(e)}if(this.optionsStore.options.display.components.seconds){this._gridColumns+=" a",this.optionsStore.options.display.components.minutes&&(t.push(d()),s.push(d(!0)),i.push(d()),this._gridColumns+=" a");let e=document.createElement("div");e.setAttribute("title",this.optionsStore.options.localization.incrementSecond),e.setAttribute("data-action",E.incrementSeconds),e.appendChild(n.cloneNode(!0)),t.push(e),e=document.createElement("div"),e.setAttribute("title",this.optionsStore.options.localization.pickSecond),e.setAttribute("data-action",E.showSeconds),e.setAttribute("data-time-component",a.seconds),s.push(e),e=document.createElement("div"),e.setAttribute("title",this.optionsStore.options.localization.decrementSecond),e.setAttribute("data-action",E.decrementSeconds),e.appendChild(r.cloneNode(!0)),i.push(e)}if(this.optionsStore.isTwelveHour){this._gridColumns+=" a";let e=d();t.push(e);const a=document.createElement("button");a.setAttribute("title",this.optionsStore.options.localization.toggleMeridiem),a.setAttribute("data-action",E.toggleMeridiem),a.setAttribute("tabindex","-1"),Namespace.css.toggleMeridiem.includes(",")?a.classList.add(...Namespace.css.toggleMeridiem.split(",")):a.classList.add(Namespace.css.toggleMeridiem),e=document.createElement("div"),e.classList.add(Namespace.css.noHighlight),e.appendChild(a),s.push(e),e=d(),i.push(e)}return this._gridColumns=this._gridColumns.trim(),[...t,...s,...i]}}class HourDisplay{constructor(){this.optionsStore=l.locate(OptionsStore),this.validation=l.locate(Validation)}getPicker(){const e=document.createElement("div");e.classList.add(Namespace.css.hourContainer);for(let t=0;t<(this.optionsStore.isTwelveHour?12:24);t++){const t=document.createElement("div");t.setAttribute("data-action",E.selectHour),e.appendChild(t)}return e}_update(e,t){const s=e.getElementsByClassName(Namespace.css.hourContainer)[0],i=this.optionsStore.viewDate.clone.startOf(a.date);s.querySelectorAll(`[data-action="${E.selectHour}"]`).forEach((e=>{const s=[];s.push(Namespace.css.hour),this.validation.isValid(i,a.hours)||s.push(Namespace.css.disabled),t(a.hours,i,s,e),e.classList.remove(...e.classList),e.classList.add(...s),e.setAttribute("data-value",`${i.hours}`),e.innerText=i.getHoursFormatted(this.optionsStore.options.localization.hourCycle),i.manipulate(1,a.hours)}))}}class MinuteDisplay{constructor(){this.optionsStore=l.locate(OptionsStore),this.validation=l.locate(Validation)}getPicker(){const e=document.createElement("div");e.classList.add(Namespace.css.minuteContainer);const t=1===this.optionsStore.options.stepping?5:this.optionsStore.options.stepping;for(let s=0;s<60/t;s++){const t=document.createElement("div");t.setAttribute("data-action",E.selectMinute),e.appendChild(t)}return e}_update(e,t){const s=e.getElementsByClassName(Namespace.css.minuteContainer)[0],i=this.optionsStore.viewDate.clone.startOf(a.hours),o=1===this.optionsStore.options.stepping?5:this.optionsStore.options.stepping;s.querySelectorAll(`[data-action="${E.selectMinute}"]`).forEach((e=>{const s=[];s.push(Namespace.css.minute),this.validation.isValid(i,a.minutes)||s.push(Namespace.css.disabled),t(a.minutes,i,s,e),e.classList.remove(...e.classList),e.classList.add(...s),e.setAttribute("data-value",`${i.minutes}`),e.innerText=i.minutesFormatted,i.manipulate(o,a.minutes)}))}}class secondDisplay{constructor(){this.optionsStore=l.locate(OptionsStore),this.validation=l.locate(Validation)}getPicker(){const e=document.createElement("div");e.classList.add(Namespace.css.secondContainer);for(let t=0;t<12;t++){const t=document.createElement("div");t.setAttribute("data-action",E.selectSecond),e.appendChild(t)}return e}_update(e,t){const s=e.getElementsByClassName(Namespace.css.secondContainer)[0],i=this.optionsStore.viewDate.clone.startOf(a.minutes);s.querySelectorAll(`[data-action="${E.selectSecond}"]`).forEach((e=>{const s=[];s.push(Namespace.css.second),this.validation.isValid(i,a.seconds)||s.push(Namespace.css.disabled),t(a.seconds,i,s,e),e.classList.remove(...e.classList),e.classList.add(...s),e.setAttribute("data-value",`${i.seconds}`),e.innerText=i.secondsFormatted,i.manipulate(5,a.seconds)}))}}class Collapse{static toggle(e){e.classList.contains(Namespace.css.show)?this.hide(e):this.show(e)}static showImmediately(e){e.classList.remove(Namespace.css.collapsing),e.classList.add(Namespace.css.collapse,Namespace.css.show),e.style.height=""}static show(e){if(e.classList.contains(Namespace.css.collapsing)||e.classList.contains(Namespace.css.show))return;e.style.height="0",e.classList.remove(Namespace.css.collapse),e.classList.add(Namespace.css.collapsing),setTimeout((()=>{Collapse.showImmediately(e)}),this.getTransitionDurationFromElement(e)),e.style.height=`${e.scrollHeight}px`}static hideImmediately(e){e&&(e.classList.remove(Namespace.css.collapsing,Namespace.css.show),e.classList.add(Namespace.css.collapse))}static hide(e){if(e.classList.contains(Namespace.css.collapsing)||!e.classList.contains(Namespace.css.show))return;e.style.height=`${e.getBoundingClientRect().height}px`;e.offsetHeight,e.classList.remove(Namespace.css.collapse,Namespace.css.show),e.classList.add(Namespace.css.collapsing),e.style.height="",setTimeout((()=>{Collapse.hideImmediately(e)}),this.getTransitionDurationFromElement(e))}}Collapse.getTransitionDurationFromElement=e=>{if(!e)return 0;let{transitionDuration:t,transitionDelay:s}=window.getComputedStyle(e);const i=Number.parseFloat(t),a=Number.parseFloat(s);return i||a?(t=t.split(",")[0],s=s.split(",")[0],1e3*(Number.parseFloat(t)+Number.parseFloat(s))):0};class Display{constructor(){this._isVisible=!1,this._documentClickEvent=e=>{this.optionsStore.options.debug||window.debug||!this._isVisible||e.composedPath().includes(this.widget)||e.composedPath()?.includes(this.optionsStore.element)||this.hide()},this._actionsClickEvent=e=>{this._eventEmitters.action.emit({e:e})},this.optionsStore=l.locate(OptionsStore),this.validation=l.locate(Validation),this.dates=l.locate(Dates),this.dateDisplay=l.locate(DateDisplay),this.monthDisplay=l.locate(MonthDisplay),this.yearDisplay=l.locate(YearDisplay),this.decadeDisplay=l.locate(DecadeDisplay),this.timeDisplay=l.locate(TimeDisplay),this.hourDisplay=l.locate(HourDisplay),this.minuteDisplay=l.locate(MinuteDisplay),this.secondDisplay=l.locate(secondDisplay),this._eventEmitters=l.locate(EventEmitters),this._widget=void 0,this._eventEmitters.updateDisplay.subscribe((e=>{this._update(e)}))}get widget(){return this._widget}get isVisible(){return this._isVisible}_update(e){if(this.widget)switch(e){case a.seconds:this.secondDisplay._update(this.widget,this.paint);break;case a.minutes:this.minuteDisplay._update(this.widget,this.paint);break;case a.hours:this.hourDisplay._update(this.widget,this.paint);break;case a.date:this.dateDisplay._update(this.widget,this.paint);break;case a.month:this.monthDisplay._update(this.widget,this.paint);break;case a.year:this.yearDisplay._update(this.widget,this.paint);break;case"clock":if(!this._hasTime)break;this.timeDisplay._update(this.widget),this._update(a.hours),this._update(a.minutes),this._update(a.seconds);break;case"calendar":this._update(a.date),this._update(a.year),this._update(a.month),this.decadeDisplay._update(this.widget,this.paint),this._updateCalendarHeader();break;case"all":this._hasTime&&this._update("clock"),this._hasDate&&this._update("calendar")}}paint(e,t,s,i){}show(){if(null==this.widget){if(0==this.dates.picked.length){if(this.optionsStore.options.useCurrent&&!this.optionsStore.options.defaultDate){const e=(new DateTime).setLocale(this.optionsStore.options.localization.locale);if(!this.optionsStore.options.keepInvalid){let t=0,s=1;for(this.optionsStore.options.restrictions.maxDate?.isBefore(e)&&(s=-1);!(this.validation.isValid(e)||(e.manipulate(s,a.date),t>31));)t++}this.dates.setValue(e)}this.optionsStore.options.defaultDate&&this.dates.setValue(this.optionsStore.options.defaultDate)}this._buildWidget(),this._updateTheme();const e=this._hasTime&&!this._hasDate;if(e?(this.optionsStore.currentView="clock",this._eventEmitters.action.emit({e:null,action:E.showClock})):this.optionsStore.currentCalendarViewMode||(this.optionsStore.currentCalendarViewMode=this.optionsStore.minimumCalendarViewMode),e||"clock"===this.optionsStore.options.display.viewMode||(this._hasTime&&(this.optionsStore.options.display.sideBySide?Collapse.show(this.widget.querySelector(`div.${Namespace.css.timeContainer}`)):Collapse.hideImmediately(this.widget.querySelector(`div.${Namespace.css.timeContainer}`))),Collapse.show(this.widget.querySelector(`div.${Namespace.css.dateContainer}`))),this._hasDate&&this._showMode(),this.optionsStore.options.display.inline)this.optionsStore.element.appendChild(this.widget);else{(this.optionsStore.options?.container||document.body).appendChild(this.widget),this.createPopup(this.optionsStore.element,this.widget,{modifiers:[{name:"eventListeners",enabled:!0}],placement:"rtl"===document.documentElement.dir?"bottom-end":"bottom-start"}).then()}"clock"==this.optionsStore.options.display.viewMode&&this._eventEmitters.action.emit({e:null,action:E.showClock}),this.widget.querySelectorAll("[data-action]").forEach((e=>e.addEventListener("click",this._actionsClickEvent))),this._hasTime&&this.optionsStore.options.display.sideBySide&&(this.timeDisplay._update(this.widget),this.widget.getElementsByClassName(Namespace.css.clockContainer)[0].style.display="grid")}this.widget.classList.add(Namespace.css.show),this.optionsStore.options.display.inline||(this.updatePopup(),document.addEventListener("click",this._documentClickEvent)),this._eventEmitters.triggerEvent.emit({type:Namespace.events.show}),this._isVisible=!0}async createPopup(e,t,s){let i;if(window?.Popper)i=window?.Popper?.createPopper;else{const{createPopper:e}=await import("@popperjs/core");i=e}i&&(this._popperInstance=i(e,t,s))}updatePopup(){this._popperInstance?.update()}_showMode(e){if(!this.widget)return;if(e){const t=Math.max(this.optionsStore.minimumCalendarViewMode,Math.min(3,this.optionsStore.currentCalendarViewMode+e));if(this.optionsStore.currentCalendarViewMode==t)return;this.optionsStore.currentCalendarViewMode=t}this.widget.querySelectorAll(`.${Namespace.css.dateContainer} > div:not(.${Namespace.css.calendarHeader}), .${Namespace.css.timeContainer} > div:not(.${Namespace.css.clockContainer})`).forEach((e=>e.style.display="none"));const t=p[this.optionsStore.currentCalendarViewMode],s=this.widget.querySelector(`.${t.className}`);switch(t.className){case Namespace.css.decadesContainer:this.decadeDisplay._update(this.widget,this.paint);break;case Namespace.css.yearsContainer:this.yearDisplay._update(this.widget,this.paint);break;case Namespace.css.monthsContainer:this.monthDisplay._update(this.widget,this.paint);break;case Namespace.css.daysContainer:this.dateDisplay._update(this.widget,this.paint)}s.style.display="grid",this.optionsStore.options.display.sideBySide&&(this.widget.querySelectorAll(`.${Namespace.css.clockContainer}`)[0].style.display="grid"),this._updateCalendarHeader(),this._eventEmitters.viewUpdate.emit()}_updateTheme(e){if(this.widget){if(e){if(this.optionsStore.options.display.theme===e)return;this.optionsStore.options.display.theme=e}this.widget.classList.remove("light","dark"),this.widget.classList.add(this._getThemeClass()),"auto"===this.optionsStore.options.display.theme?window.matchMedia(Namespace.css.isDarkPreferredQuery).addEventListener("change",(()=>this._updateTheme())):window.matchMedia(Namespace.css.isDarkPreferredQuery).removeEventListener("change",(()=>this._updateTheme()))}}_getThemeClass(){const e=this.optionsStore.options.display.theme||"auto",t=window.matchMedia&&window.matchMedia(Namespace.css.isDarkPreferredQuery).matches;switch(e){case"light":return Namespace.css.lightTheme;case"dark":return Namespace.css.darkTheme;case"auto":return t?Namespace.css.darkTheme:Namespace.css.lightTheme}}_updateCalendarHeader(){if(!this._hasDate)return;const e=[...this.widget.querySelector(`.${Namespace.css.dateContainer} div[style*="display: grid"]`).classList].find((e=>e.startsWith(Namespace.css.dateContainer))),[t,s,i]=this.widget.getElementsByClassName(Namespace.css.calendarHeader)[0].getElementsByTagName("div");switch(e){case Namespace.css.decadesContainer:t.setAttribute("title",this.optionsStore.options.localization.previousCentury),s.setAttribute("title",""),i.setAttribute("title",this.optionsStore.options.localization.nextCentury);break;case Namespace.css.yearsContainer:t.setAttribute("title",this.optionsStore.options.localization.previousDecade),s.setAttribute("title",this.optionsStore.options.localization.selectDecade),i.setAttribute("title",this.optionsStore.options.localization.nextDecade);break;case Namespace.css.monthsContainer:t.setAttribute("title",this.optionsStore.options.localization.previousYear),s.setAttribute("title",this.optionsStore.options.localization.selectYear),i.setAttribute("title",this.optionsStore.options.localization.nextYear);break;case Namespace.css.daysContainer:t.setAttribute("title",this.optionsStore.options.localization.previousMonth),s.setAttribute("title",this.optionsStore.options.localization.selectMonth),i.setAttribute("title",this.optionsStore.options.localization.nextMonth),s.setAttribute(e,this.optionsStore.viewDate.format(this.optionsStore.options.localization.dayViewHeaderFormat))}s.innerText=s.getAttribute(e)}hide(){this.widget&&this._isVisible&&(this.widget.classList.remove(Namespace.css.show),this._isVisible&&(this._eventEmitters.triggerEvent.emit({type:Namespace.events.hide,date:this.optionsStore.unset?null:this.dates.lastPicked?this.dates.lastPicked.clone:void 0}),this._isVisible=!1),document.removeEventListener("click",this._documentClickEvent))}toggle(){return this._isVisible?this.hide():this.show()}_dispose(){document.removeEventListener("click",this._documentClickEvent),this.widget&&(this.widget.querySelectorAll("[data-action]").forEach((e=>e.removeEventListener("click",this._actionsClickEvent))),this.widget.parentNode.removeChild(this.widget),this._widget=void 0)}_buildWidget(){const e=document.createElement("div");e.classList.add(Namespace.css.widget);const t=document.createElement("div");t.classList.add(Namespace.css.dateContainer),t.append(this.getHeadTemplate(),this.decadeDisplay.getPicker(),this.yearDisplay.getPicker(),this.monthDisplay.getPicker(),this.dateDisplay.getPicker());const s=document.createElement("div");s.classList.add(Namespace.css.timeContainer),s.appendChild(this.timeDisplay.getPicker(this._iconTag.bind(this))),s.appendChild(this.hourDisplay.getPicker()),s.appendChild(this.minuteDisplay.getPicker()),s.appendChild(this.secondDisplay.getPicker());const i=document.createElement("div");if(i.classList.add(Namespace.css.toolbar),i.append(...this.getToolbarElements()),this.optionsStore.options.display.inline&&e.classList.add(Namespace.css.inline),this.optionsStore.options.display.calendarWeeks&&e.classList.add("calendarWeeks"),this.optionsStore.options.display.sideBySide&&this._hasDate&&this._hasTime){e.classList.add(Namespace.css.sideBySide),"top"===this.optionsStore.options.display.toolbarPlacement&&e.appendChild(i);const a=document.createElement("div");return a.classList.add("td-row"),t.classList.add("td-half"),s.classList.add("td-half"),a.appendChild(t),a.appendChild(s),e.appendChild(a),"bottom"===this.optionsStore.options.display.toolbarPlacement&&e.appendChild(i),void(this._widget=e)}"top"===this.optionsStore.options.display.toolbarPlacement&&e.appendChild(i),this._hasDate&&(this._hasTime&&(t.classList.add(Namespace.css.collapse),"clock"!==this.optionsStore.options.display.viewMode&&t.classList.add(Namespace.css.show)),e.appendChild(t)),this._hasTime&&(this._hasDate&&(s.classList.add(Namespace.css.collapse),"clock"===this.optionsStore.options.display.viewMode&&s.classList.add(Namespace.css.show)),e.appendChild(s)),"bottom"===this.optionsStore.options.display.toolbarPlacement&&e.appendChild(i);const a=document.createElement("div");a.classList.add("arrow"),a.setAttribute("data-popper-arrow",""),e.appendChild(a),this._widget=e}get _hasTime(){return this.optionsStore.options.display.components.clock&&(this.optionsStore.options.display.components.hours||this.optionsStore.options.display.components.minutes||this.optionsStore.options.display.components.seconds)}get _hasDate(){return this.optionsStore.options.display.components.calendar&&(this.optionsStore.options.display.components.year||this.optionsStore.options.display.components.month||this.optionsStore.options.display.components.date)}getToolbarElements(){const e=[];if(this.optionsStore.options.display.buttons.today){const t=document.createElement("div");t.setAttribute("data-action",E.today),t.setAttribute("title",this.optionsStore.options.localization.today),t.appendChild(this._iconTag(this.optionsStore.options.display.icons.today)),e.push(t)}if(!this.optionsStore.options.display.sideBySide&&this._hasDate&&this._hasTime){let t,s;"clock"===this.optionsStore.options.display.viewMode?(t=this.optionsStore.options.localization.selectDate,s=this.optionsStore.options.display.icons.date):(t=this.optionsStore.options.localization.selectTime,s=this.optionsStore.options.display.icons.time);const i=document.createElement("div");i.setAttribute("data-action",E.togglePicker),i.setAttribute("title",t),i.appendChild(this._iconTag(s)),e.push(i)}if(this.optionsStore.options.display.buttons.clear){const t=document.createElement("div");t.setAttribute("data-action",E.clear),t.setAttribute("title",this.optionsStore.options.localization.clear),t.appendChild(this._iconTag(this.optionsStore.options.display.icons.clear)),e.push(t)}if(this.optionsStore.options.display.buttons.close){const t=document.createElement("div");t.setAttribute("data-action",E.close),t.setAttribute("title",this.optionsStore.options.localization.close),t.appendChild(this._iconTag(this.optionsStore.options.display.icons.close)),e.push(t)}return e}getHeadTemplate(){const e=document.createElement("div");e.classList.add(Namespace.css.calendarHeader);const t=document.createElement("div");t.classList.add(Namespace.css.previous),t.setAttribute("data-action",E.previous),t.appendChild(this._iconTag(this.optionsStore.options.display.icons["rtl"===document.documentElement.dir?"next":"previous"]));const s=document.createElement("div");s.classList.add(Namespace.css.switch),s.setAttribute("data-action",E.changeCalendarView);const i=document.createElement("div");return i.classList.add(Namespace.css.next),i.setAttribute("data-action",E.next),i.appendChild(this._iconTag(this.optionsStore.options.display.icons["rtl"===document.documentElement.dir?"previous":"next"])),e.append(t,s,i),e}_iconTag(e){if("sprites"===this.optionsStore.options.display.icons.type){const t=document.createElementNS("http://www.w3.org/2000/svg","svg"),s=document.createElementNS("http://www.w3.org/2000/svg","use");return s.setAttribute("xlink:href",e),s.setAttribute("href",e),t.appendChild(s),t}const t=document.createElement("i");return t.classList.add(...e.split(" ")),t}_rebuild(){const e=this._isVisible;this._dispose(),e&&this.show()}}class Actions{constructor(){this.optionsStore=l.locate(OptionsStore),this.dates=l.locate(Dates),this.validation=l.locate(Validation),this.display=l.locate(Display),this._eventEmitters=l.locate(EventEmitters),this._eventEmitters.action.subscribe((e=>{this.do(e.e,e.action)}))}do(e,t){const s=e?.currentTarget;if(s?.classList?.contains(Namespace.css.disabled))return!1;t=t||s?.dataset?.action;const i=(this.dates.lastPicked||this.optionsStore.viewDate).clone;switch(t){case E.next:case E.previous:this.handleNextPrevious(t);break;case E.changeCalendarView:this.display._showMode(1),this.display._updateCalendarHeader();break;case E.selectMonth:case E.selectYear:case E.selectDecade:this.handleSelectCalendarMode(t,s);break;case E.selectDay:this.handleSelectDay(s);break;case E.selectHour:{let t=+s.dataset.value;i.hours>=12&&this.optionsStore.isTwelveHour&&(t+=12),i.hours=t,this.dates.setValue(i,this.dates.lastPickedIndex),this.hideOrClock(e);break}case E.selectMinute:i.minutes=+s.dataset.value,this.dates.setValue(i,this.dates.lastPickedIndex),this.hideOrClock(e);break;case E.selectSecond:i.seconds=+s.dataset.value,this.dates.setValue(i,this.dates.lastPickedIndex),this.hideOrClock(e);break;case E.incrementHours:this.manipulateAndSet(i,a.hours);break;case E.incrementMinutes:this.manipulateAndSet(i,a.minutes,this.optionsStore.options.stepping);break;case E.incrementSeconds:this.manipulateAndSet(i,a.seconds);break;case E.decrementHours:this.manipulateAndSet(i,a.hours,-1);break;case E.decrementMinutes:this.manipulateAndSet(i,a.minutes,-1*this.optionsStore.options.stepping);break;case E.decrementSeconds:this.manipulateAndSet(i,a.seconds,-1);break;case E.toggleMeridiem:this.manipulateAndSet(i,a.hours,this.dates.lastPicked.hours>=12?-12:12);break;case E.togglePicker:this.handleToggle(s);break;case E.showClock:case E.showHours:case E.showMinutes:case E.showSeconds:this.optionsStore.options.display.sideBySide||"clock"===this.optionsStore.currentView||(Collapse.hideImmediately(this.display.widget.querySelector(`div.${Namespace.css.dateContainer}`)),Collapse.showImmediately(this.display.widget.querySelector(`div.${Namespace.css.timeContainer}`))),this.handleShowClockContainers(t);break;case E.clear:this.dates.setValue(null),this.display._updateCalendarHeader();break;case E.close:this.display.hide();break;case E.today:{const e=(new DateTime).setLocale(this.optionsStore.options.localization.locale);this._eventEmitters.updateViewDate.emit(e),this.validation.isValid(e,a.date)&&this.dates.setValue(e,this.dates.lastPickedIndex);break}}}handleShowClockContainers(e){if(!this.display._hasTime)return void Namespace.errorMessages.throwError("Cannot show clock containers when time is disabled.");this.optionsStore.currentView="clock",this.display.widget.querySelectorAll(`.${Namespace.css.timeContainer} > div`).forEach((e=>e.style.display="none"));let t="";switch(e){case E.showClock:t=Namespace.css.clockContainer,this.display._update("clock");break;case E.showHours:t=Namespace.css.hourContainer,this.display._update(a.hours);break;case E.showMinutes:t=Namespace.css.minuteContainer,this.display._update(a.minutes);break;case E.showSeconds:t=Namespace.css.secondContainer,this.display._update(a.seconds)}this.display.widget.getElementsByClassName(t)[0].style.display="grid"}handleNextPrevious(e){const{unit:t,step:s}=p[this.optionsStore.currentCalendarViewMode];e===E.next?this.optionsStore.viewDate.manipulate(s,t):this.optionsStore.viewDate.manipulate(-1*s,t),this._eventEmitters.viewUpdate.emit(),this.display._showMode()}hideOrClock(e){this.optionsStore.isTwelveHour||this.optionsStore.options.display.components.minutes||this.optionsStore.options.display.keepOpen||this.optionsStore.options.display.inline?this.do(e,E.showClock):this.display.hide()}manipulateAndSet(e,t,s=1){const i=e.manipulate(s,t);this.validation.isValid(i,t)&&this.dates.setValue(i,this.dates.lastPickedIndex)}handleSelectCalendarMode(e,t){const s=+t.dataset.value;switch(e){case E.selectMonth:this.optionsStore.viewDate.month=s;break;case E.selectYear:case E.selectDecade:this.optionsStore.viewDate.year=s}this.optionsStore.currentCalendarViewMode===this.optionsStore.minimumCalendarViewMode?(this.dates.setValue(this.optionsStore.viewDate,this.dates.lastPickedIndex),this.optionsStore.options.display.inline||this.display.hide()):this.display._showMode(-1)}handleToggle(e){e.getAttribute("title")===this.optionsStore.options.localization.selectDate?(e.setAttribute("title",this.optionsStore.options.localization.selectTime),e.innerHTML=this.display._iconTag(this.optionsStore.options.display.icons.time).outerHTML,this.display._updateCalendarHeader(),this.optionsStore.refreshCurrentView()):(e.setAttribute("title",this.optionsStore.options.localization.selectDate),e.innerHTML=this.display._iconTag(this.optionsStore.options.display.icons.date).outerHTML,this.display._hasTime&&(this.handleShowClockContainers(E.showClock),this.display._update("clock"))),this.display.widget.querySelectorAll(`.${Namespace.css.dateContainer}, .${Namespace.css.timeContainer}`).forEach((e=>Collapse.toggle(e))),this._eventEmitters.viewUpdate.emit()}handleSelectDay(e){const t=this.optionsStore.viewDate.clone;e.classList.contains(Namespace.css.old)&&t.manipulate(-1,a.month),e.classList.contains(Namespace.css.new)&&t.manipulate(1,a.month),t.date=+e.dataset.day;let s=0;this.optionsStore.options.multipleDates?(s=this.dates.pickedIndex(t,a.date),-1!==s?this.dates.setValue(null,s):this.dates.setValue(t,this.dates.lastPickedIndex+1)):this.dates.setValue(t,this.dates.lastPickedIndex),this.display._hasTime||this.optionsStore.options.display.keepOpen||this.optionsStore.options.display.inline||this.optionsStore.options.multipleDates||this.display.hide()}}class TempusDominus{constructor(e,t={}){this._subscribers={},this._isDisabled=!1,this._inputChangeEvent=e=>{const t=e?.detail;if(t)return;const s=()=>{this.dates.lastPicked&&(this.optionsStore.viewDate=this.dates.lastPicked.clone)},i=this.optionsStore.input.value;if(this.optionsStore.options.multipleDates)try{const e=i.split(this.optionsStore.options.multipleDatesSeparator);for(let t=0;t<e.length;t++)this.dates.setFromInput(e[t],t);s()}catch{console.warn("TD: Something went wrong trying to set the multipleDates values from the input field.")}else this.dates.setFromInput(i,0),s()},this._toggleClickEvent=()=>{this.optionsStore.element?.disabled||this.optionsStore.input?.disabled||this.toggle()},l=new ServiceLocator,this._eventEmitters=l.locate(EventEmitters),this.optionsStore=l.locate(OptionsStore),this.display=l.locate(Display),this.dates=l.locate(Dates),this.actions=l.locate(Actions),e||Namespace.errorMessages.mustProvideElement(),this.optionsStore.element=e,this._initializeOptions(t,h,!0),this.optionsStore.viewDate.setLocale(this.optionsStore.options.localization.locale),this.optionsStore.unset=!0,this._initializeInput(),this._initializeToggle(),this.optionsStore.options.display.inline&&this.display.show(),this._eventEmitters.triggerEvent.subscribe((e=>{this._triggerEvent(e)})),this._eventEmitters.viewUpdate.subscribe((()=>{this._viewUpdate()})),this._eventEmitters.updateViewDate.subscribe((e=>{this.viewDate=e}))}get viewDate(){return this.optionsStore.viewDate}set viewDate(e){this.optionsStore.viewDate=e,this.optionsStore.viewDate.setLocale(this.optionsStore.options.localization.locale),this.display._update("clock"===this.optionsStore.currentView?"clock":"calendar")}updateOptions(e,t=!1){t?this._initializeOptions(e,h):this._initializeOptions(e,this.optionsStore.options),this.display._rebuild()}toggle(){this._isDisabled||this.display.toggle()}show(){this._isDisabled||this.display.show()}hide(){this.display.hide()}disable(){this._isDisabled=!0,this.optionsStore.input?.setAttribute("disabled","disabled"),this.display.hide()}enable(){this._isDisabled=!1,this.optionsStore.input?.removeAttribute("disabled")}clear(){this.optionsStore.input.value="",this.dates.clear()}subscribe(e,t){let s;"string"==typeof e&&(e=[e]),s=Array.isArray(t)?t:[t],e.length!==s.length&&Namespace.errorMessages.subscribeMismatch();const i=[];for(let t=0;t<e.length;t++){const a=e[t];if(Array.isArray(this._subscribers[a])||(this._subscribers[a]=[]),this._subscribers[a].push(s[t]),i.push({unsubscribe:this._unsubscribe.bind(this,a,this._subscribers[a].length-1)}),1===e.length)return i[0]}return i}dispose(){this.display.hide(),this.display._dispose(),this._eventEmitters.destroy(),this.optionsStore.input?.removeEventListener("change",this._inputChangeEvent),this.optionsStore.options.allowInputToggle&&this.optionsStore.input?.removeEventListener("click",this._toggleClickEvent),this._toggle?.removeEventListener("click",this._toggleClickEvent),this._subscribers={}}locale(e){const t=T[e];t&&this.updateOptions({localization:t})}_triggerEvent(e){e.viewMode=this.optionsStore.currentView;const t=e.type===Namespace.events.change;if(t){const{date:t,oldDate:s,isClear:i}=e;if(t&&s&&t.isSame(s)||!i&&!t&&!s)return;this._handleAfterChangeEvent(e),this.optionsStore.input?.dispatchEvent(new CustomEvent(e.type,{detail:e})),this.optionsStore.input?.dispatchEvent(new CustomEvent("change",{detail:e}))}if(this.optionsStore.element.dispatchEvent(new CustomEvent(e.type,{detail:e})),window.jQuery){const s=window.jQuery;t&&this.optionsStore.input?s(this.optionsStore.input).trigger(e):s(this.optionsStore.element).trigger(e)}this._publish(e)}_publish(e){Array.isArray(this._subscribers[e.type])&&this._subscribers[e.type].forEach((t=>{t(e)}))}_viewUpdate(){this._triggerEvent({type:Namespace.events.update,viewDate:this.optionsStore.viewDate.clone})}_unsubscribe(e,t){this._subscribers[e].splice(t,1)}_initializeOptions(e,t,s=!1){let i=OptionConverter.deepCopy(e);i=OptionConverter._mergeOptions(i,t),s&&(i=OptionConverter._dataToOptions(this.optionsStore.element,i)),OptionConverter._validateConflicts(i),i.viewDate=i.viewDate.setLocale(i.localization.locale),this.optionsStore.viewDate.isSame(i.viewDate)||(this.optionsStore.viewDate=i.viewDate),i.display.components.year&&(this.optionsStore.minimumCalendarViewMode=2),i.display.components.month&&(this.optionsStore.minimumCalendarViewMode=1),i.display.components.date&&(this.optionsStore.minimumCalendarViewMode=0),this.optionsStore.currentCalendarViewMode=Math.max(this.optionsStore.minimumCalendarViewMode,this.optionsStore.currentCalendarViewMode),p[this.optionsStore.currentCalendarViewMode].name!==i.display.viewMode&&(this.optionsStore.currentCalendarViewMode=Math.max(p.findIndex((e=>e.name===i.display.viewMode)),this.optionsStore.minimumCalendarViewMode)),this.display?.isVisible&&this.display._update("all"),i.display.components.useTwentyfourHour&&void 0===i.localization.hourCycle?i.localization.hourCycle="h24":void 0===i.localization.hourCycle&&(i.localization.hourCycle=(e=>{if(!e)return"h12";const t={hour:"2-digit",minute:"2-digit",numberingSystem:"latn"},s=(new DateTime).setLocale(e);s.hours=0;const i=s.parts(void 0,t).hour;if("12"===i)return"h12";if("24"===i)return"h24";s.hours=23;const a=s.parts(void 0,t).hour;return"00"===i&&"11"===a?"h11":"00"===i&&"23"===a?"h23":void console.warn(`couldn't determine hour cycle for ${e}. start: ${i}. end: ${a}`)})(i.localization.locale)),this.optionsStore.options=i}_initializeInput(){if("INPUT"==this.optionsStore.element.tagName)this.optionsStore.input=this.optionsStore.element;else{const e=this.optionsStore.element.dataset.tdTargetInput;this.optionsStore.input=null==e||"nearest"==e?this.optionsStore.element.querySelector("input"):this.optionsStore.element.querySelector(e)}this.optionsStore.input&&(!this.optionsStore.input.value&&this.optionsStore.options.defaultDate&&(this.optionsStore.input.value=this.dates.formatInput(this.optionsStore.options.defaultDate)),this.optionsStore.input.addEventListener("change",this._inputChangeEvent),this.optionsStore.options.allowInputToggle&&this.optionsStore.input.addEventListener("click",this._toggleClickEvent),this.optionsStore.input.value&&this._inputChangeEvent())}_initializeToggle(){if(this.optionsStore.options.display.inline)return;let e=this.optionsStore.element.dataset.tdTargetToggle;"nearest"==e&&(e='[data-td-toggle="datetimepicker"]'),this._toggle=null==e?this.optionsStore.element:this.optionsStore.element.querySelector(e),this._toggle.addEventListener("click",this._toggleClickEvent)}_handleAfterChangeEvent(e){!this.optionsStore.options.promptTimeOnDateChange||this.optionsStore.options.display.inline||this.optionsStore.options.display.sideBySide||!this.display._hasTime||this.display.widget?.getElementsByClassName(Namespace.css.show)[0].classList.contains(Namespace.css.timeContainer)||!e.oldDate&&this.optionsStore.options.useCurrent||e.oldDate&&e.date?.isSame(e.oldDate)||(clearTimeout(this._currentPromptTimeTimeout),this._currentPromptTimeTimeout=setTimeout((()=>{this.display.widget&&this._eventEmitters.action.emit({e:{currentTarget:this.display.widget.querySelector(`.${Namespace.css.switch}`)},action:E.togglePicker})}),this.optionsStore.options.promptTimeOnDateChangeTransitionDelay))}}const T={},M=e=>{T[e.name]||(T[e.name]=e.localization)},L=e=>{const t=T[e];t&&(h.localization=t)},O=function(e,t){return e?(e.installed||(e(t,{TempusDominus:TempusDominus,Dates:Dates,Display:Display,DateTime:DateTime,Namespace:Namespace},V),e.installed=!0),V):V},A="6.2.10",V={TempusDominus:TempusDominus,extend:O,loadLocale:M,locale:L,Namespace:Namespace,DefaultOptions:h,DateTime:DateTime,Unit:a,version:A};const $={__proto__:null,TempusDominus:TempusDominus,extend:O,loadLocale:M,locale:L,Namespace:Namespace,DefaultOptions:h,DateTime:DateTime,get Unit(){return a},version:A};$.extend(((e,t,s)=>{t.Dates.prototype.setFromInput=function(e,t){let i=this.optionsStore.options.localization.locale,a=this.optionsStore.options.localization.format;if(a){let o={locale:i},r=new s.DateTime(n.DateTime.fromFormat(e,a,o).toJSDate());if(r&&r.getTime()==r.getTime()){let e=s.DateTime.convert(r,i);this.setValue(e,t)}else console.error("Luxon failed to parse the input date.")}else console.error("Missing format.")},t.Dates.prototype.formatInput=function(e){let t=this.optionsStore.options.localization.locale,s=this.optionsStore.options.localization.format;if(s){let i={locale:t,outputCalendar:"gregory"};return e?n.DateTime.fromJSDate(e,i).toFormat(s):""}console.error("Missing format.")}})),
/*!
   * Tempus Dominus v6.2.10 (https://getdatepicker.com/)
    * Copyright 2013-2021 Jonathan Peterson
    * Licensed under MIT (https://github.com/Eonasdan/tempus-dominus/blob/master/LICENSE)
    */
$.jQueryInterface=function(e,t){return 1===this.length?$.jQueryHandleThis(this,e,t):this.each((function(){$.jQueryHandleThis(this,e,t)}))},$.jQueryHandleThis=function(e,t,s){let i=o.default(e).data($.Namespace.dataKey);if("object"==typeof t&&(t=o.default.extend({},$.DefaultOptions,t)),i||(i=new $.TempusDominus(o.default(e)[0],t),o.default(e).data($.Namespace.dataKey,i)),"string"==typeof t){if(void 0===i[t])throw new Error(`No method named "${t}"`);if(void 0===s)return i[t]();{"date"===t&&(i.isDateUpdateThroughDateOptionFromClientCode=!0);const e=i[t](s);return i.isDateUpdateThroughDateOptionFromClientCode=!1,e}}};const H="tempusDominus",x=o.default.fn[H];return o.default.fn[H]=$.jQueryInterface,o.default.fn[H].Constructor=$.TempusDominus,o.default.fn[H].noConflict=function(){return o.default.fn[H]=x,$.jQueryInterface},$}(jQuery,luxon);
//# sourceMappingURL=tempus-dominus.min.js.map